# mq-tmpfile.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; it implements the temporary files
# management API functions, used to facilitate creation, and updating of
# patch files, and patch queue management meta-data files.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2018, 2019, Keith Marshall
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
# Helper function for creating temporary files, and registering them with
# a clean-up trap, to delete them on process termination; typically invoked
# as a wrapper around "mktemp", thus:
#
#   mq_tmpfile  mq_datafile_tmp '`mktemp ...` || die "fault message ..."'
#
  mq_tmpfile(){
    eval $1="$2"; eval mq_tmpfiles='${'"$1"'}'
    mq_tmpfile(){ eval $1="$2"; eval mq_tmpfiles='"$mq_tmpfiles ${'"$1"'}"'; }
    mq_tmpfile_cleanup(){ test -n "$mq_tmpfiles" && rm -f $mq_tmpfiles; }
    mq_require mq-atexit mq_tmpfile_cleanup
  }

# Helper function to replace any data file with an updated copy, which has
# been created within a temporary file; invoked thus:
#
#   mq_replace_if_modified  data_file_path_name  tmpfile_path_name
#
  mq_replace_if_modified(){
    test -f "$1" && cmp > /dev/null 2>&1 "$1" "$2" && rm -f "$2" \
      || mv -f "$2" "$1"
  }

# Wrapper to facilitate use of the preceding function; assumes that the
# data file to be updated, and the replacement temporary file, are both
# named in shell variables, themselves named respectively as "data_file"
# and "data_file_tmp", and is invoked as:
#
#   mq_update  data_file
#
# thus causing a corresponding invocation of "mq_replace_if_modified":
#
#   mq_replace_if_modified  "$data_file"  "$data_file_tmp"
#
  mq_update(){
    eval 'mq_replace_if_modified "$'$1'" "$'$1'_tmp"'
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
