.ig
pdfmark.ms

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2004-2023 Free Software Foundation, Inc.
written by Keith Marshall <keith.d.marshall@ntlworld.com>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.CS
Portable Document Format
Publishing with GNU Troff
.AU Keith Marshall
.AI <keith.d.marshall@ntlworld.com>
.CE
.
.\" Specify the Internet address for the groff web site.
.\"
.ds GROFF-WEBSITE http://www.gnu.org/software/groff
.
.\" Set the PDF default document view attribute, to ensure that the document
.\" outline is visible, each time the document is opened in Acrobat Reader.
.\"
.pdfview /PageMode /UseOutlines
.pdfview /Page 1 /View [/FitH \n(.p u]
.\"
.\" Initialize the outline view to show only three heading levels,
.\" with additional subordinate level headings folded.
.\"
.nr PDFOUTLINE.FOLDLEVEL 3
.
.\" Add document identification meta-data
.\"
.pdfinfo /Author    Keith Marshall
.pdfinfo /Title     Portable Document Format Publishing with GNU Troff
.pdfinfo /Subject   Tips and Techniques for Exploiting PDF Features with GNU Troff
.pdfinfo /Keywords  groff troff PDF pdfmark
.
.\" Set the default cross reference format to indicate section numbers,
.\" rather than page numbers, when we insert a reference pointer; (note
.\" that we preserve the default setting, for later use in examples).
.\"
.rn PDFHREF.INFO PDFHREF.INFO.DEFAULT
.ds PDFHREF.INFO.LOCAL section \\*[SN-NO-DOT] \\$*
.als PDFHREF.INFO PDFHREF.INFO.LOCAL
.
.\" Define a macro, to print reference links WITHOUT the usual "see" prefix.
.\"
.de XR-NO-PREFIX
.rn PDFHREF.PREFIX xx
.ds PDFHREF.PREFIX
.XR \\$@
.rn xx PDFHREF.PREFIX
..
.
.\" Define a string, to insert a Registered Trade Mark symbol as
.\" a superscript...
.\"
.ds rg \*{\(rg\*}
.\"
.\" ...and use it to define strings, representing frequently used
.\" registered trade marks.
.\"
.ds Adobe "Adobe\Z'\\$1'\*(rg\"
.ds Acrobat "Acrobat\Z'\\$1'\*(rg\"
.ds Distiller "Distiller\Z'\\$1'\*(rg\"
.ds PostScript "PostScript\Z'\\$1'\*(rg\"
.\"
.ds Microsoft "Microsoft\Z'\\$1'\*(rg\"
.
.\" Define a string to facilitate interpolation of em-dash punctuation,
.\" with spacing in accordance with the British style.
.\"
.ds em \\$1\h'0.6n'\(em\h'0.6n'\\$2
.
.\" Establish the page layout.
.\"
.nr PO  2.5c
.nr LL 17.0c
.nr LT 17.0c
.nr DI  3n
.nr PI  3n
.nr QI  3n
.nr HY  0
.
.\" Generate headers in larger point sizes, for NH levels < 4,
.\" with point size increasing by 1.5p, for each lesser NH level.
.\"
.nr GROWPS 4
.nr PSINCR 1.5p
.
.\" Immediately following the cover sheet, and front-matter, is the
.\" conventional placement for the table of contents; we begin this
.\" on a new page, with a centred heading, which we have choosen to
.\" set at a font size 2pts greater than that of normal paragraphs,
.\" (thus matching standard "ms" convention), with lower case roman
.\" numerals for page numbering, with its own entry within the PDF
.\" document outline, and with the equivalent of two blank lines
.\" separating the heading from the TOC references.
.\"
.af % i
.LP
.ce 1
.pdfhref O 1 \\*[TOC]
.B "\s'+2p'\*[TOC]\s'-2p'"
.sp 2v
.\"
.\" The traditional mechanism, supported by "ms", for generation of
.\" tables of contents, relies on post-press collation, to print the
.\" table of contents AFTER the document body, and then to relocate
.\" it to its conventional position, BEFORE the body content.
.\"
.\" While pdfroff DOES support such post-press collation, it is not
.\" the most effective method for placement of the tables of contents
.\" within PDF documents.  Although a method for use of the technique
.\" is described, in Section 3 of this document, it is not the actual
.\" method employed; in particular, it has been found to be unsuited
.\" to the creation of a table of contents which is actively linked
.\" to its corresponding body content.  Consequently, the preferred
.\" method of table of contents generation is now to save relevant
.\" reference data during the pdfroff pre-press phase, and then to
.\" reimport it during the body content publication phase, using
.\" the toc.tmac macros, integrated with pdfroff...
.\"
.mso toc.tmac
.\"
.\" Within the table of contents, structural layout will be achieved,
.\" under the direction of the following spacing control constants:
.\"
.ds TC-VS1 1.30v  \" leading for top level
.ds TC-VS2 0.15v  \" leading at nesting level increment
.ds TC-VS3 0.25v  \" leading following nested group
.\"
.\" Additionally, the width of the right-hand margin, in which space
.\" is reserved for the display of page numbers, and the appearance of
.\" the leaders which precede it, are controlled by:-
.\"
.nr TC-MARGIN \w'00000'
.char \[TC-LEADER] \h'0.8n'.
.lc \[TC-LEADER]
.\"
.\" Macro "toc.outline" initializes output state for each individual
.\" TOC reference entry, controlling indentation based on designated
.\" outline-level, as passed in the initiating XH-UPDATE-TOC call.
.\"
.de toc.outline
.   ie \\$1>1 \{\
.      \" Entries at outline-levels greater than one are indented
.      \" by 1em for each level; additionally, on increasing level
.      \" from that of the preceding entry, as recorded in the local
.      \" register, "toc.outline.current", additional vertical space
.      \" equal to "TC-VS2" is inserted, while on decreasing to any
.      \" level which remains greater than one, similar additional
.      \" vertical space equal to "TC-VS3" is inserted.
.      \"
.         nr toc.indent (\w'0.'u+1.5n)*(\\$1-1)
.         if \\$1>2 .nr toc.indent +\w'0.'u*(\\$1-1)*(\\$1-2)/2
.         ie \\$1>\\n[toc.outline.current] .sp \*[TC-VS2]
.         el .if \\n[toc.outline.current]>\\$1 .sp \*[TC-VS3]
.         nop \h'\\n[toc.indent]u'\c
.
.      \" After emitting the appropriate indentation space, the
.      \" tab-stop settings must be adjusted to compensate.
.      \"
.         nr toc.indent \\n[.l]-\\n[.i]-\\n[toc.indent]
.         ta (u;\\n[toc.indent]-\\n[TC-MARGIN]) (u;\\n[toc.indent])R
.         rr toc.indent
.      \}
.   el \{\
.      \" Entries at outline-level one are not indented, but each
.      \" except the first, (identified by not yet having defined
.      \" the "toc.outline.current" register), will be preceded by
.      \" vertical space equal to "TC-VS1"; in any case, tab-stops
.      \" are reset to match "ms" convention, in preparation for
.      \" output of level one TOC entry.
.      \"
.         if r toc.outline.current .sp \*[TC-VS1]
.         ta (u;\\n[.l]-\\n[.i]-\\n[TC-MARGIN]) (u;\\n[.l]-\\n[.i])R
.      \}
.
.\" After initialization for the first TOC entry, tracking of the
.\" current outline-level is persistently maintained, by recording
.\" of the "toc.outline.current" register.
.\"
.   nr toc.outline.current \\$1
..
.\" The collected TOC reference data is interpolated back into the
.\" document output stream, initially by the toc.refmark macro...
.\"
.de toc.refmark
.   \" ...which simply stores the text for the TOC pageref entry,
.   \" within the toc.refmark.text string, whence it is...
.   \"
.   ds \\$0.text \\$*
..
.\" ...subsequently retrieved by the toc.pageref macro...
.\"
.de toc.pageref
.   \" ...to be incorporated into an active pdfhref link, along
.   \" with the appropriate page number reference, and emitted
.   \" to the document output stream.
.   \"
.   ie \\n[toc.outline.current]>1 .as toc.refmark.text "\a\t\\$*\"
.   el .as toc.refmark.text "\f[]\s'-1p'\a\s'+1p'\fB\t\\$1\f[]\s'-1p'\"
.   pdfhref L -D \\*[toc.refmark.text]
.   rm toc.refmark.text
.   br
..
.\" Although the TOC is to be entirely populated by active PDFHREF
.\" links, we prefer to not over-emphasize this by use of the link
.\" highlight colour; thus, after breaking the PDFHREF.TEXT.COLOUR
.\" to PDFHREF.TEXT.COLOR equivalence, we may adjust the effective
.\" link colour, to match the normal body text colour.
.\"
.rm PDFHREF.TEXT.COLOUR
.ds PDFHREF.TEXT.COLOUR \n(.m
.\"
.\" Actual content for the TOC has been dynamically captured in the
.\" pdfmark.toc file; simply include it here, then restart TOC data
.\" collection, for use in subsequent formatting passes.
.\"
.so pdfmark.toc
.toc file pdfmark.toc
.\"
.\" After output of the TOC, we may clear the PDFHREF.TEXT.COLOUR
.\" reassignment; the next call of pdfhref L, or of pdfhref W, will
.\" re-establish its equivalence to PDFHREF.TEXT.COLOR
.\"
.rm PDFHREF.TEXT.COLOUR
.\"
.\" Finally, reset the page numbering style, and prepare for output
.\" of the document body from page number one.
.\"
.af % 0
.bp 1
.
.\" Implement an interface with the FS macro (from s.tmac) to facilitate
.\" placement of footnote reference marks, with each serving as an active
.\" pdfhref link to the associated footnote itself.
.\"
.de pdf:fn.mark nr
.\" Macro to replace original duty performed by "\**"; must be invoked
.\" at point of footnote mark placement, e.g. by FS, BEFORE recording of
.\" the associated text within the footnote diversion is commenced.
.\"
.ie \\n[.$] \{\
.   pdfhref L -D pdf:fn\\$1 -- \\$2
.   pdfhref M -N pdf:fn\\$1r
.\}
.\" s.tmac does not publicly expose its auto-incrementing footnote index;
.\" to avoid a dependency on this undocumented internal feature, we create
.\" our own counter, which we increment as each footnote is marked, while
.\" also concurrently interpolating a renamed "\**" string reference, to
.\" maintain synchronization with the internal s.tmac index.
.\"
.el .\\$0 \\n+[pdf:fn.index.count] \\*[pdf:fn.index]
.nr pdf:fn.index.count 0 1
.rn * pdf:fn.index
.ds * \c
.
.\" For versions of s.tmac which support the FS-MARK callback hook, it
.\" is sufficient for us to answer the callback request.
.\"
.\" FIXME: in time, we may be able to unconditionally assume that this
.\" callback hook will be supported...
.\"
.ie d FS-MARK .als FS-MARK pdf:fn.mark
.el \{\
.\" ...but in the interim, we may need to redefine s.tmac's FS macro,
.\" (actually the @FS internal macro, rather than FS itself), to gain
.\" an effect equivalent to taking control of FS-MARK, to achieve the
.\" placement of a footnote mark as an active pdfhref link.
.\"
.rn @FS pdf:fn.record
.de @FS
.pdf:fn.mark
.pdf:fn.record
..
.\}
.\" Override s.tmac's (undocumented) footnote output hook; this emulates
.\" the default output style for \n[FF] == 3 footnotes, with the footnote
.\" number formatted as a pdfhref link back to the position at which the
.\" footnote marker appears, within the document text.
.\"
.de FP
.LP
.nr pdf:fn.tag.width (u;2*\\n[FI])
.ds pdf:fn.tag \s'-1.5p'\\$1.\s'+1.5p'
.pdfhref M -N pdf:fn\\$1
.in +\\n[pdf:fn.tag.width]u
.ti -\\n[pdf:fn.tag.width]u
.nr pdf:fn.tag.width -\\w'\\*[pdf:fn.tag]'u
.pdfhref L -D pdf:fn\\$1r -A \\h'\\n[pdf:fn.tag.width]u'\c -- \\*[pdf:fn.tag]
..
.\" When a footnote marker is placed adjacent to punctuation which would
.\" normally end a sentence, the normal end-of-sentence spacing effect is
.\" suppressed; this alternative footnote termination macro augments the
.\" effect of the normal FE macro, to reactivate sentence spacing.
.\"
.de FZ
.FE
.\" Without arguments, this becomes equivalent to FE alone; there is no
.\" more to do.  However, WITH arguments, we emit them invisibly, without
.\" spacing, such that if they exhibit the semantics of end-of-sentence
.\" punctuation, the sentence spacing effect is reactivated.
.\"
.if \\n[.$] \O0\Z'\\$*'\O\\n[OPMODE]
..
.de pdfhref-nobreak
.\" FIXME: I've only noticed this anomaly when planting pdfhref links
.\" within footnotes; if the start of the link text is placed near the
.\" line length limit, and all of it is moved to the start of the next
.\" line, the "hot-spot" region is computed to be one line higher than
.\" it should be; ending the preceding input line with "\c", and then
.\" invoking pdfhref via this wrapper, works around this issue.
.\"
.ie \\n[.l]-\\n[.i]-\\n[.k]-\\w'\\$\\n[.$]' \&
.el \p
.pdfhref \\$*
..
.
.\" Define a local macro to facilitate choice of style for emphasis;
.\" by default, make it equivalent to the ms standard "I" macro.
.\"
.de EM
.\".I "\s'+0.3'\\$1\s0" "\\$2" "\\$3"
.I \\$@
..
.\" Also, define variations on the ms standard "CW" macro, to add
.\" bold, italic, and both styles to constant width text; note that
.\" each of these accept two additional arguments, in comparison to
.\" standard "CW", such that \$1 specifies the text which is to be
.\" styled, \$2 and \$3 specify inner after/before bracketting, to
.\" set as regular "CW" text,  while \$4 and \$5 become equivalent
.\" to \$2 and \$3 of standard "CW", acting as outer bracketting.
.\"
.de CWB
\\$5\fC\\$3\fP\f(CB\\$1\fP\fC\\$2\fP\\$4
..
.de CWI
\\$5\fC\\$3\fP\f(CI\\$1\fP\fC\\$2\fP\\$4
..
.de CWBI
\\$5\fC\\$3\fP\f[CBI]\\$1\fP\fC\\$2\fP\\$4
..
.\" Finally, augment this group with a variant string, which may be
.\" used to set constant width tags on "IP" paragraphs, with \$1 set
.\" as if by "CWB", followed by an optional suffix set as if by "CWBI",
.\" and with the suffix bracketted by \$3 after and \$4 before, each
.\" set in the regular "CW" style.
.\"
.ds = \f(CB\\$1\f(CR\\$4\f[CBI]\\$2\f(CR\\$3
.
.\" Additionally, add a cross-reference convenience macro, emulating
.\" the style of the "ms" font change macros...
.\"
.\"  .XR <dest-name> [<affixed> [<prefix>]]
.\"
.\" ...such that, when invoked with one, two, or three arguments, this
.\" expands to the equivalent of:
.\"
.\"  .pdfhref L -D <dest-name> [-A <affixed> [-P <prefix>]]
.\"
.\" to place a pdfhref reference link, to a named destination, within
.\" the same document, using the reference text which is predefined in
.\" the reference dictionary entry associated with the destination.
.\"
.de XR
.if \\n(.$ \{\
.   if \\n[OPMODE] \{\
.         ds xr!argv -D "\\$1"
.         if \\n(.$>1 .as xr!argv " -A "\\$2"
.         if \\n(.$>2 .as xr!argv " -P "\\$3"
.         pdfhref L \\*[xr!argv]
.         rm xr!argv
.      \}
.   \}
..
.
.NH 1
.\" Conventionally, in "ms", NH precedes text which is to be set as a
.\" numbered section heading, but it makes no provision for automatic
.\" reference to that heading in a table of contents, or (in the case
.\" of PDF document production) in a document outline.  Both of these
.\" limitations may be mitigated, by using the XN macro, (provided by
.\" spdf.tmac), which sets its arguments, both as text to be included
.\" in the section heading, as printed, and as an associated document
.\" outline reference;  it will also make this same text available to
.\" the user-specified callback macro,  XH-UPDATE-TOC, whereby it may
.\" be used, e.g. to construct a table of contents entry.
.\"
.\" Note that one TOC related callback hook is shared by both XH and
.\" XN; its is called XH-UPDATE-TOC, regardless of whether called by
.\" XH or by XN; when called by XN, it is invoked with arguments:
.\"
.\"  .XH-UPDATE-TOC <outline-level> <section-number> <text> ...
.\"
.de XH-UPDATE-TOC
.   \" Collection of TOC reference data is performed in pdfroff's
.   \" pre-press phase, (before any PHASE indicator register value
.   \" has been assigned); once PHASE has been assigned, this will
.   \" simply appear as noise on standard error, so we may just as
.   \" well suppress it.
.   \"
.   if !\\n[PHASE] \{\
.      \" When collecting the reference data, we begin by storing
.      \" the <outline-level>, the associated name assigned to the
.      \" outline bookmark, and the <section-number> string...
.      \"
.      toc put outline \\$1
.      ds toc.refmark.text "\\*[PDFBOOKMARK.NAME] -- \"
.      ie \\$1=1 \{\
.            \" ...with font size increment, and corresponding
.            \" spacing adjustment, for top level headings...
.            \"
.            as toc.refmark.text "\s'+1p'\fB\Z'\\$2'\f[]\s'-1p'\"
.            as toc.refmark.text "\h'1.5n+\w!0.!u'\s'+1p'\fB\"
.         \}
.         \" ...while maintaining normal font size, and common
.         \" spacing, for all levels of sub-headings.
.         \"
.      el .as toc.refmark.text "\\$2\h'1.5n'\"
.      \"
.      \" Having stored these two arguments, we discard them, so
.      \" that we are left with only the <text> ... argument list,
.      \" which we append to the collected TOC reference data...
.      \"
.      shift 2
.      toc put refmark \\*[toc.refmark.text]\\$*\h'0.5n'
.      \"
.      \" ...which is then completed, by the addition of a page
.      \" number reference.
.      \"
.      toc put pageref \\n%
.      \"
.      \" Finally, clean up the temporary storage, which we have
.      \" used to collect the TOC reference data.
.      \"
.      rm toc.refmark.text
.   \}
..
.XN Introduction
.\"
.\" If using an old s.tmac, without the SN-NO-DOT extension, ensure
.\" that we get SOMETHING in section number references.
.\"
.if !d SN-NO-DOT .als SN-NO-DOT SN
.LP
It might appear that it is a fairly simple matter to
produce documents in \*[Adobe]\~\(lqPortable\~Document\~Format\(rq,
commonly known as PDF, using
.CW groff ) GNU\~Troff\~(
as the document formatter.
Indeed,
.CW groff 's
default output format is the native \*[Adobe]\~\*[PostScript] format,
which PDF producers such as \*[Adobe] \*[Acrobat] \*[Distiller ,]
or GhostScript, expect as their input format.
Thus, the PDF production process would seem to entail simply
formatting the document source with
.CW groff ,
to produce a \*[PostScript] version of the document,
which can subsequently be processed by \*[Acrobat] \*[Distiller]
or GhostScript, to generate the final PDF document.
.LP
For many PDF production requirements,
the production cycle described above may be sufficient.
However, this is a limited PDF production method,
in which the resultant PDF document represents no more than
an on screen image of the printed form of the document, if
.CW groff 's
\*[PostScript] output were printed directly.
.LP
The Portable Document Format provides a number of features,
which significantly enhance the experience of reading a document on screen,
but which are of little or no value to a document which is merely printed.
It
.EM is
possible to exploit these PDF features, which are described in the \*[Adobe]
.de pdfmark-manual pdfmark-manual
.\" This is an example of a resource reference specified by URI ...
.\" We may need to refer often to the Adobe pdfmark Reference Manual,
.\" so we create the internet link definition using a macro, to make
.\" it reusable.
.\"
.\" Note also, that we protect the description of the reference by
.\" preceding it with "--", to avoid "invalid character in name" type
.\" error messages from groff (caused by the use of "\~").
.\"
.pdfhref W -D https://www.adobe.com/go/acrobatsdk_pdfmark \
    -P \(lq -A \(rq\\$1 -- pdfmark\~Reference\~Manual
.pdfmark-manual ,
with some refinement of the simple PDF production method, provided
appropriate \(lqfeature implementing\(rq instructions can be embedded into
.CW groff 's
\*[PostScript] rendering of the document.
This, of course, implies that the original document source, which
.CW groff
will process to generate the \*[PostScript] description of the document,
must include appropriate markup to exploit the desired PDF features.
It is this preparation of the
.CW groff
document source to exploit a number of these features,
which provides the principal focus of this document.
.LP
The markup techniques to be described have been utilized in the production of
the PDF version of this document itself.
This has been formatted using
.CW groff 's
.CW ms
macro package;
thus, usage examples may be found in the document source file,
.CW \n(.F ,
to which comments have been added,
to help identify appropriate markup examples for implementing PDF features,
such as:\(en
.QS
.sp -\n[PD]u
.IP \(bu 2n
Selecting a default document view, which defines how the document will appear
when opened in the reader application; for example, when this document is
opened in \*[Acrobat]\~Reader, it should display the top of the cover sheet,
in the document view pane, while a document outline should appear to the left,
in the \(lqBookmarks\(rq pane.
.IP \(bu
Adding document identification \%\(lqmeta\(hydata\(rq,
which can be accessed, in \*[Acrobat]\~Reader,
by inspecting the \(lqFile\^/\^Document\~Properties\^/\^Summary\(rq.
.IP \(bu
Creating a document outline, which will be displayed in the \(lqBookmarks\(rq
pane of \*[Acrobat]\~Reader, such that readers may quickly navigate to any
section of the document, simply by clicking on the associated heading
in the outline view.
.IP \(bu
Embedding active links in the body of the document, such that readers may
quickly navigate to related material at another location within the same
document, or in another PDF document, or even to a related Internet resource,
specified by its URI.
.IP \(bu
Adding annotations, in the form of \(lqsticky notes\(rq, at strategic
points within the PDF document.
.QE
.sp -\n[PD]u
.LP
All of the techniques described have been tested on
.EM both
GNU/Linux, and on \*[Microsoft] Windows\(tm2000 operating platforms, using
.CW groff
.CW 1.19.1 \Z','\**
.FS
Later versions should, and some earlier versions may, be equally suitable.
See\c
.pdfhref-nobreak W \*[GROFF-WEBSITE]
for information and availability of the latest version.
.FE
in association with
.CW AFPL
.CW GhostScript
.CW 8.14 \Z'.'\**
.FS
Again, other versions may be suitable.
See\c
.pdfhref-nobreak W http://ghostscript.com
for information and availability.
.FZ GhostScript 8.14.
Other tools employed, which should be readily available on
.EM any
Unix\(tm
or GNU/Linux system, are
.CW sed ,
.CW awk
and
.CW make ,
together with an appropriate text editor, for creating and marking up the
.CW groff
input files.
These additional utilities are not provided, as standard,
on the \*[Microsoft] Windows\(tm platform,
but several third party implementations are available.
Some worth considering include the MKS\*(rg\~Toolkit\Z','\**
.FS
A commercial offering; see\c
.pdfhref-nobreak W http://mkssoftware.com/products/tk/default.asp
for information.
.FE
Cygwin\Z','\**
.FS
A
.EM free
but comprehensive
.SM
POSIX
.LG
emulation environment and
Unix\(tm
toolkit for \%32\(hybit \*[Microsoft] Windows\(tm platforms; see\c
.pdfhref-nobreak W http://cygwin.com
for information and download.
.FE
or MSYS\Z'.'\**
.FS
Another free, but minimal suite of common
Unix\(tm
tools for \%32\(hybit \*[Microsoft] Windows\(tm, available for download from\c
.pdfhref-nobreak W -A ; https://mingw.osdn.io
it
.EM does
include those tools listed above,
and is the package which was actually used when performing the Windows\(tm2000
platform tests referred to in the text.
.FZ MSYS.
This list is by no means exhaustive, and should in no way be construed as an
endorsement of any of these packages, nor to imply that other similar packages,
which may be available, are in any way inferior to them.
.bp
.
.NH 1
.\" We may wish a section heading to represent a named destination,
.\" so that we can create a linked reference to it, from some other
.\" part of the PDF document, (or even from another PDF document).
.\"
.\" Here we use the "-N" option of the "XN" macro, to create a named
.\" PDF link destination, at the location of the heading.  Notice that
.\" we also use the "--" marker to separate the heading text from the
.\" preceding option specification; it is not strictly necessary in
.\" this case, but it does help to set off the heading text from the
.\" option specification.
.\"
.XN -N pdf-features -- Exploiting PDF Document Features
.LP
To establish a consistent framework for adding PDF features, a
.CW groff
macro package, named
.CW pdfmark.tmac ,
has been provided.
Thus, to incorporate PDF features in a document,
the appropriate macro calls, as described below, may be placed in the
.CW groff
document source, which should then be processed with a
.CW groff
command of the form\**
.FS
.pdfhref M pdf-features-fn
.nr pdf-features-fn \n[fn*text-num]
Note that,
if any
.CW -T \^\c
.CWI dev
option is specified,
it should be either
.CW -T \^\c
.CW ps ,
or
.CW -T \^\c
.CW pdf ;
any other explicit choice is unlikely to be compatible with
.CW -m \|\|\c
.CW pdfmark ,
and will have an unpredictable
(possibly erroneous)
effect on the output.
If no
.CW -T \^\c
.CWI dev
option is specified,
(in which case
.CW -T \^\c
.CW ps
is implicitly assumed),
or if
.CW -T \^\c
.CW ps
is explicitly specified,
then the output will be produced in \*[PostScript] format,
and will require conversion to PDF,
(e.g. by using GhostScript tools);
explicit specification of
.CW -T \^\c
.CW pdf
will result in direct output in PDF format,
thus obviating the need for conversion.
.FE
.QP
.fam C
groff [-Tps\h'0.2p'|\h'0.2p'-Tpdf] [-m\F[]\|\|\FC\c
.I name ]
-m\F[]\|\|\FC\c
.B pdfmark
.I options \F[]\|\|\FC\c [-
.I file \F[]\|\|\FC\c "...] "
\&...
.LP
It may be noted that the
.CW pdfmark
macros have no dependencies on, and no known conflicts with,
any other
.CW groff
macro package;  thus, users are free to use any other macro package,
of their choice, to format their documents, while also using the
.CW pdfmark
macros to add PDF features.
.
.NH 2
.XN -S -N pdfmark-operator -- The \F[C]pdfmark\F[] Operator
.LP
All PDF features are implemented by embedding instances of the
.B \F[C]pdfmark\F[]
operator, as described in the \*[Adobe]
.pdfmark-manual ,
into
.CW groff 's
\*[PostScript] output stream.
To facilitate the use of this operator, the
.CW pdfmark
macro package defines the primitive
.CW pdfmark
macro; it simply emits its argument list,
as arguments to a
.CW pdfmark
operator, in the \*[PostScript] output stream.
.LP
.pdfhref M -N pdfmark-example
To illustrate the use of the
.CW pdfmark
macro, the following is a much simplified example of how a bookmark
may be added to a PDF document outline
.QP
.CW ".pdfmark \e"
.RS 4
.nf
.fam C
/Count 2 \e
/Title (An Example of a Bookmark with Two Children) \e
/View  [/FitH \en[PDFPAGE.Y]] \e
/OUT
.RE
.LP
In general, users should rarely need to use the
.CW pdfmark
macro directly.
In particular, the above example is too simple for general use; it
.EM will
create a bookmark, but it does
.EM not
address the issues of setting the proper value for the
.CW /Count
key, nor of computing the
.CW PDFPAGE.Y
value used in the
.CW /View
key. The
.CW pdfmark
macro package includes a more robust mechanism for creating bookmarks,
.\"
.\" Here is an example of how a local reference may be planted,
.\" using the automatic formatting feature of the "pdfhref" macro.
.\"
.\" This is a forward reference to the named destination "add-outline",
.\" which is defined below, using the "XN" wrapper macro, from the
.\" "spdf.tmac" macro package.  The automatically formatted reference
.\" will be enclosed in parentheses, as specified by the use of
.\" "-P" and "-A" options.
.\"
.pdfhref L -P ( -A ), -D add-outline
.\"
which addresses these issues automatically.
Nevertheless, the
.CW pdfmark
macro may be useful to users wishing to implement more advanced PDF features,
than those currently supported directly by the
.CW pdfmark
macro package.
.
.NH 2
.XN -N docview -- Selecting an Initial Document View
.LP
By default,
when a PDF document is opened,
the first page will be displayed,
at the default magnification set for the reader,
and outline and thumbnail views will be hidden.
When using a PDF reader,
such as \*[Acrobat]\~Reader,
which supports the
.CW /DOCVIEW
class of the
.CW pdfmark
operator,
these default initial view settings may be overridden,
using the
.CW pdfview
macro.
For example
.QP
.CW ".pdfview /PageMode /UseOutlines"
.LP
will cause \*[Acrobat]\~Reader to open the document outline view,
to the left of the normal page view,
while
.QP
.CW ".pdfview /PageMode /UseThumbs"
.LP
will open the thumbnail view instead.
.LP
Note that the two
.CW /PageMode
examples, above, are mutually exclusive\*[em]it is not possible to have
.EM both
outline and thumbnail views open simultaneously.
However, it
.EM is
permitted to add
.CW /Page
and
.CW /View
keys, to force the document to open at a page other than the first,
or to change the magnification at which the document is initially displayed;
see the
.pdfmark-manual
for more information.
.LP
It should be noted that the view controlling \%meta\(hydata, defined by the
.CW pdfview
macro, is not written immediately to the \*[PostScript] output stream,
but is stored in an internal \%meta\(hydata \(lqcache\(rq,
(simply implemented as a
.CW groff
diversion).
This \(lqcached\(lq \%meta\(hydata must be written out later, by invoking the
.CW pdfsync
macro,
.\"
.\" Here is another example of how we may introduce a forward reference.
.\" This time we are using the shorter notation afforded by the "XR" macro
.\" provided by "spdf.tmac"; this example is equivalent to the native
.\" "pdfmark.tmac" form
.\"     .pdfhref L -D pdfsync -P ( -A ).
.\"
.XR pdfsync ). (
.
.NH 2
.XN -N docinfo -- Adding Document Identification Meta-Data
.LP
In addition to the
.CW /DOCVIEW
class of \%meta\(hydata described above,
.XR docview ), (
we may also wish to include document identification \%meta\(hydata,
which belongs to the PDF
.CW /DOCINFO
class.
.LP
To do this, we use the
.CW pdfinfo
macro.
As an example of how it is used,
the identification \%meta\(hydata attached to this document
was specified using a macro sequence similar to:\(en
.DS I
.CW
\&.pdfinfo /Title     PDF Document Publishing with GNU Troff
\&.pdfinfo /Author    Keith Marshall
\&.pdfinfo /Subject   How to Exploit PDF Features with GNU Troff
\&.pdfinfo /Keywords  groff troff PDF pdfmark
.DE
Notice that the
.CW pdfinfo
macro is repeated, once for each
.CW /DOCINFO
record to be placed in the document.
In each case, the first argument is the name of the applicable
.CW /DOCINFO
key, which
.EM must
be named with an initial solidus character;
all additional arguments are collected together,
to define the value to be associated with the specified key.
.LP
As is the case with the
.CW pdfview
macro,
.XR docview ), (
the
.CW /DOCINFO
records specified with the
.CW pdfinfo
macro are not immediately written to the \*[PostScript] output stream;
they are stored in the same \%meta\(hydata cache as
.CW /DOCVIEW
specifications, until this cache is explicitly flushed,
by invoking the
.CW pdfsync
macro,
.XR pdfsync ). (
.
.NH 2
.XN -N add-outline -- Creating a Document Outline
.LP
A PDF document outline comprises a table of references,
to \(lqbookmarked\(rq locations within the document.
When the document is viewed in an \(lqoutline\~aware\(rq PDF document reader,
such as \*[Adobe] \*[Acrobat] Reader,
this table of \(lqbookmarks\(rq may be displayed in a document outline pane,
or \(lqBookmarks\(rq pane, to the left of the main document view.
Individual references in the outline view may then be selected,
by clicking with the mouse,
to jump directly to the associated marked location in the document view.
.LP
The document outline may be considered as a collection of \(lqhypertext\(rq
references to \(lqbookmarked\(rq locations within the document.
The
.CW pdfmark
macro package provides a single generalized macro,
.CW pdfhref ,
for creating and linking to \(lqhypertext\(rq reference marks.
This macro will be described more comprehensively in a later section,
.XR pdfhref ); (
the description here is restricted to its use for defining document outline entries.
.
.NH 3
.XN -N basic-outline -- A Basic Document Outline
.LP
In its most basic form, the document outline comprises a structured list of headings,
each associated with a marked location, or \(lqbookmark\(rq, in the document text,
and a specification for how that marked location should be displayed,
when this bookmark is selected.
.LP
To create a PDF bookmark, the
.CW pdfhref
macro is used,
at the point in the document where the bookmark is to be placed,
in the form
.QP
.fam C
.B ".pdfhref O"
.I level > <
.I "descriptive text ..."
.LP
in which the reference class
.CWB O \& \& \(rq \(lq
stipulates that this is an outline reference.
.LP
Alternatively, for those users who may prefer to think of a document outline
simply as a collection of bookmarks, the
.CW pdfbookmark
macro is also provided\*[em]indeed,
.CW pdfhref
invokes it, when processing the
.CWB O \& \& \(rq \(lq
reference class operator.
It may be invoked directly, in the form
.QP
.fam C
.B .pdfbookmark
.I level > <
.I "descriptive text ..."
.LP
Irrespective of which of the above macro forms is employed, the
.CWI level > <
argument is required.
It is a numeric argument, defining the nesting level of the \(lqbookmark\(rq
in the outline hierarchy, with one being the topmost level.
Its function may be considered analogous to the
.EM "heading level"
of the document's section headings,
for example, as specified with the
.CW NH
macro, if using the
.CW ms
macros to format the document.
.LP
All further arguments, following the
.CWI level > <
argument, are collected together, to specify the heading text which will appear
in the document's outline view.
Thus, the outline entry for this section of this document,
which has a level three heading,
might be specified as
.QP
.CW
\&.pdfhref O 3 \*(SN A Basic Document Outline
.LP
or, in the alternative form using the
.CW pdfbookmark
macro, as
.QP
.CW
\&.pdfbookmark 3 \*(SN A Basic Document Outline
.
.NH 3
.XN Hierarchical Structure in a Document Outline
.LP
When a document outline is created, using the
.CW pdfhref
macro as described in
.\"
.\" Here is an example of how we can temporarily modify the format of
.\" a reference link, in this case to indicate only the section number
.\" of the link target, in the form "section #", (or, if we define
.\" "SECREF.BEGIN" before the call, its content followed by the
.\" section number).
.\"
.\" We first define a macro, which will get the reference data from
.\" pdfhref, as arguments, and will return the formatted output, as we
.\" require it, the string "PDFHREF.TEXT".
.\"
.de SECREF
.while \\n(.$ \{\
.   ie '\\$1'section' \{\
.      if !dSECREF.BEGIN .ds SECREF.BEGIN \\$1
.      ds PDFHREF.TEXT \\*[SECREF.BEGIN]\~\\$2
.      rm SECREF.BEGIN
.      shift \\n(.$
.      \}
.   el \{\
.      shift
.      if \\n(.$ .shift
.      \}
.   \}
..
.\" We now tell "pdfhref" to use our formatting macro, in place of
.\" its builtin default formatter, before we specify the reference.
.\"
.pdfhref F SECREF
.pdfhref L -A , -D basic-outline
.\"
.\" At this point, we would normally revert the "pdfhref" formatter
.\" to use its default, built in macro.  However, in this particular
.\" case, we want to use our custom format one more time, before we
.\" revert it, so we will omit the reversion step this time.
.\"
and any entry is added at a nesting level greater than one,
then a hierarchical structure is automatically defined for the outline.
However, as was noted in the simplified
.pdfhref L -D pdfmark-example -- example
in
.pdfhref L -A , -D pdfmark-operator
.\"
.\" And now, we revert to default "pdfhref" formatting behaviour,
.\" by completing the call we delayed above.
.\"
.pdfhref F
.\"
the data required by the
.CW pdfmark
operator to create the outline entry may not be fully defined,
when the outline reference is defined in the
.CW groff
document source.
Specifically, when the outline entry is created, its
.CW /Count
key must be assigned a value equal to the number of its subordinate entries,
at the next inner level of the outline hierarchy;
typically however,
these subordinate entries will be defined
.EM later
in the document source, and the appropriate
.CW /Count
value will be unknown, when defining the parent entry.
.LP
To resolve this paradox, the
.CW pdfhref
macro creates the outline entry in two distinct phases\*[em]a
destination marker is placed in the \*[PostScript] output stream immediately,
when the outline reference is defined,
but the actual outline entry is stored in an internal \(lqoutline cache\(rq,
until its subordinate hierarchy has been fully defined;
it can then be inserted in the output stream, with its
.CW /Count
value correctly assigned.
Effectively, to ensure integrity of the document outline structure,
this means that each top level outline entry, and
.EM all
of its subordinates, are retained in the cache, until the
.EM next
top level entry is defined.
.LP
One potential problem, which arises from the use of the \(lqoutline cache\(rq,
is that, at the end of any document formatting run, the last top level outline entry,
and any subordinates defined after it, will remain in the cache, and will
.EM not
be automatically written to the output stream.
To avoid this problem, the user should follow the guidelines given in
.\"
.\" Here is a more conventional example of how to temporarily change
.\" to the format used to display reference links.  We will again use
.\" the "SECREF" format, which we defined above, but on this occasion
.\" we will immediately revert to the default format, after the link
.\" has been placed.
.\"
.pdfhref F SECREF
.pdfhref L -D pdfsync -A ,
.pdfhref F
.\"
to synchronize the output state with the cache state,
.XR pdfsync ), (
at the end of the
.CW groff
formatting run.
.
.NH 3
.XN -N outline-view -- Associating a Document View with an Outline Reference
.LP
Each \(lqbookmark\(rq entry, in a PDF document outline,
is associated with a specific document view.
When the reader selects any outline entry,
the document view changes to display the document context
associated with that entry.
.LP
The document view specification,
to be associated with any document outline entry,
is established at the time when the outline entry is created.
However, rather than requiring that each individual use of the
.CW pdhref
macro, to create an outline entry,
should include its own view specification,
the actual specification assigned to each entry is derived from
a generalized specification defined in the string
.CW PDFBOOKMARK.VIEW ,
together with the setting of the numeric register
.CW PDFHREF.VIEW.LEADING ,
which determine the effective view specification as follows:\(en
.QS
.sp -\n[PD]u
.IP \*[= PDFBOOKMARK.VIEW]
Establishes the magnification at which the document will be viewed,
at the location of the \(lqbookmark\(rq; by default, it is defined by
.RS
.QP
.CW ".ds PDFBOOKMARK.VIEW /FitH \e\en[PDFPAGE.Y] u"
.RE
.IP
which displays the associated document view,
with the \(lqbookmark\(rq location positioned at the top of the display window,
and with the magnification set to fit the page width to the width of the window.
.IP \*[= PDFHREF.VIEW.LEADING]
Specifies additional spacing,
to be placed between the top of the display window
and the actual location of the \(lqbookmark\(rq on the displayed page view.
By default, it is set as
.RS
.QP
.CW ".nr PDFHREF.VIEW.LEADING 5.0p"
.RE
.IP
Note that
.CW PDFHREF.VIEW.LEADING
does not represent true \(lqleading\(rq, in the typographical sense,
since any preceding text, set in the specified display space,
will be visible at the top of the document viewing window,
when the reference is selected.
.IP
Also note that the specification of
.CW PDFHREF.VIEW.LEADING
is shared by
.EM all
reference views defined by the
.CW pdfhref
macro; whereas
.CW PDFBOOKMARK.VIEW
is applied exclusively to outline references,
there is no independent
.CW PDFBOOKMARK.VIEW.LEADING
specification.
.QE
.LP
If desired, the view specification may be changed, by redefining the string
.CW PDFBOOKMARK.VIEW ,
and possibly also the numeric register
.CW PDFHREF.VIEW.LEADING .
Any alternative definition for
.CW PDFBOOKMARK.VIEW
.EM must
be specified in terms of valid view specification parameters,
as described in the \*[Adobe]
.pdfmark-manual .
.LP
Note the use of the register
.CW PDFPAGE.Y ,
in the default definition of
.CW PDFBOOKMARK.VIEW
above.
This register is computed by
.CW pdfhref ,
when creating an outline entry;
it specifies the vertical position of the \(lqbookmark\(rq,
in basic
.CW groff
units, relative to the
.EM bottom
edge of the document page on which it is defined,
and is followed, in the
.CW PDFBOOKMARK.VIEW
definition, by the
.CW grops
.CW u \(rq \(lq
operator, to convert it to \*[PostScript] units on output.
It may be used in any redefined specification for
.CW PDFBOOKMARK.VIEW ,
(or in the analogous definition of
.CW PDFHREF.VIEW ,
described in
'ne 2v
.XR-NO-PREFIX pdfhref-view ),
but
.EM not
in any other context,
since its value is undefined outside the scope of the
.CW pdfhref
macro.
.LP
Since
.CW PDFPAGE.Y
is computed relative to the
.EM bottom
of the PDF output page,
it is important to ensure that the page length specified to
.CW troff
correctly matches the size of the logical PDF page.
This is most effectively ensured,
by providing
.EM identical
page size specifications to
.CW groff ,
.CW grops
and to the \*[PostScript] to PDF converter employed,
and avoiding any page length changes within the document source.
.LP
Also note that
.CW PDFPAGE.Y
is the only automatically computed \(lqbookmark\(rq location parameter;
if the user redefines
.CW PDFBOOKMARK.VIEW ,
and the modified view specification requires any other positional parameters,
then the user
.EM must
ensure that these are computed
.EM before
invoking the
.CW pdfhref
macro.
.
.NH 3
.XN -N outline-folding -- Folding the Outline to Conceal Less Significant Headings
.LP
When a document incorporates many subheadings,
at deeply nested levels,
it may be desirable to \(lqfold\(rq the outline
such that only the major heading levels are initially visible,
yet making the inferior subheadings accessible,
by allowing the reader to expand the view of any heading branch on demand.
.LP
The
.CW pdfmark
macros support this capability,
through the setting of the
.CW PDFOUTLINE.FOLDLEVEL
register.
This register should be set to the number of heading levels
which it is desired to show in expanded form, in the
.EM initial
document outline display;
all subheadings at deeper levels will still be added to the outline,
but will not become visible until the outline branch containing them is expanded.
'ne 5
For example, the setting used in this document:
.QS
.sp -\n[PD]u
.LD
.fam C
\&.\e" Initialize the outline view to show only three heading levels,
\&.\e" with additional subordinate level headings folded.
\&.\e"
\&.nr PDFOUTLINE.FOLDLEVEL 3
.DE
.sp -\n[PD]u
.QE
.sp -\n[PD]u
.LP
results in only the first three levels of headings being displayed
in the document outline,
.EM until
the reader chooses to expand the view,
and so reveal the lower level headings in any outline branch.
.LP
The initial default setting of
.CW PDFOUTLINE.FOLDLEVEL ,
if the document author does not choose to change it,
is 10,000.
This is orders of magnitude greater than the maximum heading level
which is likely to be used in any document;
thus the default behaviour will be to show document outlines fully expanded,
to display all headings defined,
at all levels within each document.
.LP
The setting of
.CW PDFOUTLINE.FOLDLEVEL
may be changed at any time;
however, the effect of each such change may be difficult to predict,
since it is applied not only to outline entries which are defined
.EM after
the setting is changed,
but also to any entries which remain in the outline cache,
.EM at
this time.
Therefore, it is recommended that
.CW PDFOUTLINE.FOLDLEVEL
should be set
.EM once ,
at the start of each document;
if it
.EM is
deemed necessary to change it at any other time,
the outline cache should be flushed,
.XR pdfsync ), (
.EM immediately
before the change,
which should immediately precede a level one heading.
.
.NH 3
.XN -N multipart-outline -- Outlines for Multipart Documents
.LP
When a document outline is created, using the
.CW pdfhref
macro, each reference mark is automatically assigned a name,
composed of a fixed stem followed by a serially generated numeric qualifier.
This ensures that, for each single part document, every outline reference
has a uniquely named destination.
.LP
As the overall size of the PDF document increases,
it may become convenient to divide it into smaller,
individually formatted \*[PostScript] components,
which are then assembled, in the appropriate order,
to create a composite PDF document.
While this strategy may simplify the overall process of creating and
editing larger documents, it does introduce a problem in creating
an overall document outline,
since each individual \*[PostScript] component will be assigned
duplicated sequences of \(lqbookmark\(rq names,
with each name ultimately referring to multiple locations in the composite document.
To avoid such reference naming conflicts, the
.CW pdfhref
macro allows the user to specify a \(lqtag\(rq,
which is appended to the automatically generated \(lqbookmark\(rq name;
this may be used as a discriminating mark, to distinguish otherwise
similarly named destinations, in different sections of the composite document.
.LP
To create a \(lqtagged\(rq document outline,
the syntax for invocation of the
.CW pdfhref
macro is modified, by the inclusion of an optional \(lqtag\(rq specification,
.EM before
the nesting level argument, i.e.
.QP
.fam C
.B ".pdfhref O"
.B -T \& [
.I tag >] <
.I level > <
.I "descriptive text ..."
.LP
The optional
.CWI tag > <
argument may be composed of any characters of the user's choice;
however, its initial character
.EM "must not"
be any decimal digit, and ideally it should be kept short\*[em]one
or two characters at most.
.LP
By employing a different tag in each section,
the user can ensure that \(lqbookmark\(rq names remain unique,
throughout all the sections of a composite document.
For example, when using the
.CW spdf.tmac
macro package, which adds
.CW pdfmark
capabilities to the standard
.CW ms
package,
.XR using-spdf ), (
the table of contents is collected into a separate \*[PostScript] section
from the main body of the document.
In the \(lqbody\(rq section, the document outline is \(lquntagged\(rq,
but in the \(lqTable\~of\~Contents\(rq section, a modified version of the
.CW TC
macro adds an outline entry for the start of the \(lqTable\~of\~Contents\(rq,
invoking the
.CW pdfhref
macro as
.QP
.CW ".pdfhref O -T T 1 \e\e*[TOC]"
.LP
to tag the associated outline destination name with the single character suffix,
.CW T \(rq. \(lq
Alternatively, as in the case of the basic outline,
.XR basic-outline ), (
this may equally well be specified as
.QP
.CW ".pdfbookmark -T T 1 \e\e*[TOC]"
.
.NH 3
.XN Delegation of the Outline Definition
.LP
Since the most common use of a document outline
is to provide a quick method of navigating through a document,
using active \(lqhypertext\(rq links to chapter and section headings,
it may be convenient to delegate the responsibility of creating the outline
to a higher level macro, which is itself used to
define and format the section headings.
This approach has been adopted in the
.CW spdf.tmac
package, to be described later,
.XR using-spdf ). (
.LP
When such an approach is adopted,
the user will rarely, if ever, invoke the
.CW pdfhref
macro directly, to create a document outline.
For example, the structure and content of the outline for this document
has been exclusively defined, using a combination of the
.CW NH
macro, from the
.CW ms
package, to establish the structure, and the
.CW XN
macro from
.CW spdf.tmac ,
to define the content.
In this case,
the responsibility for invoking the
.CW pdfhref
macro, to create the document outline,
is delegated to the
.CW XN
macro.
.
.NH 2
.XN -N pdfhref -- Adding Reference Marks and Links
.LP
.pdfhref F SECREF
.ds SECREF.BEGIN Section
.pdfhref L -D add-outline
.pdfhref F
has shown how the
.CW pdfhref
macro may be used to create a PDF document outline.
While this is undoubtedly a powerful capability,
it is by no means the only trick in the repertoire of this versatile macro.
.LP
The macro name,
.CW pdfhref ,
which is a contraction of \(lqPDF HyperText Reference\(rq,
indicates that the general purpose of this macro is to define
.EM any
type of dynamic reference mark, within a PDF document.
Its generalized usage syntax takes the form
.QP
.fam C
.B .pdfhref
.BI class > <
.I "-options ...\&" ] [
[--]
.I "descriptive text ...\&" ] [
.LP
where
.CW <\f(CIclass\fP>
represents a required single character argument,
which defines the specific reference operation to be performed,
and may be selected from:\(en
.QS
.sp -\n[PD]u
.IP \*[= O]
Add an entry to the document outline.
This operation has been described earlier,
.XR add-outline ). (
.IP \*[= M]
Place a \(lqnamed destination\(rq reference mark at the current output position,
in the current PDF document,
.XR mark-dest ). (
.IP \*[= D]
Specify the content of a PDF document reference dictionary entry;
typically, such entries are generated automatically,
by transformation of the intermediate output resulting from the use of
.CW pdfhref
.CWB M \& \& \(rq, \(lq
with the
.CWB -X \& \& \(rq \(lq
modifier,
.XR create-map ); (
however, it is also possible to specify such entries manually,
.XR user-format ). (
.IP \*[= L]
Insert an active link to a named destination,
.XR link-named ), (
at the current output position in the current PDF document,
such that when the reader clicks on the link text,
the document view changes to show the location of the named destination.
.IP \*[= W]
Insert an active link to a \(lqweb\(rq resource,
.XR add-weblink ), (
at the current output position in the current PDF document.
This is effectively the same as using the
.CWB L \& \& \(rq \(lq
operator to establish a link to a named destination in another PDF document,
.XR link-extern ), (
except that in this case, the destination is specified by a
\(lquniform resource identifier\(rq, or
.CW URI ;
this may represent any Internet or local resource
which can be specified in this manner.
.IP \*[= F]
Specify a user defined macro, to be called by
.CW pdfhref ,
when formatting the text in the active region of a link,
.XR set-format ). (
.IP \*[= K]
Define one or more location keywords,
and associated \%format\(hystring names,
which should be interpreted by the
.CW pdfhref
reference text formatting routine,
.XR custom-format ). (
.IP \*[= Z]
Define the absolute position on the physical PDF output page,
where the \%\(lqhot\(hyspot\(rq associated with an active link is to be placed.
Invoked in pairs, marking the starting and ending PDF page \%co\(hyordinates
for each link \%\(lqhot\(hyspot\(rq, this operator is rarely, if ever,
specified directly by the user;
rather, appropriate
.CW pdfhref
.CWB Z \& \& \(rq \(lq
specifications are inserted automatically into the document reference map
during the PDF document formatting process,
.XR create-map ). (
.IP \*[= I]
Initialize support for
.CW pdfhref
features.
The current
.CW pdfhref
implementation provides only one such feature which requires
initialization\*[em]a helper macro which must be attached to
a user supplied page trap handler,
in order to support mapping of reference \%\(lqhot\(hyspots\(rq
which extend through a page transition;
.XR page-trap ). (
.QE
.
.NH 3
.XN -S -- Optional Features of the \F[C]pdfhref\F[] Macro
.LP
The behaviour of a number of the
.CW pdfhref
macro operations can be modified,
by including
.EM "option specifiers" \(rq \(lq
after the operation specifying argument,
but
.EM before
any other arguments normally associated with the operation.
In
.EM all
cases, an option is specified by an
.EM "option flag" \(rq, \(lq
comprising an initial hyphen,
followed by one or two option identifying characters.
Additionally,
.EM some
options require
.EM "exactly one"
option argument;
for these options, the argument
.EM must
be specified, and it
.EM must
be separated from the preceding option flag by one or more
.EM spaces ,
(tabs
.EM "must not"
be used).
It may be noted that this paradigm for specifying options
is reminiscent of most
Unix\(tm
shells; however, in the case of the
.CW pdfhref
macro, omission of the space separating an option flag from its argument is
.EM never
permitted.
.LP
A list of
.EM all
general purpose options supported by the
.CW pdfhref
macro is given below.
Note that not all options are supported for all
.CW pdfhref
operations; the operations affected by each option are noted in the list.
For
.EM most
operations, if an unsupported option is specified,
it will be silently ignored; however, this behaviour should
not be relied upon.
.LP
The general purpose options, supported by the
.CW pdfhref
macro, are:\(en
.QS
.sp -\n[PD]u
.IP \*[= -N\0 name > <] 4n
Allows the
.CWI name > <
associated with a PDF reference destination
to be defined independently from the following text,
which describes the reference.
This option affects only the
.CWB M \& \& \(rq \(lq
operation of the
.CW pdfhref
macro,
.XR mark-dest ). (
.IP \*[= -E]
Also used exclusively with the
.CWB M \& \& \(rq \(lq
operator, the
.CWB -E
option causes any specified
.CWI descriptive \& \& \~\c
.CWI text
arguments,
.XR mark-dest ), (
to be copied, or
.EM echoed ,
in the body text of the document,
at the point where the reference mark is defined;
(without the
.CWB -E
option, such
.CWI descriptive \& \& \~\c
.CWI text
will appear
.EM only
at points where links to the reference mark are placed,
and where the standard reference display format,
.XR set-format ), (
is used).
.IP \*[= -D\0 dest > <]
Specifies the
.CW URI ,
or the destination name associated with a PDF active link,
independently of the following text,
which describes the link and demarcates the link \%\(lqhot\(hyspot\(rq.
This option affects the behaviour of the
.CW pdfhref
macro's
.CWB L \& \& \(rq \(lq
and
.CWB W \& \& \(rq \(lq
operations.
.IP
When used with the
.CWB L \& \& \(rq \(lq
operator, the
.CWI dest > <
argument must specify a PDF \(lqnamed destination\(rq,
as defined using
.CW pdfhref
with the
.CWB M \& \& \(rq \(lq
operator.
.IP
When used with the
.CWB W \& \& \(rq \(lq
operator,
.CWI dest > <
must specify a link destination in the form of a
\(lquniform resource identifier\(rq, or
.CW URI ,
.XR add-weblink ). (
.IP \*[= -F\0 file > <]
When used with the
.CWB L \& \& \(rq \(lq
.CW pdfhref
operator,
.CWI file > <
specifies an external PDF file in which the named destination
for the link reference is defined.
This option
.EM must
be specified with the
.CWB L \& \& \(rq \(lq
operator,
to create a link to a destination in a different PDF document;
when the
.CWB L \& \& \(rq \(lq
operator is used
.EM without
this option, the link destination is assumed to be defined
within the same document.
.
.IP \*[= -P\0 \(dqprefix\(hytext\(dq > <]
'ne 4v
Specifies
.CWI \(dqprefix\(hytext\(dq > \%<
to be attached to the
.EM start
of the text describing an active PDF document link,
with no intervening space, but without itself being included in the
active area of the link \%\(lqhot\(hyspot\(rq;
it is effective with the
.CWB L \& \& \(rq \(lq
and
.CWB W \& \& \(rq \(lq
.CW pdfhref
operators.
.
.IP
'ne 3v
Typically, this option would be used to insert punctuation before
the link \%\(lqhot\(hyspot\(rq.
Thus, there is little reason for the inclusion of spaces in
.CWI \(dqprefix\(hytext\(dq > \%< ;
however, if such space is required, then the enclosing double quotes
.EM must
be specified, as indicated.
.
.IP \*[= -A\0 \(dqaffixed\(hytext\(dq > <]
'ne 4v
Specifies
.CWI \(dqaffixed\(hytext\(dq > \%<
to be attached to the
.EM end
of the text describing an active PDF document link,
with no intervening space, but without itself being included in the
active area of the link \%\(lqhot\(hyspot\(rq;
it is effective with the
.CWB L \& \& \(rq \(lq
and
.CWB W \& \& \(rq \(lq
.CW pdfhref
operators.
.
.IP
'ne 3v
Typically, this option would be used to insert punctuation after
the link \%\(lqhot\(hyspot\(rq.
Thus, there is little reason for the inclusion of spaces in
.CWI \(dqaffixed\(hytext\(dq > \%< ;
however, if such space is required, then the enclosing double quotes
.EM must
be specified, as indicated.
.
.IP \*[= -T\0 tag > <]
When specified with the
.CWB O \& \& \(rq \(lq
operator,
.CWI tag > <
is appended to the \(lqbookmark\(rq name assigned to the generated outline entry.
This option is
.EM required ,
to distinguish between the series of \(lqbookmark\(rq names generated in
individual passes of the
.CW groff
formatter, when the final PDF document is to be assembled
from a number of separately formatted components;
.XR multipart-outline ). (
.IP \*[= -X]
This
.CW pdfhref
option is used with either the
.CWB M \& \& \(rq \(lq
operator, or with the
.CWB L \& \& \(rq \(lq
operator.
.IP
When used with the
.CWB M \& \& \(rq \(lq
operator,
.XR mark-dest ), (
it ensures that a cross reference record for the marked destination
will be included in the document reference map,
.XR export-map ). (
.IP
When used with the
.CWB L \& \& \(rq \(lq
operator,
.XR link-named ), (
it causes the reference to be displayed in the standard cross reference format,
.XR set-format ), (
but substituting the
.CWI descriptive \& \& \~\c
.CWI text
specified in the
.CW pdfhref \& \(lq
.CW L \(rq
argument list,
for the description specified in the document reference map.
.IP \*[= --]
Marks the end of the option specifiers.
This may be used with all
.CW pdfhref
operations which accept options, to prevent
.CW pdfhref
from interpreting any following arguments as option specifiers,
even if they would otherwise be interpreted as such.
It is also useful when the argument list to
.CW pdfhref
contains special characters\*[em]any special character,
which is not valid in a
.CW groff
macro name, will cause a parsing error, if
.CW pdfhref
attempts to match it as a possible option flag;
using the
.CW -- \(rq \(lq
flag prevents this, so suppressing the
.CW groff
warning message, which would otherwise ensue.
.IP
Using this flag after
.EM all
sequences of macro options is recommended,
even when it is not strictly necessary,
if only for the entirely cosmetic benefit of visually separating
the main argument list from the sequence of preceding options.
.QE
.sp -\n[PD]u
.LP
In addition to the
.CW pdfhref
options listed above, a supplementary set of two character options are defined.
These supplementary options, listed below, are intended for use with the
.CWB L \& \& \(rq \(lq
operator, in conjunction with the
.CWB -F \& \& \~\c
.CWBI file > <
option, to specify alternate file names,
in formats compatible with the file naming conventions
of alternate operating systems;
they will be silently ignored, if used in any other context.
.LP
The supported alternate file name options,
which are ignored if the
.CWB -F \& \& \~\c
.CWBI file > <
option is not specified, are:\(en
.QS
.sp -\n[PD]u
.IP \*[= -DF\0 dos\(hyfile > <] 5n
Specifies the name of the file in which a link destination is defined,
using the file naming semantics of the
.CW \%MS\(hyDOS \*(rg
operating system.
When the PDF document is read on a machine
where the operating system uses the
.CW \%MS\(hyDOS \*(rg
file system, then
.CWI dos\(hyfile > \%<
is used as the name of the file containing the reference destination,
overriding the
.CWI file > <
argument specified with the
.CWB -F
option.
.IP \*[= -MF\0 mac\(hyfile > <]
Specifies the name of the file in which a link destination is defined,
using the file naming semantics of the
.CW Apple \*(rg
.CW Macintosh \*(rg
operating system.
When the PDF document is read on a machine
where the operating system uses the
.CW Macintosh \*(rg
file system, then
.CWI mac\(hyfile > \%<
is used as the name of the file containing the reference destination,
overriding the
.CWI file > <
argument specified with the
.CWB -F
option.
.IP \*[= -UF\0 unix\(hyfile > <]
Specifies the name of the file in which a link destination is defined,
using the file naming semantics of the
.CW Unix \(tm
operating system.
When the PDF document is read on a machine
where the operating system uses
.CW POSIX
file naming semantics, then
.CWI unix\(hyfile > \%<
is used as the name of the file containing the reference destination,
overriding the
.CWI file > <
argument specified with the
.CWB -F
option.
.IP \*[= -WF\0 win\(hyfile > <]
Specifies the name of the file in which a link destination is defined,
using the file naming semantics of the
.CW \%MS\(hyWindows \*(rg
\%32\(hybit operating system.
When the PDF document is read on a machine
where the operating system uses any of the
.CW \%MS\(hyWindows \*(rg
file systems, with long file name support, then
.CWI win\(hyfile > \%<
is used as the name of the file containing the reference destination,
overriding the
.CWI file > <
argument specified with the
.CWB -F
option.
.QE
.
.NH 3
.XN -N mark-dest -- Marking a Reference Destination
.LP
The
.CW pdfhref
macro may be used to create active links to any Internet resource,
specified by its
.CW URI ,
or to any \(lqnamed destination\(rq,
either within the same document, or in another PDF document.
Although the PDF specification allows link destinations to be defined
in terms of a page number, and an associated view specification,
this style of reference is not currently supported by the
.CW pdfhref
macro, because it is not possible to adequately bind the specification
for the destination with the intended reference context.
.LP
References to Internet resources are interpreted in accordance with the
.CW W3C
standard for defining a
.CW URI ;
hence the only prerequisite, for creating a link to any Internet resource,
is that the
.CW URI
be properly specified, when declaring the reference;
.XR add-weblink ). (
In the case of references to \(lqnamed destinations\(rq in PDF documents,
however, it is necessary to provide a mechanism for creating such
\(lqnamed destinations\(rq.
This may be accomplished, by invoking the
.CW pdfhref
macro in the form
.QP
.fam C
.B ".pdfhref M"
.B -N \& [
.I name >] <
.B -X ] [
.B -E ] [
.I "descriptive text ...\&" ] [
.LP
This creates a \(lqnamed destination\(rq reference mark, with its name specified by
.CWI name > < ,
or, if the
.CWB -N
option is not specified, by the first word of
.CWI descriptive \& \& \~\c
.CWI text \& \& ;
(note that this imposes the restriction that,
if the
.CWB -N
option is omitted, then
.EM "at least"
one word of
.CWI descriptive \& \& \~\c
.CWI text
.EM must
be specified).
Additionally, a reference view will be automatically defined,
and associated with the reference mark,
.XR pdfhref-view ), (
.\" and, if any
.\" .CWI descriptive
.\" .CWI text
.\" is specified, or the
and, if the
.CWB -X
option is specified, and no document cross reference map has been imported,
.XR import-map ), (
then a cross reference mapping record,
.XR export-map ), (
will be written to the
.CW stdout
stream;
this may be captured, and subsequently used to generate a cross reference map
for the document,
.XR create-map ). (
.LP
When a \(lqnamed destination\(rq reference mark is created, using the
.CW pdfhref
macro's
.CWB M \& \& \(rq \(lq
operator, there is normally no visible effect in the formatted document; any
.CWI descriptive \& \& \~\c
.CWI text
which is specified will simply be stored in the cross reference map,
for use when a link to the reference mark is created.
This default behaviour may be changed, by specifying the
.CWB -E
option, which causes any specified
.CWI descriptive \& \& \~\c
.CWI text
to be \(lqechoed\(rq in the document text,
at the point where the reference mark is placed,
in addition to its inclusion in the cross reference map.
.
.NH 4
.XN -N export-map -- Mapping a Destination for Cross Referencing
.LP
Effective cross referencing of
.EM any
document formatted by
.CW groff
requires multiple pass formatting.
Details of how this multiple pass formatting may be accomplished,
when working with the
.CW pdfmark
macros, will be discussed later,
.XR do-xref ); (
at this stage, the discussion will be restricted to the initial preparation,
which is required at the time when the cross reference destinations are defined.
.LP
The first stage, in the process of cross referencing a document,
is the generation of a cross reference map.
Again, the details of
.EM how
the cross reference map is generated will be discussed in
.pdfhref F SECREF L -D do-xref -A ;
.pdfhref F
however, it is important to recognize that
.EM what
content is included in the cross reference map is established
when the reference destination is defined\*[em]it is derived
from the reference data exported on the
.CW stderr
stream by the
.CW pdfhref
macro, when it is invoked with the
.CWB M \& \& \(rq \(lq
operator, and is controlled by whatever definition of the string
.CW PDFHREF.INFO
is in effect, when the
.CW pdfhref
macro is invoked.
.LP
The initial default setting of
.CW PDFHREF.INFO
is
.QP
.CW ".ds PDFHREF.INFO page \e\en% \e\e$*"
.LP
which ensures that the cross reference map will contain
at least a page number reference, supplemented by any
.CWI descriptive \& \& \~\c
.CWI text
which is specified for the reference mark, as defined by the
.CW pdfhref
macro, with its
.CWB M \& \& \(rq \(lq
operator; this may be redefined by the user,
to export additional cross reference information,
or to modify the default format for cross reference links,
.XR set-format ). (
.
.NH 4
'ne 4v+\n[PD]u
.XN -N pdfhref-view -- Associating a Document View with a Reference Mark
.LP
In the same manner as each document outline reference, defined by the
.CW pdfhref
macro with the
.CWB O \& \& \(rq \(lq
operator,
.XR add-outline ), (
has a specific document view associated with it,
each reference destination marked by
.CW pdfhref
with the
.CWB M \& \& \(rq \(lq
operator, requires an associated document view specification.
.LP
The mechanism whereby a document view is associated with a reference mark
is entirely analogous to that employed for outline references,
.XR outline-view ), (
except that the
.CW PDFHREF.VIEW
string specification is used, in place of the
.CW PDFBOOKMARK.VIEW
specification.
'ne 2v
Thus, the reference view is defined in terms of:\(en
.QS
.sp -\n[PD]u
.IP \*[= PDFHREF.VIEW]
A string,
establishing the position of the reference mark within the viewing window,
and the magnification at which the document will be viewed,
at the location of the marked reference destination;
by default, it is defined by
.RS
.QP
.CW ".ds PDFHREF.VIEW /FitH \e\en[PDFPAGE.Y] u"
.RE
.IP
which displays the reference destination at the top of the viewing window,
with the magnification set to fit the page width to the width of the window.
.IP \*[= PDFHREF.VIEW.LEADING]
A numeric register,
specifying additional spacing, to be placed between the top of the display
window and the actual position at which the location of the reference
destination appears within the window.
This register is shared with the view specification for outline references,
and thus has the same default initial setting,
.RS
.QP
.CW ".nr PDFHREF.VIEW.LEADING 5.0p"
.RE
.IP
as in the case of outline reference views.
.IP
Again, notice that
.CW PDFHREF.VIEW.LEADING
does not represent true typographic \(lqleading\(rq,
since any preceding text, set in the specified display space,
will be visible at the top of the viewing window,
when the reference is selected.
.QE
.LP
.sp -\n[PD]u
Just as the view associated with outline references may be changed,
by redefining
.CW PDFBOOKMARK.VIEW ,
so the view associated with marked reference destinations may be changed,
by redefining
.CW PDFHREF.VIEW ,
and, if desired,
.CW PDFHREF.VIEW.LEADING ;
such changes will become effective for all reference destinations marked
.EM after
these definitions are changed.
(Notice that, since the specification of
.CW PDFHREF.VIEW.LEADING
is shared by both outline reference views and marked reference views,
if it is changed, then the views for
.EM both
reference types are changed accordingly).
.LP
It may again be noted, that the
.CW PDFPAGE.Y
register is used in the definition of
.CW PDFHREF.VIEW ,
just as it is in the definition of
.CW PDFBOOKMARK.VIEW ;
all comments in
.pdfhref F SECREF L -D outline-view
.pdfhref F
relating to its use, and indeed to page position computations in general,
apply equally to marked reference views and to outline reference views.
.
.NH 3
.XN -N link-named -- Linking to a Marked Reference Destination
.LP
Any named destination, such as those marked by the
.CW pdfhref
macro, using it's
.CWB M \& \& \(rq \(lq
operator, may be referred to from any point in
.EM any
PDF document, using an
.EM "active link" ;
such active links are created by again using the
.CW pdfhref
macro, but in this case, with the
.CWB L \& \& \(rq \(lq
operator.
This operator provides support for two distinct cases,
depending on whether the reference destination is defined in
the same document as the link,
.XR link-intern ), (
or is defined as a named destination in a different PDF document,
.XR link-extern ). (
.
.NH 4
.XN -N link-intern -- References within a Single PDF Document
.LP
The general syntactic form for invoking the
.CW pdfhref
macro,
when creating a link to a named destination within the same PDF document is
.QP
.fam C
.B .pdfhref
.B L
.B -D \& [
.BI dest-name >] <
.B -P \& [
.BI prefix-text >] <
.B -A \& [
.BI affixed-text >] <
\e
.br
\0\0\0
.B -X ] [
.B -- ] [
.I "descriptive text ...\&" ] [
.LP
where
.CWI dest-name > <
specifies the name of the link destination,
as specified using the
.CW pdfhref
.CWB M \& \& \(rq \(lq
operation; (it may be defined either earlier in the document,
to create a backward reference, or later, to create a forward reference).
.\"
.\" Here's a example of how to add an iconic annotation.
.\"
.\".pdfnote -T "Internal Cross References" \
.\"   This description is rather terse, and could benefit from \
.\"   the inclusion of an example.
.LP
If any
.CWI descriptive \& \& \~\c
.CWI text
arguments are specified, then they will be inserted into the
.CW groff
output stream, to define the text appearing in the \%\(lqhot\(hyspot\(rq
region of the link;
this will be printed in the link colour specified by the string,
.CW PDFHREF.TEXT.COLOUR ,
which is described in
.XR-NO-PREFIX set-colour .
If the
.CWB -X
option is also specified, then the
.CWI descriptive \& \& \~\c
.CWI text
will be augmented, by prefacing it with page and section number indicators,
in accordance with the reference formatting rules which are in effect,
.XR set-format ); (
such indicators will be included within the active link region,
and will also be printed in the link colour.
.LP
Note that
.EM either
the
.CWB -D \& \& \~\c
.CWBI dest\(hyname > \%<
option,
.EM or
the
.CWI descriptive \& \& \~\c
.CWI text
arguments,
.EM "but not both" ,
may be omitted.
If the
.CWB -D \& \& \~\c
.CWBI dest\(hyname > \%<
option is omitted, then the first word of
.CWI descriptive \& \& \~\c
.CWI text \& \& ,
i.e.\~all text up to but not including the first space,
will be interpreted as the
.CWBI dest\(hyname > \%<
for the link; this text will also appear in the running text of the document,
within the active region of the link.
Alternatively, if the
.CWB -D \& \& \~\c
.CWBI dest\(hyname > \%<
option
.EM is
specified, and
.CWI descriptive \& \& \~\c
.CWI text
is not,
then the running text which defines the reference,
and its active region,
will be derived from the reference description which is specified
when the named destination is marked,
.XR mark-dest ), (
and will be formatted according to the reference formatting rules
which are in effect, when the reference is placed,
.XR set-format ); (
in this case, it is not necessary to specify the
.CWB -X
option to activate automatic formatting of the reference\*[em]it is implied,
by the omission of all
.CWI descriptive \& \& \~\c
.CWI text
arguments.
.LP
The
.CWB -P \& \& \~\c
.CWBI prefix\(hytext > \%<
and
.CWB -A \& \& \~\c
.CWBI affixed\(hytext > \%<
options may be used to specify additional text
which will be placed before and after the linked text respectively,
with no intervening space.
Such prefixed and affixed text will be printed in the normal text colour,
and will not be included within the active region of the link.
This feature is mostly useful for creating parenthetical references,
or for placing punctuation adjacent to,
but not included within,
the text which defines the active region of the link.
.LP
The operation of the
.CW pdfhref
macro, when used with its
.CWB L \& \& \(rq \(lq
operator to place a link to a named PDF destination,
may best be illustrated by an example.
However, since the appearance of the link will be influenced by
factors established when the named destination is marked,
.XR mark-dest ), (
and also by the formatting rules in effect when the link is placed,
the presentation of a suitable example will be deferred,
until the formatting mechanism has been explained,
.XR set-format ). (
.
.NH 4
.XN -N link-extern -- References to Destinations in Other PDF Documents
.LP
The
.CW pdfhref
macro's
.CWB L \& \& \(rq \(lq
operator is not restricted to creating reference links
within a single PDF document.
When the link destination is defined in a different document,
then the syntactic form for invoking
.CW pdfhref
is modified, by the addition of options to specify the
name and location of the PDF file in which the destination is defined.
Thus, the extended
.CW pdfhref
syntactic form becomes
.QP
.fam C
.B .pdfhref
.B L
.B -F
.BI file > <
.B -D \& [
.BI dest-name >] <
\e
.br
\0\0\0
.B -DF \& [
.BI dos-file >] <
.B -MF \& [
.BI mac-file >] <
.B -UF \& [
.BI unix-file >] <
\e
.br
\0\0\0
.B -WF \& [
.BI win-file >] <
.B -P \& [
.BI prefix-text >] <
.B -A \& [
.BI affixed-text >] <
\e
.br
\0\0\0
.B -X ] [
.B -- ] [
.I "descriptive text ...\&" ] [
.LP
where the
.CWB -F \& \& \~\c
.CWBI file > <
option serves
.EM two
purposes: it both indicates to the
.CW pdfhref
macro that the specified reference destination
is defined in an external PDF file,
and it also specifies the normal path name,
which is to be used to locate this file,
when a user selects the reference.
.LP
In addition to the
.CWB -F \& \& \~\c
.CWBI file > <
option, which
.EM must
be specified when referring to a destination in an external PDF file,
the
.CWB -DF \& \& \~\c
.CWBI dos\(hyfile > \%< ,
.CWB -MF \& \& \~\c
.CWBI mac\(hyfile > \%< ,
.CWB -UF \& \& \~\c
.CWBI unix\(hyfile > \%<
and
.CWB -WF \& \& \~\c
.CWBI win\(hyfile > \%<
options may be used to specify the location of the file
containing the reference destination,
in a variety of operating system dependent formats.
These options assign their arguments to the
.CW /DosFile ,
.CW /MacFile ,
.CW /UnixFile
and
.CW /WinFile
keys of the generated
.CW pdfmark
respectively; thus when any of these options are specified,
.EM "in addition to"
the
.CWB -F \& \& \~\c
.CWBI file > <
option, and the document is read on the appropriate operating systems,
then the path names specified by
.CWBI dos\(hyfile > \%< ,
.CWBI mac\(hyfile > \%< ,
.CWBI unix\(hyfile > \%<
and
.CWBI win\(hyfile > \%<
will be searched,
.EM instead
of the path name specified by
.CWBI file > < ,
for each of the
.CW \%MS\(hyDOS \*(rg,
.CW Apple \*(rg
.CW Macintosh \*(rg,
.CW Unix \(tm
and
.CW \%MS\(hyWindows \*(rg
operating systems, respectively; see the
.pdfmark-manual ,
for further details.
.LP
Other than the use of these additional options,
which specify that the reference destination is in an external PDF file,
the behaviour of the
.CW pdfhref
.CWB L \& \& \(rq \(lq
operator, with the
.CWB -F \& \& \~\c
.CWBI file > <
option, remains identical to its behaviour
.EM without
this option,
.XR link-intern ), (
with respect to the interpretation of other options,
the handling of the
.CWI descriptive \& \& \~\c
.CWI text
arguments, and the formatting of the displayed reference.
.LP
Once again, since the appearance of the reference is determined by
factors specified in the document reference map,
and also by the formatting rules in effect when the reference is placed,
the presentation of an example of the placing of
a reference to an external destination will be deferred,
until the formatting mechanism has been explained,
.XR set-format ). (
.
.NH 3
.XN -N add-weblink -- Linking to Internet Resources
.LP
In addition to supporting the creation of cross references
to named destinations in PDF documents, the
.CW pdfhref
macro also has the capability to create active links to Internet resources,
or indeed to
.EM any
resource which may be specified by a Uniform Resource Identifier,
(which is usually abbreviated to the acronym \(lqURI\(rq,
and sometimes also referred to as a Uniform Resource Locator,
or \(lqURL\(rq).
.LP
'ne 7v+(u;2*\n[PD])
Since the mechanism for creating a link to a URI differs somewhat
from that for creating PDF references, the
.CW pdfhref
macro is invoked with the
.CWB W \& \& \(rq \(lq
(for \%\(lqweb\(hylink\(rq) operator, rather than the
.CWB L \& \& \(rq \(lq
operator; nevertheless, the invocation syntax is similar, having the form
.QP
.fam C
.B .pdfhref
.B W
.B -D \& [
.BI URI >] <
.B -P \& [
.BI prefix-text >] <
.B -A \& [
.BI affixed-text >] <
\e
.br
\0\0\0
.B -- ] [
.I "descriptive text ...\&"
.LP
where the optional
.CWB -D
.CWBI URI > <
modifier specifies the address for the target Internet resource,
in any appropriate
.EM "Uniform Resource Identifier"
format, while the
.CWI descriptive
.CWI text
argument specifies the text which is to appear in the \%\(lqhot\(hyspot\(rq
region, and the
.CWB -P
.CWBI prefix\(hytext > \%<
and
.CWB -A
.CWBI affixed\(hytext > \%<
options have the same effect as in the case of local document links,
.XR link-intern ). (
.LP
Notice that it is not mandatory to include the
.CWB -D
.CWBI URI > <
in the link specification; if it
.EM is
specified, then it is not necessary for the URI to appear,
in the running text of the document\*[em]the
.CWI descriptive
.CWI text
argument exactly defines the text
which will appear within the \%\(lqhot\(hyspot\(rq region,
and this need not include the URI.
However, if the
.CWB -D \& \& \~\c
.CWBI URI > <
specification is omitted, then the
.CWI descriptive
.CWI text
argument
.EM must
be an
.EM exact
representation of the URI, which
.EM will ,
therefore, appear as the entire content of the \%\(lqhot\(hyspot\(rq.
For example, we could introduce a reference to
.pdfhref W -D \*[GROFF-WEBSITE] -A , the groff web site
in which the actual URI is concealed, by using mark up such as:\(en
.DS I
.CW
For example, we could introduce a reference to
\&.pdfhref W -D \*[GROFF-WEBSITE] -A , the groff web site
in which the actual URI is concealed,
.DE
Alternatively,
to refer the reader to the groff web site,
making it obvious that the appropriate URI is
.pdfhref W -A , \*[GROFF-WEBSITE]
the requisite mark up might be:\(en
.DS I
.CW
to refer the reader to the groff web site,
making it obvious that the appropriate URI is
\&.pdfhref W -A , \*[GROFF-WEBSITE]
the requisite mark up might be:\e(en
.DE
.
.NH 3
.XN -N set-format -- Establishing a Format for References
.LP
There are two principal aspects to be addressed,
when defining the format to be used when displaying references.
Firstly, it is desirable to provide a visual cue,
to indicate that the text describing the reference is imbued
with special properties\*[em]it is dynamically linked to the reference
destination\*[em]and secondly, the textual content should
describe where the link leads, and ideally,
it should also describe the content of the reference destination.
.LP
The visual cue,
that a text region defines a dynamically linked reference,
is most commonly provided by printing the text within the active
region in a distinctive colour.
This technique will be employed automatically by the
.CW pdfhref
.XR set-colour \*[em]unless macro\*[em]
the user specifically chooses to adopt, and implement,
some alternative strategy.
.
.NH 4
.\" The following section will serve as a convenient example for
.\" the default reference text formatting capabilities of pdfhref;
.\" thus, mark it, and store PDFHREF.INFO records in both original
.\" default format, and our preferred section reference format.
.\"
.nr chapter 2
.ds PDFHREF.INFO.KLUDGE section \\n[chapter] \\*[PDFHREF.INFO.DEFAULT]
.ds PDFHREF.INFO.CHAPTER chapter \\n[chapter] page \\n% \\*[PDFHREF.INFO.LOCAL]
.ds set-colour-heading Using Colour to Demarcate Link Regions
.
.als PDFHREF.INFO PDFHREF.INFO.CHAPTER
.pdfhref M -X -N set-colour-chapter -- \*[set-colour-heading]
.
.als PDFHREF.INFO PDFHREF.INFO.KLUDGE
.pdfhref M -X -N set-colour-chapter-kludge -- \*[set-colour-heading]
.
.als PDFHREF.INFO PDFHREF.INFO.DEFAULT
.pdfhref M -X -N set-colour-default -- \*[set-colour-heading]
.
.als PDFHREF.INFO PDFHREF.INFO.LOCAL
.XN -N set-colour -- \*[set-colour-heading]
.rm set-colour-heading
.
.LP
Typically, when a PDF document contains
.EM active
references to other locations, either within the same document,
or even in other documents, or on the World Wide Web,
it is usually desirable to make the regions
where these active links are placed stand out from the surrounding text.
.LP
The mechanism,
which is apparently advocated by \*[Adobe ,]
as the default for indicating any active link region,
is to draw a coloured border around the region.
This is a most unfortunate default choice:
not only does it look hideously ugly,
but it also seems very distracting to the reader!
Consequently,
while it does support this mechanism for link visualization,
.CW groff 's
.CW pdfmark
macros disable it,
by default;
it is controlled by a pair of strings:\(en
.QS
.sp -\n[PD]u
.IP \*[= PDFHREF.BORDER]
This string comprises a \%space\(hyseparated triplet of numeric values,
optionally followed by a further \%space\(hyseparated
.CW pdfmark "\ \c"
.CW array ,
(see the \*[Adobe]
.pdfmark-manual
for details),
which together specify the link border style,
in terms of its elliptical corner horizontal radius,
vertical radius,
line thickness,
and line style \%mark\(hyto\(hyspace ratio array;
'ne 2v+\n[PD]u
by default,
it is defined as
.RS
.QP
.CW ".ds PDFHREF.BORDER 0 0 0"
.RE
.IP
which has the effect of specifying an invisible link border,
(a solid \%zero\(hywidth line,
with rectanuglar corners),
thus appearing to disable the use of borders
for link visualization.
This differs from the \*[Adobe] default,
'ne 4v+(u;2*\n[PD])
which represents a solid (visible) line,
one pixel in width,
and with rectangular corners;
this \*[Adobe] default may be reinstated,
by explicitly defining
.RS
.QP
.CW ".ds PDFHREF.BORDER 0 0 1"
.RE
.IP
.EM before
specifying any link references,
which it is desired to have rendered in the \*[Adobe] style.
.
.IP \*[= PDFHREF.COLOUR]
This string\**
.FS
For authors who may prefer American English spelling,
.CW PDFHREF.COLOR
will be recognized as an alias for
.CW PDFHREF.COLOUR .
However,
should the alias be broken,
(by deletion of either of the alternative names,
prior to redefining it),
it is the World English spelling,
.CW PDFHREF.COLOUR ,
which will be honoured when rendering links.
.FE
comprises a triplet of \%space\(hyseparated decimal numeric values,
each in the range 0.0\^..\^1.0;
together,
they represent,
in RGB colour space,
the colour in which link borders should be rendered,
in the event that the
.CW PDFHREF.BORDER
property is specified to make them visible;
by default,
it is defined as
.RS
.QP
.CW ".ds PDFHREF.COLOUR 0.35 0.00 0.60"
.RE
.IP
which represents a deep lilac colour.
.QE
.LP
While the foregoing discussion of
.CW PDFHREF.BORDER ,
and
.CW PDFHREF.COLOUR ,
may seem sufficient for those users who are willing
to adopt the \*[Adobe] convention of drawing a border
to offset links from the surrounding text,
it is
.EM not
the preferred way of doing so,
in
.CW groff 's
.CW pdfmark
implementation.
Given the perceived ugliness of the \*[Adobe] convention,
the preferred technique for visualizing links is to disable
the rendition of the link border,
(by making it invisible,
as
.CW groff 's
.CW pdfmark
implementation does by default),
and to simply print the text,
within the link \%\(lqhot\(hyspot\(rq region,
in a colour which contrasts with that of the surrounding text.
.LP
It may noted that,
whereas the preceding
.CW PDFHREF.BORDER ,
and
.CW PDFHREF.COLOUR
properties exert their influence within the \*[Adobe]
.CW pdfmark
infrastructure,
that infrastructure provides no mechanism for control of
the text colour within a link \%\(lqhot\(hyspot\(rq region;
however,
the desired effect may be readily achieved,
simply by assignment of
.CW groff
colour properties.
In
.CW groff 's
.CW pdfmark
implementation,
the text colour,
for use within link \%\(lqhot\(hyspot\(rq regions,
is established by a further string assignment,
viz.:\(en
.QS
.sp -\n[PD]u
.IP \*[= PDFHREF.TEXT.COLOUR]
Specifies the text colour,
for rendition of PDF reference links.
.IP
Unlike
.CW PDFHREF.COLOUR ,
this string\**
.FS
Just as
.CW PDFHREF.COLOR
is defined as an alias for
.CW PDFHREF.COLOUR ,
the alias
.CW PDFHREF.TEXT.COLOR
may be used as an American English spelling alternative
to World English
.CW PDFHREF.TEXT.COLOUR ;
once again,
should the alias be broken,
the World English spelling will prevail.
.FE
must be assigned a value which represents a
.CW groff
colour name,
rather than an RGB \%colour\(hyspace triplet;
by default,
it is assigned the name of a custom colour,
which is internally derived from,
and is thus chromatically identical to the deep lilac colour\Z','\**
.FS
This deep lilac colour has been chosen
on the basis that it will provide sufficient contrast,
when the PDF document is viewed on a colour display screen,
to be discernable by readers with normal colour perception,
but not so much contrast as to be distracting;
conversely,
if the document is printed on a monochrome \%hard\(hycopy device,
since links cannot then be clicked,
it is anticipated that the contrast will be barely discernable,
if at all.
.FE
as represented by the default RGB \%colour\(hyspace triplet
which is specified as the default value of
.CW PDFHREF.COLOUR .
.QE
.
.NH 4
.XN -N user-format -- Specifying Reference Text Explicitly
.LP
Although the
.pdfhref L -D set-colour -- use of colour
within,
and/or borders around,
.CW pdfhref
link \%\(lqhot\(hyspot\(rq regions may be considered
to be a necessary visual indication of the location
of such \%\(lqhot\(hyspots\(rq,
for users of \%on\(hyscreen\(rq PDF readers,
such visual indicators alone are insufficient
to convey any necessary information regarding the context
to which the link refers;
neither do they offer any particular benefit
to readers of documents in printed \%hard\(hycopy formats.
To address these limitations,
it is necessary to specify appropriate text
within each \%\(lqhot\(hyspot\(rq region,
to identify the link context.
.LP
Depending on the type of contextual information,
which it is desired to include
within any link \%\(lqhot\(hyspot\(rq region,
.CW groff 's
.CW pdfmark
macro suite provides a variety of mechanisms
to specify it;
the simplest of these
is to simply specify the desired text
.EM explicitly ,
at the point of insertion of the reference.
For example,
given that the
.pdfhref L -D set-colour -P \(lq -A \(rq -- use of colour
reference,
in the initial paragraph of
'ne 4v+(u;3*\n[PD])
.pdfhref L -D user-format -A , -- this section
points to a destination named by mark up similar to:\(en
.QP
.CW ".pfdhref M -X -N \%set-colour -- ..."
.LP
the reference text was specified explicitly,
(ignoring recorded location information),
using the mark up:\(en
.QP
.CW ".pdfhref L -D set-colour -- use of colour"
.
.NH 4
'ne 3v+(u;2*\n[PD])
.XN -N auto-format -- Using Automatically Formatted Reference Text
.LP
When the text within a link \%\(lqhot\(hyspot\(rq is specified explicitly,
using a
.CW pdfhref
macro call of the form
.QP
.fam C
\&.pdfhref L -D
.CWI dest-name > <
--
.CWI explicit-text > <
.fam
'ne 2v+\n[PD]u
.LP
as described in
.pdfhref L -D user-format -A , -- the preceding section
then
.CWI explicit-text > <
will appear in the formatted document,
.EM exactly
as specified.
This may be the author's intent,
but it does suffer from the disadvantage that,
in spite of location information having been recorded when
.CWI dest-name > <
was marked,
none is included in
.CWI explicit-text > < ,
.EM unless
the author
.EM explicitly
includes it;
this places the onus on the author,
if inclusion of such location information is desired,
to track it
.EM manually ,
and to specify it within
.CWI explicit-text > < ,
in the desired format.
.LP
To mitigate this limitation,
of
.EM explicitly
specified reference text,
.CW groff 's
.CW pdfmark
macro suite provides a capability for
.EM automatic
formatting of reference text,
based on the content of a
.CW PDFHREF.INFO \& \(lq
record\(rq\Z','\**
.FS
The conceptual nomenclature
.CW PDFHREF.INFO \& \(lq
record\(rq has been adopted here,
since the content of the record is dictated by the definition of the
.CW PDFHREF.INFO
string,
as described in
.XR-NO-PREFIX export-map .
.FE
which is generated by,
and is specific to any named \%link\(hydestination marked by a
.CW pdfhref
macro request of the form
.QP
.fam C
\&.pdfhref M -X -N
.CWI dest-name > <
[[--]
.CWI default-text >] <
.fam
.LP
When a
.CW pdfhref
link destination has been marked by a macro request of this form\Z','\**
.FS
The specification of the
.CWB -X
option is imperative,
within this
.CW pdfhref
macro request;
without it,
no
.CW PDFHREF.INFO \& \(lq
record\(rq will be generated.
.FE
a subsequent request of the simplified form
.QP
.fam C
\&.pdfhref L -D
.CWI dest-name > <
.fam
.LP
(excluding
.EM any
.CWI explicit-text > <
specification),
then the reference text will be generated
.EM automatically ,
by passing the content of the
.CW PDFHREF.INFO \& \(lq
record\(rq associated with
.CWI dest-name > < ,
as arguments to a designated\**
.FS
A suitable
.CW pdfhref
reference text formatting macro is provided,
within
.CW groff 's
.CW pdfmark
macro suite;
it will be used by default,
unless the author has designated an alternative,
as described in
.XR-NO-PREFIX custom-format .
.FE
.CW pdfhref
reference text formatting macro.
.LP
.pdfhref M -N auto-format-example
To illustrate this capability,
if we revisit the example offered in
.XR-NO-PREFIX user-format ,
but instead of specifying the reference as
.QP
.CW ".pdfhref L -D set-colour -- use of colour"
.LP
we simply specify it,
.EM without
the explict reference text arguments,
as
.QP
.CW ".pdfhref L -D set-colour"
.LP
and if neither
.CW PDFHREF.INFO ,
nor the designated
.CW pdfhref
reference text formatting macro,
have been changed from their original default settings,
then we should see a reference formatted as
.QP
.pdfhref L -D set-colour-default
.LP
Alternatively,
location data from the
.CW PDFHREF.INFO \& \(lq
record\(rq may be combined with explicitly specified text,
by adding the
.CWB -X
option to the explicit form of the
.CW pdfhref
macro request,
e.g.
.QP
.CW ".pdfhref L -X -D set-colour -- Using Colour ..."
.LP
will cause the reference to be displayed as
.QP
.pdfhref L -X -D set-colour-default -- Using Colour ...
.LP
Notice that,
when the displayed form of the reference incorporates the assigned
.CWI default-text > < ,
as derived from the
.CW PDFHREF.INFO \& \(lq
record\(rq,
this is enclosed in double quotation marks,
but explicitly specified text is not;
if quotation of explicitly specified text is desired,
then appropriate quotation marks should simply be included within the
.CWI explicit-text > <
arguments specification.
.LP
Finally,
to conclude this introduction to
the automatic reference text formatting capabilities of
.CW groff 's
.CW pdfmark
macro suite,
it may be noted that,
while the default provisions may be adequate,
in many cases,
this will not always be so.
In the event of these default provisions being inadequate,
customization is readily supported,
as explained in
.pdfhref L -D custom-format -A . -- the following section
.
.NH 4
'ne 5v+(u;3*\n[PD])
.XN -N custom-format -- Customizing Automatically Formatted Reference Text
.LP
\(lqAutomatically formatted\(rq reference text is interpolated,
within the running text of a published PDF document,
when the
.CW pdfhref
macro is invoked with its
.CWB L \& \& \(rq \(lq
operator,
to refer to a destination named by the
.CWB -D \& \& \(rq \(lq
option,
.EM "and either" \^:\(en
.QS
.sp -\n[PD]u
.IP \(bu
no explicit reference text is specified,
(in which case,
specification of the
.CWB -X \& \& \(rq \(lq
option is implied),
.EM or ,
.IP \(bu
the
.CWB -X \& \& \(rq \(lq
option is specified,
in conjunction with explicit reference text.
.QE
.sp -\n[PD]u
.LP
In each of these cases,
the reference text is derived,
(in its entirety,
in the first case,
or partially,
in the second),
from a reference dictionary record for the named destination.
.LP
The reference dictionary,
itself,
comprises a collection of
.CW PDFHREF.INFO
records,
one per destination,
indexed by destination name.
While it is possible to create a reference dictionary record manually,
using a macro call of the form:\(en
.QP
.CW .pdfhref\ D\ -N
.CWI dest-name >\ \c <
.CWI keyword > [< \h'0.5n'\c
.CWI value >] < \^\c
.CW ...\ \c
.CWI text > < \|\c
.CW ...
.LP
(in which the \%in\(hyorder aggregate of all specified
.CWI keyword > <
.CWI value > <
pairs,
and all following
.CWI text > <
arguments,
comprises the
.CW PDFHREF.INFO
record,
and
.CWI dest-name > <
represents the destination name
on which it is indexed),
it is generally more convenient to have the dictionary compiled automatically,
by specifying the
.CWB -X \& \& \(rq \(lq
option,
when using a macro call of the form:\(en
.QP
.CW ".pdfhref M -X -N"
.CWI dest-name "> -- \c" <
.CWI text > < \|\c
.CW ...
.LP
to mark the location of each named destination;
the procedure is described,
in detail,
in
.XR-NO-PREFIX create-map .
.LP
Interpolation of automatically formatted reference text
is delegated to a specialized formatting macro,
which assumes responsibility for storing the formatted representation
of the reference text,
into the
.CW PDFHREF.TEXT
string;
this formatting macro may be defined by the user,
(if specialized formatting is required),
or,
in most cases,
a standardized default macro,
provided by
.CW pdfmark.tmac ,
may be used.
In either case,
the content of the
.CW PDFHREF.INFO
record,
which is associated with the named reference destination,
will be passed to the formatting macro as a sequence of macro arguments,
while any explicit reference text,
which has been specified in the initiating
.CW .pdfhref\ L\ ... \(rq \(lq
call,
will be passed in the
.CW PDFHREF.DESC
string;
(if no reference text is explicitly specified,
then any \%pre\(hyexisting definition of
.CW PDFHREF.DESC
is explicitly deleted,
prior to calling the formatting macro).
.LP
.pdfhref M -N default-format
When the
.CW pdfmark.tmac
default formatting macro is used,
formatting progresses as follows:\(en
.QS
.sp -\n[PD]u
.nr ITEM 0 1
.de ITEMIZE ITEMIZE
.IP \s'-2.5p'\\n+[ITEM]\s'+2.5p'.
.ITEMIZE
.CW PDFHREF.TEXT
is initialized to the content of the
.CW PDFHREF.PREFIX
string;
this has a default value of \(lqsee\(rq,
but may be redefined by the user,
to any suitable alternative content,
(including the empty string,
if desired).
.
.ITEMIZE
The
.CW PDFHREF.INFO
record,
as passed in the argument list,
is inspected to determine whether the first argument
.CW \e$1 ) (
matches any of the known formatting keywords,
or otherwise it,
and any additional arguments which follow it,
will be interpreted as representing the text
of an implicit reference description.
.
.ITEMIZE
If
.CW \e$1
.EM does
match any of the known formatting keywords,
the argument which follows
.CW \e$2 ) (
is interpreted as the
.CWI value > < ,
(which completes a
.CWI keyword > < \h'0.5n'\c
.CWI value > <
pair);
.CW \e$2
is interpolated into the format string
which is associated with keyword
.CW \e$1 ,
and the result is appended to
.CW PDFHREF.TEXT .
The matched
.CW \e$1 ,
and accompanying
.CW \e$2 ,
are then shifted out of the argument list,
promoting
.CW \e$3 ,
(if any further arguments are present),
to the
.CW \e$1
position,
and the keyword matching process is repeated,
from step \s'-1.5p'2\s'+1.5p'.
.
.ITEMIZE
If,
during
.EM any
execution cycle of step \s'-1.5p'2\s'+1.5p',
.CW \e$1
is found
.EM not
to match any known formatting keyword,
.EM and
.CW PDFHREF.DESC
has
.EM not
been assigned any explicit content,
then any remaining arguments are assigned to
.CW PDFHREF.DESC ;
thus,
.CW PDFHREF.DESC
becomes the descriptive component of the reference text,
either as explicitly specified by the originating
.CW .pdfhref\ L\ ... \(rq \(lq
call,
or implicitly deduced from the reference dictionary
.CW PDFHREF.INFO
record for the named link destination.
.
.ITEMIZE
Finally,
an interpolating reference to
.CW PDFHREF.DESC
is appended to
.CW PDFHREF.TEXT ,
from which any accumulated initial spaces are then removed,
and the resultant
.CW PDFHREF.TEXT
string is handed back to the originating
.CW .pdfhref\ L\ ... \(rq \(lq
call,
for interpolation as the formatted content within,
and which defines the extent of,
the link \%\(lqhot\(hyspot\(rq region.
.QE
.sp -\n[PD]u
.LP
From the foregoing,
it may be deduced that reference text,
formatted by the default formatting macro,
will commence with the content of the
.CW PDFHREF.PREFIX
string,
followed by the result of interpolation of any
.CW keyword/value
pairs found in the
.CW PDFHREF.INFO
record component of the relevant reference dictionary entry,
and ends with a
.CW PDFHREF.DESC
component,
either as implicitly defined within that same
.CW PDFHREF.INFO
record,
or as explicitly specified as final arguments to
.CW .pdfhref\ L\ ... \(rq. \(lq
Within the formatted text,
the keyword/value pair interpolations appear
in the order in which \(lqknown\(rq keywords are found,
'ne 7v+\n[PD]u
while parsing the
.CW PDFHREF.INFO
record;
the default set of known formatting keywords comprises:\(en
.QS
\h'0.45n'\Z'Keyword'\h'0.9i'\Z'Format Name'\h'1.5i'Default Format
.sp -0.5v
\l'0.7i'\h'0.2i'\l'1.3i'\h'0.2i'\l'1.2i'
.de keyword keyword
.br
.ta 0.9i 2.4i
.ti +0.45n
.CW \\$1\t\\$2\t \\$3
.keyword page PDFHREF.PAGEREF page
.CW \e\e$1,
.keyword section PDFHREF.SECTREF section
.CW \e\e$1,
.keyword file PDFHREF.FILEREF \c
.CW \e\e$1
.QE
.LP
The format of any of these known keyword interpolations may be customized,
by redefinition of their corresponding \(lqFormat Name\(rq strings;
each may incorporate any text of the user's choice\*[em]inclusion of
the keyword itself is
.EM not
necessary,
however,
inclusion of the
.CW \e\e$1
placeholder,
while not mandatory,
.EM is
a necessary prerequisite for interpolation of the
.CW value
component of the
.CW keyword/value
pair,
from the
.CW PDFHREF.INFO
record.
.
.LP
In the case of any
.CW PDFHREF.INFO
record which originates from a
.CW .pdfhref\ M\ -X\ ... \(rq \(lq
call,
the precise gamut of keyword interpolations which do,
and the order in which they will,
appear within automatically formatted reference text,
may be manipulated by redefinition of the
.CW PDFHREF.INFO
string itself.
For example,
with the default
.CW PDFHREF.PREFIX ,
.CW PDFHREF.PAGEREF ,
.CW PDFHREF.SECTREF ,
and
.CW PDFHREF.INFO
definitions:\(en
.DS I
.CW
\&.ds PDFHREF.PREFIX see
\&.ds PDFHREF.PAGEREF page \e\e$1,
\&.ds PDFHREF.SECTREF section \e\e$1,
\&.ds PDFHREF.INFO page \e\en% \e\e$*
.DE
.LP
a request such as
.IP
.CW ".pdfhref L -D set-colour"
.LP
may,
(as indicated in
.XR-NO-PREFIX auto-format ),
result in formatted reference text similar to:\(en
.QP
.XR set-colour-default
.LP
whereas,
a simple redefinition of
.CW PDFHREF.INFO ,
.EM before
the
.CW set-colour \(rq \(lq
destination is marked:\(en
.IP
.CW ".ds PDFHREF.INFO section \e\e*[SN-NO-DOT] \e\e$*"
.LP
may\**
.FS
Assuming that the
.CW SN-NO-DOT
string represents the effective section number,
at the point where the link destination is marked,
as it does when formatting with the
.CW ms
macros provided with
.CW \%groff-1.19.2
and later.
.FE
result in alternative formatting similar to:\(en
.QP
.XR set-colour
.LP
(as is used in this document itself).
.
.LP
In addition to these default formatting capabilities,
.CW pdfmark.tmac
also offers support\**
.FS
Available only in versions of
.CW pdfmark.tmac
as distributed with
.CW groff
from
.CW \%groff-1.23.0
onwards.
.FE
for interpolation of \%user\(hydefined
.CW keyword/value
pairs;
these may be defined,
using a macro call of the form:\(en
.IP
.CW ".pdfhref K <" \c
.CWI keyword >\ < \& \c
.CWI \%format-name >\ [< \& \c
.CWI keyword >\ < \& \c
.CWI \%format-name >]
.CW ...
.LP
accompanied by string definitions,
similar to that for
.CW PDFHREF.PAGEREF ,
for each
.CW \%format-name
argument specified;
.CW keyword/value
pairs,
corresponding to such \%user\(hydefined keywords,
may be incorporated into the
.CW PDFHREF.INFO
record definition,
and they will be interpreted by the default formatting macro,
in the same manner as the default set of keywords.
For example,
we might wish to add add a chapter reference capability.
We
.EM could
accomplish this by subverting the effect of one the default keywords;\**
.FS
We might choose to implement the effect of a
.CW chapter
keyword by subverting the default behaviour of,
e.g. the
.CW section
keyword;
we could achieve this by redefining the associated
.CW PDFHREF.SECTREF
format string,
in conjunction with a modified
.CW PDFHREF.INFO
template:\(en
.nr zz \n[.i]
.QP
.in +\n[pdf:fn.tag.width]u
.CW ".ds PDFHREF.SECTREF chapter \e\e$1,"
.br
.CW ".ds PDFHREF.INFO section \e\en[chapter] page \e\en% \e\e$*"
.LP
.in \n[zz]u
and,
(assuming for the purpose of this example,
that the
.CW chapter
number matches the current \%top\(hylevel section heading number),
.QP
.in +\n[pdf:fn.tag.width]u
.CW ".pdfhref L -D set-colour"
.LP
.in \n[zz]u
would be expected to yield a reference similar to:\(en
.QP
.in +\n[pdf:fn.tag.width]u
.rn PDFHREF.SECTREF xx
.ds PDFHREF.SECTREF chapter \\$1,
.pdfhref L -D set-colour-chapter-kludge
.rn xx PDFHREF.SECTREF
.FE
however,
as a (possibly undesirable) side effect of such a customization,
we would lose the normal behaviour of the selected default keyword,
while also introducing an element of obfuscation around
the use of that keyword;
we may prefer not to do this.
.
.LP
If we wish to avoid subversion of any default keyword,
with the attendant obfuscation of intent for the chosen keyword,
(and we have a sufficiently recent version of
.CW pdfmark.tmac ),
then the preferred method for implementing a custom keyword feature,
such as automatic interpretation of a
.CW chapter
reference keyword,
would be to make use of the
.CW .pdfhref\ K\ ... \(rq \(lq
capability;
e.g.:\(en
.DS I
.CW
\&.pdfhref K chapter PDFHREF.CHAPTER
\&.ds PDFHREF.CHAPTER chapter \e\e$1,
.DE
.LP
With these definitions in place,
and assuming that,
at the point where the named destination is marked,
the effective chapter number is made available in the
.CW \en[CH]
numeric register,
and also that the effective
.CW PDFHREF.INFO
definition has been preset to:\(en
.QP
.CW ".ds PDFHREF.INFO chapter \e\en[CH] page \e\en%" \c
.CW " section \e\e*[SN-NO-DOT] \e\e$*"
.LP
(assuming that
.CW SN-NO-DOT
represents a section number,
as it does when the
.CW -ms
macros are used for document formatting),
.pdfhref L -D auto-format-example -A , -- \
the example from the preceding section
viz.:\(en
.QP
.CW ".pdfhref L -D set-colour"
.LP
will now produce a reference similar to
.QP
.ds PDFHREF.CHAPTER chapter \\$1,
.pdfhref K chapter PDFHREF.CHAPTER
.pdfhref L -D set-colour-chapter
.
.LP
Finally,
in the event that the default reference text formatting macro,
combined with any \%user\(hydefined
.CW PDFHREF.INFO
specification,
\%user\(hydefined \%keyword\(hyspecific format strings,
and combination of default or \%user\(hydefined keywords,
is insufficient to achieve a required formatting effect,
the
.CW .pdfhref\ F\ [<\fImacro-name\fP>] \(rq \(lq
facility allows the user to define an alternative formatting macro,
and substitute it in place of the default.
For example,
within this document itself,
some internal references are displayed as a section number reference alone;
such references are derived from the associated
.CW PDFHREF.INFO
record,
but are formatted by the document\(hylocal
.CW SECREF
macro:\(en
.DS I
.CW
\&.de SECREF
\&.   while \e\en(.$ \e{\e
\&.      ie \(aq\e\e$1\(aqsection\(aq \e{\e
\&.            if !dSECREF.BEGIN .ds SECREF.BEGIN \e\e$1
\&.            ds PDFHREF.TEXT \e\e*[SECREF.BEGIN]\e\(ti\e\e$2
\&.            rm SECREF.BEGIN
\&.            shift \e\en(.$
\&.         \e}
\&.      el \e{\e
\&.            shift
\&.            if \e\en(.$ shift
\&.         \e}
\&.      \e}
\&..
.DE
.LP
to filter all but the \(lqsection\(rq reference out of the
.CW PDFHREF.INFO
record,
which is then displayed as the reference text;
used thus:\(en
.DS I
.CW
\&.pdfhref F SECREF
\&.pdfhref L -D <\f(CIreference-name\fP>
\&.pdfhref F
.DE
.LP
it will emit reference text similar to:\(en
.QP
.pdfhref F SECREF L -D custom-format
.LP
while,
when used with the additional qualifying definition of
.CW SECREF.BEGIN :\(en
.DS I
.CW
\&.pdfhref F SECREF
\&.ds SECREF.BEGIN Section
\&.pdfhref L -D <\f(CIreference-name\fP>
\&.pdfhref F
.DE
.LP
it will capitalize the emitted reference text,
such that it becomes suitable for use at the beginning of a sentence:\(en
.QP
.ds SECREF.BEGIN Section
.pdfhref L -D custom-format
.pdfhref F
.LP
Notice that the preceding
.CW SECREF
macro exhibits
.EM identical
semantics to those of the default reference formatting macro,
.pdfhref L -A , -D default-format -- as described above
(and as
.EM any
\%user\(hydefined reference formatting macro
.EM must ),
insofar as it expects to be passed the content of a
.CW PDFHREF.INFO
record as its arguments,
and it returns the formatted reference text as the definition of the
.CW PDFHREF.TEXT
string;
however,
while the
.CW PDFHREF.DESC ,
.CW PDFHREF.PREFIX ,
.CW PDFHREF.PAGEREF ,
.CW PDFHREF.SECTREF ,
and
.CW PDFHREF.FILEREF
strings
(and any other custom format strings which the user may have defined)
remain available,
the
.CW SECREF
macro simply ignores them.
.LP
Further note that the effect of invoking
.CW .pdfhref\ F\  \c \(lq
.CWI macro-name > < \(rq
is persistent;
if it is desired to revert to use of the default reference formatting macro,
after temporary use of a \%user\(hydefined alternative,
this may be accomplished by invoking
.CW .pdfhref\ F \(rq \(lq
.EM without
specifying any
.CWI macro-name > < \(rq \(lq
argument,
as shown in each of the two preceding usage examples.
.
.NH 3
.XN Problematic Links
.LP
Irrespective of whether a
.CW pdfhref
reference is placed using the
.CWB L \& \& \(rq \(lq
operator, or the
.CWB W \& \& \(rq \(lq
operator, there may be occasions when the resulting link
does not function as expected.
A number of scenarios, which are known to be troublesome,
are described below.
.
.NH 4
.XN -N page-trap -- Links with a Page Transition in the Active Region
.LP
When a link is placed near the bottom of a page,
it is possible that its active region, or \%\(lqhot\(hyspot\(rq,
may extend on to the next page.
In this situation, a page trap macro is required
to intercept the page transition, and to restart the mapping of
the \%\(lqhot\(hyspot\(rq boundary on the new page.
.LP
The
.CW pdfmark
macro package includes a suitable page trap macro, to satisfy this requirement.
However, to avoid \%pre\(hyempting any other requirement the user may have for
a page transition trap, this is
.EM not
installed as an active page trap,
unless explicitly requested by the user.
.LP
To enable proper handling of page transitions,
which occur within the active regions of reference links,
the user should:\(en
.QS
.nr ITEM 0 1
.sp -\n[PD]u
.ITEMIZE
Define a page transition macro, to provide whatever features may be required,
when a page transition occurs\*[em]e.g.\& printing footnotes,
adding page footers and headers, etc.
This macro should end by setting the output position at the correct
vertical page offset, where the printing of running text is to restart,
following the page transition.
.
.ITEMIZE
Plant a trap to invoke this macro, at the appropriate vertical position
marking the end of normal running text on each page.
.
.ITEMIZE
'ne 4v+(u;2*\n[PD])
Initialize the
.CW pdfhref
hook into this page transition trap, by invoking
.RS
.IP
.fam C
.B ".pdfhref I -PT"
.BI macro-name > <
.LP
where
.CWBI macro-name > <
is the name of the user supplied page trap macro,
to ensure that
.CW pdfhref
will correctly restart mapping of active link regions,
at the start of each new page.
.RE
.QE
.LP
It may be observed that this initialization of the
.CW pdfhref
page transition hook is, typically, required only once
.EM before
document formatting begins.
Users of document formatting macro packages may reasonably expect that
this initialization should be performed by the macro package itself.
Thus, writers of such macro packages which include
.CW pdfmark
bindings, should provide appropriate initialization,
so relieving the end user of this responsibility.
The following example, abstracted from the sample
.CW ms
binding package,
.CW spdf.tmac ,
illustrates how this may be accomplished:\(en
.DS I
.CW
\&.\e" groff "ms" provides the "pg@bottom" macro, which has already
\&.\e" been installed as a page transition trap.  To ensure proper
\&.\e" mapping of "pdfhref" links which overflow the bottom of any
\&.\e" page, we need to install the "pdfhref" page transition hook,
\&.\e" as an addendum to this macro.
\&.
\&.pdfhref I -PT pg@bottom
.DE
.
.NH 2
.XN -N add-note -- Annotating a PDF Document using Pop-Up Notes
.LP
The \*[Adobe] PDF specification defines several types of annotation,
which may be associated with a PDF document;
of these defined annotation types,
.EM two
are
.EM explicitly
supported by
.CW groff 's
.CW pdfmark
macros.
Of these,
although it is not explicitly identified as such,
in the preceding discussion,
it is the
.CW Link \(rq \(lq
annotation type which underpins the operation of the
.CW pdfhref
macro,
as it is extensively described in
.XR-NO-PREFIX pdfhref .
.
.LP
In addition to supporting the
.CW Link \(rq \(lq
annotation type,
through the use of the
.CW pdfhref
macro,
.XR pdfhref ), (
the
.CW pdfmark
macros offer support for the
.CW Text \(rq \(lq
annotation type;
primarily useful as a means of adding editorial comments,
this creates an annotation similar to a \(lqsticky note\(rq,
attached to the document page,
and represented by an icon,
at the attachment point,
which, when clicked, opens the annotation itself,
in a \%pop\(hyup window.
.
.LP
It may be noted that some\*[em]but not all\**
.FS
Indeed,
Adobe's own Acrobat Reader\*{\(tm\*} application
may be found wanting, in this respect.
.FE
\h'-0.8n'\*[em]PDF viewer applications may provide support for adding,
and editing
.CW Text \(rq \(lq
annotations.
While such support,
within a viewer application,
may be convenient for \%3rd\(hyparty editorial annotation,
it may not be the most convenient method for the document author,
should he, or she, wish to insert such annotations
at the point of document origin.
Thus, the
.CW pdfmark
macros provide the
.CW pdfnote
macro, for direct insertion of
.CW Text \(rq \(lq
annotations,
such as this,
.pdfnote -T "An Example Text Annotation" -PD 1 \# continued/...
Please do not move, modify, or remove this note; doing \#
so may invalidate the example to which it refers.\#
\*[PDFNOTE.PILCROW]\#
This is an illustration of an editorial comment, \#
placed directly by the document author, \#
using the exact markup, as specified in \#
the example of the usage of the pdfnote macro, \# .../continuation ends
which immediately follows the note's icon.\"          here.
\h'5n'created as in the following example:\**
.FS
It may be noted that the
.EM entire
content of any
.CW pdfnote
.EM must
be entered as a
.EM "single logical"
input line;
this may be achieved,
most effectively,
and
.EM without
necessitating an excessively long,
and unwieldy,
.EM physical
input line,
by folding the
.CW .pdfnote
call over multiple input lines,
with each,
.EM excluding
the last,
terminated by a line continuation escape,
(either a single
.CW \(rs \(rq \(lq
escape at the bitter end of each line,
or a
escape,
followed by an optional comment).
.IP \& 5n
Furthermore,
note that the continuation of the running text,
following interpolation of the
.CW .pdfnote
in this example,
commences with an
.CW \(rsh\(aq5n\(aq \(rq \(lq
escape;
this to leave sufficient space for the placement of the icon,
associated with the
.CW pdfnote ,
.EM without
occlusion of the initial few glyphs
of this continued running text.
.FE
.
.DS I
.CW
Thus, the
\&.CW pdfmark
macros provide the
\&.CW pdfnote
macro, for direct insertion of
\&.CW Text \(rs(rq \(rs(lq
annotations,
such as this,
\&.pdfnote -T \(dqAn Example Text Annotation\(dq -PD 1 \(rs# continued/...
Please do not move, modify, or remove this note; doing \(rs#
so may invalidate the example to which it refers.\(rs#
\(rs*[PDFNOTE.PILCROW]\(rs#
This is an illustration of an editorial comment, \(rs#
placed directly by the document author, \(rs#
using the exact markup as specified in \(rs#
the example of the usage of the pdfnote macro, \(rs# .../continuation ends
which immediately follows the note\[aq]s icon.\(rs\(dq          here.
\(rsh\(aq5n\(aqcreated as in the following example:
.DE
In addition to illustrating the technique
for spreading the
.CW pdfnote
text content over several
.EM input
lines,
this example of
.CW pdfnote
usage gratuituously introduces some of the available
options for setting
.CW pdfnote
attributes,
and the
.CW \(rs*[PDFNOTE.PILCROW]
control,
for manipulation of text layout within the
.CW pdfnote
\%pop\(hyup window;
further discussion of these may be found below, in
.XR-NO-PREFIX pdfnote-options ,
and
.XR-NO-PREFIX pdfnote-layout ,
respectively.
.
.NH 3
.XN -S -N pdfnote-placement -- Controlling \F[C]pdfnote\F[] Icon Placement
.LP
The placement of each
.CW pdfnote
annotation,
on its respective document page,
is determined from its
.CW Rect
attribute;
(this is a
.EM required
attribute,
comprising an array of
.EM four
numeric values, representing, in order, the
.EM "lower left x" ,
.EM "lower left y" ,
.EM "upper right x" ,
and
.EM "upper right y"
\%co\(hyordinates of the page region
in which the
.CW pdfnote
annotation is to be placed).
The
.CW pdfnote
macro computes these four \%co\(hyordinate values,
relative to the current text
.EM output
position on the page,
and specifies the required
.CW Rect
attribute accordingly,
in terms of the following numeric register,
and string assignments:
.QS
.IP \*[= PDFNOTE.OFFSET]
A string,
defined such that it may be evaluated as a numeric expression;
its evaluation is interpreted as the
.EM "lower left x"
ordinate, (and hence, implicitly, the
.EM "upper left x"
ordinate), of the
.CW pdfnote
placement region.
By default, it is defined as
.DS I
.CW
\&.ds PDFNOTE.OFFSET  \(dq\(rs\(rsn[.k]+\(rs\(rsn[.o]+\(rs\(rsn[.in]\(rs\(dq
.DE
which, when evaluated,
will result in placement of the
.EM "left edge"
of the
.CW pdfnote
region
.EM immediately
to the
.EM right
of the last running text glyph
written to the output stream.
.
.IP
Users may redefine
.CW PDFNOTE.OFFSET ,
to achieve a different left edge placement for any
.CW pdfnote
annotations which follow;
for example, the definition
.DS I
.CW
\&.ds PDFNOTE.OFFSET  \(dq\(rs\(rsn[.o]-\(rs\(rsn[PDFNOTE.WIDTH]-1m
.DE
.ds PDFNOTE.OFFSET  "\\n[.o]-\\n[PDFNOTE.WIDTH]-1m
will place
.CW pdfnote
annotations into the left hand page margin, with
.CW 1em
separation from the running text,
as in this example:
.br
.pdfnote -T "Marginal Placement Example" \
This note illustrates placement of pdfnote annotations \
in the left hand page margin, following redefinition of \
the PDFNOTE.OFFSET string.\
\*[PDFNOTE.PILCROW]\
As in the case of the previous pdfnote example, \
moving, modifying, or removing this annotation may \
invalidate the example to which it refers; please \
do not do this!
.DS I
.CW
\&.pdfnote -T \(dqMarginal Placement Example\(dq \(rs
This note illustrates placement of pdfnote annotations \(rs
in the left hand page margin, following redefinition of \(rs
the PDFNOTE.OFFSET string.\(rs
\(rs*[PDFNOTE.PILCROW]\(rs
As in the case of the previous pdfnote example, \(rs
moving, modifying, or removing this annotation may \(rs
invalidate the example to which it refers; please \(rs
do not do this!
.DE
.
.IP \*[= PDFNOTE.LEADING]
The value of this numeric register
is added to the value retrieved by invocation of the
.CW .mk
request,
to establish the vertical distance,
from the top of the current document page,
at which the top edge of each
.CW pdfnote
icon is to be placed.
By default,
it is defined with a value of
.CW 0.3v ,
which will result in placement of
.CW pdfnote
icons at 30% of the line spacing,
below the
.EM top
of the output line which is currently being composed,
at the insertion point of each
.CW pdfnote
annotation.
This may be redefined by the user;
positive values will push the icons further down the page,
while negative values will pull them upwards,
towards the top of the page.
.
.IP \*[= PDFNOTE.HEIGHT]
Combination of the effects of
.CW PDFNOTE.OFFSET
and
.CW PDFNOTE.LEADING
serves to specify the
.CW (x, \^\c
.CW y)
page \%co\(hyordinates of the
.EM "upper left"
vertex of the placement region for a
.CW pdfnote
annotation;
the value of the
.CW PDFNOTE.HEIGHT
numeric register is added to the
.CW y
ordinate of this upper left \%co\(hyordinate pair,
to determine the corresponding
.EM "lower left"
.CW (x, \^\c
.CW y)
\%co\(hyordinate pair,
which is
.EM required
for the specification of the
.CW Rect
attribute of the
.CW pdfnote
annotation
.CW pdfmark .
.
.IP
The default value specified for
.CW PDFNOTE.HEIGHT
is
.CW 9 \h'0.6n'\c
.CW millimetres ;
this corresponds,
approximately,
to the height of
.CW Text \(rq \(lq
annotation icons in many PDF viewer applications.
The user
.EM may
choose to define an alternative value;
however,
the usefulness of doing so may be questionable.
.
.IP \*[= PDFNOTE.WIDTH]
As in the case of addition of the value of
.CW PDFNOTE.HEIGHT
to the
.CW y
ordinate of the upper left
.CW pdfnote
placement \%co\(hyordinate pair,
to compute the
.EM lower
left \%co\(hyordinate pair,
the value of the
.CW PDFNOTE.WIDTH
numeric register is added to the upper left
.CW x
ordinate,
to compute the corresponding
.EM "upper right"
.CW (x, \^\c
.CW y)
\%co\(hyordinate pair;
this is
.EM required
to complete the
.CW Rect
attribute specification for the annotation
.CW pdfmark .
.
.IP
The default value specified for
.CW PDFNOTE.WIDTH
is
.CW 8 \h'0.6n'\c
.CW millimetres ;
this corresponds,
approximately,
to the width of
.CW Text \(rq \(lq
annotation icons in many PDF viewer applications.
The user
.EM may
choose to define an alternative value;
however,
as in the case of
.CW PDFNOTE.HEIGHT ,
the usefulness of such an alternative definition may be questionable.
.QE
It may be worthy of note that
the \*[Adobe] PDF Specification is rather vague,
with respect to how the
.CW Rect
attribute of
.CW Text \(rq \(lq
annotations should be interpreted,
(simply stating that this attribute specifies the placement
of such annotations on their respective pages),
and there is substantial inconsistency among PDF viewer applications,
in their respective interpretations.
Whereas the \*[Adobe]
.pdfmark-manual
states that the
.CW Rect
attribute specifies the vertex \%co\(hyordinates
\(lqof the rectangle defining the open note window\(rq,
(which might be construed as referring to the \%pop\(hyup
window in its open state),
it appears that few\*[em]if indeed any\*[em]of
of the currently available PDF viewer applications
have adopted this interpretation.
All
.EM do
appear to agree that the
.EM "upper left corner"
of the annotation
.EM icon
should be placed at the page \%co\(hyordinates
which are derived by combination of the
.EM "lower left x"
ordinate, and the
.EM "upper right y"
ordinate, as specified for the
.CW Rect
attribute;
there is significantly less agreement on what effect,
if any, the width, and height of the rectangle,
which may be deduced from the
.CW Rect
attribute specification,
should have.
All viewers appear to use a fixed size icon,
and an arbitrarily chosen size, and placement,
for the associated \%pop\(hyup window;
at least one viewer
.EM does
appear to interpret the derived annotation width,
and height, as a specification of the extent
to which the effective clickable region covers,
or extends beyond,
the region occupied by the icon itself,
but most appear to ignore them altogether,
.
.NH 3
.XN -S -N pdfnote-options -- Options for Manipulating \
\F[C]pdfnote\F[] Annotation Attributes
.LP
To the extent to which various PDF viewing applications
may support them, the
.CW pdfnote
macro will interpret the following optional argments,
(which
.EM must
be placed
.EM before
any text specifying the content of the annotation),
to affect the style of
.CW pdfnote
annotations:
.QS
.IP "\*[= -O]" 4n
Select
.EM open \(rq \(lq
as the preferred initial state for the associated
.CW pdfnote
\%pop\(hyup window;
no additional arguments are parsed, beyond
.CW -O
itself, when interpreting this option.
.
.IP
This option sets the
.CW Open
attribute for the associated
.CW pdfnote
annotation to
.CW true ;
some PDF viewer applications may not
reliably interpret this attribute.
.pdfnote -O -T "A Pop-Up Note in Initially Open State" \
This note should be displayed in the open state, when the \
document itself is opened, if the PDF viewer supports \
this capability.
.
The example to the left is specified thus:
.DS I
.CW
\&.pdfnote -O -T \(dqA Pop-Up Note in Initially Open State\(dq \(rs
This note should be displayed in the open state, when the \(rs
document itself is opened, if the PDF viewer supports \(rs
this capability.
.DE
it should be displayed in the initially open state,
when this document is opened in a PDF viewer application which
.EM does
correctly interpret the attribute.
.
.IP "\*[= -T] \*[= \& Title\~Bar\~Text\~... \(dq \(dq]"
Define text to be displayed within the title bar
of the \%pop\(hyup window which is associated with a
.CW pdfnote
annotation;
requires
.EM "exactly one"
following argument,
in addition to the
.CW -T
itself;
this argument should be a text string,
and should be enclosed in programming quotes (ASCII 34),
if spaces are to be included.
Any of the preceding
.CW pdfnote
annotation examples illustrate how this option is used.
.
.IP
This option causes its text string argument to be passed as
the value of the
.CW Title
attribute,
when invoking the
.CW pdfmark
macro to create the associated
.CW pdfnote
annotation;
this appears to enjoy better support than the
.CW Open
attribute, among PDF viewer applications,
but support is by no means universal.
.
.IP "\*[= -C] \
\*[= \& red-value > <] \*[= \& green-value > <] \*[= \& blue-value > <]"
Specifies the background colour, which is to be used for the
.CW pdfnote
annotation's icon,
and also, if supported by the PDF viewer application,
for the frame, and title bar, of the associated
.CW pdfnote
\%pop\(hyup window.
This option requires
.EM "exactly three"
additional arguments,
following the
.CW -C
itself; each of these
.EM must
be a decimal number, in the range
.CW 0.0\h'0.5n'...\h'0.5n'1.0 ,
representing the intensity,
in RGB colour space,
for each of the red, green, and blue components of the desired colour,
respectively.
.
.IP
If this option is not specified,
the PDF viewer application will assign a default colour,
for both the
.CW pdfnote
icon background, and, if supported,
for the \%pop\(hyup window's frame.
.
.IP
Specification of this option causes a
.CW Color
attribute assignment to be included within the
.CW pdfmark
invocation, which is used to place the associated
.CW pdfnote
annotation.
Differing PDF viewer applications vary
in the extent to which they support this attribute.
The example to the left
.pdfnote -C 0.7 1.0 0.7 \
-T "Icon Background Colour Example" \
This example specifies a pale green colour, for the icon \
background and pop-up window frame, and serves to illustrate \
the extent to which text annotation colours are supported by \
the current PDF viewer application.
has been specified thus:
.DS I
.CW
\&.pdfnote -C 0.7 1.0 0.7 \(rs
-T \(dqIcon Background Colour Example\(dq \(rs
This example specifies a pale green colour, for the icon \(rs
background and pop-up window frame, and serves to illustrate \(rs
the extent to which text annotation colours are supported by \(rs
the current PDF viewer application.
.DE
which may serve as an illustration of the current
PDF viewer application's level of support for colour attributes,
when applied to
.CW Text \(rq \(lq
annotations defined using the
.CW pdfnote
macro.
.
.IP "\*[= -I] \*[= \& icon-name > <]"
Assigns an alternative icon,
to indicate placement of a
.CW pdfnote
annotation; requires one additional argument following the
.CW -I ,
indicating the style of icon which is to be assigned;
the selected style is assigned, via the
.CW pdfmark
macro, to the
.CW Name
attribute of the annotation.
.
.IP
Icon styles are identified by name.
The particular set of named icons, which are available,
depends on the PDF viewer application which is in use;
however, regardless of any \%non\(hystandard choices,
which a particular viewer might support,
the \*[Adobe] PDF Specification requires, as minimum, that icons named
.CW Note ,
.CW Comment ,
.CW Help ,
.CW Insert ,
.CW Key ,
.CW NewParagraph ,
and
.CW Paragraph
should be available.
If no explicit icon style is selected, the
.CW Note
style is used, by default.
.
.IP
.ne 8v
As an example of how an alternative icon style might be used\Z','\**
.FS
While this example serves, primarily,
to illustrate the the selection of the
.CW Key \(rq \(lq
icon style, for the associated
.CW pdfnote
annotation,
it also illustrates the use of
.CW PDFNOTE.QUOTED
interpolation,
(with aliasing to \(rs*[\(dq\(dq ...text...]
as \%document\(hylocal shorthand),
to introduce double quoted text within
the content of the annotation.
.FE
.als "" PDFNOTE.QUOTED
.pdfnote -I Key -T "An Example Keynote Annotation" \
This is an example of a \*["" keynote annotation], which has been \
defined using the pdfnote macro, using its optional \*["" Key] \
icon selection.
a keynote annotation may be placed thus:
.DS I
.CW
\&.als \(dq\(dq PDFNOTE.QUOTED
\&...
\&.pdfnote -I Key -T \(dqAn Example Keynote Annotation\(dq \(rs
This is an example of a \(rs*[\(dq\(dq keynote annotation], which has been \(rs
defined using the pdfnote macro, using its optional \(rs*[\(dq\(dq Key] \(rs
icon selection.
.DE
.
.IP "\*[= -PD] \*[= \& line-count > <]"
Set the number of blank lines which should be inserted,
to serve as paragraph separators within
.CW pdfnote
content,
following an \%end\(hyof\(hyparagraph
.CW PDFNOTE.PILCROW
mark,
.XR pdfnote-layout ), (
within the content of
.CW pdfnote
annotations.
Requires
.EM "exactly one"
additional argument, following
.CW -PD
itself; this should be an
.EM "integer numeric"
value, indicating the number of
.EM additional
newlines which should be inserted,
.EM following
the one which is normally placed at
the \%end\(hyof\(hyparagraph mark.
.
.IP
Unlike each of the preceding
.CW pdfnote
options,
(each of which assigns annotation attributes,
and applies only to the individual
.CW pdfnote
instance for which it is specified),
the
.CW -PD
option\*[em]so named by analogy with the similarly named
.CW ms
macro, which has a similar effect\*[em]\c
.EM "does not"
assign annotation attributes;
rather, it sets a count initializer,
which is internal to the
.CW pdfnote
macro itself.
Its effect is \(lqsticky\(rq:
that is, it applies not only to the
.CW pdfnote
instance which specifies it,
but also to any
.CW pdfnote
instances which follow it,
unless it is specified again,
with a different\*[em]or even (albeit redundantly)
with the same\*[em]\c
.CW \%line-count
value, for any such following instance.
.
.IP "\*[= --]"
Suppresses interpretation of any further
.CW pdfnote
macro arguments as options.
This is
.EM not ,
strictly, an option
.EM "per se" ,
but may be required in any case
where the following argument is intended to begin
the annotation content,
when it could be mistaken for an optional feature specification.
.QE
.
.NH 3
.XN -S -N pdfnote-layout -- Controlling \F[C]pdfnote\F[] Text Layout
.LP
The \*[Adobe] PDF and pdfmark specifications make
very little provision for control of the layout
of the content of \%pop\(hyup windows which are associated with
.CW Text \(rq \(lq
annotations,
stipulating only that the size and font should be chosen
by the PDF viewer application, which usually offers little,
or no opportunity for user participation in these choices.
.
.LP
Generally,
PDF viewer applications will open annotation \%pop\(hyup windows
when required, each with default width and height as specified by
the viewer application itself.
The annotation content is displayed in a font
which is also specified by the viewer application;
this is usually a proportionally spaced font,
and there is no mechanism for choosing an alternative.
The content is nominally interpreted as a \%single\(hyline of text,
which flows to fit the width of the window;
text flow is facilitated by insertion of \(lqsoft\(rq line breaks,
coincident with white space,
resulting is a flush left, ragged right layout.
The extent to which the author of the annotation may influence this layout
is limited to insertion of \(lqhard\(rq line breaks;
these will always be rendered as such,
when the text is displayed in the \%pop\(hyup window,
producing the effect of a paragraph break.
.
.LP
When placing an annotation,
using the
.CW pdfnote
macro,
if the author wishes to affect the text layout
by inserting a hard line break, this
.EM must
be represented by the literal
.CW \(rsn \(rq \(lq
character sequence.
Unfortunately,
simply specifying this character sequence within any argument to the
.CW pdfnote
macro, (as is necessary to include it within the annotation content),
presents a \%non\(hytrivial challenge to the author: the
.CW \(rs \(rq \(lq
character introduces a
.CW troff
escape, and when it is followed by the
.CW n \(rq \(lq
character,
the escape is interpreted as a reference to a numeric register,
which is resolved according to whatever follows.
Simply escaping the
.CW \(rs \(rq \(lq
character itself,
at the point of the
.CW pdfnote
macro call, does
.EM not
present a satisfactory solution to this challenge, since
.EM "multiple levels"
of escaping are required,
to survive interpretation through an indeterminate number
of internal macro call levels.
Thus, to circumvent this challenge,
and to robustly facilitate inclusion of the literal
.CW \(rsn \(rq \(lq
character sequence within the
.CW pdfmark
output stream, the
.CW pdfmark
macros define the following named strings:
.QS
.IP \*[= PDFNOTE.NEWLINE]
A string representation of the
.CW \(rsn \(rq \(lq
character sequence, which is encoded in a manner which,
when interpreted within the immediate arguments to the
.CW pdfnote
macro, \%re\(hyencodes the sequence such that
its ultimate interpretation is deferred,
until it is eventually written,
as a literal representation of a
.EM single
.CW \(rsn \(rq \(lq
character sequence, to the
.CW pdfmark
output stream.
Use of
.CW PDFNOTE.NEWLINE
is analogous to that of
.CW PDFNOTE.PILCROW ,
which is described below,
and is illustrated in previous examples within
.XR-NO-PREFIX add-note .
.
.IP \*[= PDFNOTE.PILCROW]
So named for its association with the typographer's pilcrow mark,
when interpreted within the immediate arguments to the
.CW pdfnote
macro, this marks the end of a logical paragraph,
and is \%re\(hyencoded as a (possibly recurring) sequence of
.CW \(rs*[PDFNOTE.NEWLINE]
\%re\(hyencodings.
At least one such \%re\(hyencoding is
.EM always
inserted; this is then repeated as many times as specified by the
.CW \%<line-count>
argument to the \%last\(hyspecified, if any,
.CW -PD
option\*(em\c
.XR pdfnote-options \c
\*[em]to the immediate, or any preceding, instance of
.CW pdfnote
macro use.
The effect is to introduce a new logical paragraph,
within the content of the
.CW pdfnote
annotation,
separated from the preceding paragraph,
of which the end is indicated by the
.CW \(rs*[PDFNOTE.PILCROW]
mark, by
.CW \%<line-count>
blank lines.
.
.IP
In the absence of any preceding
.CW -PD
option specification,
the effect of
.CW \(rs*[PDFNOTE.PILCROW]
becomes
.EM identical
to that of a single instance of
.CW \(rs*[PDFNOTE.NEWLINE] .\**
.FS
Neither
.CW PDFNOTE.NEWLINE ,
nor
.CW PDFNOTE.PILCROW
were provided in any version of the
.CW pdfmark
macros, which was published before \%Feb\(hy2023.
Earlier versions provided
.CW PDFLB ,
(for PDF \%line\(hybreak),
as an alternative;
it offered a similar capability to
.CW PDFNOTE.NEWLINE ,
but its implementation was flawed,
and was not robust.
The flawed implementation of
.CW PDFLB
is still supported, but it is now considered to be deprecated,
and using it is not recommended;
either
.CW PDFNOTE.NEWLINE ,
or
.CW PDFNOTE.PILCROW
should be used instead.
.FE
.QE
.
.NH 2
.XN -S -N pdfsync -- Synchronizing Output and \F[C]pdfmark\F[] Contexts
.LP
It has been noted previously, that the
.CW pdfview
macro,
.XR docview ), (
the
.CW pdfinfo
macro,
.XR docinfo ), (
and the
.CW pdfhref
macro, when used to create a document outline,
.XR add-outline ), (
do not immediately write their
.CW pdfmark
output to the \*[PostScript] data stream;
instead, they cache their output, in a
.CW groff
diversion, in the case of the
.CW pdfview
and
.CW pdfinfo
macros, or in an ordered collection of strings and numeric registers,
in the case of the document outline,
until a more appropriate time for copying it out.
In the case of
.CW pdfview
and
.CW pdfinfo
\%\(lqmeta\(hydata\(rq,
this \(lqmore appropriate time\(rq is explicitly chosen by the user;
in the case of document outline data,
.EM some
cached data may be implicitly written out as the document outline is compiled,
but there will
.EM always
be some remaining data, which must be explicitly flushed out, before the
.CW groff
formatting process is allowed to complete.
.LP
'ne 4v+\n[PD]u
To allow the user to choose when cached
.CW pdfmark
data is to be flushed to the output stream, the
.CW pdfmark
macro package provides the
.CW pdfsync
macro, (to synchronize the cache and output states).
In its simplest form, it is invoked without arguments, i.e.
.QP
.fam C
.B .pdfsync
.LP
This form of invocation ensures that
.EM both
the \%\(lqmeta\(hydata cache\(rq, containing
.CW pdfview
and
.CW pdfinfo
data,
.EM and
the \(lqoutline cache\(rq,
containing any previously uncommitted document outline data,
are flushed; ideally, this should be included in a
.CW groff
\(lqend macro\(rq, to ensure that
.EM both
caches are flushed, before
.CW groff
terminates.
.LP
Occasionally,
it may be desirable to flush either the \%\(lqmeta\(hydata cache\(rq,
without affecting the \(lqoutline cache\(rq, or \%vice\(hyversa,
at a user specified time, prior to reaching the end of the document.
This may be accomplished, by invoking the
.CW pdfsync
macro with an argument, i.e.
.QP
.fam C
.B ".pdfsync M"
.LP
to flush only the \%\(lqmeta\(hydata cache\(rq, or
.QP
.fam C
.B ".pdfsync O"
.LP
to flush only the \(lqoutline cache\(rq.
.LP
The \%\(lqmeta\(hydata cache\(rq can normally be safely flushed
in this manner, at any time
.EM after
output of the first page has started;
(it may cause formatting problems,
most notably the appearance of unwanted white space, if flushed earlier,
or indeed, if flushed immediately after a page transition,
but before the output of the content on the new page has commenced).
Caution is required, however, when explicitly flushing the
\(lqoutline cache\(rq, since if the outline is to be
subsequently extended, then the first outline entry after flushing
.EM must
be specified at level 1.
Nevertheless, such explicit flushing may occasionally be necessary;
for example, the
.CW TC
macro in the
.CW spdf.tmac
package,
.XR using-spdf ), (
invokes
.CW ".pdfsync\ O" \(rq \(lq
to ensure that the outline for the \(lqbody\(rq section of the document
is terminated,
.EM before
it commences the formatting of the table of contents section.
.bp
.
.NH 1
.XN -N pdf-layout -- PDF Document Layout
.LP
The
.CW pdfmark
macros described in the preceding section,
.XR pdf-features ), (
provide no inherent document formatting capability of their own.
However,
they may be used in conjunction with any other
.CW groff
macro package of the user's choice\Z','\**
.FS
Any of the standard
.CW groff
\%\(lqfull\(hyservice\(rq
macro packages,
.CW me ,
.CW mm ,
.CW mom ,
or
.CW ms ,
or indeed,
any \%\(lqhome\(hybrew\(rq macro package provided by the user,
should be suitable for the purpose;
regardless of the chosen \%\(lqfull\(hyservice\(rq macro package,
it is likely that a binding package,
specific to this choice,
will be required.
.FE
to add such capability.
.LP
In preparing this document, the standard
.CW ms
macro package, supplied as a component of the GNU Troff distribution,
has been employed.
To facilitate the use of the
.CW pdfmark
macros with the
.CW ms
macros,
a binding macro package,
.CW spdf.tmac ,
has been created.
The use of this binding macro package is described in the following section,
.XR using-spdf ); (
it may also serve as an example to users of other standard
.CW groff
macro packages,
as to how the
.CW pdfmark
macros may be employed with their chosen primary macro package.
.
.NH 2
.XN -S -N using-spdf -- Using \F[C]pdfmark\F[] Macros with the \F[C]ms\F[] Macro Package
.LP
The use of the binding macro package,
.CW spdf.tmac ,
allows for the use of the
.CW pdfmark
macros in conjunction with the
.CW ms
macros,
simply by issuing a
.CW groff
command of the form\**
.FS
Once again,
.pdfhref L -D pdf-features-fn -- as noted in footnote\*{\n[pdf-features-fn]\*}
to
.XR-NO-PREFIX pdf-features ,
do not specify any
.CW -T \^\c
.CWI dev
option,
other than
.CW -T \^\c
.CW ps ,
or
.CW -T \^\c
.CW pdf ;
specify
.CW -T \^\c
.CW pdf ,
if you wish to avoid the conversion of \*[PostScript] output to PDF,
which will be required if you specify
.CW -T \^\c
.CW ps ,
or if you omit the
.CW -T \^\c
.CWI dev
option entirely.
.FE
.QP
.fam C
groff [-Tps\h'0.2p'|\h'0.2p'-Tpdf] [-m\F[]\|\|\FC\c
.B spdf
.I options \F[]\|\|\FC\c [-
.I file \F[]\|\|\FC\c "...] "
\&...
.LP
When using the
.CW spdf.tmac
package, the
.CW groff
input files may be marked up using any of the standard
.CW ms
macros to specify document formatting,
while PDF features may be added,
using any of the
.CW pdfmark
macros described previously,
.XR pdf-features ). (
Additionally,
.CW spdf.tmac
defines a number of convenient extensions to the
.CW ms
macro set, to better accommodate the use of PDF features within the
.CW ms
formatting framework,
and to address a number of
.CW ms
document layout issues,
which require special handling when producing PDF documents.
These additional macros,
and the issues they are intended to address,
are described below.
.
.NH 3
.XN -S -- Document Structuring Considerations when using \F[C]ms\F[] Macros
.LP
Every published document
.EM must
incorporate,
as a minimum,
a document body;
additionally,
many documents may include
.EM \%front\(hymatter ,
which precedes the body,
and
.EM \%end\(hymatter ,
which follows the body.
Additionally,
when publishing as a PDF document,
it may be desired to incorporate a document outline,
referring to chapter,
or section headings,
within the document body.
.LP
Conventionally,
when a document is to include a
.EM "table of contents" ,
this should be placed at the end of the
.EM \%front\(hymatter .
.LP
Traditional
.CW AT&T
implementations of
.CW ms
provide a number of macros to control \%front\(hymatter style,
(of which only the \(lqreleased paper\(rq style,
selected by use of the
.CW RP
macro,
is supported by
.CW groff
.CW ms ),
accompanied by several macros to specify \%front\(hymatter content,
(also supported by
.CW groff
.CW ms ).
Both traditional,
and
.CW groff
.CW ms
implementations also provide a small set of macros
to facilitate compilation of a table of contents;
they do not,
however,
offer any standard facilities for creation
of a corresponding document outline.
.LP
Unfortunately,
the traditional
.CW ms
method of compiling the table of contents
results in it being printed at the end of the document,
rather than in its normal position,
at the end of the \%front\(hymatter.
Traditionally,
this unusual placement of the table of contents would be corrected,
by manual collation,
after printing;
emulation of this mechanical collation technique presents a challenge,
when the document is to be published in PDF format.
.LP
Taking up the challenge of collating the various document sections
into the correct order,
when producing any PDF document,
will necessitate special consideration during the PDF publication process;
this will be discussed in greater depth,
in
.rn PDFHREF.PREFIX XX
.XR pdf-publishing .
.rn XX PDFHREF.PREFIX
To accommodate any specialized processing which may be required,
.CW spdf.tmac
provides:\(en
.QS
.sp -\n[PD]u
.IP \(bu 2n
Macros to isolate the
.EM \%front\(hymatter ,
(excluding the
.EM "table of contents" ),
from the body of the document.
.IP \(bu
Further macros to compile a table of contents,
and a corresponding PDF document outline,
deriving both from section headings,
.XR xh-xn-macros ). (
.IP \(bu
A redefined implementation of the
.CW TC
macro,
(to be invoked at the end of the document,
as in traditional
.CW ms
usage);
this isolates the table of contents
from its preceding \%front\(hymatter (if any),
and from the document body,
to facilitate the collation process.
.\"nr PD +0.1v
.QE
.
.NH 3
.XN -S -- Using \F[C]ms\F[] Section Headings in PDF Documents
.LP
Traditionally,
.CW ms
provides the
.CW NH
and
.CW SH
macros to introduce section headings.
However,
in traditional
.CW ms
implementations,
there is no standard mechanism for generating a
table of contents entry based on the text of the section heading;
neither is there any recognized standard method
for establishing a cross reference link,
or a document outline reference,
to the section.
.LP
To address this limitation of traditional
.CW ms
implementations,
the
.CW spdf.tmac
binding macro package provides the
.CW XH
and
.CW XN
macros\Z','\**
.FS
On a technical note,
since
.CW \%groff-1.23 ,
the
.CW groff
implementation of
.CW ms
itself has incorporated basic infrastructure providing
.CW XH
and
.CW XN
macros,
to facilitate duplication of section heading text
into the table of contents;
.CW spdf.tmac
builds on top of this infrastructure,
.EM indirectly
redefining
.CW XH
and
.CW XN ,
by provision of macros
.CW \%XH-REPLACEMENT
and
.CW \%XN-REPLACEMENT
respectively,
to accommodate the duplication of section heading text
into the PDF document outline,
in addition to the table of contents.
Use of this indirect technique is recommended,
whenever redefinition of
.CW XH ,
or
.CW XN ,
is desired.
.FE
.XR xh-xn-macros ), (
to be used in conjunction with the
.CW SH
and
.CW NH
macros respectively;
each of these identifies,
by specification of appropriate arguments,
text which is to be incorporated into the section heading,
duplicated within the PDF document outline,
and in the table of contents.
.
.NH 4
.XN -S -N xh-xn-macros -- The \F[C]XH\F[] and \F[C]XN\F[] Macros
.LP
Formalized from the release of
.CW \%groff-1.23
onwards\Z','\**
.FS
Prior to the release of
.CW \%groff-1.23 ,
a prototypical implementation of
.CW spdf.tmac
was introduced with
.CW \%groff-1.19.2 ;
this prototype included an implementation of the
.CW XN
macro,
but it did
.EM not
provide
.CW XH ,
nor did it support the
.CW \%XH-INIT ,
.CW \%XN-INIT ,
and
.CW \%XH-UPDATE-TOC
\%call\(hyback features,
nor the
.CW \%XH-REPLACEMENT ,
and
.CW \%XN-REPLACEMENT
capabilities.
.FE
and nominally intended to be used following
.CW SH
and
.CW NH
respectively,
the calling syntax for this pair of
.CW spdf.tmac
macros is specified as:\(en
.DS I
.sp -\n[PD]u
.CWB .SH
.CWB .XH \& \& \0\c
.CWB -N \& [ \ \c
.CWI name >] < \ \c
.CWB -S ] [ \ \c
.CWB -X ] [ \0\c
.CWI outline-level > < \0\c
.CWI heading-text > < \ \c
.CW ...
.DE
.DS I
.sp -\n[PD]u
.CWB .NH \& \& \0\c
.CWI outline-level > <
.CWB .XN \& \& \0\c
.CWB -N \& [ \ \c
.CWI name >] < \ \c
.CWB -S ] [ \ \c
.CWB -X ] [ \0\c
.CWI heading-text > < \ \c
.CW ...
.DE
.LP
.sp -\n[PD]u
In either case,
the
.CWI heading-text >... < \&
arguments are incorporated into the document body,
formatted as section heading text.
Additionally,
these same
.CWI heading-text >... < \&
arguments,
(prefixed by the content of the
.CW SN
string,
in the
.CW XN
case),
are incorporated into the PDF document outline,
at the level specified by the
.CWI outline-level > <
argument,
and they are made available to the \%user\(hydefinable
.CW \%XH-UPDATE-TOC
\%call\(hyback macro,
.XR xh-update-toc-macro ), (
to support creation of a corresponding entry in
the document's table of contents.
.LP
In both cases,
the supported macro options\**
.FS
.EM None
of these options are supported by the underlying
.CW ms
implementations of
.CW XH
or
.CW XN ,
as implemented from
.CW \%groff-1.23
onwards.
Prior to
.CW \%groff-1.23 ,
only the
.CW -N \ \c
.CWI name > <
and
.CW -X
options are supported by the prototypical
.CW spdf.tmac
implementation of
.CW XN ,
as provided from
.CW \%groff-1.19.2
onwards.
.FE
are:\(en
.QS
.sp -\n[PD]u
.IP "\f(CB-N\fP\0\FC<\fIname\fP>\F[]" 4n
Create a
.CW pdfhref
destination,
with the specified
.CWI name > < ,
and associate it with the corresponding section heading,
as designated by
.CWI heading-text > \%< .
.IP \*[= -S]
Strip any \%font\(hyfamily selection escape sequences,
which may have been specified,
from a copy of
.CWI heading-text > \%< ,
before incorporating this into the document outline;
(this is necessary when such escape sequences are present,
to avoid verbatim rendition of the escape sequences themselves,
within the text of the document outline).
.IP \*[= -X]
Ensure that any
.CW pdfhref
destination name,
specified by the
.CWB -N
.CWI name > <
option,
is included within the document's \%cross\(hyreference dictionary.
.QE
.
.NH 4
.XN -S -N xh-xn-init-macros -- The \F[C]XH\-INIT\F[] and \F[C]XN\-INIT\F[] Macros
.LP
This pair of macros serve as context initialization hooks;
called by the default implementations of the
.CW XH
and
.CW XN
macros respectively,
without arguments,
.EM before
.CW \%XH\-UPDATE\-TOC
is called.
By default,
both return immediately,
.EM without
performing
.EM any
action.
However,
users may override either,
or both,
to perform any desired activity\ ...\ e.g. to save context
for subsequent use by any user\(hydefined macro,
which may have been provided to override the default implementation of
.CW \%XH\-UPDATE\-TOC .
.
.NH 4
.XN -S -N xh-update-toc-macro -- The \F[C]XH\-UPDATE\-TOC\F[] Macro
.LP
This macro is called by both
.CW XH
and
.CW XN ,
(there is no corresponding
.CW \%XN\-UPDATE\-TOC
equivalent,
since none is required to support the default
.CW XH
and
.CW XN
implementations),
to propagate content from the specified section heading arguments
to the document's table of contents.
From
.CW \%groff\-1.23
onwards,
a rudimentary default implementation of
.CW \%XH\-UPDATE\-TOC
is provided within the standard
.CW ms
macro suite;
however,
it is anticipated that the user will override this default implementation,
in order to achieve more effective control of table of contents formatting.
.LP
When writing a replacement for the
.CW \%XH\-UPDATE\-TOC
macro,
it should be implemented such that it will interpret arguments
as specified in the prototype
.DS I
.CWB \%.XH\-UPDATE\-TOC\c
.CWI outline\-level > \ \%< \c
.CWI section\-number >] \ \%[< \c
.CWI heading\-text > \ \%< \ \c
.CWI ...
.DE
in which the
.CWI outline\-level > \%<
and
.CWI heading\-text > \%<
arguments are the same as those specified for the
.CW XH ,
or the
.CW NH \^/\^\c
.CW XN
call sequence,
from which
.CW \%XH\-UPDATE\-TOC
itself is called;
the
.CWI section\-number > \%<
argument is
.EM always
specified,
when
.CW \%XH\-UPDATE\-TOC
is called by
.CW XN ,
(and
.EM never
when called by
.CW XH );
when present,
it represents the value of the
.CW SN
string,
which prevails at the time of the invoking
.CW XN
call,
and is simply processed as a prefix to the
.CWI heading\-text > \%<
argument.
.LP
The default implementation of
.CW \%XH\-UPDATE\-TOC
offers only rudimentary formatting of
the resultant table of contents entry;
the
.CWI outline\-level > \%<
argument is simply ignored,
and the remaining arguments are passed to the standard
.CW ms
table of contents generating capability,
in a form which is equivalent to
.DS I
.CW .XS
.CWI section\-number >\ ] \(rs&[< \c
.CWI heading\-text >\ ... \%<
.CW .XE
.DE
As an example (with abridged comments) of how
.CW \%XH\-UPDATE\-TOC
may be redefined,
to achieve more creative formatting of a table of contents,
this publication substitutes the following document\(hylocal
implementation:
.DS I
.CW
\&.ds XNVS1 0.50v  \(rs" leading for top level
\&.ds XNVS2 0.15v  \(rs" leading at nesting level increment
\&.ds XNVS3 0.30v  \(rs" leading following nested group
\&.
\&.de XH-UPDATE-TOC
\&.   XS
\&.      if r tc*hl \(rs{\(rs
\&.            \(rs" Compute additional leading at <outline-level> change
\&.            \(rs"
\&.            ie \(rs\(rs$1>1 \(rs{\(rs
\&.                  ie \(rs\(rs$1>\(rs\(rsn[tc*hl] .sp \(rs\(rs*[XNVS2]
\&.                  el .if \(rs\(rsn[tc*hl]>\(rs\(rs$1 .sp \(rs\(rs*[XNVS3]
\&.               \(rs}
\&.            el .sp \(rs\(rs*[XNVS1]
\&.         \(rs}
\&.
\&.      \(rs" Record <outline-level> of this entry, to compare with next
\&.      \(rs"
\&.      ie \(rs\(rs$1 .nr tc*hl \(rs\(rs$1
\&.      el .nr tc*hl 1
\&.
\&.      \(rs" Set indentation, and insert <section-number> for this entry
\&.      \(rs"
\&.      nop \(rsh\(aq\(rs\(rsn[tc*hl]-1m\(aq\(rs\(rs$2\(rsc
\&.
\&.      \(rs" Append <heading-text> for this entry
\&.      \(rs"
\&.      shift 2
\&.      nop \(rsh\(aq1.5n\(aq\(rs\(rs$*\(rsh\(aq0.5n\(aq
\&.   XE
\&..
.DE
Used in conjunction with
.CW NH
and
.CW XN ,
this uses document\(hylocal register
.CW \%tc*hl
to track,
group,
and indent the table of contents entries for this document,
on the basis of their specified
.CWI outline\-level > \%<
specifications,
separating
.CWI outline\-level > \%<
groups by additional line spacing,
(having an effect similar to that of increased leading),
as controlled by the
.CW XNVS1 ,
.CW XNVS2 ,
and
.CW XNVS3
document\(hylocal strings,
at each change in
.CWI outline\-level > \%< .
.
.NH 4
.XN -S -- The \F[C]XH\-REPLACEMENT\F[] and \F[C]XN\-REPLACEMENT\F[] Macros
.LP
The default
.CW XH
and
.CW XN
macro implementations
.EM reserve
this pair of macro names,
to facilitate
.EM redefinition
of
.CW XH
and
.CW XN
behaviour respectively,
while retaining the ability to take advantage
of first\(hytime\(hyof\(hyuse infrastructure initialization logic,
which is incorporated within the respective default implementations.
.LP
It is important to understand that,
in conventional usage,
neither of these macros should ever be called directly.
Rather,
either one,
or both,
should be defined,
.EM after
loading
.CW s.tmac ,
and
.EM before
calling either
.CW XH ,
or
.CW XN
for the first time;
the defined implementations are then invoked when
.CW XH ,
or
.CW XN
are called,
respectively.
.
.LP
User\(hywritten
.CW \%XH\-REPLACEMENT
and
.CW \%XN\-REPLACEMENT
macros may implement
.EM any
desired functionality.
They are not constrained to emulation of the default
.CW XH
and
.CW XN
capabilities;
however,
it is
.EM strongly
recommended that they do so,
while adding any required extended features.
For example,
.CW spdf.tmac
defines both replacement macros thus:\**
.FS
An important consideration,
in the design of such replacement macros,
is that they will ultimately be invoked as
.CW XH ,
and
.CW XN
respectively;
thus,
they
.EM must
interpret their arguments
.EM exactly
as they would be passed to
.CW XH
and
.CW XN ,
and within the macro bodies,
.CW \%\(rs\(rs$0
will be interpreted as
.CW XH
or
.CW XN ,
as appropriate.
.FE
.DS I
.CW
\&.de XH\-REPLACEMENT als
\&.als XN\-REPLACEMENT XH-REPLACEMENT
\&.am XH-REPLACEMENT
\&.   \(rs\(rs$0\-INIT
\&.   rm spdf:refname
\&.   als spdf:bm.define spdf:bm.basic
\&.   while d spdf:XH\(rs\(rs$1 \(rs{\(rs
\&.         spdf:XH\(rs\(rs$1 \(rs\(rs$*
\&.         shift \(rs\(rsn[spdf:argc]
\&.      \(rs}
\&.   rr spdf:argc
\&.   if \(aq\(rs\(rs$1\(aq\-\-\(aq .shift
\&.   spdf:\(rs\(rs$0.format \(rs\(rs$@
\&..
.DE
with macros
.CW \%XH\-N ,
.CW \%XH\-S ,
and
.CW \%XH\-X
defined locally,
extending the default behaviour,
such that the non\(hydefault
.CW \-N ,
.CW \-S ,
and
.CW \-X
option flags are interpreted,
(and register
.CW \%spdf:argc
is set,
to control the
.CW while
loop which does so);
it further extends the default behaviour,
by using locally defined macros,
.CW \%spdf:XH.format ,
and
.CW \%spdf:XN.format ,
(dynamically modified by
.CW \%spdf:bm.basic ,
.CW \%spdf:bm.define ,
and
.CW \%spdf:refname ),
to propagate the specified section heading text
to the PDF document outline,
in addition to reproducing the default
propagation to the document's table of contents,
by calling
.CW \%XH\-UPDATE\-TOC .
.
.bp
.NH 1
.XN -N pdf-publishing -- The PDF Publishing Process
.
.NH 2
.XN -N do-xref -- Resolving Cross References
.
.NH 3
.XN -N create-map -- Creating a Document Reference Map
.
.NH 3
.XN -N import-map -- Deploying a Document Reference Map
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: filetype=groff:
