// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class ColTransform
{//{{{
	KyVector2f position = new KyVector2f(0f, 0f);
	KyVector2f scale = new KyVector2f(0f, 0f);
	float angle360 = 0f;

	public ColTransform getClone()
	{//{{{
		ColTransform clone_ = new ColTransform();
		clone_.position.x = position.x;
		clone_.position.y = position.y;
		clone_.scale.x = scale.x;
		clone_.scale.y = scale.y;
		clone_.angle360 = angle360;
		return clone_;
	}//}}}
	public ColTransform addLocal( ColTransform rhs_ )
	{//{{{
		position.addLocal( rhs_.position );
		scale.addLocal( rhs_.scale );
		angle360 += rhs_.angle360;
		return this;
	}//}}}
	public ColTransform subLocal( ColTransform rhs_ )
	{//{{{
		position.subLocal( rhs_.position );
		scale.subLocal( rhs_.scale );
		angle360 -= rhs_.angle360;
		return this;
	}//}}}
	public ColTransform mulLocal( float rhs_ )
	{//{{{
		position.mulLocal( rhs_ );
		scale.mulLocal( rhs_ );
		angle360 *= rhs_;
		return this;
	}//}}}
	public ColTransform add( ColTransform rhs_ )
	{//{{{
		return getClone().addLocal( rhs_ );
	}//}}}
	public ColTransform sub( ColTransform rhs_ )
	{//{{{
		return getClone().subLocal( rhs_ );
	}//}}}
	public ColTransform mul( float rhs_ )
	{//{{{
		return getClone().mulLocal( rhs_ );
	}//}}}
	static float mod( float lhs_, float rhs_ )
	{//{{{
		int n_ = (int)(lhs_ / rhs_);
		return lhs_ - (float)n_ * rhs_;
	}//}}}
	public void apply( KyFloatComparator cmp_, KyVector2f vec_ )
	{//{{{
		float cos_ = 1f;
		float sin_ = 0f;
		if( !cmp_.equals( mod( angle360, 360), 0f ) ){
			double a_ = angle360 * Math.PI/180.0;
			sin_ = (float)Math.sin( a_);
			cos_ = (float)Math.cos( a_);
		}
		float sx_ = scale.x;
		float sy_ = scale.y;
		float x_ = vec_.x * cos_ * sx_ - vec_.y * sin_ * sx_ + position.x;
		float y_ = vec_.x * sin_ * sy_ + vec_.y * cos_ * sy_+ position.y;
		vec_.x = x_;
		vec_.y = y_;
	}//}}}

	public void setPosition( float x_, float y_ )
	{//{{{
		position.x = x_;
		position.y = y_;
	}//}}}
	public void setScale( float x_, float y_ )
	{//{{{
		scale.x = x_;
		scale.y = y_;
	}//}}}
	public void setScale( float v_ )
	{//{{{
		scale.x = scale.y = v_;
	}//}}}
	public String toString()
	{//{{{
		return String.format( "position=(%s) scale=(%s) angle360=%f", position, scale, angle360 );
	}//}}}
}//}}}

