// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.util.KyLinkedElement;
import java.util.ArrayList;

public class ColWorld
{//{{{
	ColSpace space;
	ColControl control;
	KyLinkedElement<ColBody> bodyHead = new KyLinkedElement<ColBody>(null);
	float time = 0f;
	float frameUnitTime = 1f/60f;
	int frameCount = 0;
	int bodyHashCount = 0;

	public ColWorld( ColSpace space_, ColControl control_ )
	{//{{{
		space = space_;
		control = control_;
	}//}}}

	public float getFrameUnitTime()
	{//{{{
		return frameUnitTime;
	}//}}}
	public void setFrameUnitTime( float value_ )
	{//{{{
		frameUnitTime = value_;
	}//}}}
	float getFrameTime()
	{//{{{
		return frameUnitTime * (float)frameCount;
	}//}}}
	float getNextFrameTime()
	{//{{{
		return frameUnitTime * (float)(frameCount+1);
	}//}}}

	public void update( float vt_ )
	{//{{{
		time += vt_;
		float frameTime_ = getFrameTime();
		float wait_ = time - frameTime_;
		int n_ = (int)(wait_/frameUnitTime);
		for( int i_ = 0; i_ < n_; ++i_ ){
			control.onUpdate( this, frameUnitTime );
			++frameCount;
		}
	}//}}}

	public void updateBody( ColBody body_ )
	{//{{{
		body_.node.disconnect();
		body_.node = space.register( body_ );
	}//}}}
	public ColBody addBody( ColShape shape_ )
	{//{{{
		ColBody body_ = control.newBody();
		shape_.body = body_;
		body_.shape = shape_;
		addBody( body_ );
		return body_;
	}//}}}
	void addBody( ColBody body_ )
	{//{{{
		KyLinkedElement<ColBody> link_ = bodyHead.valueRefOf( body_ );
		if( link_ != null ){
			return;
		}
		body_.world = this;
		body_.hash = bodyHashCount++;
		body_.node = space.register( body_ );
		link_ = new KyLinkedElement<ColBody>( body_ );
		bodyHead.connectNext( link_ );
	}//}}}
}//}}}

