// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import mn.jp.kekkouyakan.util.KyArrayUtil;
import mn.jp.kekkouyakan.test.SvgWriter;
import mn.jp.kekkouyakan.test.HtmlWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Collections;
import java.util.Comparator;
import static mn.jp.kekkouyakan.collision.CollisionTest.ShapeInfo;
import static mn.jp.kekkouyakan.collision.CollisionTest.toPolygon;
import static mn.jp.kekkouyakan.collision.CollisionTest.drawPath;
import static mn.jp.kekkouyakan.collision.ColSpace.Node;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

class KyListVisitor implements ColSpace.IVisitor
{//{{{
	List<Node> list;
	public KyListVisitor()
	{//{{{
		list = new ArrayList<Node>();
	}//}}}
	public KyListVisitor( List<Node> list_ )
	{//{{{
		list = list_;
	}//}}}
	public List<Node> getList()
	{//{{{
		return list;
	}//}}}
	public boolean visit( Node val_ )
	{//{{{
		list.add( val_ );
		return true;
	}//}}}
}//}}}
public class ColSpaceTest
{//{{{
	public final static String TEST_ID="collision20180830_2C0l6WFcSyqc4qKZnftVpw";
	public static File resultDir = null;
	static ArrayList<String> fileNameList = new ArrayList<String>();
	KyFloatComparator floatComparator = new KyFloatComparator();

	static class NodeComparator implements Comparator<Node>
	{//{{{
		public int compare( Node lhs_, Node rhs_ )
		{//{{{
			ShapeInfo linfo_ = (ShapeInfo)lhs_.getShape().userObject;
			ShapeInfo rinfo_ = (ShapeInfo)rhs_.getShape().userObject;
			return linfo_.id.compareTo( rinfo_.id );
		}//}}}
		public boolean equals( Object a_ )
		{//{{{
			return a_ == this;
		}//}}}
	}//}}}

	public ColSpaceTest()
	{//{{{
	}//}}}

	@BeforeClass
	public static void setUpClass()
	{//{{{
		String resultPath_ = System.getenv( "TEST_RESULT" );
		if( resultPath_ == null ){
			throw new AssertionError();
		}
		File base_ = new File( resultPath_ );
		if( base_.exists() ){
			if( !base_.isDirectory() ){
				throw new AssertionError();
			}
		}
		else{
			base_.mkdir();
		}
		resultDir = new File( base_, TEST_ID );
		if( resultDir.exists() ){
			//throw new AssertionError();
		}
		else{
			resultDir.mkdir();
		}
	}//}}}
	@AfterClass
	public static void tearDownClass() throws Exception
	{//{{{
		File f_ = new File( resultDir, "index.html" );
		HtmlWriter w_ = new HtmlWriter( f_ );
		w_.beginHtmlTag();
		w_.printHeadTag();
		w_.beginBodyTag();

		synchronized( fileNameList ){
			for( String fileName_ : fileNameList ){
				w_.beginDivTag();
				w_.printATagHref( fileName_, fileName_, null );
				w_.endDivTag();
			}
		}

		w_.endBodyTag();
		w_.endHtmlTag();
	}//}}}
	@Before
	public void setUp()
	{//{{{
	}//}}}
	@After
	public void tearDown()
	{//{{{
	}//}}}

	ColCircle newCircle( float x_, float y_, float r_, String id_, String color_ )
	{//{{{
		ColCircle c_ = new ColCircle( x_, y_, r_, floatComparator );
		ShapeInfo info_ = new ShapeInfo();
		info_.id = id_;
		info_.color = color_;
		c_.userObject = info_;
		return c_;
	}//}}}
	ColVectors newVecs( String id_, String color_, KyVector2f[] vecLs_ )
	{//{{{
		ColVectors v_ = new ColVectors( vecLs_, floatComparator );
		ShapeInfo info_ = new ShapeInfo();
		info_.id = id_;
		info_.color = color_;
		v_.userObject = info_;
		return v_;
	}//}}}

	static class Writer_mUrhBPWYT_mbn_DSXFantA
	{//{{{
		String phase=null;
		String name;
		float scale = 5;
		int gridPitch = 1;
		int groupNumber = 0;
		int listPageMin = 1;
		int listPageMax = 10;
		String width = null;
		String height = null;
		int axisScaleMarkingStep = 0;
		List<Node> visitResult;
		String getFileName( String funcName_, String ext_, int groupNumber_, int num_ )
		{//{{{
			return String.format( "%s%d_%d.%s", funcName_, groupNumber_, num_, ext_ );
		}//}}}

		String getFileName( String funcName_, String ext_, int num_ )
		{//{{{
			return getFileName( funcName_, ext_, groupNumber, num_ );
		}//}}}

		public void put( ColSpace space_, int n_ ) throws Exception
		{//{{{
			put( space_, null, n_ );
		}//}}}
		public void put( ColSpace space_, ColShape viShape_, int n_ ) throws Exception
		{//{{{
			if( viShape_ != null ){
				KyListVisitor lsVi_ = new KyListVisitor();
				space_.visitCollisionNodes( viShape_, lsVi_ );
				visitResult = lsVi_.getList();
				Collections.sort( visitResult, new NodeComparator() );
			}
			else{
				visitResult = null;
			}
			KyListVisitor lsAll_ = new KyListVisitor();
			space_.visitAllNodes( lsAll_ );
			Collections.sort( lsAll_.list, new NodeComparator() );
			int divCnt_ = space_.getDivCount();

			String svgFileName_ = getFileName( name, "svg", n_ );
			File svgFile_ = new File( resultDir, svgFileName_ );
			SvgWriter svg_ = new SvgWriter( svgFile_ );

			float x0_ = space_.getMinX();
			float y0_ = space_.getMinY();
			float w_ = space_.getWidth();
			float h_ = space_.getHeight();

			svg_.beginSvgTag( (int)(scale*w_), (int)(scale*h_) );
			svg_.setView( scale, scale, -scale*x0_, -scale*y0_ );
			svg_.setFill( "None" );
			svg_.setStroke( "#ddd" );
			svg_.setStrokeWidth( "1" );
			svg_.drawGrid( gridPitch, (int)w_/gridPitch, (int)h_/gridPitch, x0_, y0_ );
			svg_.setStroke( "#aaa" );
			svg_.setStrokeWidth( "2" );
			for( float x_ : space_.xOffsetList ){
				svg_.drawLine( x_, space_.getMinY(), x_, space_.getMaxY() );
			}
			for( float y_ : space_.yOffsetList ){
				svg_.drawLine( space_.getMinX(), y_, space_.getMaxX(), y_ );
			}
			svg_.setStroke( "None" );
			svg_.setFill( "#aaa" );
			if( axisScaleMarkingStep > 0 ){
				float mx_ = space_.xOffsetList[ divCnt_/2 ];
				float my_ = space_.yOffsetList[ divCnt_/2 ];
				for( int i_ = 0; i_ <= divCnt_/2; i_ += axisScaleMarkingStep ){
					{
						float x_ = space_.xOffsetList[ divCnt_/2 - i_ ];
						String str_ = String.format( "(%.2f,%.2f)", x_, my_ );
						svg_.drawText( x_, my_, str_ );
					}
					{
						float x_ = space_.xOffsetList[ divCnt_/2 + i_ ];
						String str_ = String.format( "(%.2f,%.2f)", x_, my_ );
						svg_.drawText( x_, my_, str_ );
					}
					{
						float y_ = space_.yOffsetList[ divCnt_/2 - i_ ];
						String str_ = String.format( "(%.2f,%.2f)", mx_, y_ );
						svg_.drawText( mx_, y_, str_ );
					}
					{
						float y_ = space_.yOffsetList[ divCnt_/2 + i_ ];
						String str_ = String.format( "(%.2f,%.2f)", mx_, y_ );
						svg_.drawText( mx_, y_, str_ );
					}
				}
			}
			{
				int midIndex_ = divCnt_/2;
				svg_.setStrokeWidth( "4" );
				float x_ = space_.xOffsetList[midIndex_];
				float y_ = space_.yOffsetList[midIndex_];
				svg_.drawLine( x_, space_.getMinY(), x_, space_.getMaxY() );
				svg_.drawLine( space_.getMinX(), y_, space_.getMaxX(), y_ );
			}
			svg_.setStroke( "None" );
			svg_.setFill( "#aaa" );
			for( int x_ = 0; x_ < divCnt_; ++x_ ){
				float xf1_ = space_.xOffsetList[x_];
				float xf2_ = space_.xOffsetList[x_+1];
				float xfm_ = (xf1_+xf2_)/2f;
				for( int y_ = 0; y_ < divCnt_; ++y_ ){
					float yf1_ = space_.yOffsetList[y_];
					float yf2_ = space_.yOffsetList[y_+1];
					float yfm_ = (yf1_+yf2_)/2f;
					int o_ = ColSpace.getOrder( x_, y_ );
					svg_.drawText( xfm_, yfm_, String.valueOf( o_ ) );
				}
			}
			svg_.setStrokeWidth( "1" );
			for( Node node_ : lsAll_.getList() ){
				printShape( svg_, node_.getShape() );
			}
			if( viShape_ != null ){
				printShape( svg_, viShape_ );
			}

			svg_.endSvgTag();

			String htmlFileName_ = getFileName( name, "html", n_ );
			fileNameList.add( htmlFileName_ );
			File htmlFile_ = new File( resultDir, htmlFileName_ );
			HtmlWriter html_ = new HtmlWriter( htmlFile_ );
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.endHeadTag();

			html_.beginBodyTag();

			if( phase != null ){
				html_.beginDivTag();
				html_.out.print( phase );
				html_.endDivTag();
			}

			if( width != null ){
				html_.setWidth( width );
			}
			if( height != null ){
				html_.setHeight( height );
			}
			html_.beginATag( svgFileName_ );
			html_.printImgTag( svgFileName_ );
			html_.endATag();
			html_.beginDivTag();
			html_.out.printf( "x:" );
			for( int i_ = 0; i_ < space_.xOffsetList.length; ++i_ ){
				if( i_ == divCnt_/2 ){
					html_.out.printf( "(%f),", space_.xOffsetList[i_] );
				}
				else{
					html_.out.printf( "%f,", space_.xOffsetList[i_] );
				}
			}
			html_.endDivTag();
			html_.beginDivTag();
			html_.out.printf( "y:" );
			for( int i_ = 0; i_ < space_.yOffsetList.length; ++i_ ){
				if( i_ == divCnt_/2 ){
					html_.out.printf( "(%f),", space_.yOffsetList[i_] );
				}
				else{
					html_.out.printf( "%f,", space_.yOffsetList[i_] );
				}
			}
			html_.endDivTag();

			html_.beginDivTag();
			html_.printATagHref( "(|&lt;)", getFileName( name, "html", groupNumber-1, 1 ), null );
			html_.printATagHref( "(&lt&lt;)", getFileName( name, "html", groupNumber, n_-1 ), null );
			html_.out.printf( "%d-%d", groupNumber, n_ );
			html_.printATagHref( "(&gt&gt;)", getFileName( name, "html", groupNumber, n_+1 ), null );
			html_.printATagHref( "(&gt;|)", getFileName( name, "html", groupNumber+1, 1 ), null );
			html_.endDivTag();
			html_.beginDivTag();
			html_.printATagHref( "index|", "index.html", null );
			for( int i_ = listPageMin; i_ <= listPageMax; ++i_ ){
				if( i_ == n_ ){
					html_.out.print( String.valueOf(i_) );
				}
				else{
					html_.printATagHref( String.valueOf(i_), getFileName( name, "html", groupNumber, i_ ), null );
				}
				html_.out.print( "," );
			}
			html_.endDivTag();

			if( visitResult != null ){
				html_.beginDivTag();
				html_.out.print( "Visit:" );
				for( Node node_ : visitResult ){
					assert( node_.getShape().userObject instanceof ShapeInfo );
					ShapeInfo info_ = (ShapeInfo)node_.getShape().userObject;
					html_.out.printf( "%s,", info_.id );
				}
				html_.endDivTag();
			}

			for( Node node_ : lsAll_.getList() ){
				printShape( html_, node_.getShape() );
			}
			if( viShape_ != null ){
				printShape( html_, viShape_ );
			}
			for( Node node_ : lsAll_.getList() ){
				printNode( html_, space_, node_ );
			}

			html_.endBodyTag();

			html_.endHtmlTag();
		}//}}}
		static void printShape( HtmlWriter html_, ColShape shape0_ )
		{//{{{
			if( shape0_ instanceof ColCircle ){
				ColCircle shape_ = (ColCircle)shape0_;
				assert( shape_.userObject instanceof ShapeInfo );
				String id_ = ((ShapeInfo)shape_.userObject).id;
				html_.beginDivTag();
				html_.out.printf(
					"Circle %s: origin=%s, r=%f, min=(%f,%f) max=(%f,%f)"
					,id_
					,shape_.transform.position
					,shape_.getRadius()
					,shape_.getMinX()
					,shape_.getMinY()
					,shape_.getMaxX()
					,shape_.getMaxY()
				);
				html_.endDivTag();
			}
			else if( shape0_ instanceof ColVectors ){
				ColVectors shape_ = (ColVectors)shape0_;
				assert( shape_.userObject instanceof ShapeInfo );
				String id_ = ((ShapeInfo)shape_.userObject).id;
				html_.beginDivTag();
				html_.out.printf(
					"Vectors %s: min=(%f,%f) max=(%f,%f)"
					,id_
					,shape_.getMinX()
					,shape_.getMinY()
					,shape_.getMaxX()
					,shape_.getMaxY()
				);
				html_.endDivTag();
			}
		}//}}}
		static void printNode( HtmlWriter html_, ColSpace space_, Node node_ )
		{//{{{
			Node hd_ = (Node)node_.getHead();
			html_.beginDivTag();
			String id_ = ((ShapeInfo)node_.getShape().userObject).id;
			html_.out.printf( "Node %s:", id_ );
			html_.out.printf( " lv=%d", hd_.minOrder );
			html_.out.printf( " index=%d", hd_.maxOrder );
			html_.out.printf( " order=(%d,%d)", node_.minOrder, node_.maxOrder);
			html_.out.printf( " shareLv=%d", space_.getShareLevel( node_.minOrder, node_.maxOrder ) );
			for( int lv_ = 0; lv_ < space_.getLevelCount(); ++lv_ ){
				html_.out.printf( " min%d=%d", lv_, space_.getOrderIndex( node_.minOrder, lv_ ) );
				html_.out.printf( " max%d=%d", lv_, space_.getOrderIndex( node_.maxOrder, lv_ ) );
			}
			html_.endDivTag();
		}//}}}
		static void printShape( SvgWriter svg_, ColShape shape0_ )
		{//{{{
			if( shape0_ instanceof ColCircle ){
				ColCircle shape_ = (ColCircle)shape0_;
				float x_ = shape_.transform.position.x;
				float y_ = shape_.transform.position.y;
				assert( shape_.userObject instanceof ShapeInfo );
				ShapeInfo info_ = (ShapeInfo)shape_.userObject;
				svg_.setStroke( info_.color );
				svg_.setFill( "None" );
				svg_.drawCircle( x_, y_, shape_.getRadius() );
				svg_.setStroke( "None" );
				svg_.setFill( info_.color );
				svg_.drawText( x_, y_, info_.id );
			}
			else if( shape0_ instanceof ColVectors ){
				ColVectors shape_ = (ColVectors)shape0_;
				float x1_ = shape_.getMinX();
				float y1_ = shape_.getMinY();
				float y2_ = shape_.getMaxY();
				assert( shape_.userObject instanceof ShapeInfo );
				ShapeInfo info_ = (ShapeInfo)shape_.userObject;
				svg_.setStroke( info_.color );
				svg_.setFill( "None" );
				drawPath( svg_, shape_.currentPoints );
				svg_.setStroke( "None" );
				svg_.setFill( info_.color );
				svg_.drawText( x1_, (y1_+y2_)/2f, info_.id );
			}
		}//}}}
	}//}}}

	static boolean checkIds( List<Node> ls_, String... idLs_ )
	{//{{{
		if( ls_.size() != idLs_.length ){
			return false;
		}
		for( Node node_ : ls_ ){
			ShapeInfo info_ = (ShapeInfo)node_.getShape().userObject;
			if( KyArrayUtil.find( idLs_, info_.id ) == null ){
				return false;
			}
		}
		return true;
	}//}}}

	@Test
	public void space_mUrhBPWYT_mbn_DSXFantA() throws Exception
	{//{{{
		Writer_mUrhBPWYT_mbn_DSXFantA w_ = new Writer_mUrhBPWYT_mbn_DSXFantA();
		w_.name = "space_mUrhBPWYT_mbn_DSXFantA";
		w_.gridPitch = 2;
		w_.width = "800px";
		w_.height = "800px";

		//{{{
		ColCircle circle01_ = newCircle(    0,    0, 10, "C01", "#00f" );
		ColCircle circle02_ = newCircle( -180, -180, 10, "C02", "#00f" );
		ColCircle circle03_ = newCircle( -150, -180, 10, "C03", "#00f" );
		ColCircle circle04_ = newCircle( -130, -180, 10, "C04", "#00f" );
		ColCircle circle05_ = newCircle( -100, -180, 10, "C05", "#00f" );
		ColCircle circle06_ = newCircle( -100, -150, 10, "C06", "#00f" );
		ColCircle circle07_ = newCircle(    0, -180, 10, "C07", "#00f" );
		ColCircle circle08_ = newCircle(  130, -100, 10, "C08", "#00f" );
		//}}}
		{//{{{
			int n_ = 0;
			++w_.groupNumber;
			ColSpace space_ = new ColSpace(0, -200, -200, 200, 200, floatComparator );
			{//{{{
				assertTrue( space_.headNodeLists != null );
				assertTrue( space_.headNodeLists.length == 1 );
				assertTrue( space_.headNodeLists[0] != null );
				assertTrue( space_.headNodeLists[0].length == 1 );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle01_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle01_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle02_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle02_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle01_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle03_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle03_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle02_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle04_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle04_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle03_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle05_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle05_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle04_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle06_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle06_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle05_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle07_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle07_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle06_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle08_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle08_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle07_ );
			}//}}}
		}//}}}
		{//{{{
			int n_ = 0;
			++w_.groupNumber;
			ColSpace space_ = new ColSpace(1, -200, -200, 200, 200, floatComparator );
			{//{{{
				assertTrue( space_.headNodeLists != null );
				assertTrue( space_.headNodeLists.length == 2 );
				assertTrue( space_.headNodeLists[0] != null );
				assertTrue( space_.headNodeLists[0].length == 1 );
				assertTrue( space_.headNodeLists[1] != null );
				assertTrue( space_.headNodeLists[1].length == 4 );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle01_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 3 );
				assertTrue( node_.getShape() == circle01_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle02_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle02_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle03_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle03_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle02_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle04_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle04_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle03_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle05_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle05_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle04_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle06_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle06_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle05_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle07_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle07_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle01_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle08_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 1 );
				assertTrue( node_.minOrder == 1 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle08_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
		}//}}}
		{//{{{
			int n_ = 0;
			++w_.groupNumber;
			ColSpace space_ = new ColSpace(2, -200, -200, 200, 200, floatComparator );
			{//{{{
				assertTrue( space_.headNodeLists != null );
				assertTrue( space_.headNodeLists.length == 3 );
				assertTrue( space_.headNodeLists[0] != null );
				assertTrue( space_.headNodeLists[0].length == 1 );
				assertTrue( space_.headNodeLists[1] != null );
				assertTrue( space_.headNodeLists[1].length == 4 );
				assertTrue( space_.headNodeLists[2] != null );
				assertTrue( space_.headNodeLists[2].length == 16 );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle01_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 3 );
				assertTrue( node_.maxOrder == 12 );
				assertTrue( node_.getShape() == circle01_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle02_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 2 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle02_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle03_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 2 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle03_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle02_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle04_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 2 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle04_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle03_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle05_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle05_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle06_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle06_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle05_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle07_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 1 );
				assertTrue( node_.maxOrder == 4 );
				assertTrue( node_.getShape() == circle07_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle01_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle08_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 1 );
				assertTrue( node_.minOrder == 5 );
				assertTrue( node_.maxOrder == 7 );
				assertTrue( node_.getShape() == circle08_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
		}//}}}
		{//{{{
			int n_ = 0;
			++w_.groupNumber;
			ColSpace space_ = new ColSpace(3, -200, -200, 200, 200, floatComparator );
			{//{{{
				assertTrue( space_.headNodeLists != null );
				assertTrue( space_.headNodeLists.length == 4 );
				assertTrue( space_.headNodeLists[0] != null );
				assertTrue( space_.headNodeLists[0].length == 1 );
				assertTrue( space_.headNodeLists[1] != null );
				assertTrue( space_.headNodeLists[1].length == 4 );
				assertTrue( space_.headNodeLists[2] != null );
				assertTrue( space_.headNodeLists[2].length == 16 );
				assertTrue( space_.headNodeLists[3] != null );
				assertTrue( space_.headNodeLists[3].length == 64 );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle01_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 15 );
				assertTrue( node_.maxOrder == 48 );
				assertTrue( node_.getShape() == circle01_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle02_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 3 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 0 );
				assertTrue( node_.getShape() == circle02_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle03_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 2 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 0 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle03_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle04_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 3 );
				assertTrue( space_.getShareIndex( node_ ) == 1 );
				assertTrue( node_.minOrder == 1 );
				assertTrue( node_.maxOrder == 1 );
				assertTrue( node_.getShape() == circle04_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle05_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 1 );
				assertTrue( node_.maxOrder == 4 );
				assertTrue( node_.getShape() == circle05_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle06_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 1 );
				assertTrue( node_.maxOrder == 6 );
				assertTrue( node_.getShape() == circle06_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle05_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle07_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 0 );
				assertTrue( space_.getShareIndex( node_ ) == 0 );
				assertTrue( node_.minOrder == 5 );
				assertTrue( node_.maxOrder == 16 );
				assertTrue( node_.getShape() == circle07_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() != null );
				assertTrue( ((Node)node_.getNext()).getShape() == circle01_ );
			}//}}}
			{//{{{
				Node node_ = space_.register( circle08_ );
				w_.put( space_, ++n_ );
				assertTrue( space_.getShareLevel( node_ ) == 1 );
				assertTrue( space_.getShareIndex( node_ ) == 1 );
				assertTrue( node_.minOrder == 22 );
				assertTrue( node_.maxOrder == 28 );
				assertTrue( node_.getShape() == circle08_ );
				assertTrue( node_.getPrev() != null );
				assertTrue( node_.getNext() == null );
			}//}}}
		}//}}}
	}//}}}
	@Test
	public void space_Rf6shFZCRdCvXLjlkGOoeA() throws Exception
	{//{{{
		Writer_mUrhBPWYT_mbn_DSXFantA w_ = new Writer_mUrhBPWYT_mbn_DSXFantA();
		w_.name = "space_Rf6shFZCRdCvXLjlkGOoeA";
		w_.scale = 20;
		w_.axisScaleMarkingStep = 2;
		String visitorColor_ = "#00f";

		ColSpace space_ = new ColSpace(3, -12, -12, 30, 20, floatComparator );
		space_.xOffsetList[3] += 1f;
		space_.xOffsetList[4] += 1f;
		space_.yOffsetList[4] += 1f;
		space_.yOffsetList[5] += 1f;
		space_.yOffsetList[6] -= 1f;
		int n_=1;
		w_.phase = "REGISTER PHASE";
		++w_.groupNumber;
		{//{{{
			ColVectors vecs_ = newVecs( "A", "#f00", toPolygon( 1,1,  1,4,  4,1 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 3 );
			assertTrue( node_.minOrder == 14 );
			assertTrue( node_.maxOrder == 14 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 2 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 2 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "B", "#f00", toPolygon( 7,2,  4,6,  5,8, 9,6 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 0 );
			assertTrue( node_.minOrder == 14 );
			assertTrue( node_.maxOrder == 37 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 2 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 1 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 2 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 1 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "C", "#f00", toPolygon( 15,2,  10,10,  5,10, 10,15, 18,10 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 0 );
			assertTrue( node_.minOrder == 15 );
			assertTrue( node_.maxOrder == 57 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 2 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 1 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "D", "#f00", toPolygon( 18,5,  22,8,  24,5, 26,0, 25,-5, 19,-2 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 0 );
			assertTrue( node_.minOrder == 19 );
			assertTrue( node_.maxOrder == 53 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 1 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 1 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 1 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "E", "#f00", toPolygon( 17,-2,  8, -2, 8,-10, 17,-10, 17,-8, 11,-8, 11,-5, 17, -5 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 0 );
			assertTrue( node_.minOrder == 5 );
			assertTrue( node_.maxOrder == 25 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 1 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 1 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 2 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 1 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 1 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "F", "#f00", toPolygon( -3,10, -1,10, 0,13, -4,14 ,-5,10, -7,5, -6,0, -5,-5 ,0,-7, 2,-5, 5,-6, 3,-10 ,-8,-8, -9,0, -9,10, -5,16 ,3,15 ,0,6, -1,0, 2,-2 ,2,-4, 0,-6, -4,-4, -6,5));
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 0 );
			assertTrue( node_.minOrder == 0 );
			assertTrue( node_.maxOrder == 47 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 2 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 3 );
		}//}}}
		{//{{{
			ColVectors vecs_ = newVecs( "M", "#f00", toPolygon( 22,12, 20,15, 25,15 ) );
			Node node_ = space_.register( vecs_ );
			w_.put( space_, n_++ );
			assertTrue( space_.getShareLevel( node_ ) == 2 );
			assertTrue( node_.minOrder == 60 );
			assertTrue( node_.maxOrder == 61 );
			assertTrue( space_.getOrderBits( node_.minOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 0 ) == 0 );
			assertTrue( space_.getOrderBits( node_.minOrder, 1 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 1 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 2 ) == 3 );
			assertTrue( space_.getOrderBits( node_.minOrder, 3 ) == 0 );
			assertTrue( space_.getOrderBits( node_.maxOrder, 3 ) == 1 );
		}//}}}

		w_.phase = "VISIT PHASE";
		++w_.groupNumber;
		n_ = 1;
		{//{{{
			ColCircle vshape_ = newCircle( 15, 15, 3, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "B", "C", "D", "E", "F" ) );
		}//}}}
		{//{{{
			ColCircle vshape_ = newCircle( 27, 18, 1, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "B", "C", "D", "E", "F", "M" ) );
		}//}}}
		{//{{{
			ColCircle vshape_ = newCircle( 8, -2, 1, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "B", "C", "D", "E", "F" ) );
		}//}}}
		{//{{{
			ColCircle vshape_ = newCircle( 0, 0, 1, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "A", "B", "C", "D", "E", "F" ) );
		}//}}}
		{//{{{
			ColCircle vshape_ = newCircle( 0, -4, 1, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "A", "B", "C", "D", "E", "F" ) );
		}//}}}
		{//{{{
			ColCircle vshape_ = newCircle( 10, 5, 1, "a", visitorColor_ );
			w_.put( space_, vshape_, n_++ );
			assertTrue( checkIds( w_.visitResult, "A", "B", "C", "D", "E", "F", "M" ) );
		}//}}}
	}//}}}
}//}}}

