// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import mn.jp.kekkouyakan.test.SvgWriter;
import mn.jp.kekkouyakan.test.XmlWriter;
import mn.jp.kekkouyakan.test.HtmlWriter;
import mn.jp.kekkouyakan.util.KyArrayUtil;
import mn.jp.kekkouyakan.functional.IKyAction1;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;
import java.io.File;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class CollisionTest
{//{{{
	public final static String TEST_ID="collision20180830_4c5EHbBBTTyLN355vBzBag";
	public static File resultDir = null;
	static ArrayList<String> fileNameList = new ArrayList<String>();
	KyFloatComparator floatComparator = new KyFloatComparator();

	public CollisionTest()
	{//{{{
	}//}}}
	public static class ShapeInfo
	{//{{{
		String id;
		String color;
	}//}}}


	@BeforeClass
	public static void setUpClass()
	{//{{{
		String resultPath_ = System.getenv( "TEST_RESULT" );
		if( resultPath_ == null ){
			throw new AssertionError();
		}
		File base_ = new File( resultPath_ );
		if( base_.exists() ){
			if( !base_.isDirectory() ){
				throw new AssertionError();
			}
		}
		else{
			base_.mkdir();
		}
		resultDir = new File( base_, TEST_ID );
		if( resultDir.exists() ){
			//throw new AssertionError();
		}
		else{
			resultDir.mkdir();
		}
	}//}}}
	@AfterClass
	public static void tearDownClass() throws Exception
	{//{{{
		File f_ = new File( resultDir, "index.html" );
		HtmlWriter w_ = new HtmlWriter( f_ );
		w_.beginHtmlTag();
		w_.printHeadTag();
		w_.beginBodyTag();

		synchronized( fileNameList ){
			for( String fileName_ : fileNameList ){
				w_.beginDivTag();
				w_.printATagHref( fileName_, fileName_, null );
				w_.endDivTag();
			}
		}

		w_.endBodyTag();
		w_.endHtmlTag();
	}//}}}
	@Before
	public void setUp()
	{//{{{
	}//}}}
	@After
	public void tearDown()
	{//{{{
	}//}}}
	static void addFileName( String file_ )
	{//{{{
		synchronized( fileNameList ){
			fileNameList.add( file_ );
		}
	}//}}}
	boolean checkInvalidCollision( KyVector2f[] pLs_, KyVector2f[] qLs_ )
	{//{{{
		return checkInvalidCollision( new ColVectors( pLs_, floatComparator ), new ColVectors( qLs_, floatComparator ) );
	}//}}}
	boolean checkInvalidCollision( ColShape shape1_, ColShape shape2_ )
	{//{{{
		if( shape1_ instanceof ColCircle ){
			if( shape2_ instanceof ColCircle ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape1_, (ColCircle)shape2_
				);
			}
			else if( shape2_ instanceof ColVectors ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape1_, (ColVectors)shape2_
				);
			}
		}
		else if( shape1_ instanceof ColVectors ){
			if( shape2_ instanceof ColCircle ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape2_, (ColVectors)shape1_
				);
			}
			else if( shape2_ instanceof ColVectors ){
				return !ColResult.isShared( floatComparator,
					(ColVectors)shape1_, (ColVectors)shape2_
				);
			}
		}
		throw new Error();
	}//}}}
	<Key_> boolean checkInvalidCollision( Map<Key_, ColBody> bdMap_ )
	{//{{{
		for( Key_ key1_ : bdMap_.keySet() ){
			ColBody bd1_ = bdMap_.get( key1_ );
			for( Key_ key2_ : bdMap_.keySet() ){
				ColBody bd2_ = bdMap_.get( key2_ );
				if( bd1_ == bd2_ ){
					continue;
				}
				if( !checkInvalidCollision( bd1_.shape, bd2_.shape ) ){
					return false;
				}
			}
		}
		return true;
	}//}}}

	static final String POLYGON_MARKER0="polygon-marker0";

	static void drawPath( SvgWriter svg_, boolean close_, float... cdLs_ )
	{//{{{
		int sz_ = cdLs_.length / 2;
		float[] xLs_ = new float[ sz_ ];
		float[] yLs_ = new float[ sz_ ];
		for( int i_ = 0; i_ < sz_; ++i_ ){
			xLs_[i_] = cdLs_[ 2*i_ ];
			yLs_[i_] = cdLs_[ 2*i_ + 1 ];
		}
		svg_.drawPath( xLs_, yLs_, close_ );
	}//}}}
	static void drawPath( SvgWriter svg_, KyVector2f... vecLs_ )
	{//{{{
		drawPath( svg_, ColResult.isClosedPoints( vecLs_ ), vecLs_ );
	}//}}}
	static void drawPath( SvgWriter svg_, boolean close_, KyVector2f... vecLs_ )
	{//{{{
		float[] xLs_ = new float[ vecLs_.length ];
		float[] yLs_ = new float[ vecLs_.length ];
		for( int i_ = 0; i_ < vecLs_.length; ++i_ ){
			xLs_[i_] = vecLs_[i_].x;
			yLs_[i_] = vecLs_[i_].y;
		}
		svg_.drawPath( xLs_, yLs_, close_ );
	}//}}}
	static <Key_> void drawPoints( SvgWriter svg_, float sz_, HashMap<Key_, KyVector2f> vecMap_, HashMap<Key_, String> colorMap_ )
	{//{{{
		String defColor_ = svg_.getFill();
		for( Key_ k_ : vecMap_.keySet() ){
			svg_.setFill( defColor_ );
			if( colorMap_ != null ){
				String color_ = colorMap_.get( k_ );
				if( color_ != null ){
					svg_.setFill( color_ );
				}
			}
			KyVector2f vec_ = vecMap_.get( k_ );
			svg_.drawPoint( vec_.x, vec_.y, sz_ );
		}
	}//}}}
	static void drawPath( SvgWriter svg_, float sz0_, float sz1_, KyVector2f... vecLs_ )
	{//{{{
		drawPath( svg_, ColResult.isClosedPoints(vecLs_), vecLs_ );
		for( int i_ = 0; i_ < vecLs_.length; i_ += 4 ){
			svg_.drawPoint( vecLs_[i_].x, vecLs_[i_].y, sz0_ );
		}
		for( int i_ = 0; i_ < vecLs_.length; i_ += 1 ){
			if( i_ == 1 ){
				svg_.drawPoint( vecLs_[i_].x, vecLs_[i_].y, sz0_ );
			}
			else{
				svg_.drawPoint( vecLs_[i_].x, vecLs_[i_].y, sz1_ );
			}
		}
	}//}}}
	static <Key_> void drawPolygons( SvgWriter svg_, float sz0_, float sz1_, HashMap<Key_, KyVector2f[]> vecLsMap_, HashMap<Key_, String> colorMap_ )
	{//{{{
		String defColor_ = svg_.getStroke();
		for( Key_ k_ : vecLsMap_.keySet() ){
			svg_.setStroke( defColor_ );
			if( colorMap_ != null ){
				String color_ = colorMap_.get( k_ );
				if( color_ != null ){
					svg_.setStroke( color_ );
				}
			}
			KyVector2f[] vecLs_ = vecLsMap_.get( k_ );
			drawPath( svg_, sz0_, sz1_, vecLs_ );
		}
	}//}}}
	static void drawPointLabels( SvgWriter svg_, HashMap<String, KyVector2f> vecMap_, HashMap<String,String> colorMap_ )
	{//{{{
		String defColor_ = svg_.getFill();
		for( String k_ : vecMap_.keySet() ){
			svg_.setFill( defColor_ );
			if( colorMap_ != null ){
				String color_ = colorMap_.get( k_ );
				if( color_ != null ){
					svg_.setFill( color_ );
				}
			}
			KyVector2f vec_ = vecMap_.get( k_ );
			svg_.drawText( vec_.x + .5f, vec_.y, k_ );
		}
	}//}}}
	static void drawPolygonLabels( SvgWriter svg_, HashMap<String, KyVector2f[]> vecLsMap_, HashMap<String, String> colorMap_ )
	{//{{{
		String defColor_ = svg_.getFill();
		for( String k_ : vecLsMap_.keySet() ){
			svg_.setFill( defColor_ );
			if( colorMap_ != null ){
				String color_ = colorMap_.get( k_ );
				if( color_ != null ){
					svg_.setFill( color_ );
				}
			}
			KyVector2f[] vecLs_ = vecLsMap_.get( k_ );
			int t_ = 0;
			for( int i_ = 1; i_ < vecLs_.length; ++i_ ){
				if( vecLs_[t_].x < vecLs_[i_].x ){
					t_ = i_;
				}
			}
			svg_.drawText( vecLs_[t_].x + .5f, vecLs_[t_].y, k_ );
		}
	}//}}}
	static void drawMaps( SvgWriter svg_, HashMap<String, KyVector2f> ptMap_, HashMap<String, KyVector2f[]> polyMap_, HashMap<String, String> colorMap_, HashMap<String,String> textMap_ )
	{//{{{
		svg_.setStrokeWidth( null );
		svg_.setStroke( "None" );
		svg_.setFill( "#00f" );
		drawPoints( svg_, 4, ptMap_, colorMap_ );

		svg_.setStrokeWidth( "1" );
		svg_.setStroke( "#f00" );
		svg_.setFill( "None" );
		drawPolygons( svg_, 4, 2, polyMap_, colorMap_ );

		svg_.setFontSize( "16" );
		svg_.setStrokeWidth( null );
		svg_.setStroke( "None" );
		svg_.setFill( "#080" );
		drawPointLabels( svg_, ptMap_, textMap_ );
		svg_.setFill( "#f0f" );
		drawPolygonLabels( svg_, polyMap_, textMap_ );
	}//}}}
	static KyVector2f[] toPolygon( float... vLs_ )
	{//{{{
		int sz_ = vLs_.length / 2;
		KyVector2f[] vecLs_ = new KyVector2f[sz_ + 1];
		for( int i_ = 0; i_ < sz_; ++i_ ){
			vecLs_[i_] = new KyVector2f( vLs_[2*i_], vLs_[2*i_+1] );
		}
		vecLs_[sz_] = vecLs_[0];
		return vecLs_;
	}//}}}
	static KyVector2f[] toLines( float... vLs_ )
	{//{{{
		int sz_ = vLs_.length / 2;
		KyVector2f[] vecLs_ = new KyVector2f[sz_];
		for( int i_ = 0; i_ < sz_; ++i_ ){
			vecLs_[i_] = new KyVector2f( vLs_[2*i_], vLs_[2*i_+1] );
		}
		return vecLs_;
	}//}}}
	static void beginSvgTag( SvgWriter svg_, int unitSz_, int gridSz_, int minX_, int minY_, int w_, int h_ )
	{//{{{
		svg_.setView( unitSz_, unitSz_, -minX_*unitSz_, -minY_*unitSz_);
		svg_.beginSvgTag( unitSz_*w_, unitSz_*h_ );
		svg_.setStroke( "#ddd" );
		svg_.setStrokeWidth( "1" );
		svg_.drawGrid( 1, w_, h_, minX_, minY_ );
		svg_.setFill( "#ddd" );
		svg_.drawGridText( gridSz_, w_/gridSz_+1, h_/gridSz_+1, (minX_/gridSz_ - 1)*gridSz_, (minY_/gridSz_-1)*gridSz_ );
		svg_.setStroke( "#aaa" );
		svg_.drawGrid( gridSz_, w_/gridSz_+1, h_/gridSz_+1, (minX_/gridSz_ - 1)*gridSz_, (minY_/gridSz_-1)*gridSz_ );
		svg_.setStrokeWidth( "2" );
		svg_.setStroke( "#888" );
		drawPath( svg_, false, minX_,0, minX_+w_,0);
		drawPath( svg_, false, 0,minY_, 0,minY_+h_);
	}//}}}
	static void dumpMap( HtmlWriter html_, HashMap<String, KyVector2f> ptMap_, HashMap<String, KyVector2f[]> polyMap_ )
	{//{{{
		{
			ArrayList<String> lbLs_ = new ArrayList(ptMap_.keySet());
			Collections.sort( lbLs_ );
			for( String lb_ : lbLs_ ){
				KyVector2f vec_ = ptMap_.get( lb_ );
				html_.beginDivTag();
				html_.out.printf( "%s(%f,%f)", lb_, vec_.x, vec_.y );
				html_.endDivTag();
			}
		}
		{
			ArrayList<String> lbLs_ = new ArrayList(polyMap_.keySet());
			Collections.sort( lbLs_ );
			for( String lb_ : lbLs_ ){
				KyVector2f[] vecLs_ = polyMap_.get( lb_ );
				html_.beginDivTag();
				html_.out.print( lb_ );
				for( int i_ = 0; i_ < vecLs_.length; ++i_ ){
					KyVector2f vec_ = vecLs_[i_];
					if( i_ % 4 == 0 ){
						html_.beginSpanTag( POLYGON_MARKER0 );
						html_.out.printf( "(%f,%f)", vec_.x, vec_.y );
						html_.endSpanTag();
					}
					else{
						html_.out.printf( "(%f,%f)", vec_.x, vec_.y );
					}
				}
				html_.endDivTag();
			}
		}
	}//}}}
	static IKyAction1<ColResult> bind( final ArrayList<ColResult> ls_ )
	{//{{{
		return new IKyAction1<ColResult>(){
			public void call( ColResult res_ ){
				ls_.add( res_.getClone() );
			}
		};
	}//}}}

	@Test
	public void writer_orOafho4RFiKBTnKHi3fzA() throws Exception
	{//{{{
		final String funcName_ = "writer_orOafho4RFiKBTnKHi3fzA";
		File f_ = new File( resultDir, funcName_ + ".html" );

		HtmlWriter html_ = new HtmlWriter( f_ );
		html_.printXmlDecralation();
		html_.beginHtmlTag();

		html_.beginHeadTag();
		html_.printTag( "title", funcName_ );
		html_.beginCssTag();
		html_.out.println( ".piyo { color: red }" ) ;
		html_.endCssTag();
		html_.endHeadTag();

		html_.beginBodyTag();
		SvgWriter svg_ = new SvgWriter( html_ );
		svg_.setView( 16, 16, 0, 0 );
		svg_.beginSvgTag( 640, 480 );
		svg_.setStroke( "#ccc" );
		svg_.setStrokeWidth( "1" );
		svg_.drawGrid( 1, 40, 30, 0, 0 );
		svg_.setStroke( "#888" );
		svg_.drawGrid( 5, 8, 6, 0, 0 );
		svg_.setStroke( "Red" );
		svg_.setFill( "None" );
		drawPath( svg_, true, 5f, 5f,  5f, 15f, 10f, 10f );
		svg_.drawPoint( 21, 10, 4f );
		svg_.setStroke( "Blue" );
		svg_.setFill( "Blue" );
		svg_.drawText( 1, 1, "Hello." );
		svg_.endSvgTag();
		html_.printDivTag( "hoge", "piyo" );
		html_.printDivTag( "aiueo", "piyo" );
		html_.endBodyTag();
		html_.endHtmlTag();
	}//}}}

	static <Val_> void registerMaps(
		String k_,
		HashMap<String, String> colorMap_, String color_,
		HashMap<String, String> textMap_, String text_,
		HashMap<String, Val_> map_, Val_ value_
	)
	{//{{{
		if( map_.get( k_ ) != null ){
			throw new AssertionError();
		}
		colorMap_.put( k_, color_ );
		textMap_.put( k_, text_ );
		map_.put( k_, value_ );
	}//}}}
	public void checkProgress( ColResult[] ls_, ColResult val_ )
	{//{{{
		ColResult res_ = KyArrayUtil.find( ls_, val_ );
		assertTrue( res_ != null );
		assertTrue( !floatComparator.less( res_.progress, 0.0f) );
		assertTrue( !floatComparator.more( res_.progress, 1.0f) );
	}//}}}
	public void checkProgress( ColResult[] ls_, ColResult val_, float prog_ )
	{//{{{
		ColResult res_ = KyArrayUtil.find( ls_, val_ );
		assertTrue( res_ != null );
		assertTrue( floatComparator.equals( res_.progress, prog_ ) );
	}//}}}

	@Test
	public void pointInPolygon_YpGlDADSSpqkYe3ZAQVRXA() throws Exception
	{//{{{
		final String funcName_ = "pointInPolygon_YpGlDADSSpqkYe3ZAQVRXA";
		String fileName_ = funcName_ + ".html";
		File f_ = new File( resultDir, fileName_ );
		addFileName( fileName_ );

		HashMap<String,KyVector2f> ptMap_ = new HashMap<String, KyVector2f>();
		HashMap<String,KyVector2f[]> polyMap_ = new HashMap<String, KyVector2f[]>();
		HashMap<String,String> cMap_ = new HashMap<String, String>();
		HashMap<String,String> tMap_ = new HashMap<String, String>();

		{
			String c_ = "#00f";
			String t_ = "#00f";
			registerMaps( "a", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 3, 3 ) );
			registerMaps( "b", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 2, 2 ) );
			registerMaps( "c", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 7, 4 ) );
			registerMaps( "d", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 8, 3 ) );
			registerMaps( "e", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 5, 8 ) );
			registerMaps( "f", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 13, 3 ) );
			registerMaps( "g", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 15, 3 ) );
			registerMaps( "h", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 16, 3 ) );
			registerMaps( "i", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 8, 10 ) );
			registerMaps( "j", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 7, 12 ) );
			registerMaps( "k", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 8, 12 ) );
			registerMaps( "l", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 6, 12 ) );
			registerMaps( "m", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 22, 3 ) );
			registerMaps( "n", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 22, -2 ) );
			registerMaps( "o", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 22, -4 ) );
			registerMaps( "p", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 12, -4 ) );
			registerMaps( "q", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 12, -6 ) );
			registerMaps( "r", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 12, -8 ) );
			registerMaps( "s", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 9, -7 ) );
			registerMaps( "t", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 6, -5 ) );
			registerMaps( "u", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( 2, -8 ) );
			registerMaps( "v", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( -7, -7 ) );
			registerMaps( "w", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( -5, -2 ) );
			registerMaps( "x", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( -7, 12 ) );
			registerMaps( "y", cMap_, c_, tMap_, t_, ptMap_, new KyVector2f( -3, 12 ) );

			c_ = "#f00";
			t_ = "#f00";
			registerMaps( "A", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 1,1,  1,4,  4,1 ) );
			registerMaps( "B", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 7,2,  4,6,  5,8, 9,6 ) );
			registerMaps( "C", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 15,2,  10,10,  5,10, 10,15, 18,10 ) );
			registerMaps( "D", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 18,5,  22,8,  24,5, 26,0, 25,-5, 19,-2 ) );
			registerMaps( "E", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 17,-2,  8, -2, 8,-10, 17,-10, 17,-8, 11,-8, 11,-5, 17, -5 ) );
			registerMaps( "F", cMap_, c_, tMap_, t_, polyMap_, toPolygon(
				-3,10, -1,10, 0,13, -4,14
				,-5,10, -7,5, -6,0, -5,-5
				,0,-7, 2,-5, 5,-6, 3,-10
				,-8,-8, -9,0, -9,10, -5,16
				,3,15 ,0,6, -1,0, 2,-2
				,2,-4, 0,-6, -4,-4, -6,5
			));
			registerMaps( "M", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 22,12, 20,15, 25,15 ) );

			c_ = t_ = "#080";
			registerMaps( "G", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 17,8, 19,8, 19,11, 17,11 ) );
			registerMaps( "H", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 16,7, 22,7, 22,12, 16,12 ) );
			registerMaps( "I", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 16,-3, 17,1, 20,-1 ) );
			registerMaps( "J", cMap_, c_, tMap_, t_, polyMap_, toPolygon( -4,11, -4,13, -2,11 ) );
			registerMaps( "K", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 12,-3, 10,-1, 10,3, 7,4, 8,5, 11,4, 13,7, 14,6, 11,1, 12,-1 ) );
			registerMaps( "L", cMap_, c_, tMap_, t_, polyMap_, toPolygon( 17,-10, 17,-7, 20,-8 ) );

			c_ = "#f0f";
			t_ = "#f0f";
			registerMaps( "@A", cMap_, c_, tMap_, t_, polyMap_, toLines( 25,1,  25,11,  20,9 ) );
			registerMaps( "@B", cMap_, c_, tMap_, t_, polyMap_, toLines( 9,-8, 5,-5, 3,-2, 0,0, 1,5, 5,2, 5,0, 1,0 ) );

			c_ = "#0cc";
			t_ = "#0cc";
			registerMaps( "@C", cMap_, c_, tMap_, t_, polyMap_, toLines( 26,9, 21,11 ) );
		}

		{//{{{
			HtmlWriter html_ = new HtmlWriter( f_ );
			html_.printXmlDecralation();
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.printTag( "title", funcName_ );
			html_.beginCssTag();
			html_.out.printf( ".%s { font-weight: bold; }%n", POLYGON_MARKER0 ) ;
			html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			SvgWriter svg_ = new SvgWriter( html_ );

			beginSvgTag( svg_, 16, 5, -11, -12, 40, 30 );

			drawMaps( svg_, ptMap_, polyMap_, cMap_, tMap_ );

			svg_.endSvgTag();
			
			dumpMap( html_, ptMap_, polyMap_ );
			html_.endBodyTag();
			html_.endHtmlTag();
		}//}}}

		{//{{{
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("a"), polyMap_.get( "A" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("b"), polyMap_.get( "A" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("a"), polyMap_.get( "B" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("b"), polyMap_.get( "B" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("c"), polyMap_.get( "B" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("d"), polyMap_.get( "B" ) ) );
			//assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("e"), polyMap_.get( "B" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("f"), polyMap_.get( "C" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("g"), polyMap_.get( "C" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("h"), polyMap_.get( "C" ) ) );
			//assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("i"), polyMap_.get( "C" ) ) );
			//assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("j"), polyMap_.get( "C" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("k"), polyMap_.get( "C" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("l"), polyMap_.get( "C" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("h"), polyMap_.get( "D" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("m"), polyMap_.get( "D" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("n"), polyMap_.get( "D" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("o"), polyMap_.get( "D" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("p"), polyMap_.get( "E" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("q"), polyMap_.get( "E" ) ) );
			//assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("r"), polyMap_.get( "E" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("s"), polyMap_.get( "E" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("t"), polyMap_.get( "E" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("t"), polyMap_.get( "F" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("u"), polyMap_.get( "F" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("v"), polyMap_.get( "F" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("w"), polyMap_.get( "F" ) ) );
			assertTrue(  ColResult.isPointInPoints( floatComparator, ptMap_.get("x"), polyMap_.get( "F" ) ) );
			assertTrue( !ColResult.isPointInPoints( floatComparator, ptMap_.get("y"), polyMap_.get( "F" ) ) );

			assertTrue(  checkInvalidCollision( polyMap_.get( "A" ), polyMap_.get( "B" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "A" ), polyMap_.get( "C" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "A" ), polyMap_.get( "D" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "A" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "A" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "B" ), polyMap_.get( "A" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "B" ), polyMap_.get( "C" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "B" ), polyMap_.get( "D" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "B" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "B" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "A" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "B" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "D" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "A" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "B" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "C" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "E" ), polyMap_.get( "A" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "E" ), polyMap_.get( "B" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "E" ), polyMap_.get( "C" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "E" ), polyMap_.get( "D" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "E" ), polyMap_.get( "F" ) ) );

			assertTrue( !checkInvalidCollision( polyMap_.get( "G" ), polyMap_.get( "C" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "G" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "H" ), polyMap_.get( "C" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "C" ), polyMap_.get( "H" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "H" ), polyMap_.get( "G" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "G" ), polyMap_.get( "H" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "H" ), polyMap_.get( "D" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "D" ), polyMap_.get( "H" ) ) );

			assertTrue( !checkInvalidCollision( polyMap_.get( "I" ), polyMap_.get( "D" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "I" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "J" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "F" ), polyMap_.get( "J" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "A" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "B" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "C" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "D" ) ) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "K" ), polyMap_.get( "F" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "L" ), polyMap_.get( "E" ) ) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "M" ), polyMap_.get( "H" ) ) );

			assertTrue( !checkInvalidCollision( polyMap_.get( "@A" ), polyMap_.get( "D" )) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "@A" ), polyMap_.get( "G" )) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "@A" ), polyMap_.get( "H" )) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "@B" ), polyMap_.get( "A" )) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "@B" ), polyMap_.get( "E" )) );
			assertTrue( !checkInvalidCollision( polyMap_.get( "@C" ), polyMap_.get( "@A" )) );
			assertTrue(  checkInvalidCollision( polyMap_.get( "@C" ), polyMap_.get( "@B" )) );

		}//}}}

	}//}}}

	static class Writer_E68OTeHzS_SFOhTKWnBeyA
	{//{{{
		final String COL_RESULTS="col-results";
		KyFloatComparator floatComparator;
		String funcName;
		int pageMin = -1;
		int pageMax = -1;
		ColShape lastBallShape;
		ColResult[] resultList;

		int unitSize = 10;
		int gridSize = 5;
		int offsetX = -40;
		int offsetY = -30;
		int width = 80;
		int height = 60;

		Writer_E68OTeHzS_SFOhTKWnBeyA( String funcName_, KyFloatComparator floatComparator_ )
		{//{{{
			funcName = funcName_;
			floatComparator = floatComparator_;
		}//}}}
		public String getFileName( int page_ )
		{//{{{
			return funcName + String.format( "-%03d", page_ ) + ".html";
		}//}}}
		void draw( SvgWriter svg_, ColShape shape0_, String color_ )
		{//{{{
			if( shape0_ instanceof ColCircle ){
				ColCircle shape_ = (ColCircle)shape0_;
				svg_.setStroke( color_ );
				svg_.setFill( "None" );
				svg_.drawCircle( shape_.transform.position.x, shape_.transform.position.y, shape_.getRadius() );
				svg_.setFill( color_ );
				svg_.drawPoint( shape_.transform.position.x, shape_.transform.position.y, 3 );
			}
			else if( shape0_ instanceof ColVectors ){
				ColVectors shape_ = (ColVectors)shape0_;
				svg_.setStroke( color_ );
				svg_.setFill( "None" );
				drawPath( svg_, 6, 3, shape_.currentPoints );
			}
			else{
				throw new Error();
			}
		}//}}}
		public void put( int page_, ColShape ballShape_, ColShape wallShape_ ) throws Exception
		{//{{{
			if( ballShape_.delta == null ){
				lastBallShape = ballShape_;
				resultList = null;
			}
			else{
				ArrayList<ColResult> ls_ = new ArrayList<ColResult>();
				lastBallShape = ColResult.collideWithShape( floatComparator, bind( ls_ ), ballShape_,  wallShape_ );
				if( lastBallShape == null ){
					lastBallShape = ballShape_;
				}
				if( ls_.isEmpty() ){
					resultList = null;
				}
				else{
					resultList = ls_.toArray( new ColResult[0] );
				}
			}

			String fileName_ = getFileName( page_ );
			addFileName( fileName_ );
			File f_ = new File( resultDir, fileName_ );
			HtmlWriter html_ = new HtmlWriter( f_ );
			html_.printXmlDecralation();
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.printTag( "title", fileName_ );
			html_.beginCssTag();
			html_.out.printf( "div.%s { border-style: solid; }%n", COL_RESULTS ) ;
			html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			SvgWriter svg_ = new SvgWriter( html_ );

			//beginSvgTag( svg_, 10, 5, -40, -30, 80, 60 );
			beginSvgTag( svg_, unitSize, gridSize, offsetX, offsetY, width, height );

			svg_.setFill( "None" );
			if( lastBallShape != ballShape_ ){
				draw( svg_, ballShape_, "#fcc" );
			}
			draw( svg_, wallShape_, "#00f" );
			draw( svg_, lastBallShape, "#f00" );

			svg_.endSvgTag();

			html_.beginDivTag();
			html_.printATagHref( "&lt;&lt;", getFileName( page_ - 1 ), null );

			html_.out.println( page_ );
			html_.printATagHref( "&gt;&gt;", getFileName( page_ + 1 ), null );
			html_.endDivTag();

			if( pageMin > 0 && pageMax > 0 ){
				html_.beginDivTag();
				html_.printATagHref(
					"index",
					"index.html",
					null
				);
				html_.out.println( ":" );
				for( int p_ = pageMin; p_ <= pageMax; ++p_ ){
					if( p_ == page_ ){
						html_.out.println( p_ );
					}
					else{
						html_.printATagHref(
							String.valueOf( p_ ),
							getFileName( p_ ),
							null
						);
					}
					html_.out.println( "," );
				}
				html_.endDivTag();
			}

			if( resultList != null ){
				for( int i_ = 0; i_ < resultList.length; ++i_ ){
					ColResult resIt_ = resultList[i_];
					html_.beginDivTag( COL_RESULTS );
					html_.beginDivTag();
					html_.out.printf( "Collision#%d Ball:%d,%d Wall:%d,%d",
						i_+1,
						resIt_.ballIndex1, resIt_.ballIndex2,
						resIt_.wallIndex1, resIt_.wallIndex2
					);
					html_.endDivTag();
					html_.beginDivTag();
					html_.out.printf( "Progress:%f", resIt_.progress );
					html_.endDivTag();
					if( resIt_.ballShape1 instanceof ColVectors ){
						html_.beginDivTag();
						html_.out.print( "Ball:" );
						for( KyVector2f pt_ : ColVectors.getBallPoints1(resIt_) ){
							html_.out.print( pt_ );
						}
						html_.endDivTag();
						html_.beginDivTag();
						html_.out.print( "Ball':" );
						for( KyVector2f pt_ : ColVectors.getBallPoints2(resIt_) ){
							html_.out.print( pt_ );
						}
						html_.endDivTag();
					}
					if( resIt_.wallShape instanceof ColVectors ){
						html_.out.print( "Wall:" );
						for( KyVector2f pt_ : ColVectors.getWallPoints(resIt_) ){
							html_.out.print( pt_ );
						}
						html_.endDivTag();
					}
					html_.endDivTag();
				}
			}
			else{
				html_.beginDivTag();
				html_.out.println( "No Collision" );
				html_.endDivTag();
			}
			html_.endBodyTag();
			html_.endHtmlTag();
		}//}}}
	}//}}}

	//Vectors ball vs Vectors wall
	@Test
	public void collideWith_iglL0gX1R5ePNW2PTjJ1IQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_iglL0gX1R5ePNW2PTjJ1IQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_, floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toPolygon( 10,10, 20,10, 20,20, 10,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -1f;
			ballShape_.delta.position.y = -1f;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape != null );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), 9 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), 19 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), 9 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), 19 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -15f;
			ballShape_.delta.position.y = -15f;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -6 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), 4 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -6 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), 4 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -5f;
			ballShape_.delta.position.y = -5f;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( !checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 2 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 0, 1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -11 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -1 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -11 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -1 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
	}//}}}
	@Test
	public void collideWith_WYe9pwzdRlOXMWf5NVLAoA() throws Exception
	{//{{{
		final String funcName_ = "collideWith_WYe9pwzdRlOXMWf5NVLAoA";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toPolygon( 10,10, 20,10, 20,20, 10,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = 0;
			ballShape_.delta.position.y = -25;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -20;
			ballShape_.delta.position.y = 0;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), 0 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -25;
			ballShape_.delta.position.y = 0;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 14 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, -1, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, -1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, 2, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, 2, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, 2, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, 2, 1, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 1, -1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -35 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -25 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
			ballShape_ = w_.lastBallShape;
		}//}}}
	}//}}}
	@Test
	public void collideWith_Uil6J4_bSdq6_WUkVxmlYQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_Uil6J4_bSdq6_WUkVxmlYQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toPolygon( 20,10, 10,20, 20,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -20;
			ballShape_.delta.position.y = -20;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), 0 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), 0 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -5;
			ballShape_.delta.position.y = -5;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = 1;
			ballShape_.delta.position.y = -1;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -14 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -4 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -16 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -6 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = 1;
			ballShape_.delta.position.y = 1;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -13 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -3 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -2;
			ballShape_.delta.position.y = -2;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( !checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 3 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 0, -1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -17 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -7 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
	}//}}}
	@Test
	public void collideWith_PNFu8hPHQau_cksmtsmJsA() throws Exception
	{//{{{
		final String funcName_ = "collideWith_PNFu8hPHQau_cksmtsmJsA";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toPolygon( 10,10, 20,10, 20,20, 10,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-20, -20,-10, -20,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -25;
			ballShape_.delta.position.y = -25;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = 2;
			ballShape_.delta.position.y = 0;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -13 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -3 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -2;
			ballShape_.delta.position.y = 0;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -1;
			ballShape_.delta.position.y = 0;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( !checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 3 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 3, 4, 0, 1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -16 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -6 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}

	}//}}}
	@Test
	public void collideWith_5bop6HLGRC6my_qVvj4evg() throws Exception
	{//{{{
		final String funcName_ = "collideWith_5bop6HLGRC6my_qVvj4evg";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toLines( 10,10, 15,15 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -20;
			ballShape_.delta.position.y = -20;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -3;
			ballShape_.delta.position.y = -3;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( !checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 3 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 3, 4 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -13 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -8 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -13 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -8 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
	}//}}}
	@Test
	public void collideWith_u5BsbCjNRQCI2W5_9LwwjQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_u5BsbCjNRQCI2W5_9LwwjQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toLines( 10,10, 15,15 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -20;
			ballShape_.delta.position.y = -20;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -10 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -16;
			ballShape_.delta.position.y = -16;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 4 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 2, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, -1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 1, -1, 2, -1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -26 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -21 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -26 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -21 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}

	}//}}}
	@Test
	public void collideWith_jlVWyv54Tw2q5n1mLJ24oQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_jlVWyv54Tw2q5n1mLJ24oQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] ballPtLs_ = toLines( 10,10, 20,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -10,-20, -20,-10, -20,-20 );
		ColShape ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.position.x = -25;
			ballShape_.delta.position.y = -25;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			ballShape_ = w_.lastBallShape;

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -15 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -5 ) );
		}//}}}
		{//{{{
			ballShape_.delta.position.x = -1;
			ballShape_.delta.position.y = -1;
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( !checkInvalidCollision( w_.lastBallShape, wallShape_ ) );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 2 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, 1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, 1 ) );

			assertTrue( floatComparator.equals( w_.lastBallShape.getMinX(), -16 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxX(), -6 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMinY(), -16 ) );
			assertTrue( floatComparator.equals( w_.lastBallShape.getMaxY(), -6 ) );
			ballShape_ = w_.lastBallShape;
		}//}}}
	}//}}}
	@Test
	public void collideWith_JY4Tft8nRP_GS8DBbAfK8A() throws Exception
	{//{{{
		final String funcName_ = "collideWith_JY4Tft8nRP_GS8DBbAfK8A";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		//w_.offsetX += 10;
		w_.offsetY -= 5;

		KyVector2f[] ballPtLs_ = toPolygon( 10,10, 20,10, 20,20, 10,20 );
		KyVector2f[] wallPtLs_ = toPolygon( -20,-20, -30,-20, -30,-30, -20,-30 );
		ColShape ballShape_ = new ColVectors( KyVector2f.relative( .5f, .5f, ballPtLs_ ), ballPtLs_, floatComparator );
		ColShape wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 15, 15 ) );
			assertTrue( ballShape_ instanceof ColVectors );
			assertTrue( ((ColVectors)ballShape_).initialPoints != null );
			assertTrue( ((ColVectors)ballShape_).initialPoints.length == 5 );
			assertTrue( ((ColVectors)ballShape_).initialPoints[0].equals( floatComparator, -5, -5 ) );
			assertTrue( ((ColVectors)ballShape_).initialPoints[1].equals( floatComparator, 5, -5 ) );
			assertTrue( ((ColVectors)ballShape_).initialPoints[2].equals( floatComparator, 5, 5 ) );
			assertTrue( ((ColVectors)ballShape_).initialPoints[3].equals( floatComparator, -5, 5 ) );
			assertTrue( ((ColVectors)ballShape_).initialPoints[4] == ((ColVectors)ballShape_).initialPoints[0] );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -30 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -30 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -20 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( -10, -10 );
			w_.put( page_++, ballShape_, wallShape_ );
			ColShape newShape_ = ballShape_ = w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 5, 5 ) );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			assertTrue( newShape_ instanceof ColVectors );
			assertTrue( ((ColVectors)newShape_).currentPoints != null );
			KyVector2f[] ptLs_ = ((ColVectors)newShape_).currentPoints;
			assertTrue( ptLs_.length == 5 );
			assertTrue( ptLs_[0] == ptLs_[4] );
			assertTrue( ptLs_[0].equals( floatComparator, 0, 0 ) );
			assertTrue( ptLs_[1].equals( floatComparator, 10, 0 ) );
			assertTrue( ptLs_[2].equals( floatComparator, 10, 10 ) );
			assertTrue( ptLs_[3].equals( floatComparator, 0, 10 ) );
		}//}}}
		{//{{{
			ballShape_.delta.setScale( 1 );
			w_.put( page_++, ballShape_, wallShape_ );
			ColShape newShape_ = ballShape_ = w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.scale != null );
			assertTrue( newShape_.delta.scale.equals( floatComparator, 0, 0 ) );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			assertTrue( newShape_ instanceof ColVectors );
			assertTrue( ((ColVectors)newShape_).currentPoints != null );
			KyVector2f[] ptLs_ = ((ColVectors)newShape_).currentPoints;
			assertTrue( ptLs_.length == 5 );
			assertTrue( ptLs_[0] == ptLs_[4] );
			assertTrue( ptLs_[0].equals( floatComparator, -5, -5 ) );
			assertTrue( ptLs_[1].equals( floatComparator, 15, -5 ) );
			assertTrue( ptLs_[2].equals( floatComparator, 15, 15 ) );
			assertTrue( ptLs_[3].equals( floatComparator, -5, 15 ) );
		}//}}}
		{//{{{
			ballShape_.delta.angle360 += 90;
			w_.put( page_++, ballShape_, wallShape_ );
			ColShape newShape_ = ballShape_ = w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.scale != null );
			assertTrue( newShape_.delta.scale.equals( floatComparator, 0, 0 ) );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			assertTrue( newShape_ instanceof ColVectors );
			assertTrue( ((ColVectors)newShape_).currentPoints != null );
			KyVector2f[] ptLs_ = ((ColVectors)newShape_).currentPoints;
			assertTrue( ptLs_.length == 5 );
			assertTrue( ptLs_[0] == ptLs_[4] );
			assertTrue( ptLs_[0].equals( floatComparator, 15, -5 ) );
			assertTrue( ptLs_[1].equals( floatComparator, 15, 15 ) );
			assertTrue( ptLs_[2].equals( floatComparator, -5, 15 ) );
			assertTrue( ptLs_[3].equals( floatComparator, -5, -5 ) );
		}//}}}
		{//{{{
			ballShape_.delta.angle360 += 45;
			w_.put( page_++, ballShape_, wallShape_ );
			ColShape newShape_ = ballShape_ = w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.scale != null );
			assertTrue( newShape_.delta.scale.equals( floatComparator, 0, 0 ) );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			final float c_ = 1.41421356f;
			assertTrue( newShape_ instanceof ColVectors );
			assertTrue( ((ColVectors)newShape_).currentPoints != null );
			KyVector2f[] ptLs_ = ((ColVectors)newShape_).currentPoints;
			assertTrue( ptLs_.length == 5 );
			assertTrue( ptLs_[0] == ptLs_[4] );
			assertTrue( ptLs_[0].equals( floatComparator, 5f+10f*c_, 5f ) );
			assertTrue( ptLs_[1].equals( floatComparator, 5f, 5f+10*c_ ) );
			assertTrue( ptLs_[2].equals( floatComparator, 5f-10*c_, 5f ) );
			assertTrue( ptLs_[3].equals( floatComparator, 5f, 5f-10*c_ ) );
		}//}}}
	}//}}}

	//Circle ball vs Circle wall
	@Test
	public void collideWith_D9VcU_d3T4GNVpFH7u8Kfw() throws Exception
	{//{{{
		final String funcName_ = "collideWith_D9VcU_d3T4GNVpFH7u8Kfw";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		ColCircle ballShape_ = new ColCircle( -10, 0, 5, floatComparator );
		ColCircle wallShape_ = new ColCircle( 10, 0, 5 , floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, -10, 0 ) );
			assertTrue( wallShape_.transform != null );
			assertTrue( wallShape_.transform.position != null );
			assertTrue( wallShape_.transform.position.equals( floatComparator, 10, 0 ) );
			assertTrue( ballShape_ instanceof ColCircle );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 5 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 5, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -5, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 5, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 5, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 5, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 1 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, -1 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_q38Ib8wtQUy3onBaGdYmKg() throws Exception
	{//{{{
		final String funcName_ = "collideWith_q38Ib8wtQUy3onBaGdYmKg";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		ColCircle ballShape_ = new ColCircle( -10, 0, 5 , floatComparator );
		ColCircle wallShape_ = new ColCircle( 10, 0, 5 , floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, -10, 0 ) );
			assertTrue( wallShape_.transform != null );
			assertTrue( wallShape_.transform.position != null );
			assertTrue( wallShape_.transform.position.equals( floatComparator, 10, 0 ) );
			assertTrue( ballShape_ instanceof ColCircle );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 5 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 0, 10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -10, 10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 30, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 20, 10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, -20 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 20, -10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -20, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 0, -10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 5, 5 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 5, -5 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 1 );
			checkProgress( w_.resultList, new ColResult( ballShape_, w_.lastBallShape, wallShape_, 0, -1, 0, -1 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}

	//Circle ball vs Vectors wall
	@Test
	public void collideWith_XfoTxpIdSjSfPxhF1u27Pw() throws Exception
	{//{{{
		final String funcName_ = "collideWith_XfoTxpIdSjSfPxhF1u27Pw";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle ballShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( -15, -15 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -5, -5 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, -10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -5, -15 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 5, -10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 0, -25 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -25, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -25, -25 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, 20 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -25, -5 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 10, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -15, -5 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, -1 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -15, -6 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 1 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0, 1 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_TM3AvXWTRJm9t2A8RHwzBA() throws Exception
	{//{{{
		final String funcName_ = "collideWith_TM3AvXWTRJm9t2A8RHwzBA";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		w_.offsetY -= 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle ballShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( -25, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -15, 10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, -40 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -15, -30 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 2 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 2, 3 ) );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_Pn6ZNzgvSJGMr3SFZLelig() throws Exception
	{//{{{
		final String funcName_ = "collideWith_Pn6ZNzgvSJGMr3SFZLelig";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		w_.offsetY -= 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle ballShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( -10, -10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -8, -8 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -8, -8 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 3 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0,-1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 3, 4 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_72XUJVqMQv_QyqKZsk94MQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_72XUJVqMQv_QyqKZsk94MQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		w_.offsetY -= 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle ballShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors wallShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), -10 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( -10, -10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -25, -25 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColCircle );
			ColCircle newShape_ =  (ColCircle)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, -25, -25 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 6 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0,-1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 2,-1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 0, 1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 3, 4 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 1, 2 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, -1, 2, 3 ) );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}

	//Vectors ball vs Circle wall
	@Test
	public void collideWith_XGO7moo3QWSWNEn4C7QAkA() throws Exception
	{//{{{
		final String funcName_ = "collideWith_XGO7moo3QWSWNEn4C7QAkA";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle wallShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors ballShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 15 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 15, 15 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 15, 15 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, 10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 15, 25 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -5, 10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 10, 35 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 25, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 35, 35 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, -20 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 35, 15 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( -10, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 25, 15 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, 1 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 25, 16 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 1 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, 1, 0, -1 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_nJ9OvnboT1qtankyRUINpA() throws Exception
	{//{{{
		final String funcName_ = "collideWith_nJ9OvnboT1qtankyRUINpA";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		w_.offsetY += 5;

		KyVector2f[] ballPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColVectors ballShape_ = new ColVectors( ballPtLs_, floatComparator );
		ColCircle wallShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 15 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 25, 0 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 25, 0 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 0, 40 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 25, 40 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 2 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, 1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 2, 3, 0, -1 ) );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_nqab80_fTNOJ_gvw7QySmQ() throws Exception
	{//{{{
		final String funcName_ = "collideWith_nqab80_fTNOJ_gvw7QySmQ";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		w_.offsetY += 5;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle wallShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors ballShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 15 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 10, 10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 8, 8 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 18, 18 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 1 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0,-1, 0, -1 ) );
			assertTrue( !checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}
	@Test
	public void collideWith_q7Pbv_LSR2O9b2eovm0Khg() throws Exception
	{//{{{
		final String funcName_ = "collideWith_q7Pbv_LSR2O9b2eovm0Khg";
		Writer_E68OTeHzS_SFOhTKWnBeyA w_ = new Writer_E68OTeHzS_SFOhTKWnBeyA( funcName_ , floatComparator );
		w_.pageMin = 1;
		w_.pageMax = 10;
		//w_.offsetY -= 10;

		KyVector2f[] wallPtLs_ = toPolygon( -10,-10, -20,-10, -20,-20, -10,-20 );

		ColCircle wallShape_ = new ColCircle( 10, 10, 5 , floatComparator );
		ColVectors ballShape_ = new ColVectors( wallPtLs_, floatComparator );
		w_.put( 1, ballShape_, wallShape_ );
		ballShape_.delta = new ColTransform();
		{//{{{
			assertTrue( ballShape_.transform != null );
			assertTrue( ballShape_.transform.position != null );
			assertTrue( ballShape_.transform.position.equals( floatComparator, 0, 0 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinX(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxX(), -10 ) );
			assertTrue( floatComparator.equals( ballShape_.getMinY(), -20 ) );
			assertTrue( floatComparator.equals( ballShape_.getMaxY(), -10 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinX(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxX(), 15 ) );
			assertTrue( floatComparator.equals( wallShape_.getMinY(), 5 ) );
			assertTrue( floatComparator.equals( wallShape_.getMaxY(), 15 ) );
		}//}}}

		int page_ = 2;
		{//{{{
			ballShape_.delta.setPosition( 10, 10 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 10, 10 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList == null );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
		{//{{{
			ballShape_.delta.setPosition( 25, 25 );
			w_.put( page_++, ballShape_, wallShape_ );
			assertTrue( w_.lastBallShape instanceof ColVectors );
			ColVectors newShape_ =  (ColVectors)w_.lastBallShape;

			assertTrue( newShape_ != null );
			assertTrue( newShape_.delta != null );
			assertTrue( newShape_.delta.position != null );
			assertTrue( newShape_.delta.position.equals( floatComparator, 0, 0 ) );
			assertTrue( newShape_.transform.position.equals( floatComparator, 35, 35 ) );
			assertTrue( !newShape_.keepDelta );
			assertTrue( w_.resultList != null );
			assertTrue( w_.resultList.length == 6 );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0,-1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 2,-1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 0, 1, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 3, 4, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 1, 2, 0, -1 ) );
			checkProgress( w_.resultList, new ColResult( ballShape_, newShape_, wallShape_, 2, 3, 0, -1 ) );
			assertTrue( checkInvalidCollision( newShape_, wallShape_ ) );

			ballShape_ = newShape_;
		}//}}}
	}//}}}


	static class Writer_XZt45RjGTXmGZfCN5ADvEg
	{//{{{
		String funcName;
		int pageMin = -1;
		int pageMax = -1;
		float[] progress = null;
		KyFloatComparator floatComparator;

		Writer_XZt45RjGTXmGZfCN5ADvEg( String funcName_, KyFloatComparator floatComparator_ )
		{//{{{
			funcName = funcName_;
			floatComparator = floatComparator_;
		}//}}}
		public String getFileName( int page_ )
		{//{{{
			return funcName + String.format( "-%03d", page_ ) + ".html";
		}//}}}
		public void put( int page_, KyVector2f a1_, KyVector2f a2_, KyVector2f v1_, KyVector2f v2_, KyVector2f w_ ) throws Exception
		{//{{{
			KyVector2f b1_ = a1_.add( v1_ );
			KyVector2f b2_ = a2_.add( v2_ );
			progress = ColResult.calcBallLineProgress( floatComparator, a1_, a2_, b1_, b2_, w_ );
			KyVector2f[] c1_ = null;
			KyVector2f[] c2_ = null;
			if( progress != null && progress.length > 0 ){
				c1_ = new KyVector2f[ progress.length ];
				c2_ = new KyVector2f[ progress.length ];
				c1_[0] = a1_.add( v1_.mul( progress[0] ) );
				c2_[0] = a2_.add( v2_.mul( progress[0] ) );
				if( progress.length > 1 ){
					c1_[1] = a1_.add( v1_.mul( progress[1] ) );
					c2_[1] = a2_.add( v2_.mul( progress[1] ) );
				}
			}


			String fileName_ = getFileName( page_ );
			addFileName( fileName_ );
			File f_ = new File( resultDir, fileName_ );
			HtmlWriter html_ = new HtmlWriter( f_ );
			html_.printXmlDecralation();
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.printTag( "title", fileName_ );
			//html_.beginCssTag();
			//html_.out.printf( "div.%s { border-style: solid; }%n", COL_RESULTS ) ;
			//html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			SvgWriter svg_ = new SvgWriter( html_ );

			beginSvgTag( svg_, 10, 5, -20, -15, 80, 60 );

			svg_.setFill( "None" );
			svg_.setStroke( "#00f" );
			drawPath( svg_, 6, 3, a1_, a2_ );
			svg_.setStroke( "#f00" );
			drawPath( svg_, 6, 3, b1_, b2_ );
			if( progress != null ){
				svg_.setStroke( "#f0f" );
				drawPath( svg_, 6, 3, c1_[0], c2_[0] );
			}
			svg_.setFill( "#080" );
			svg_.setStroke( "#080" );
			svg_.drawPoint( w_.x, w_.y, 3 );

			svg_.endSvgTag();

			html_.beginDivTag();
			html_.printATagHref( "&lt;&lt;", getFileName( page_ - 1 ), null );
			html_.out.println( page_ );
			html_.printATagHref( "&gt;&gt;", getFileName( page_ + 1 ), null );
			html_.endDivTag();

			if( pageMin > 0 && pageMax > 0 ){
				html_.beginDivTag();
				html_.printATagHref(
					"index",
					"index.html",
					null
				);
				html_.out.println( ":" );
				for( int p_ = pageMin; p_ <= pageMax; ++p_ ){
					if( p_ == page_ ){
						html_.out.println( p_ );
					}
					else{
						html_.printATagHref(
							String.valueOf( p_ ),
							getFileName( p_ ),
							null
						);
					}
					html_.out.println( "," );
				}
				html_.endDivTag();
			}

			if( progress == null ){
				html_.beginDivTag();
				html_.out.print( "progress: None" );
				html_.endDivTag();
			}
			else{
				for( int i_ = 0; i_ < progress.length; ++i_ ){
					float p_ = progress[i_];
					html_.beginDivTag();
					html_.out.printf( "progress: %f", p_ );
					html_.endDivTag();
					html_.beginDivTag();
					html_.out.printf( "line: %s%s", c1_[i_], c2_[i_] );
					html_.endDivTag();
				}
			}

			html_.endBodyTag();
			html_.endHtmlTag();
		}//}}}
	}//}}}
	@Test
	public void calcProgress_XZt45RjGTXmGZfCN5ADvEg() throws Exception
	{//{{{
		final String funcName_ = "calcProgress_XZt45RjGTXmGZfCN5ADvEg";
		Writer_XZt45RjGTXmGZfCN5ADvEg writer_ = new Writer_XZt45RjGTXmGZfCN5ADvEg( funcName_, floatComparator );
		writer_.pageMin = 1;
		writer_.pageMax = 10;

		int page_ = 1;
		{
			KyVector2f b1_ = new KyVector2f( 5, 30 );
			KyVector2f b2_ = new KyVector2f( 20,10 );
			KyVector2f w_ = new KyVector2f( 10,10 );
			KyVector2f v1_ = new KyVector2f( -10,-10 );
			KyVector2f v2_ = new KyVector2f( -10,-10 );
			writer_.put( page_++, b1_, b2_, v1_, v2_, w_ );
		}
		{
			KyVector2f b1_ = new KyVector2f( 5, 30 );
			KyVector2f b2_ = new KyVector2f( 20,10 );
			KyVector2f w_ = new KyVector2f( 10,20 );
			KyVector2f v1_ = new KyVector2f( -10,-10 );
			KyVector2f v2_ = new KyVector2f( 10,10 );
			writer_.put( page_++, b1_, b2_, v1_, v2_, w_ );
		}
		{
			KyVector2f b1_ = new KyVector2f( 5, 30 );
			KyVector2f b2_ = new KyVector2f( 20,10 );
			KyVector2f w_ = new KyVector2f( 0,22 );
			KyVector2f v1_ = new KyVector2f( -10,-10 );
			KyVector2f v2_ = new KyVector2f( 10,10 );
			writer_.put( page_++, b1_, b2_, v1_, v2_, w_ );
		}
	}//}}}

	/*
	static class Writer_ay6Z55fuRlSxOY2dTNw_BQ
	{//{{{
		String funcName;
		int pageMin = -1;
		int pageMax = -1;
		float[] progress = null;

		Writer_ay6Z55fuRlSxOY2dTNw_BQ( String funcName_ )
		{//{{{
			funcName = funcName_;
		}//}}}
		public String getFileName( int page_ )
		{//{{{
			return funcName + String.format( "-%03d", page_ ) + ".html";
		}//}}}
		public void put( int page_, KyVector2f a1_, float r1_, KyVector2f b1_, float r2_, KyVector2f p_ ) throws Exception
		{//{{{
			progress = ColResult.calcCircleProgress( a1_, r1_, b1_, r2_, p_ );
			KyVector2f v1_ = b1_.sub( a1_ );
			float[] r_ = null;
			KyVector2f[] c1_ = null;
			if( progress != null && progress.length > 0 ){
				r_ = new float[progress.length];
				c1_ = new KyVector2f[progress.length];
				c1_[0] = a1_.add( v1_.mul( progress[0] ) );
				r_[0] = (r2_-r1_)*progress[0] + r1_;
				if( progress.length > 1 ){
					c1_[1] = a1_.add( v1_.mul( progress[1] ) );
					r_[1] = (r2_-r1_)*progress[1] + r1_;
				}
			}


			String fileName_ = getFileName( page_ );
			addFileName( fileName_ );
			File f_ = new File( resultDir, fileName_ );
			HtmlWriter html_ = new HtmlWriter( f_ );
			html_.printXmlDecralation();
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.printTag( "title", fileName_ );
			//html_.beginCssTag();
			//html_.out.printf( "div.%s { border-style: solid; }%n", COL_RESULTS ) ;
			//html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			SvgWriter svg_ = new SvgWriter( html_ );

			beginSvgTag( svg_, 10, 5, -20, -15, 80, 60 );

			svg_.setStroke( "#f00" );
			svg_.setFill( "None" );
			svg_.drawCircle( a1_.x, a1_.y, r1_ );
			svg_.setFill( "#f00" );
			svg_.drawPoint( a1_.x, a1_.y, 3 );

			svg_.setStroke( "#00f" );
			svg_.setFill( "None" );
			svg_.drawCircle( b1_.x, b1_.y, r2_ );
			svg_.setFill( "#00f" );
			svg_.drawPoint( b1_.x, b1_.y, 3 );

			if( progress != null ){
				if( progress.length > 1 ){
					svg_.setStroke( "#0ff" );
					svg_.setFill( "None" );
					svg_.drawCircle( c1_[1].x, c1_[1].y, r_[1] );
					svg_.setFill( "#0ff" );
					svg_.drawPoint( c1_[1].x, c1_[1].y, 3 );
				}
				svg_.setStroke( "#f0f" );
				svg_.setFill( "None" );
				svg_.drawCircle( c1_[0].x, c1_[0].y, r_[0] );
				svg_.setFill( "#f0f" );
				svg_.drawPoint( c1_[0].x, c1_[0].y, 3 );
			}
			svg_.setStroke( "None" );
			svg_.setFill( "#080" );
			svg_.drawPoint( p_.x, p_.y, 3 );

			svg_.endSvgTag();

			html_.beginDivTag();
			html_.printATagHref( "&lt;&lt;", getFileName( page_ - 1 ), null );
			html_.out.println( page_ );
			html_.printATagHref( "&gt;&gt;", getFileName( page_ + 1 ), null );
			html_.endDivTag();

			if( pageMin > 0 && pageMax > 0 ){
				html_.beginDivTag();
				for( int pg_ = pageMin; pg_ <= pageMax; ++pg_ ){
					if( pg_ == page_ ){
						html_.out.println( pg_ );
					}
					else{
						html_.printATagHref(
							String.valueOf( pg_ ),
							getFileName( pg_ ),
							null
						);
					}
					html_.out.println( "," );
				}
				html_.endDivTag();
			}

			if( progress == null ){
				html_.beginDivTag();
				html_.out.print( "progress: None" );
				html_.endDivTag();
			}
			else{
				for( int i_ = 0; i_ < progress.length; ++i_ ){
					float k_ = progress[i_];
					html_.beginDivTag();
					html_.out.printf( "progress: %f", k_ );
					html_.endDivTag();
					html_.beginDivTag();
					html_.out.printf( "origin: %s", c1_[i_] );
					html_.out.printf( "radius: %f", r_[i_] );
					html_.endDivTag();
				}
			}

			html_.endBodyTag();
			html_.endHtmlTag();
		}//}}}
		public void put( int page_, KyVector2f a1_, float r1_, KyVector2f b1_, float r2_, KyVector2f p_, KyVector2f q_ ) throws Exception
		{//{{{
			progress = ColResult.calcCircleProgress( a1_, r1_, b1_, r2_, p_, q_ );
			KyVector2f v1_ = b1_.sub( a1_ );
			float[] r_ = null;
			KyVector2f[] c1_ = null;
			if( progress != null && progress.length > 0 ){
				r_ = new float[progress.length];
				c1_ = new KyVector2f[progress.length];
				c1_[0] = a1_.add( v1_.mul( progress[0] ) );
				r_[0] = (r2_-r1_)*progress[0] + r1_;
				if( progress.length > 1 ){
					c1_[1] = a1_.add( v1_.mul( progress[1] ) );
					r_[1] = (r2_-r1_)*progress[1] + r1_;
				}
			}


			String fileName_ = getFileName( page_ );
			addFileName( fileName_ );
			File f_ = new File( resultDir, fileName_ );
			HtmlWriter html_ = new HtmlWriter( f_ );
			html_.printXmlDecralation();
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.printTag( "title", fileName_ );
			//html_.beginCssTag();
			//html_.out.printf( "div.%s { border-style: solid; }%n", COL_RESULTS ) ;
			//html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			SvgWriter svg_ = new SvgWriter( html_ );

			beginSvgTag( svg_, 10, 5, -20, -15, 80, 60 );

			svg_.setStroke( "#f00" );
			svg_.setFill( "None" );
			svg_.drawCircle( a1_.x, a1_.y, r1_ );
			svg_.setFill( "#f00" );
			svg_.drawPoint( a1_.x, a1_.y, 3 );

			svg_.setStroke( "#00f" );
			svg_.setFill( "None" );
			svg_.drawCircle( b1_.x, b1_.y, r2_ );
			svg_.setFill( "#00f" );
			svg_.drawPoint( b1_.x, b1_.y, 3 );

			if( progress != null ){
				if( progress.length > 1 ){
					svg_.setStroke( "#0ff" );
					svg_.setFill( "None" );
					svg_.drawCircle( c1_[1].x, c1_[1].y, r_[1] );
					svg_.setFill( "#0ff" );
					svg_.drawPoint( c1_[1].x, c1_[1].y, 3 );
				}
				svg_.setStroke( "#f0f" );
				svg_.setFill( "None" );
				svg_.drawCircle( c1_[0].x, c1_[0].y, r_[0] );
				svg_.setFill( "#f0f" );
				svg_.drawPoint( c1_[0].x, c1_[0].y, 3 );
			}
			svg_.setStroke( "#080" );
			svg_.setFill( "None" );
			//svg_.drawPoint( p_.x, p_.y, 3 );
			drawPath( svg_, p_, q_ );

			svg_.endSvgTag();

			html_.beginDivTag();
			html_.printATagHref( "&lt;&lt;", getFileName( page_ - 1 ), null );
			html_.out.println( page_ );
			html_.printATagHref( "&gt;&gt;", getFileName( page_ + 1 ), null );
			html_.endDivTag();

			if( pageMin > 0 && pageMax > 0 ){
				html_.beginDivTag();
				for( int pg_ = pageMin; pg_ <= pageMax; ++pg_ ){
					if( pg_ == page_ ){
						html_.out.println( pg_ );
					}
					else{
						html_.printATagHref(
							String.valueOf( pg_ ),
							getFileName( pg_ ),
							null
						);
					}
					html_.out.println( "," );
				}
				html_.endDivTag();
			}

			if( progress == null ){
				html_.beginDivTag();
				html_.out.print( "progress: None" );
				html_.endDivTag();
			}
			else{
				for( int i_ = 0; i_ < progress.length; ++i_ ){
					float k_ = progress[i_];
					html_.beginDivTag();
					html_.out.printf( "progress: %f", k_ );
					html_.endDivTag();
					html_.beginDivTag();
					html_.out.printf( "origin: %s", c1_[i_] );
					html_.out.printf( "radius: %f", r_[i_] );
					html_.endDivTag();
				}
			}

			html_.endBodyTag();
			html_.endHtmlTag();
		}//}}}
	}//}}}
	@Test
	public void calcProgress_ay6Z55fuRlSxOY2dTNw_BQ() throws Exception
	{//{{{
		final String funcName_ = "calcProgress_ay6Z55fuRlSxOY2dTNw_BQ";
		Writer_ay6Z55fuRlSxOY2dTNw_BQ writer_ = new Writer_ay6Z55fuRlSxOY2dTNw_BQ( funcName_ );
		writer_.pageMin = 1;
		writer_.pageMax = 10;

		int page_ = 1;
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 20f, 0f );
			float r1_ = 3f;
			float r2_ = 5f;
			//KyVector2f p_ = new KyVector2f( 8f, 0f );
			KyVector2f p_ = new KyVector2f( 14f, 0f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_ );
		}//}}}
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 20f, 0f );
			float r1_ = 3f;
			float r2_ = 5f;
			KyVector2f p_ = new KyVector2f( 8f, 0f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_ );
		}//}}}
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 25f, 10f );
			float r1_ = 3f;
			float r2_ = 6f;
			KyVector2f p_ = new KyVector2f( 10f, 5f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_ );
		}//}}}
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 20f, 0f );
			float r1_ = 5f;
			float r2_ = 3f;
			//KyVector2f p_ = new KyVector2f( 8f, 0f );
			KyVector2f p_ = new KyVector2f( 14f, 0f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_ );
		}//}}}
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 25f, 10f );
			float r1_ = 6f;
			float r2_ = 3f;
			KyVector2f p_ = new KyVector2f( 10f, 5f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_ );
		}//}}}

		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 20f, 0f );
			float r1_ = 3f;
			float r2_ = 5f;
			KyVector2f p_ = new KyVector2f( 14f, -5f );
			KyVector2f q_ = new KyVector2f( 14f, 5f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_, q_ );
		}//}}}
		{//{{{
			KyVector2f a1_ = new KyVector2f( 0f, 0f );
			KyVector2f b1_ = new KyVector2f( 20f, 0f );
			float r1_ = 3f;
			float r2_ = 5f;
			KyVector2f p_ = new KyVector2f( 14f, -5f );
			KyVector2f q_ = new KyVector2f( 14f, -2f );
			writer_.put( page_++, a1_, r1_, b1_, r2_, p_, q_ );
		}//}}}
	}//}}}
	*/
}//}}}
