// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.devutil;

import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.xml.XMLExporter;
import com.jme3.export.xml.XMLImporter;
import com.jme3.export.Savable;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import com.jme3.asset.DesktopAssetManager;
import com.jme3.scene.plugins.ogre.MeshLoader;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.font.plugins.BitmapFontLoader;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.material.plugins.J3MLoader;
import com.jme3.scene.plugins.ogre.SkeletonLoader;

public class J3oConverter extends AssetInfo
{//{{{
	File file;
	Savable data;

	public J3oConverter( File file_, String... pathLs_ )
	{//{{{
		super( createAssetManager( pathLs_ ), null );
		file = file_;
	}//}}}

	static DesktopAssetManager createAssetManager( String... pathLsLs_ )
	{//{{{
		DesktopAssetManager ass_ = new DesktopAssetManager();
		ass_.registerLoader( MeshLoader.class, "mesh.xml" );
		ass_.registerLoader( MaterialLoader.class, "material" );
		ass_.registerLoader( SkeletonLoader.class, "skeleton.xml" );
		ass_.registerLoader( AWTLoader.class, "png" );
		ass_.registerLoader( AWTLoader.class, "jpg" );
		ass_.registerLoader( AWTLoader.class, "gif" );
		ass_.registerLoader( J3MLoader.class, "j3md" );
		for( String pathLs_ : pathLsLs_ ){
			for( String path_ : pathLs_.split( ":" ) ){
				if( path_.trim().length() == 0 ){
					continue;
				}
				ass_.registerLocator( path_, FileLocator.class );
			}
		}
		return ass_;
	}//}}}

	public void readObject()
	{//{{{
		BinaryImporter imp_ = BinaryImporter.getInstance();
		Object obj_ = imp_.load( this );
		if( obj_ != null && obj_ instanceof Savable ){
			data = (Savable)obj_;
		}
	}//}}}
	public void readOgreXml()
	{//{{{
		data = getManager().loadModel( file.getPath() );
	}//}}}
	public void readXml() throws IOException
	{//{{{
		XMLImporter imp_ = XMLImporter.getInstance();
		Object obj_ = imp_.load( this );
		if( obj_ != null && obj_ instanceof Savable ){
			data = (Savable)obj_;
		}
	}//}}}
	public void writeObject( File f_ ) throws IOException
	{//{{{
		BinaryExporter exp_ = BinaryExporter.getInstance();
		exp_.save( data, f_ );
	}//}}}
	public void writeXml( File f_ ) throws IOException
	{//{{{
		assert( data != null );
		assert( f_ != null );
		XMLExporter xx_ = XMLExporter.getInstance();
		FileOutputStream fo_ = new FileOutputStream( f_ );
		xx_.save( data, fo_ );
	}//}}}
	@Override
    public InputStream openStream()
	{//{{{
		try{
			return new FileInputStream( file );
		}
		catch( Exception ex_ )
		{
			return null;
		}
	}//}}}

	static String changeExt( String str_, String ext1_, String ext2_ )
	{//{{{
		return str_.substring( 0, str_.length() - ext1_.length() ) + ext2_;
	}//}}}

	public static void main( String[] args_ ) throws Exception
	{//{{{
		for( String arg_ : args_ ){
			System.out.println( arg_ );
		}
		if( args_.length < 2 ){
			System.exit( -1 );
			return;
		}
		String pathLs_ = null;
		String fis_ = null;
		String fos_ = null;
		String j3oStr_ = null;
		String j3xStr_ = null;
		String nodeName_ = null;
		for( int i_ = 0; i_ < args_.length; ){
			String arg_ = args_[i_];
			if( arg_.equals( "-n" ) ){ //name
				if( i_ + 1 >= args_.length ){
					System.err.println( "-n option required node's name" );
					System.exit( -1 );
					return;
				}
				nodeName_ = args_[i_ + 1];
				i_ += 2;
			}
			else{
				if( pathLs_ == null ){
					pathLs_ = arg_;
				}
				else if( fis_ == null ){
					fis_ = arg_;
				}
				else if( fos_ == null ){
					fos_ = arg_;
				}
				else{
					System.err.println( "unexpected arg:" + arg_ );
					System.exit( -1 );
					return;
				}
				++i_;
			}
		}
		File fi_ = new File( fis_ );
		J3oConverter conv_ = new J3oConverter( fi_, pathLs_ );
		String fis1_ = fis_.toLowerCase();
		if( fis1_.endsWith( ".j3o" ) ){
			conv_.readObject();
			if( fos_ == null ){
				j3xStr_ = changeExt( fis_, ".j3o", ".j3x" );
			}
		}
		else if( fis1_.endsWith( ".mesh.xml" ) ){
			conv_.readOgreXml();
			if( fos_ == null ){
				j3oStr_ = changeExt( fis_, ".mesh.xml", ".j3o" );
				j3xStr_ = changeExt( fis_, ".mesh.xml", ".j3x" );
			}
		}
		else if( fis1_.endsWith( ".xml" ) ){
			conv_.readXml();
			if( fos_ == null ){
				j3oStr_ = changeExt( fis_, ".xml", ".j3o" );
			}
		}
		else if( fis1_.endsWith( ".j3x" ) ){
			conv_.readXml();
			if( fos_ == null ){
				j3oStr_ = changeExt( fis_, ".j3x", ".j3o" );
			}
		}
		else{
			System.err.println( "unsuported file type:" + fis_ );
			System.exit( -1 );
			return;
		}
		if( conv_.data == null ){
			System.err.println( "unexpected error" );
			throw new Error();
		}

		if( nodeName_ != null && (conv_.data instanceof Spatial) ){
			((Spatial)conv_.data).setName( nodeName_ );
		}

		if( fos_ != null ){
			File fo_ = new File( fos_ );
			String fos1_ = fos_.toLowerCase();
			if( fos1_.endsWith( ".j3o" ) ){
				conv_.writeObject( fo_ );
			}
			else if( fos1_.endsWith( ".xml" ) ){
				conv_.writeXml( fo_ );
			}
			else if( fos1_.endsWith( ".j3x" ) ){
				conv_.writeXml( fo_ );
			}
			else{
				System.err.println( "unsuported file type:" + fos_ );
				System.exit( -1 );
				return;
			}
		}
		if( j3oStr_ != null ){
			File fo_ = new File( j3oStr_ );
			conv_.writeObject( fo_ );
		}
		if( j3xStr_ != null ){
			File fo_ = new File( j3xStr_ );
			conv_.writeXml( fo_ );
		}

	}//}}}
}//}}}

