// vim: foldmethod=marker commentstring=//%s
package mygame;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.*;
import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.Set;
import java.util.ArrayList;
import java.io.InputStream;

public class TreeData
{//{{{
	public static class Node
	{//{{{
		String label;
		HashMap<String, String> leafMap;
		ArrayList<TreeData.Node> subNodeList;
		Object userData;

		public Node( String label_ )
		{//{{{
			label = label_;
			leafMap = new HashMap<String, String>();
			subNodeList = new ArrayList<TreeData.Node>();
		}//}}}
		public String getLabel()
		{//{{{
			return label;
		}//}}}
		public boolean equalsLabel( String str_ )
		{//{{{
			if( str_ == null ){
				return label == null;
			}
			return str_.equals( label );
		}//}}}
		public String getLeaf( String key_ )
		{//{{{
			return leafMap.get( key_ );
		}//}}}
		public boolean equalsLeaf( String key_, String value_ )
		{//{{{
			if( value_ == null ){
				return getLeaf( key_ ) == null;
			}
			else{
				return value_.equals( getLeaf( key_ ) );
			}
		}//}}}
		public Map<String,String> getLeafMap()
		{//{{{
			return leafMap;
		}//}}}
		public List<TreeData.Node> getSubNodeList()
		{//{{{
			return subNodeList;
		}//}}}
		public List<TreeData.Node> getSubNodeList( String label_ )
		{//{{{
			ArrayList<TreeData.Node> ls_ = new ArrayList<TreeData.Node>();
			for( TreeData.Node node_ : subNodeList ){
				if( node_.equalsLabel( label_ ) ){
					ls_.add( node_ );
				}
			}
			return ls_;
		}//}}}
		public TreeData.Node getSubNode( String label_ )
		{//{{{
			for( TreeData.Node node_ : subNodeList ){
				if( node_.equalsLabel( label_ ) ){
					return node_;
				}
			}
			return null;
		}//}}}
		public Object getUserData()
		{//{{{
			return userData;
		}//}}}
		public void setUserData( Object value_ )
		{//{{{
			userData = value_;
		}//}}}
	}//}}}
	static class Handler extends DefaultHandler
	{//{{{
		Node lastNode = null;
		ArrayList<Node> nodeStack = new ArrayList<Node>();
		public void startDocument()
		{//{{{
			lastNode = null;
			nodeStack.clear();
		}//}}}

		public void endDocument()
		{//{{{
		}//}}}

		public void startElement(
			String namespaceURI_,
			String localName_,
			String qName_,
			Attributes atts_
		)
		{//{{{
			Node node_ = lastNode = new Node( qName_ );
			Node super_ = getCurrentNode();
			if( super_ != null ){
				super_.subNodeList.add( node_ );
			}
			nodeStack.add( node_ );
			int sz_ = atts_.getLength();
			Map<String,String> map_= node_.getLeafMap();
			for( int i_ = 0; i_ < sz_; ++i_ ){
				String k_ = atts_.getQName( i_ );
				String v_ = atts_.getValue( i_ );
				map_.put( k_, v_ );
			}
		}//}}}

		static Node pop( ArrayList<Node> ls_ )
		{//{{{
			int sz_ = ls_.size();
			if( sz_ == 0 ){
				return null;
			}
			Node node_ = ls_.get( sz_ - 1 );
			ls_.remove( sz_ - 1 );
			return node_;
		}//}}}

		public void endElement(
			String namespaceURI_,
			String localName_,
			String qName_
		)
		{//{{{
			lastNode = pop( nodeStack );
		}//}}}

		Node getCurrentNode()
		{//{{{
			int sz_ = nodeStack.size();
			if( sz_ == 0 ){
				return null;
			}
			return nodeStack.get( sz_ - 1 );
		}//}}}
	}//}}}
	public static Node readXml( InputStream in_ ) throws SAXException, ParserConfigurationException, java.io.IOException
	{//{{{
		SAXParserFactory factory_ = SAXParserFactory.newInstance();
		SAXParser parser_ = factory_.newSAXParser();
		TreeData.Handler handler_ = new TreeData.Handler();
		parser_.parse( in_, handler_ ); 
		return handler_.lastNode;
	}//}}}
}//}}}
