// vim: foldmethod=marker commentstring=//%s
package mygame;

//{{{
import mn.jp.kekkouyakan.jme3.input.RawInputAdapter;
import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Quaternion;
import com.jme3.math.FastMath;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JTextArea;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import com.jme3.math.Transform;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.asset.AssetManager;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimChannel;
import com.jme3.export.xml.XMLImporter;
import static com.jme3.input.KeyInput.*;
import java.net.URI;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.UrlLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.DirectionalLight;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.io.InputStream;
import mn.jp.kekkouyakan.jmex.wani.WaniControl;
import mn.jp.kekkouyakan.jmex.wani.WaniItem;
import mn.jp.kekkouyakan.jmex.wani.WaniChannelManager;
import mn.jp.kekkouyakan.jmex.wani.IWaniEventListener;
//}}}

class ModelData
{//{{{
	ModelData( String name_, Spatial sp_ )
	{//{{{
		name = name_;
		spatial = sp_;
		animControl = sp_.getControl( AnimControl.class );
	}//}}}
	Spatial spatial;
	String name;
	AnimUnit[] animList;
	AnimControl animControl;
	Transform transform;
	WaniControl waniControl;
	AnimChannel createChannel()
	{//{{{
		if( waniControl == null ){
			if( animControl == null ){
				return null;
			}
			return animControl.createChannel();
		}
		else{
			WaniChannelManager cm_ = waniControl.getChannelManager( name );
			int index_ = cm_.createChannel( this );
			return cm_.getChannel( index_ );
		}
	}//}}}
	@Override
	public String toString()
	{//{{{
		return name;
	}//}}}
}//}}}
class AnimUnit
{//{{{
	public AnimUnit( ModelData modelData_, String name_ )
	{//{{{
		modelData = modelData_;
		name = name_;
	}//}}}
	ModelData modelData;
	AnimChannel channel = null;
	String name;
	boolean playing = false;
	public AnimChannel getChannel()
	{//{{{
		if( channel == null ){
			channel = modelData.createChannel();
		}
		return channel;
	}//}}}
	String getStateString()
	{//{{{
		if( channel == null || !playing ){
			return "-";
		}
		return ">";
	}//}}}
	public String toString()
	{//{{{
		return "(" + getStateString() + ")" + name;
	}//}}}
	public void changeState()
	{//{{{
		if( getChannel() == null ){
			return;
		}
		if( playing ){
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					channel.reset( false );
				}
			});
		}
		else{
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					channel.setAnim( name );
				}
			});
		}
		playing = !playing;
	}//}}}
}//}}}
class WaniUnit
{//{{{
	boolean running = false;
	WaniUnit( String name_ )
	{//{{{
		name = name_;
	}//}}}
	String name;
	public String toString()
	{//{{{
		if( running ){
			return "(>)" + name;
		}
		else{
			return "(-)" + name;
		}
	}//}}}
	public void changeState( WaniControl ct_, boolean loop_ )
	{//{{{
		if( running ){
			ct_.reset( name );
		}
		else if( loop_ ){
			ct_.startLoop( name );
		}
		else{
			ct_.start( name );
		}
		running = !running;
	}//}}}
	public void reset( WaniControl ct_ )
	{//{{{
		running = false;
		ct_.reset( name );
	}//}}}
}//}}}
class MyPanel extends JPanel implements MouseListener, IWaniEventListener
{//{{{
	Main app;
	Canvas canvas;
	JCheckBox loopCheckBox;
	JTree tree;
	JTextArea textArea;
	JFrame frame;
	Object selectedAnim = null;
	DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
	WaniControl waniControl;

	void updateTree( String rootLabel_, ModelData[] mdLs_, WaniControl waniCtrl_ )
	{//{{{
		waniControl = waniCtrl_;
		waniControl.addListener( this );
		treeNode.setUserObject( rootLabel_ );
		tree.clearSelection();
		for( ModelData md_: mdLs_ ){
			DefaultMutableTreeNode sub_ = new DefaultMutableTreeNode( md_ );
			for( AnimUnit anim_: md_.animList ){
				sub_.add( new DefaultMutableTreeNode( anim_) );
			}
			treeNode.add( sub_ );
		}
		if( waniCtrl_ != null ){
			DefaultMutableTreeNode sub_ = new DefaultMutableTreeNode( "WaniControl" );
			String[] animNames_ = Main.sort( waniCtrl_.getAnimNames() );
			for( String animName_ : animNames_ ){
				WaniUnit unit_ = new WaniUnit( animName_ );
				waniCtrl_.getItem( animName_ ).setUserObject( unit_ );
				sub_.add( new DefaultMutableTreeNode( unit_ ) );
			}
			treeNode.add( sub_ );
			tree.expandPath(new TreePath(sub_.getPath()));
		}
		tree.updateUI();
	}//}}}
	public void onWaniCycleDone( WaniControl ctrl0_, WaniItem item0_ )
	{//{{{
		final WaniControl ctrl_ = ctrl0_;
		final WaniItem item_ = item0_;
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				assert( ctrl_ == waniControl );
				Object obj_ = item_.getUserObject();
				assert( obj_ instanceof WaniUnit );
				((WaniUnit)obj_).reset( ctrl_ );
				tree.updateUI();
			}
		});
	}//}}}

	public MyPanel( Main app_, Canvas canvas_, JFrame frame_ )
	{//{{{
		app = app_;
		app.panel = this;
		canvas = canvas_;
		frame = frame_;

		JPanel panel3d_ = new JPanel(new FlowLayout());
		{
			Dimension dim_ = new Dimension(400, 400);
			canvas_.setPreferredSize( dim_ );
			panel3d_.add( canvas_ );
		}

		JSplitPane panelCtrl_ = new JSplitPane( JSplitPane.VERTICAL_SPLIT );
		{
			tree = new JTree( treeNode );
			tree.addMouseListener(this);
			//tree.addTreeSelectionListener(this);
			tree.getSelectionModel().setSelectionMode
				(TreeSelectionModel.SINGLE_TREE_SELECTION);
			JScrollPane scroll_ = new JScrollPane(
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				//JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
			);
			scroll_.getViewport().setView( tree );
			Dimension dim_ = new Dimension(200, 400);
			scroll_.setPreferredSize( dim_ );
			panelCtrl_.setLeftComponent( scroll_ );
		}
		{
			textArea = new JTextArea( "Welcome." );
			loopCheckBox = new JCheckBox( "Loop" );
			JPanel panel_ = new JPanel();
			panel_.setLayout( new BorderLayout() );
			panel_.add( textArea, BorderLayout.CENTER );
			panel_.add( loopCheckBox, BorderLayout.SOUTH );
			panelCtrl_.setRightComponent( panel_ );
		}
		panelCtrl_.setDividerLocation(200);

		JSplitPane split_ = new JSplitPane(
			JSplitPane.HORIZONTAL_SPLIT,
			panel3d_,
			panelCtrl_
		);
		split_.setOneTouchExpandable(true);
		split_.setDividerLocation(400);
		add( split_ );
	}//}}}
	public void mouseClicked(MouseEvent ev_) 
	{//{{{
		assert( ev_.getSource() == tree );
		TreePath path_ = tree.getPathForLocation( ev_.getX(), ev_.getY() );
		if( path_ == null ){
			return;
		}
		Object pathCom_ = path_.getLastPathComponent();
		assert( pathCom_ instanceof DefaultMutableTreeNode );
		Object userObj_ = ((DefaultMutableTreeNode)pathCom_).getUserObject();
		assert( userObj_ != null );
		if( userObj_ instanceof AnimUnit ){
			AnimUnit anim_ = (AnimUnit)userObj_;
			if( anim_ == selectedAnim ){
				anim_.changeState();
			}
			else{
				textArea.setText( anim_.name );
			}
			selectedAnim = userObj_;
			tree.updateUI();
		}
		else if( userObj_ instanceof WaniUnit ){
			final WaniUnit anim_ = (WaniUnit)userObj_;
			if( anim_ == selectedAnim ){
				anim_.changeState( waniControl, loopCheckBox.isSelected()  );
				/*
				java.awt.EventQueue.invokeLater(new Runnable() {
					public void run() {
						anim_.changeState( waniControl );
					}
				});
				*/
			}
			else{
				textArea.setText( anim_.name );
			}
			selectedAnim = userObj_;
			tree.updateUI();
		}
		else{
			selectedAnim = null;
		}
	}//}}}
	//{{{
	public void mouseEntered(MouseEvent ev_) 
	{//{{{
	}//}}}
	public void mouseExited(MouseEvent ev_) 
	{//{{{
	}//}}}
	public void mousePressed(MouseEvent ev_) 
	{//{{{
	}//}}}
	public void mouseReleased(MouseEvent ev_) 
	{//{{{
	}//}}}
	//}}}
	public void start()
	{//{{{
		app.startCanvas();
	}//}}}
}//}}}

public class Main extends SimpleApplication
{//{{{
	//variables
	//{{{
	String[] args;
	MyPanel panel;

	boolean updateFlag = false;
	float distanceSpeed0 = 2.0f;
	float distanceSpeed = 0f;
	final float distance0 = 10.0f;
	float distanceMin = 1.0f;
	float distance = distance0;
	ModelData[] modelList;
	Spatial targetSpatial;
	Transform targetTransform0;
	int screenWidth;
	int screenHeight;
	Vector3f lookAt = new Vector3f(0,0,1);
	Vector3f lookUp = new Vector3f(0,1,0);


	//}}}
	public static String[] sort( String[] ls_ )
	{//{{{
		java.util.Arrays.sort( ls_, new java.util.Comparator<String>(){
			public int compare( String str1_, String str2_ )
			{//{{{
				return str1_.compareTo( str2_ );
			}//}}}
			public boolean equals( Object obj_ )
			{//{{{
				return this == obj_;
			}//}}}
		});
		return ls_;
	}//}}}

	public Main( String... args_ )
	{//{{{
		super( (com.jme3.app.state.AppState)null );
		args = args_;
	}//}}}
	public static MyPanel createPanel( JFrame frame_, String... args_ ) throws Exception
	{//{{{
		AppSettings settings_ = new AppSettings(true);
		settings_.setWidth(640);
		settings_.setHeight(480);

		InputStream dataXml_ = Thread.currentThread().getContextClassLoader().getResourceAsStream( "data.xml" );

		Main app_ = new Main( args_ );

		app_.setPauseOnLostFocus(false);
		app_.setSettings(settings_);
		app_.createCanvas(); // create canvas!
		app_.setDisplayFps( false );
		app_.setDisplayStatView( false );
		JmeCanvasContext ctx_ = (JmeCanvasContext) app_.getContext();
		ctx_.setSystemListener(app_);

		Canvas canvas_ = ctx_.getCanvas();
		MyPanel panel_ = new MyPanel( app_, canvas_, frame_ );

		app_.startCanvas();
		return panel_;
	}//}}}
	public static void main(String[] args_) throws Exception
	{//{{{
		final JFrame window_ = new JFrame();
		window_.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		MyPanel panel_ = createPanel( window_, args_ );
		window_.add(panel_);
		window_.setPreferredSize(new Dimension( 640, 480 ));
		window_.pack();
		window_.setVisible(true);
		panel_.start();
	}//}}}
	static int abs( int v_ )
	{//{{{
		if( v_ < 0 ){
			return -v_;
		}
		return v_;
	}//}}}
	static int sign( float v_ )
	{//{{{
		if( v_ < 0 ){
			return -1;
		}
		else if( v_ > 0 ){
			return 1;
		}
		return 0;
	}//}}}
	static int debugCount = 0;
	class RawInput extends RawInputAdapter
	{//{{{
		final int mouseMin= 10;
		final float wheelDistance = 0.005f;
		boolean mousePressed = false;
		int mouseX0 = -1;
		int mouseY0 = -1;
		int lastX = -1;
		int lastY = -1;
		@Override
		public void onKeyEvent(KeyInputEvent ev_)
		{//{{{
			if( ev_.isPressed() ){
				switch( ev_.getKeyCode() ){
					case KEY_SPACE:
						resetCamera();
						break;
					case KEY_W:
					case KEY_UP:
						break;
					case KEY_S:
					case KEY_DOWN:
						break;
					case KEY_D:
					case KEY_RIGHT:
						break;
					case KEY_A:
					case KEY_LEFT:
						break;
					case KEY_J:
					case KEY_PGUP:
						distanceSpeed = -distanceSpeed0;
						break;
					case KEY_K:
					case KEY_PGDN:
						distanceSpeed = distanceSpeed0;
						break;
				}
			}
			else {
				switch( ev_.getKeyCode() ){
					case KEY_W:
					case KEY_S:
					case KEY_UP:
					case KEY_DOWN:
						break;
					case KEY_D:
					case KEY_A:
					case KEY_LEFT:
					case KEY_RIGHT:
						break;
					case KEY_J:
					case KEY_K:
					case KEY_PGUP:
					case KEY_PGDN:
						distanceSpeed = 0f;
						break;
				}
			}
		}//}}}
		@Override
    	public void onMouseButtonEvent(MouseButtonEvent ev_)
		{//{{{
			mousePressed = ev_.isPressed();
			if( mousePressed ){
				lastX = mouseX0 = ev_.getX();
				lastY = mouseY0 = ev_.getY();
			}
		}//}}}
		@Override
		public void onMouseMotionEvent(MouseMotionEvent ev_)
		{//{{{
			{
				float wheel_ = ev_.getDeltaWheel();
				if( wheel_ != 0 ){
					distance -= wheel_ * wheelDistance;
					distanceSpeed = 0;
					updateFlag = true;
					return;
				}
				else{
					distanceSpeed = 0;
				}
			}
			if( mousePressed ){
				int x_ = ev_.getX();
				int y_ = ev_.getY();
				int dx_ = mouseX0 - x_;
				int dy_ = mouseY0 - y_;
				float sx_ = -(float)dx_/(float)screenWidth;
				float sy_ = (float)dy_/(float)screenHeight;
				{
					int sign0_ = sign( lastX - mouseX0 );
					int sign1_ = sign( x_ - lastX );
					if( sign0_ != 0 && sign1_ != sign0_ ){
						mouseX0 = lastX = x_;
					}
					lastX = x_;
				}
				{
					int sign0_ = sign( lastY - mouseY0 );
					int sign1_ = sign( y_ - lastY );
					if( sign0_ != 0 && sign1_ != sign0_ ){
						mouseY0 = lastY = y_;
					}
					lastY = y_;
				}
				++debugCount;
				Quaternion xq_ = new Quaternion().fromAngleAxis(
					FastMath.QUARTER_PI*sx_, Vector3f.UNIT_Y
				);
				Quaternion yq_ = new Quaternion().fromAngleAxis(
					FastMath.QUARTER_PI*sy_, Vector3f.UNIT_X
				);
				xq_.multLocal( lookAt );
				xq_.multLocal( lookUp );
				yq_.multLocal( lookAt );
				yq_.multLocal( lookUp );
			}
		}//}}}
	}//}}}

	public void resetCamera()
	{//{{{
		targetSpatial.setLocalTransform( targetTransform0 );
		distance = distance0;
		cam.setLocation( new Vector3f( 0, 0, distance0 ) );
		cam.lookAt( Vector3f.ZERO, Vector3f.UNIT_Y );
	}//}}}
	static ModelData[] createModelList( Spatial spatial_ )
	{//{{{
		ArrayList<ModelData> ls_ = new ArrayList<ModelData>();
		createModelList( ls_, spatial_ );
		return ls_.toArray( new ModelData[0] );
	}//}}}
	static void createModelList( ArrayList<ModelData> ls_, Spatial spatial_ )
	{//{{{
		AnimControl ct_ = spatial_.getControl( AnimControl.class );
		if( ct_ != null ){
			ModelData md_ = new ModelData( spatial_.getName(), spatial_ );
			ArrayList<AnimUnit> animLs_ = new ArrayList<AnimUnit>();
			String[] animNameLs_ = ct_.getAnimationNames().toArray( new String[0] );
			for( String animName_ : Main.sort( animNameLs_ ) ){
				animLs_.add( new AnimUnit( md_, animName_ ) );
			}
			md_.animList = animLs_.toArray( new AnimUnit[0] );
			ls_.add( md_ );
		}
		if( spatial_ instanceof Node ){
			Node node_ = (Node)spatial_;
			for( Spatial child_ : node_.getChildren() ){
				createModelList( ls_, child_ );
			}
		}
	}//}}}
	@Override
	public void simpleInitApp()
	{//{{{
		assert( args.length > 0 );
		try{
			screenWidth = settings.getWidth();
			screenHeight = settings.getHeight();
			System.out.printf( "Resolution: %d %d %n", screenWidth, screenHeight );
			final String path_ = args[0];
			assetManager.registerLoader( XMLImporter.class, "j3x" );
			if( args.length > 1 ){
				String path0_ = args[1];
				for( String pathSeg0_ : path0_.split( ":" ) ){
					assetManager.registerLocator( pathSeg0_, FileLocator.class );
				}
			}
			else{
				assetManager.registerLocator( ".", FileLocator.class );
			}
			targetSpatial = assetManager.loadModel( args[0] );
			targetTransform0 = targetSpatial.getLocalTransform();
			rootNode.attachChild( targetSpatial );
			final ModelData[] mdLs_ = createModelList( targetSpatial );
			final WaniControl wani_ = targetSpatial.getControl( WaniControl.class );
			for( ModelData md_ : mdLs_ ){
				md_.waniControl = wani_;
			}
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					panel.frame.setTitle( path_ + " - Kekkouyakan Viewer 20130808" );
					panel.updateTree( targetSpatial.getName(), mdLs_, wani_ );
				}
			});
		}
		catch( Exception ex_ ){
			throw new Error( ex_ );
		}

		inputManager.addRawInputListener( new RawInput() );
	}//}}}
	@Override
	public void simpleUpdate(float tpf_)
	{//{{{
		if( updateFlag || distanceSpeed != 0f ){
			updateFlag = false;
			distance += distanceSpeed * tpf_;
			if( distance < distanceMin ){
				distance = distanceMin;
			}
			cam.setLocation( new Vector3f( 0, 0, distance ) );
		}
		targetSpatial.lookAt( lookAt, lookUp );
	}//}}}
	@Override
	public void simpleRender(RenderManager rm_)
	{//{{{
		//TODO: add render code
	}//}}}
}//}}}
