// vim: foldmethod=marker commentstring=//%s
package mygame;

import java.util.ArrayList;
import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import com.jme3.light.DirectionalLight;
import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.SkeletonControl;
import com.jme3.light.AmbientLight;
import com.jme3.math.ColorRGBA;
import jp.sourceforge.users.kekkouyakan.xac.jme3.input.DefaultRawInputListener;
import static com.jme3.input.KeyInput.*;
import static com.jme3.math.FastMath.TWO_PI;
import com.jme3.math.Quaternion;
import java.nio.file.FileSystem;

class InputListener extends DefaultRawInputListener
{//{{{
	private int direction = 0;
	private int verticalPosition = 0;
	private boolean auto = false;
	private boolean directionFlag = true;
	private boolean verticalPositionFlag = true;

	public int getDirection()
	{//{{{
		return direction;
	}//}}}
	public int getVerticalPosition()
	{//{{{
		return verticalPosition;
	}//}}}
	public boolean isAuto()
	{//{{{
		return auto;
	}//}}}
	public boolean getDirectionFlag()
	{//{{{
		return directionFlag;
	}//}}}
	public void disableDirectionFlag()
	{//{{{
		directionFlag = false;
	}//}}}
	public boolean getVerticalPositionFlag()
	{//{{{
		return verticalPositionFlag;
	}//}}}
	public void disableVerticalPositionFlag()
	{//{{{
		verticalPositionFlag = false;
	}//}}}

	@Override
	public void onKeyEvent(com.jme3.input.event.KeyInputEvent ev_) 
	{//{{{
		if( !ev_.isPressed() ){
			return;
		}
		int key_ = ev_.getKeyCode();
		if( key_ == KEY_LEFT ){
			if( auto ){
				if( direction <= 0 ){
					--direction;
					if( direction < -4 ){
						direction = -1;
					}
				}
				else{
					direction = 0;
				}
			}
			else{
				direction = -1;
			}
			directionFlag = true;
		}
		else if( key_ == KEY_RIGHT ){
			if( auto ){
				if( direction >= 0 ){
					++direction;
					if( direction > 4 ){
						direction = 1;
					}
				}
				else{
					direction = 0;
				}
			}
			else{
				direction = +1;
			}
			directionFlag = true;
		}
		else if( key_ == KEY_DOWN ){
			--verticalPosition;
			verticalPositionFlag = true;
		}
		else if( key_ == KEY_UP ){
			++verticalPosition;
			verticalPositionFlag = true;
		}
		else if( key_ == KEY_SPACE ){
			auto = !auto;
			directionFlag = true;
		}
	}//}}}
	@Override
	public void onMouseButtonEvent(com.jme3.input.event.MouseButtonEvent ev_) 
	{//{{{
		if( ev_.isPressed() ){
			auto = !auto;
			directionFlag = true;
		}
	}//}}}
}//}}}

/**
 * test
 * @author normenhansen
 */
public class Main extends SimpleApplication
//implements AnimEventListener
{//{{{
	String[] args;
	boolean auto;
	Quaternion rotation0;
	Vector3f translation0;
	int rotationStep;

	public Main( String[] args_ )
	{//{{{
		args = args_;
	}//}}}
	public static void main(String[] args_)
	{//{{{
		Main app = new Main( args_ );
		app.start();
	}//}}}
	Spatial node = null;
	InputListener inputListener = new InputListener();

	@Override
	public void simpleInitApp()
	{//{{{
		inputManager.addRawInputListener( inputListener );

		String meshName_ = null;
		if( args.length < 1 ){
			throw new Error();
		}
		meshName_ = args[0];
		String animName_ = null;
		String dir_ = "dist/Models";
		ArrayList<String[]> eqLs_ = new ArrayList<String[]>();
		for( int i_ = 1; i_ < args.length; ){
			String arg_ = args[ i_ ];
			if( arg_.equals( "-a" ) ){
				if( i_ + 1 >= args.length ){
					throw new Error();
				}
				animName_ = args[ i_ + 1 ];
				i_ += 2;
			}
			else if( arg_.equals( "-d" ) ){
				if( i_ + 1 >= args.length ){
					throw new Error();
				}
				dir_ = args[ i_ + 1 ];
				i_ += 2;
			}
			else if( arg_.equals( "-e" ) ){
				if( i_ + 2 >= args.length ){
					throw new Error();
				}
				eqLs_.add( new String[]{ args[i_+1], args[i_+2] } );
				i_ += 3;
			}
			else{
				i_ += 1;
			}
		}

		{
			FileSystem fs_ = java.nio.file.FileSystems.getDefault();
			node = assetManager.loadModel( fs_.getPath( dir_, meshName_ ).toString() );
			rootNode.attachChild(node);
			AnimControl ctrl_ = node.getControl(AnimControl.class);
			AnimChannel ch_ = ctrl_.createChannel();

			//http://hub.jmonkeyengine.org/forum/topic/giving-the-player-a-weapon/
			SkeletonControl sc_ = node.getControl( SkeletonControl.class );
			for( String[] eq_ : eqLs_ ){
				Node node1_ = (Node)assetManager.loadModel( fs_.getPath( dir_, eq_[0] ).toString() );
				Node node2_ = sc_.getAttachmentsNode( eq_[1] );
				node2_.attachChild( node1_ );
			}

			if( animName_ != null ){
				ch_.setAnim(animName_);
			}
		}
		rotation0 = node.getLocalRotation();
		translation0 = node.getWorldTranslation();

		flyCam.setEnabled( false );

		DirectionalLight sun_ = new DirectionalLight();
		sun_.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f));
		rootNode.addLight(sun_);

		AmbientLight al_ = new AmbientLight();
		al_.setColor(ColorRGBA.White.mult(1.0f));
		rootNode.addLight(al_);

	}//}}}

	@Override
	public void simpleUpdate(float tpf_)
	{//{{{
		if( inputListener.getDirectionFlag() ){
			if( inputListener.isAuto() ){
				node.rotate( 0f, 0.5f*inputListener.getDirection()*tpf_, 0f );
			}
			else{
				rotationStep += inputListener.getDirection();
				rotationStep %= 16;
				node.setLocalRotation( rotation0.fromAngles( 0f, TWO_PI * rotationStep / 16f, 0f ) );
			}
			inputListener.disableDirectionFlag();
		}
		else{
			if( inputListener.isAuto() ){
				node.rotate( 0f, 0.5f*inputListener.getDirection()*tpf_, 0f );
			}
		}
		if( inputListener.getVerticalPositionFlag() ){
			node.setLocalTranslation(
				node.worldToLocal( translation0.add( 0f, -1f + 0.2f*inputListener.getVerticalPosition(), -1f ), new Vector3f() )
			);
			inputListener.disableVerticalPositionFlag();
		}
	}//}}}

	@Override
	public void simpleRender(RenderManager rm)
	{//{{{
		//TODO: add render code
	}//}}}
}//}}}
