﻿Imports System.Windows.Forms.WebBrowser
Imports Microsoft.VisualBasic.FileIO
Imports System.Runtime.InteropServices

Public Class FrmMain

    Public StopFlg As Boolean '停止用フラグ
    Dim DtCSv As New DataTable  'CSV読み込み用データテーブル
    Dim idx As Integer  'データテーブルの現在idx
    Dim MAXidx As Integer   '取得最大件数（表示用）
    Dim rowidx As Integer

    Private Sub FrmMain_FormClosed(sender As Object, e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Application.Exit()
    End Sub


    Private Sub Main_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim dummy As String

        '組み込みブラウザのIEバージョン変更
        Dim myreg As New RegistryControl
        myreg.SetBrowberChange("AAA")

        'ヴァージョンを表示
        LblVer.Text = Application.ProductVersion
        Me.Text = Me.Text & "(Ver." & Application.ProductVersion & ")"
        'main()
        '認識文字列を外だしに変更
        'Configファイルが読めるか確認する
        Try
            dummy = My.Settings.AppleIDdisc
            TxtAppleDisc.Text = dummy
        Catch ex As Exception
            MessageBox.Show("設定ファイルを読込ことができませんでした" & vbCrLf & ex.Message, "エラー", MessageBoxButtons.OKCancel, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub main()
        '読み込んだCSVの全行を対象にする
        'ただし途中で再開をさせるため、msgがNULLのものだけ

        For Each row As DataRow In DtCSv.Select("msg=''")
            '中止おされたか？
            If Not StopFlg Then
                idx += 1
                rowidx = row(6) '行番号取り出し
                DisplayControl(Trim(row(0).ToString), Trim(row(2).ToString))
                DisplayCnt(idx.ToString)
                If RDhosting.Checked Then
                    HostingMail_Main()
                End If
            Else
                MessageBox.Show("処理を中止しました。" & vbCrLf & "再開を行うには、再開を押してください", "中止しました", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                BtnRun.Enabled = True
                BtnRun.Text = "再開"
                Exit Sub
            End If
        Next
        MessageBox.Show("終了しました" & vbCrLf & Now.ToString, "終了しました", MessageBoxButtons.OK, MessageBoxIcon.Information)
        BtnRun.Enabled = True
        BtnRun.Text = "実行"
        PicLoad.Visible = False
    End Sub

    Private Sub HostingMail_Main()
        '----DEBUG
        'Dim Proxy As New useProxy
        'Proxy.InternetOptionProxy(useProxy.InternetOpenType.INTERNET_OPEN_TYPE_PROXY, Proxy.getProxyAddress, "")
        ' Dim pdata() As Byte
        'Dim HTTPHeader As String = "User-Agent: Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/7.0)"
        'HTTPHeader = HTTPHeader & "Accept: text/html, application/xhtml+xml, */*"
        'HTTPHeader = HTTPHeader & "Accept-Language: ja-JP"
        ' HTTPHeader = HTTPHeader & "Accept-Encoding: gzip, deflate"
        'HTTPHeader = HTTPHeader & "Connection: keep-alive"

        'WebBrowser1.Navigate(url, "", pdata, HTTPHeader)
        'WebBrowser1.Navigate(url)
        'Exit Sub
        '----DEBUG
        'シンプルメール用
        WebBrowser1.Navigate("https://m112.secure.ne.jp/public/cgi-bin/sqwebmail?index=1")
        'Application.DoEvents()

        '読み込み終了になるまで監視する
        While WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While
        WebBrowser1_SimpleLoginDocumentCompleted()
    End Sub

    '現在のメールボックスとアップルIDの表示
    Private Sub DisplayControl(ByVal argMailId As String, ByVal argAppleId As String)
        'LblAppleID.Text = argAppleId
        LblMailID.Text = argMailId
    End Sub

    Private Sub DisplayCnt(ByVal nowcnt As String)
        txtNowCnt.Text = nowcnt & "/" & MAXidx.ToString
    End Sub

    'シンプルメール用ログインページ
    '    Private Sub WebBrowser1_SimpleLoginDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_SimpleLoginDocumentCompleted()
        Dim DocFrame As System.Windows.Forms.HtmlWindowCollection

        If WebBrowser1.Document.Window.Frames.Count >= 1 Then
            DocFrame = WebBrowser1.Document.Window.Frames
            'IDもnameもついていないため、属性値で取り出し判定する
            'フレーム内の走査
            For Each f As Windows.Forms.HtmlWindow In DocFrame

                For Each X As Windows.Forms.HtmlElement In f.Document.GetElementsByTagName("INPUT")
                    'データセットからログイン情報の取り出し
                    Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
                    'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
                    'ログイン情報を自動入力
                    If X.GetAttribute("name") = "username" Then
                        'X.SetAttribute("value", "area0001@kitting.jp")
                        X.SetAttribute("value", Trim(drCsv(0).ToString))
                    End If
                    If X.GetAttribute("name") = "password" Then
                        X.SetAttribute("value", Trim(drCsv(1).ToString))
                    End If
                    'ログイン情報が入力されている前提でログインボタンを押す
                    If X.GetAttribute("value") = "ログイン" Then
                        'X.InvokeMember("submit")
                        X.InvokeMember("click")
                        Application.DoEvents()

                        '読み込み終了になるまで監視する
                        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                            Application.DoEvents()
                        End While

                        'While WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                        '    Application.DoEvents()
                        'End While
                        WebBrowser1_SimpleMenuDocumentCompleted()

                        'イベントハンドルの切り離し
                        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_SimpleLoginDocumentCompleted
                        'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_SimpleMenuDocumentCompleted
                    End If
                Next
            Next
        End If

    End Sub

    'シンプルメール用メニュー選択
    '    Private Sub WebBrowser1_SimpleMenuDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_SimpleMenuDocumentCompleted()
        Dim DocFrame As System.Windows.Forms.HtmlWindowCollection
        Dim FindFlg As Boolean = False  '受信箱が見つかったフラグ　ない場合、ログインでエラー発生

        If WebBrowser1.Document.Window.Frames.Count >= 1 Then
            DocFrame = WebBrowser1.Document.Window.Frames
            For Each f As Windows.Forms.HtmlWindow In DocFrame
                'ログインが成功している場合
                For Each X As Windows.Forms.HtmlElement In f.Document.Links
                    If X.InnerText = "受信箱" Then
                        FindFlg = True
                        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_SimpleMenuDocumentCompleted
                        'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_SimpleMailBoxDocumentcomplete
                        X.InvokeMember("click")
                        Application.DoEvents()

                        '読み込み終了になるまで監視する
                        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                            Application.DoEvents()
                        End While
                        WebBrowser1_SimpleMailBoxDocumentcomplete()

                    End If
                Next
                '受信箱が見つからないとき
                If Not FindFlg Then
                    For Each x As Windows.Forms.HtmlElement In f.Document.GetElementsByTagName("font")
                        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
                        'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
                        'エラーメッセージを取得
                        drCsv(4) = x.InnerText
                        drCsv(5) = 1
                        DtCSv.AcceptChanges()
                        Exit Sub

                    Next
                End If
            Next
        End If
    End Sub

    'シンプルメール用メールボックス操作
    '    Private Sub WebBrowser1_SimpleMailBoxDocumentcomplete(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_SimpleMailBoxDocumentcomplete()
        Dim DocFrame As System.Windows.Forms.HtmlWindowCollection
        'Dim domhref As String
        'Apple ID ご連絡先メールアドレスをご確認ください
        'Const AppleID_Title As String = "Apple ID ご連絡先メールアド"
        'Const AppleID_Title As String = "Apple ID"
        Dim AppleID_Title As String

        '認識文字列を外だしに変更
        AppleID_Title = My.Settings.AppleIDdisc

        'If sender.Url.ToString <> e.Url.ToString Then Exit Sub

        If WebBrowser1.Document.Window.Frames.Count >= 1 Then
            'フレーム取り出し
            DocFrame = WebBrowser1.Document.Window.Frames
            For Each f As Windows.Forms.HtmlWindow In DocFrame
                'HREFを取り出す
                For Each X As Windows.Forms.HtmlElement In f.Document.Links
                    'HREFの子エレメントを取り出す
                    Dim elem As System.Windows.Forms.HtmlElementCollection = X.Children
                    '子エレメントを取り出す
                    For Each s As HtmlElement In elem
                        'その中にAPPLEメール件名があるか?
                        'If s.InnerText = AppleID_Title Then
                        '画像の場合InnerTextがNothing
                        If Not IsNothing(s.InnerText) Then
                            If s.InnerText.IndexOf(AppleID_Title) > -1 Then
                                'あったら親HREFを取り出す
                                'domhref = s.Parent.GetAttribute("href")
                                'MessageBox.Show(domhref)
                                'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_SimpleMailBoxDocumentcomplete
                                'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_MailContntsDocumentCompleted
                                X.InvokeMember("click")
                                Application.DoEvents()

                                '読み込み終了になるまで監視する
                                While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                                    Application.DoEvents()
                                End While
                                WebBrowser1_MailContntsDocumentCompleted()

                            End If
                        End If
                    Next
                Next

            Next

        End If

    End Sub

    'シンプルメール用メール本文表示からリンクを探し、Appleへ
    '    Private Sub WebBrowser1_MailContntsDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_MailContntsDocumentCompleted()
        Dim DocFrame As System.Windows.Forms.HtmlWindowCollection
        'Dim pdata() As Byte
        Const APPLESUPPORT As String = "support.apple.com"
        Const HOST As String = "id.apple.com"
        'Dim HTTPHeader As String = "User-Agent: Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/7.0)"
        'HTTPHeader = HTTPHeader & "Accept: text/html, application/xhtml+xml, */*"
        'HTTPHeader = HTTPHeader & "Accept-Language: ja-JP"
        'HTTPHeader = HTTPHeader & "Accept-Encoding: gzip, deflate"
        'HTTPHeader = HTTPHeader & "Connection: keep-alive"

        Dim bytes() As Byte
        Dim str As String

        '今すぐ確認
        'Const AppleID_LINK As String = "今すぐ"

        'Str = System.Text.Encoding.GetEncoding(51932).GetString(bytesData)

        If WebBrowser1.Document.Window.Frames.Count >= 1 Then
            'フレーム取り出し
            DocFrame = WebBrowser1.Document.Window.Frames
            For Each f As Windows.Forms.HtmlWindow In DocFrame
                'HREFを取り出す
                'f.Document.Links(5)がターゲット
                For Each X As Windows.Forms.HtmlElement In f.Document.Links
                    '文字コードの変換
                    If Not IsNothing(X.InnerText) Then
                        'パスワードリセットは遷移しない
                        If Not (X.InnerText.IndexOf("iforgot.apple.com") > -1) Then

                            'UTF-8へ変換する
                            'bytes = System.Text.Encoding.UTF8.GetBytes(X.InnerText)
                            'bytes = System.Text.Encoding.GetEncoding("SHIFT-JIS").GetBytes(X.InnerText)
                            'bytes = System.Text.Encoding.GetEncoding("UTF-8").GetBytes(X.InnerHtml)
                            'str = System.Text.Encoding.Unicode.GetString(bytes)

                            'その中にAPPLEメール件名があるか?
                            'If str.IndexOf(AppleID_LINK) = 0 Then
                            ' X.InvokeMember("click")
                            Dim domhref As String
                            'あったらHREFを取り出す
                            domhref = X.GetAttribute("href")
                            'HREF内がAppleサポートなら遷移させない
                            If domhref.IndexOf(APPLESUPPORT) > -1 Then
                                '存在するならスルー
                                '認証サイトなら遷移
                            ElseIf domhref.IndexOf(HOST) > 0 Then
                                ' MessageBox.Show(domhref)
                                '同一ブラウザ内で開きたいので、HREFを取り出し、意図的に遷移させる
                                WebBrowser1.Navigate(domhref)
                                'WebBrowser1.Navigate(domhref, "", pdata, HTTPHeader)
                                'ハンドルの切り離し
                                'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_MailContntsDocumentCompleted
                                'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_DummyDocumenttCompleted
                                '読み込み終了になるまで監視する
                                While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                                    Application.DoEvents()
                                End While
                                WebBrowser1_DummyDocumenttCompleted()
                            End If

                        End If

                    End If

                Next
            Next

        End If

    End Sub

    'ダミーDocumentCompletedイベント
    '    Private Sub WebBrowser1_DummyDocumenttCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_DummyDocumenttCompleted()
        'リダイレクトページが遷移するまで待機
        Const HOST As String = "id.apple.com"

        Try
            While WebBrowser1.Url.Host <> HOST
                Application.DoEvents()
            End While

            '自分自身のハンドルを切り離し
            'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_DummyDocumenttCompleted
            'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_AppleIDLoginPageDocumentCompleted
            '読み込み終了になるまで監視する
            While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                Application.DoEvents()
            End While
            WebBrowser1_AppleIDLoginPageDocumentCompleted()
            'Application.DoEvents()
        Catch ex As Exception
            Exit Sub
        End Try
 
    End Sub

    'AppleID確認ページ
    '    Private Sub WebBrowser1_AppleIDLoginPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_AppleIDLoginPageDocumentCompleted()
        '正常の場合AppleID、とパスワードの入力が可能なので「GetElementsByID」でエレメントを取り出してみる
        'もし、エレメントが取り出せない場合は、異常なので、エラーを取り出すことを試みる
        'ページの構造が変わったら、その都度解析しなければならない
        Dim elem As HtmlElement
        Dim str As String

        elem = WebBrowser1.Document.GetElementById("accountname")
        If Not IsNothing(elem) Then
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
            'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
            'AppleID
            elem.SetAttribute("value", Trim(drCsv(2).ToString))
            'elem.SetAttribute("value", "mob01@kitting.jp")
            'AppleIDパスワード
            WebBrowser1.Document.GetElementById("accountpassword").SetAttribute("value", Trim(drCsv(3).ToString))
            elem = WebBrowser1.Document.GetElementById("bot-nav").Children(0)
            elem.InvokeMember("click")
            Application.DoEvents()

            While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
                Application.DoEvents()
            End While
            WebBrowser1_GetAppleIDLastPageDocumentCompleted()

            'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
            'Application.DoEvents()
        Else
            'エラー
            Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
            'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)
            Try
                str = WebBrowser1.Document.GetElementById("intro").InnerText
                drCsv(4) = str
                drCsv(5) = 1
                DtCSv.AcceptChanges()
            Catch ex As Exception
                MessageBox.Show("セッションが期限切れです。画面内の右下から再送ボタンを押してください", "セッション期限切れ", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                StopFlg = True
            End Try
            'MessageBox.Show(str)
            'エラーならここで終了
        End If
        'MessageBox.Show("AppleID認証ページ")

        'MessageBox.Show(e.Url.ToString)
        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_AppleIDLoginPageDocumentCompleted
    End Sub

    'AppleID確認OKページ専用
    '最終的なメッセージを取得するだけ
    '    Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    Private Sub WebBrowser1_GetAppleIDLastPageDocumentCompleted()
        Dim str As String
        Dim chk1 As String = "名前、ID、メールアドレスの管理"
        Dim chk2 As String = "Apple ID またはパスワードが正しくありません。"
        Dim chk3 As String = "この Apple ID は無効になっています"
        Dim elemLogout As HtmlElement

        Dim drCsv As DataRow = DtCSv.Rows(rowidx - 1)
        'Dim drCsv As DataRow = DtCSv.Select("msg=''")(idx - 1)

        'AppleIDかパスワードエラー対応
        If InStr(WebBrowser1.Document.Body.InnerText, chk2) > 0 Then
            str = chk2
            drCsv(4) = 1
        ElseIf InStr(WebBrowser1.Document.Body.InnerText, chk3) > 0 Then
            str = chk3
            drCsv(4) = 1
        Else
            str = ""
        End If

        'ログインエラー以外を対応
        If str = "" Then
            str = WebBrowser1.Document.GetElementById("intro").InnerText
            drCsv(4) = str
            drCsv(5) = 0    '正常終了
            DtCSv.AcceptChanges()
        End If


        'ログアウトしないと途中でURL変更を許可してくれない
        'エレメントを探す
        'For Each elemAddr In WebBrowser1.Document.GetElementsByTagName("DIV")
        '    If elemAddr.GetAttribute("className") = "logo" Then
        '        elemLogout = elemAddr.Children.Item(0)
        '        elemLogout.InvokeMember("click")
        '        Application.DoEvents()
        '        Exit For
        '    End If
        'Next

        'ページ遷移を待機
        While WebBrowser1.IsBusy OrElse WebBrowser1.ReadyState <> WebBrowserReadyState.Complete
            Application.DoEvents()
        End While
        ' MessageBox.Show(str)
        'RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_GetAppleIDLastPageDocumentCompleted
    End Sub

#Region "いらないもの"
    ''ログインページ用
    'Private Sub WebBrowser1_LoginDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)

    '    WebBrowser1.Document.Forms(0).All("am_authid").SetAttribute("value", "area0001@kitting.jp")
    '    WebBrowser1.Document.Forms(0).All("am_authpasswd").SetAttribute("value", "kddi0077")
    '    For Each x As HtmlElement In WebBrowser1.Document.Forms(0).All
    '        If Trim(x.GetAttribute("value")) = "ログイン" Then
    '            x.InvokeMember("Click")
    '            Application.DoEvents()
    '            'ログイン用イベントハンドラを削除
    '            RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_LoginDocumentCompleted
    '            'メールボックス用イベントハンドラ追加
    '            AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_MailboxDocumentCompleted
    '            Exit For
    '        End If
    '    Next

    'End Sub

    ''メールボックス用
    'Private Sub WebBrowser1_MailboxDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    '    '永久ループになるので、何か対策しないとね
    '    RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_MailboxDocumentCompleted
    '    Application.DoEvents()

    '    'WebBrowser1.Document.GetElementById("rmail").InvokeMember("click")
    '    'WebBrowser1.Document.GetElementById("pulldown_rmail_contents").InvokeMember("click")
    '    'WebBrowser1.Document.GetElementById("smail").InvokeMember("Click")
    '    'WebBrowser1.Document.GetElementById("rmail").RaiseEvent("onclick")

    '    '直接Javascriptを起動させてみる
    '    '受信メールボックスへ移行
    '    WebBrowser1.Navigate("javascript:amtop.changeContents('rmail');")
    '    'Application.DoEvents()
    '    'AddHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_ReciveMailboxDocumentCompleted
    'End Sub

    ''受信ボックス用
    'Private Sub WebBrowser1_ReciveMailboxDocumentCompleted(ByVal sender As Object, ByVal e As System.Windows.Forms.WebBrowserDocumentCompletedEventArgs)
    '    Dim DocFrame As System.Windows.Forms.HtmlWindowCollection
    '    Const AppleID_Title As String = "Apple ID ご連絡先メールアドレスをご確認ください"
    '    Application.DoEvents()

    '    RemoveHandler WebBrowser1.DocumentCompleted, AddressOf WebBrowser1_ReciveMailboxDocumentCompleted

    '    'WebBrowser1.DocumentText

    '    '受信メールボックスの件名にAppleIDが存在するものにMouseHoverイベントを起こし、クリックさせる
    '    'IFrameの取り出す
    '    'ページを読み込んでも、初期フレームのままなので、中身にアクセスできず。
    '    '
    '    If WebBrowser1.Document.Window.Frames.Count >= 2 Then
    '        DocFrame = WebBrowser1.Document.Window.Frames
    '        'IDもnameもついていないため、属性値で取り出し判定する
    '        'フレーム内の走査
    '        For Each f As Windows.Forms.HtmlWindow In DocFrame
    '            Debug.Print(f.Document.Body.InnerHtml)
    '            For Each X As Windows.Forms.HtmlElement In f.Document.GetElementsByTagName("TD")
    '                'AppleIDの承認メールか？
    '                If X.GetAttribute("title") = AppleID_Title Then

    '                End If
    '            Next
    '        Next
    '    End If
    'End Sub

    'Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
    '    Dim DocFrame As System.Windows.Forms.HtmlWindowCollection
    '    Const AppleID_Title As String = "Apple ID ご連絡先メールアドレスをご確認ください"

    '    If WebBrowser1.Document.Window.Frames.Count >= 2 Then
    '        DocFrame = WebBrowser1.Document.Window.Frames
    '        'IDもnameもついていないため、属性値で取り出し判定する
    '        'フレーム内の走査
    '        For Each f As Windows.Forms.HtmlWindow In DocFrame
    '            Debug.Print(f.Document.Body.InnerHtml)
    '            For Each X As Windows.Forms.HtmlElement In f.Document.GetElementsByTagName("TD")
    '                'AppleIDの承認メールか？
    '                If X.OuterText <> "" Then
    '                    If X.OuterText.IndexOf(AppleID_Title) > 1 Then
    '                        MessageBox.Show(X.OuterText)
    '                        X.Parent.Focus()
    '                        X.Parent.Document.Focus()

    '                    End If
    '                End If
    '            Next
    '        Next
    '    End If
    'End Sub
#End Region

    Private Sub BtnRun_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnRun.Click
        'CSV読み込んでいるかチェック
        If DtCSv.Rows.Count = 0 Then
            MessageBox.Show("先に認証用CSVを読み込んでください", "CSVを読み込んでください", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            TabControl1.SelectTab(0)
            Exit Sub
        End If
        '再開か否かの判断
        'メッセージがNULLの件数が０なら初期、それ以外は空白件数
        If DtCSv.Select("msg<>''").Length = 0 Then
            idx = 0
            'インデックスの初期値の設定
            MAXidx = DtCSv.Select("msg=''").Length
        Else
            idx = DtCSv.Select("msg<>''").Length
        End If
        StopFlg = False
        BtnRun.Enabled = False
        BtnStop.Enabled = True
        PicLoad.Visible = True

        main()
    End Sub

    Private Sub BtnStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnStop.Click
        StopFlg = True  '停止フラグ更新
        BtnRun.Enabled = True   '実行ボタンを有効に
        PicLoad.Visible = False '右上画像を非表示に
    End Sub

    'ファイル読み込みボタン
    'すべてを初期化する
    Private Sub btnChoiceFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChoiceFile.Click
        Dim cnt As Integer
        'ファイルオープンダイアログ表示
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            TxtFilePath.Text = OpenFileDialog1.FileName
            BtnRun.Enabled = True
            BtnRun.Text = "開始"
        Else
            Exit Sub
        End If

        'ファイルをセパレートで一度全部読み込み、データセットへ展開する
        'データテーブルチェック
        If DtCSv.TableName <> "CSV" Then
            DtCSv = CSVtype()
        Else
            DtCSv.Rows.Clear()  'CSV内容全消去
        End If

        Dim drCsv As DataRow
        Dim parser As New TextFieldParser(TxtFilePath.Text)
        parser.TextFieldType = FieldType.Delimited
        parser.SetDelimiters(",") ' 区切り文字はコンマ
        While Not parser.EndOfData
            Dim row As String() = parser.ReadFields() ' 1行読み込み
            cnt += 1
            drCsv = DtCSv.NewRow()  '新規行
            '空白以外は取り込む
            If row(0) <> "" Then
                drCsv(0) = row(0) 'ホスティングメール
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のホスティングメールが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If
            'ホスティングメールパスワード
            If row(1) <> "" Then
                drCsv(1) = row(1) 'ホスティングメールパスワード
            Else
                cnt = DtCSv.Rows.Count + 1
                MessageBox.Show(cnt.ToString & " 行目のホスティングメールパスワードが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                TxtFilePath.Text = ""
                Exit Sub
            End If

            'AppleID
            Try
                If row(2) <> "" Then
                    drCsv(2) = row(2) 'AppleID
                Else
                    cnt = DtCSv.Rows.Count + 1
                    MessageBox.Show(cnt.ToString & " 行目のAppleIDが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                    TxtFilePath.Text = ""
                    Exit Sub
                End If
                'AppleIDパスワード
                If row(3) <> "" Then
                    drCsv(3) = row(3) 'AppleIDパスワード
                Else
                    cnt = DtCSv.Rows.Count + 1
                    MessageBox.Show(cnt.ToString & " 行目のAppleIDが空白です", "CSV読込チェック", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                    TxtFilePath.Text = ""
                    Exit Sub
                End If
            Catch ex As Exception
                MessageBox.Show("CSVの項目が少ないため、展開できません", "CSVを確認してください", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                Exit Sub
            End Try
            drCsv(4) = "" 'AppleID認証後のメッセージ格納
            drCsv(6) = cnt    '行数
            DtCSv.Rows.Add(drCsv)   '行追加
        End While
        DtCSv.AcceptChanges()

        'データビューへ設定
        'バインディングは自動
        DGCSV.DataSource = DtCSv
        'DGCSV.DataMember = "CSV"

        '各カラムに対して幅を指定する
        For Each c As DataGridViewColumn In DGCSV.Columns
            Select Case c.Index
                Case 0, 2   'メールアドレス
                    c.Width = 125
                Case 1, 3   'パスワード
                    c.Width = 80
                Case 4  'メッセージ
                    c.Width = 317
                Case 5  'エラーフラグ
                    c.Width = 27
                Case 6  '項番
                    c.Width = 30
            End Select
            'ソートを不可にする
            c.SortMode = DataGridViewColumnSortMode.NotSortable
        Next c

        'ループ用インデックスを初期化
        idx = 0
    End Sub

    'CSV取り込み用データテーブル定義
    Public Function CSVtype() As DataTable
        Dim dtCSV As New DataTable
        With dtCSV
            .Columns.Add("MailAddress")     'ホスティングメール0
            .Columns.Add("MailPassword")    'ホスティングメールパスワード1
            .Columns.Add("AppleID")         'AppleID2
            .Columns.Add("AppleIDPassword") 'AppleIDパスワード3
            .Columns.Add("msg").DefaultValue = DBNull.Value 'AppleID認証後のメッセージ格納4
            .Columns.Add("Error").DefaultValue = 0  'エラー行は１ 5
            .Columns.Add("No")  '行数 6
            '.Columns.Add("time")  '日時 7
            .TableName = "CSV"
        End With
        Return dtCSV.Clone
    End Function

    'CSV出力ボタン
    Private Sub BtnOutPut_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnOutPut.Click
        SaveToCsv(DGCSV)
    End Sub

    '保存したいDataGridViewコントロールの名前を引数として
    '設定します。
    Public Sub SaveToCsv(ByVal tempDgv As DataGridView)

        '1行もデータが無い場合は、保存を中止します。
        If tempDgv.Rows.Count = 0 Then
            Exit Sub
        End If

        '変数を定義します。
        Dim i As Integer
        Dim j As Integer
        Dim strFileName As String
        Dim strResult As New System.Text.StringBuilder

        '保存ダイアログでファイル名を設定した場合に処理を実行します。
        If Me.sfdCsvFile.ShowDialog = _
          Windows.Forms.DialogResult.OK Then

            'コラムヘッダを1行目に列記します。
            '※ヘッダ行が不要な場合は削除可能です。
            For i = 0 To tempDgv.Columns.Count - 1
                Select Case i
                    Case 0
                        strResult.Append("""" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")

                    Case tempDgv.Columns.Count - 1
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & _
                        """" & vbCrLf)

                    Case Else
                        strResult.Append("," & """" & _
                        tempDgv.Columns(i).HeaderText.ToString & """")
                End Select

            Next

            'データを保存します。
            '※新規行の追加を認めている場合は、次行の「tempDgv.Columns.Count - 1」を
            '「tempDgv.Columns.Count - 2」としてください。
            For i = 0 To tempDgv.Rows.Count - 1
                For j = 0 To tempDgv.Columns.Count - 1
                    Select Case j
                        Case 0
                            strResult.Append("""" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")

                        Case tempDgv.Columns.Count - 1
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """" & vbCrLf)

                        Case Else
                            strResult.Append("," & """" & _
                            tempDgv.Rows(i).Cells(j).Value.ToString & _
                            """")
                    End Select

                Next
            Next

            'ファイル名を保存ダイアログで指定した値に設定します。
            strFileName = Me.sfdCsvFile.FileName

            'Shift-JISで保存します。
            Dim swText As New System.IO.StreamWriter(strFileName, _
              False, System.Text.Encoding.GetEncoding(932))
            swText.Write(strResult.ToString)
            swText.Dispose()

        End If

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If DtCSv.TableName <> "CSV" Then
            Exit Sub
        Else
            DtCSv.WriteXml("debug_output.xml", XmlWriteMode.WriteSchema)
            MessageBox.Show("デバック用XML出力した！！")
        End If
    End Sub

    'Private Sub WebBrowser1_Navigated(sender As Object, e As System.Windows.Forms.WebBrowserNavigatedEventArgs) Handles WebBrowser1.Navigated
    '    isNavigating = False
    'End Sub

    ''常にUser-Agentを偽装するイベント
    'Private Sub WebBrowser1_Navigating(sender As Object, e As System.Windows.Forms.WebBrowserNavigatingEventArgs) Handles WebBrowser1.Navigating
    '    If Not isNavigating Then
    '        isNavigating = True
    '        'キャンセルする
    '        e.Cancel = True
    '        '偽装用メソッドを呼ぶ
    '        navigate(e.Url)
    '    End If
    'End Sub

    ''偽装用メソッド
    'Private Sub navigate(ByVal uri As Uri)
    '    Dim HTTPHeader As String = "User-Agent: Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/7.0)"
    '    Dim pdata() As Byte
    '    WebBrowser1.Navigate(uri, "", pdata, HTTPHeader)
    'End Sub
End Class

