package com.mxmobiling.kitting;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class PersonProfileGUI extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private String displayName = ""; // プロファイル名
	private String description = ""; // プロファイルの説明
	private String identifier = ""; // プロファイルの識別子
	private Boolean deleteProfile = false; // プロファイル削除可否
	private JTextField profileID;
	private JTextField profileDescription;
	private JTextField profileExport;

	// 作成するプロファイルの種類を選択するチェックボックス
	JCheckBox wifiCheckBox;
	JCheckBox exchangeCheckBox;
	JCheckBox vpnCheckBox;

	// パラメータシートのパラメータ数
	private static final int WIFIPARAMS = 3;
	private static final int EXCHANGEPARAMS = 10;
	private static final String NONE = "★選択してください";

	// VPNタイプとパラメータ数
	private static final String L2TP_PASS = "L2TP_PASS";
	private static final int L2TP_PASS_NUM = 6;
	private static final String L2TP_RSA = "L2TP_RSA";
	private static final int L2TP_RSA_NUM = 5;
	private static final String PPTP_PASS_AUTO = "PPTP_PASS_AUTO";
	private static final String PPTP_PASS_NONE = "PPTP_PASS_NONE";
	private static final String PPTP_PASS_MANUAL = "PPTP_PASS_MANUAL";
	private static final int PPTP_PASS_NUM = 6;
	private static final String PPTP_RSA_AUTO = "PPTP_RSA_AUTO";
	private static final String PPTP_RSA_NONE = "PPTP_RSA_NONE";
	private static final String PPTP_RSA_MANUAL = "PPTP_RSA_MANUAL";
	private static final int PPTP_RSA_NUM = 5;
	private static final String IPSEC = "IPSec";
	private static final int IPSEC_NUM = 7;
	private static final String CISCO_ANYCONNECT = "Cisco_AnyConnect";
	private static final int CISCO_ANYCONNECT_NUM = 6;
	private static final String JUNIPER_SSL = "Juniper_SSL";
	private static final int JUNIPER_SSL_NUM = 7;
	private static final String FS_SSL = "FS_SSL";
	private static final int FS_SSL_NUM = 5;
	private static final String SONICWALL = "SonicWALL_Mobile_Connect";
	private static final int SONICWALL_NUM = 6;
	private static final String ARUBA_VIA = "Aruba_VIA";
	private static final int ARUBA_VIA_NUM = 5;
	private static final String CHECK_POINT = "Check_Point_Mobile_VPN";
	private static final int CHECK_POINT_NUM = 5;
	// private static final String CUSTOM_SSL = "カスタムSSL";

	private Choice wifiParamChoice; // Wi-Fiのパラメータ数を選択
	private Choice exchangeParamChoice; // Exchangeのパラメータ数を選択
	private Choice vpnParamChoice; // VPNのパラメータ数を選択

	// VPNのプロキシの有無とパラメータ数
	private static final String PROXY_NONE = "PROXY_NONE";
	private static final int PROXY_NONE_NUM = 0;
	private static final String PROXY_MANUAL = "PROXY_MANUAL";
	private static final int PROXY_MANUAL_NUM = 4;
	private static final String PROXY_AUTO = "PROXY_AUTO";
	private static final int PROXY_AUTO_NUM = 1;

	private int params = 0;// プロファイル数カウント

	private static final String APPTITLE = "個別プロファイル大量作成ツール　Ver 1.1.0";
	private JTextField csvInputText;

	public static void main(String args[]) {
		PersonProfileGUI frame = new PersonProfileGUI(APPTITLE);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.setLocationRelativeTo(null);
	}

	PersonProfileGUI(String title) {
		setTitle(title);
		setSize(700, 510);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// アイコンファイルの読み込み
		String iconFileName = "img/icon.png";
		URL iconUrl = this.getClass().getClassLoader()
				.getResource(iconFileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(iconFileName).getImage();
		setIconImage(icon);

		@SuppressWarnings("unused")
		Container contentPane = getContentPane();
		getContentPane().setLayout(null);

		/* ---------- ↓アプリタイトル名ラベル↓ ---------- */

		JLabel appTitleLabel = new JLabel(APPTITLE);
		appTitleLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.BOLD, 22));
		appTitleLabel.setBounds(40, 35, 446, 42);
		getContentPane().add(appTitleLabel);

		JLabel paramLabel = new JLabel("※＝必須パラメータ");
		paramLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		paramLabel.setBounds(373, 94, 122, 13);
		getContentPane().add(paramLabel);

		/* ---------- ↑アプリタイトル名ラベル↑ ---------- */

		/* ---------- ↓作成プロファイルチェックボックス↓ ---------- */

		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(new TitledBorder(new EtchedBorder(), "作成プロファイル",
				TitledBorder.LEFT, TitledBorder.TOP, new Font("ＭＳ Ｐゴシック",
						Font.PLAIN, 13), Color.BLACK));
		panel.setBounds(507, 10, 165, 97);
		getContentPane().add(panel);

		wifiCheckBox = new JCheckBox("Wi-Fi設定");
		wifiCheckBox.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		wifiCheckBox.setBounds(8, 22, 138, 21);
		panel.add(wifiCheckBox);

		exchangeCheckBox = new JCheckBox("Exchange設定");
		exchangeCheckBox.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		exchangeCheckBox.setBounds(8, 45, 138, 21);
		panel.add(exchangeCheckBox);

		vpnCheckBox = new JCheckBox("VPN設定");
		vpnCheckBox.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		vpnCheckBox.setBounds(8, 68, 138, 21);
		panel.add(vpnCheckBox);

		/* ---------- ↑作成プロファイルチェックボックス↑ ---------- */

		/* ---------- ↓タブレイアウト部分↓ ---------- */

		JTabbedPane tabLayout = new JTabbedPane(JTabbedPane.TOP);
		tabLayout.setBounds(12, 129, 660, 120);
		getContentPane().add(tabLayout);

		JPanel wifiPanel = new JPanel();
		tabLayout.addTab("Wi-Fi", null, wifiPanel, null);
		wifiPanel.setLayout(null);

		JLabel wifiParamLabel = new JLabel("Wi-Fiのパラメータ数");
		wifiParamLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		wifiParamLabel.setBounds(12, 22, 150, 13);
		wifiPanel.add(wifiParamLabel);

		wifiParamChoice = new Choice();
		wifiParamChoice.setBounds(185, 19, 381, 21);
		wifiPanel.add(wifiParamChoice);

		JPanel exchangePanel = new JPanel();
		tabLayout.addTab("Exchange", null, exchangePanel, null);
		exchangePanel.setLayout(null);

		JLabel exchangeParamLabel = new JLabel("Exchangeのパラメータ数");
		exchangeParamLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		exchangeParamLabel.setBounds(12, 22, 150, 13);
		exchangePanel.add(exchangeParamLabel);

		exchangeParamChoice = new Choice();
		exchangeParamChoice.setBounds(185, 19, 381, 21);
		exchangePanel.add(exchangeParamChoice);

		JPanel vpnPanel = new JPanel();
		tabLayout.addTab("VPN", null, vpnPanel, null);
		vpnPanel.setLayout(null);

		JLabel vpnParamLabel = new JLabel("VPNのパラメータ数");
		vpnParamLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		vpnParamLabel.setBounds(12, 22, 150, 13);
		vpnPanel.add(vpnParamLabel);

		vpnParamChoice = new Choice();
		vpnParamChoice.setBounds(185, 19, 381, 21);
		vpnPanel.add(vpnParamChoice);

		// 各項目のパラメータ数
		String[] params = { NONE, "1", "2", "3", "4", "5", "6", "7", "8", "9",
				"10" };
		for (int i = 0; i < params.length; i++) {
			wifiParamChoice.add(params[i]);
		}
		for (int i = 0; i < params.length; i++) {
			exchangeParamChoice.add(params[i]);
		}
		for (int i = 0; i < params.length; i++) {
			vpnParamChoice.add(params[i]);
		}

		/* ---------- ↑タブレイアウト部分↑ ---------- */

		/* ---------- ↓下部共通設定部分↓ ---------- */

		JLabel profileIDLabel = new JLabel("※プロファイルの識別子");
		profileIDLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileIDLabel.setBounds(12, 267, 150, 13);
		getContentPane().add(profileIDLabel);
		profileID = new JTextField(43);
		profileID.setBounds(185, 259, 410, 30);
		getContentPane().add(profileID);

		JLabel profileDescriptionLabel = new JLabel("プロファイルの説明");
		profileDescriptionLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileDescriptionLabel.setBounds(12, 308, 136, 13);
		getContentPane().add(profileDescriptionLabel);
		profileDescription = new JTextField(43);
		profileDescription.setBounds(185, 300, 410, 30);
		getContentPane().add(profileDescription);

		JLabel csvInputLabel = new JLabel("※CSV読み込み先");
		csvInputLabel.setBounds(12, 350, 136, 13);
		getContentPane().add(csvInputLabel);
		csvInputLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));

		csvInputText = new JTextField(43);
		csvInputText.setBounds(185, 342, 410, 30);
		getContentPane().add(csvInputText);

		JButton csvInputButton = new JButton("参照");
		csvInputButton.setBounds(607, 343, 65, 30);
		getContentPane().add(csvInputButton);
		csvInputButton.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		csvInputButton.setActionCommand("CSV読み込み");

		JLabel profileExportLabel = new JLabel("※プロファイル保存先");
		profileExportLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileExportLabel.setBounds(12, 382, 136, 30);
		getContentPane().add(profileExportLabel);
		profileExport = new JTextField(43);
		profileExport.setBounds(185, 383, 410, 30);
		getContentPane().add(profileExport);
		JButton profileExportBtn = new JButton("参照");
		profileExportBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileExportBtn.setBounds(607, 383, 65, 30);
		getContentPane().add(profileExportBtn);
		profileExportBtn.setActionCommand("プロファイル保存先");

		JButton profileCreateBtn = new JButton("プロファイル作成");
		profileCreateBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 15));
		profileCreateBtn.setBounds(119, 432, 456, 30);
		getContentPane().add(profileCreateBtn);
		profileCreateBtn.setActionCommand("プロファイル作成");

		/* ---------- ↑下部共通設定部分↑ ---------- */

		csvInputButton.addActionListener(this); // CSV読み込み先参照ボタン
		profileExportBtn.addActionListener(this); // プロファイル保存先フォルダ参照ボタン
		profileCreateBtn.addActionListener(this); // プロファイル作成ボタン
	}

	public void actionPerformed(ActionEvent e) {
		String str = e.getActionCommand();

		File file = null;
		JFileChooser filechooser = new JFileChooser();

		if (str.equals("CSV読み込み")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			// filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			// filechooser.setAcceptAllFileFilterUsed(false);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				csvInputText.setText(file.getPath());
			}
		} else if (str.equals("プロファイル保存先")) {
			filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				profileExport.setText(file.getPath());
			}
		} else if (str.equals("プロファイル作成")) {
			// エラー処理

			// どのチェックボックスも選択されていない場合
			if (!wifiCheckBox.isSelected() && !exchangeCheckBox.isSelected()
					&& !vpnCheckBox.isSelected()) {
				JLabel error = new JLabel("作成プロファイルが選択されていません");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// Wi-Fiの必須パラメータ未入力の場合
			if (wifiCheckBox.isSelected()
					&& wifiParamChoice.getSelectedItem().equals(NONE)) {
				JLabel error = new JLabel("Wi-Fiのパラメータ数を選択してください");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// Exchangeの必須パラメータ未入力の場合
			if (exchangeCheckBox.isSelected()
					&& exchangeParamChoice.getSelectedItem().equals(NONE)) {
				JLabel error = new JLabel("Exchangeのパラメータ数を選択してください");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// VPNの必須パラメータ未入力の場合
			if (vpnCheckBox.isSelected()
					&& vpnParamChoice.getSelectedItem().equals(NONE)) {
				JLabel label = new JLabel("VPNのパラメータ数を選択してください");
				JOptionPane.showMessageDialog(this, label);
				return;
			}

			if (profileID.getText().equals("")) {
				JLabel label = new JLabel("識別子を指定してください");
				JOptionPane.showMessageDialog(this, label);
				return;
			}

			if (csvInputText.getText().equals("")) {
				JLabel label = new JLabel("VPNのCSV読み込み先を指定してください");
				JOptionPane.showMessageDialog(this, label);
				return;
			}

			try {
				// プロファイル作成
				wepclipProfileCreate(csvInputText.getText());

				// 完了ダイアログ
				JLabel label = new JLabel("プロファイル作成完了！！【" + params + "件】");

				// プロファイル数カウントのクリア
				params = 0;
				JOptionPane.showMessageDialog(this, label);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
				JLabel error = new JLabel("存在しないフォルダが指定されています。");
				JOptionPane.showMessageDialog(this, error);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} catch (TransformerException e1) {
				e1.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
	}

	// 構成プロファイル生成
	private void wepclipProfileCreate(String fileName)
			throws ParserConfigurationException, FileNotFoundException,
			IOException, InterruptedException, TransformerException {

		Pattern pattern = Pattern.compile(",");
		List<String> colmuns = new ArrayList<String>();
		File csv = new File(fileName); // CSVデータファイル
		BufferedReader br = new BufferedReader(new FileReader(csv));

		// 一行目(ヘッダ行)を読み飛ばす
		br.readLine();

		// 最終行まで読み込む
		String line = "";

		while (br.ready()) {
			// リストのクリア
			colmuns.clear();

			// 1行分データを取得
			line = br.readLine();

			// 文字列の分割(split「-1」を指定で空白も読み込む)
			String[] strs = pattern.split(line, -1);

			// リストへの代入
			for (int i = 0; i < strs.length; i++) {
				colmuns.add(strs[i]);
			}

			// 構成プロファイルの吐き出し先
			String exportFileName = profileExport.getText() + "\\"
					+ String.valueOf(colmuns.get(0)) + ".mobileconfig";

			// 構成プロファイルを生成する
			// DOM Documentのインスタンスを生成するBuilderクラスの
			// インスタンスを取得する
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			// ビルダーからDOMを取得する
			Document document = builder.newDocument();

			// root(plist)タグ
			Element plist = document.createElement("plist");
			plist.setAttribute("version", "1.0");
			document.appendChild(plist);

			// dictタグ
			Element dict = document.createElement("dict");
			plist.appendChild(dict);

			// plistタグのパラメータ
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(
					OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC,
					"-//Apple//DTD PLIST 1.0//EN");
			transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
					"http://www.apple.com/DTDs/PropertyList-1.0.dtd");

			/* ------ 以下、構成プロファイルの中身 ------------ */

			// Wi-Fiのパラメータ数取得
			int wifiParamNum = ParamNumGenerate(wifiCheckBox, wifiParamChoice);

			// Exchangeのパラメータ数取得
			int exchangeParamNum = ParamNumGenerate(exchangeCheckBox,
					exchangeParamChoice);

			// VPNのパラメータ数取得
			int vpnParamNum = ParamNumGenerate(vpnCheckBox, vpnParamChoice);

			/*
			 * PayloadContent
			 * 
			 * ペイロードされるパラメータ
			 */
			Element PayloadContentKey = document.createElement("key");
			dict.appendChild(PayloadContentKey);

			Text PayloadContentParam = document
					.createTextNode("PayloadContent");
			PayloadContentKey.appendChild(PayloadContentParam);

			Element PayloadContentArray = document.createElement("array");
			dict.appendChild(PayloadContentArray);

			Common common = new Common();

			/* ---------- Wi-Fi設定パラメータここから ---------- */

			WiFi wifi = new WiFi();

			// Wi-Fiが選択されている場合、生成を行う
			if (wifiCheckBox.isSelected()) {

				List<String> wifiColmuns = new ArrayList<String>();

				// リストのクリア
				wifiColmuns.clear();

				// Wi-Fiパラメータ取得
				for (int i = 0; i < WIFIPARAMS * wifiParamNum; i++) {
					wifiColmuns.add(colmuns.get(i + 1));
				}

				for (int i = 0; i < wifiParamNum * WIFIPARAMS; i += WIFIPARAMS) {
					// 複数パラメータ対応
					// 必要なパラメータが入っていない場合にはスキップする
					Boolean isParamEmpty = wifiColmuns.get(0 + i).equals("")
							|| wifiColmuns.get(1 + i).equals("")
							|| wifiColmuns.get(2 + i).equals("");
					if (isParamEmpty) {
						// 何もしない
					} else {
						Element PayloadContentDict = document
								.createElement("dict");
						PayloadContentArray.appendChild(PayloadContentDict);

						wifi.WiFiAutoJoin(PayloadContentDict, document, true);

						wifi.WiFiEncryptionType(PayloadContentDict, document,
								WiFi.STRING, wifiColmuns.get(i + 2));

						wifi.WiFiHIDDEN_NETWORK(PayloadContentDict, document,
								false);

						wifi.WiFiPassword(PayloadContentDict, document,
								WiFi.STRING, wifiColmuns.get(i + 1));

						common.PayloadDescription(PayloadContentDict, document,
								Common.STRING,
								"Configures wireless connectivity settings.");

						common.PayloadDisplayName(PayloadContentDict, document,
								Common.STRING, "WiFi (" + colmuns.get(0) + ")");

						common.PayloadIdentifier(PayloadContentDict, document,
								Common.STRING,
								String.valueOf(profileID.getText()) + "."
										+ String.valueOf(params));

						common.PayloadOrganization(PayloadContentDict,
								document, Common.STRING, "");

						common.PayloadType(PayloadContentDict, document,
								WiFi.STRING, "com.apple.wifi.managed");

						common.PayloadUUID(PayloadContentDict, document,
								Common.STRING);

						common.PayloadVersion(PayloadContentDict, document,
								Common.INTEGER, "1");

						wifi.WiFiProxyType(PayloadContentDict, document,
								WiFi.STRING, "None");

						wifi.WiFiSSID_STR(PayloadContentDict, document,
								WiFi.STRING, wifiColmuns.get(i + 0));
					}

				}
			}

			/* ---------- Wi-Fi設定パラメータここまで ---------- */

			/* ---------- Exchange設定パラメータここから ---------- */

			Exchange exchange = new Exchange();
			// Exchangeが選択されている場合、生成を行う
			if (exchangeCheckBox.isSelected()) {

				List<String> exchangeColmuns = new ArrayList<String>();

				// リストのクリア
				exchangeColmuns.clear();

				// Exchangeパラメータ取得
				for (int i = WIFIPARAMS * wifiParamNum; i < (WIFIPARAMS * wifiParamNum)
						+ (EXCHANGEPARAMS * exchangeParamNum); i++) {
					exchangeColmuns.add(colmuns.get(i + 1));
				}

				for (int i = 0; i < exchangeParamNum * EXCHANGEPARAMS; i += EXCHANGEPARAMS) {
					// 複数パラメータ対応
					// 必要なパラメータが入っていない場合にはスキップする
					Boolean isParamEmpty = exchangeColmuns.get(0 + i)
							.equals("")
							|| exchangeColmuns.get(1 + i).equals("")
							|| exchangeColmuns.get(3 + i).equals("")
							|| exchangeColmuns.get(5 + i).equals("")
							|| exchangeColmuns.get(6 + i).equals("")
							|| exchangeColmuns.get(7 + i).equals("")
							|| exchangeColmuns.get(8 + i).equals("")
							|| exchangeColmuns.get(9 + i).equals("");
					if (isParamEmpty) {
						// 何もしない
					} else {
						Element PayloadContentDict2 = document
								.createElement("dict");
						PayloadContentArray.appendChild(PayloadContentDict2);

						exchange.ExchangeEmailAddress(PayloadContentDict2,
								document, Exchange.STRING,
								exchangeColmuns.get(i + 0));

						exchange.ExchangeHost(PayloadContentDict2, document,
								Exchange.STRING, exchangeColmuns.get(i + 1));

						exchange.ExchangeMailNumberOfPastDaysToSync(
								PayloadContentDict2, document,
								Exchange.INTEGER, exchangeColmuns.get(i + 5));

						exchange.ExchangePassword(PayloadContentDict2,
								document, Exchange.STRING,
								exchangeColmuns.get(i + 4));

						common.PayloadDescription(PayloadContentDict2,
								document, Common.STRING,
								"Configures device for use with Microsoft Exchange ActiveSync services.");

						common.PayloadDisplayName(PayloadContentDict2,
								document, Common.STRING,
								"Exchange (" + colmuns.get(0) + ")");

						common.PayloadIdentifier(PayloadContentDict2, document,
								Common.STRING,
								String.valueOf(profileID.getText()) + "."
										+ String.valueOf(params));

						common.PayloadOrganization(PayloadContentDict2,
								document, Common.STRING, "");

						common.PayloadType(PayloadContentDict2, document,
								WiFi.STRING, "com.apple.eas.account");

						common.PayloadUUID(PayloadContentDict2, document,
								Common.STRING);

						common.PayloadVersion(PayloadContentDict2, document,
								Common.INTEGER, "1");

						exchange.ExchangePreventAppSheet(PayloadContentDict2,
								document, exchangeColmuns.get(i + 9));

						exchange.ExchangePreventMove(PayloadContentDict2,
								document, exchangeColmuns.get(i + 7));

						exchange.ExchangeSMIMEEnabled(PayloadContentDict2,
								document, exchangeColmuns.get(i + 8));

						exchange.ExchangeSSL(PayloadContentDict2, document,
								exchangeColmuns.get(i + 6));

						exchange.ExchangeUserName(PayloadContentDict2,
								document, Exchange.STRING,
								exchangeColmuns.get(i + 2),
								exchangeColmuns.get(i + 3));

						exchange.ExchangeDisableMailRecentsSyncing(
								PayloadContentDict2, document, "false");

					}
				}
			}

			/* ---------- Exchange設定パラメータここまで ---------- */

			/* ---------- VPN設定パラメータここから ---------- */

			VPN vpn = new VPN();

			// VPNが選択されている場合、生成を行う
			if (vpnCheckBox.isSelected()) {

				List<String> vpnColmuns = new ArrayList<String>();

				// VPNのタイプの判定基準
				int VPNPARAMS = 0; // １つの接続タイプのパラメータ数
				// VPNの接続タイプを示す基点とパラメータ数を判定
				int vpnTypeNumTmp = (WIFIPARAMS * wifiParamNum)
						+ (EXCHANGEPARAMS * exchangeParamNum) + 1;

				// VPNは接続タイプによって数が異なるので、都度判定し、XML生成する
				for (int loopCnt = 0; loopCnt < vpnParamNum; loopCnt++) {

					// VPNのタイプを判定し、必要パラメータ数を代入する
					if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
						VPNPARAMS = L2TP_PASS_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
						VPNPARAMS = L2TP_RSA_NUM;
					} else if (colmuns.get(vpnTypeNumTmp)
							.equals(PPTP_PASS_AUTO)
							|| colmuns.get(vpnTypeNumTmp)
									.equals(PPTP_PASS_NONE)
							|| colmuns.get(vpnTypeNumTmp).equals(
									PPTP_PASS_MANUAL)) {
						VPNPARAMS = PPTP_PASS_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(PPTP_RSA_AUTO)
							|| colmuns.get(vpnTypeNumTmp).equals(PPTP_RSA_NONE)
							|| colmuns.get(vpnTypeNumTmp).equals(
									PPTP_RSA_MANUAL)) {
						VPNPARAMS = PPTP_RSA_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
						VPNPARAMS = IPSEC_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(
							CISCO_ANYCONNECT)) {
						VPNPARAMS = CISCO_ANYCONNECT_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(JUNIPER_SSL)) {
						VPNPARAMS = JUNIPER_SSL_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)) {
						VPNPARAMS = FS_SSL_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
						VPNPARAMS = SONICWALL_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)) {
						VPNPARAMS = ARUBA_VIA_NUM;
					} else if (colmuns.get(vpnTypeNumTmp).equals(CHECK_POINT)) {
						VPNPARAMS = CHECK_POINT_NUM;
					}

					// VPNのプロキシの有無を判定し、数を変える
					if (colmuns.get(vpnTypeNumTmp + 1).equals(PROXY_AUTO)) {
						VPNPARAMS += PROXY_AUTO_NUM;
					} else if (colmuns.get(vpnTypeNumTmp + 1)
							.equals(PROXY_NONE)) {
						VPNPARAMS += PROXY_NONE_NUM;
					} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
							PROXY_MANUAL)) {
						VPNPARAMS += PROXY_MANUAL_NUM;
					}

					// リストのクリア
					vpnColmuns.clear();

					// TODO テスト用
					System.out.println(String.valueOf(colmuns.get(VPNPARAMS)));

					// TODO テスト用
					for (int i = 0; i < colmuns.size(); i++) {
						System.out.println(String.valueOf(colmuns.get(i)));
					}

					// VPNのパラメータを抽出する
					for (int i = vpnTypeNumTmp + 2; i < vpnTypeNumTmp + 2
							+ VPNPARAMS; i++) {
						vpnColmuns.add(colmuns.get(i));
					}

					// TODO テスト用
					// for (int i = 0; i < vpnColmuns.size(); i++) {
					// System.out.println(String.valueOf(vpnColmuns.get(i)));
					// }

					// 複数パラメータ対応
					// 必要なパラメータが入っていない場合にはスキップする
					Boolean isParamEmpty = false;

					if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("")
								|| vpnColmuns.get(5).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(3).equals("")
								|| vpnColmuns.get(4).equals("");
					} else if (colmuns.get(vpnTypeNumTmp)
							.equals(PPTP_PASS_AUTO)
							|| colmuns.get(vpnTypeNumTmp)
									.equals(PPTP_PASS_NONE)
							|| colmuns.get(vpnTypeNumTmp).equals(
									PPTP_PASS_MANUAL)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(PPTP_RSA_AUTO)
							|| colmuns.get(vpnTypeNumTmp).equals(PPTP_RSA_NONE)
							|| colmuns.get(vpnTypeNumTmp).equals(
									PPTP_RSA_MANUAL)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(3).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("")
								|| vpnColmuns.get(5).equals("")
								|| vpnColmuns.get(6).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(
							CISCO_ANYCONNECT)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("")
								|| vpnColmuns.get(5).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(JUNIPER_SSL)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("")
								|| vpnColmuns.get(5).equals("")
								|| vpnColmuns.get(6).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("")
								|| vpnColmuns.get(5).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("");
					} else if (colmuns.get(vpnTypeNumTmp).equals(CHECK_POINT)) {
						isParamEmpty = vpnColmuns.get(0).equals("")
								|| vpnColmuns.get(1).equals("")
								|| vpnColmuns.get(2).equals("")
								|| vpnColmuns.get(4).equals("");
					}

					if (isParamEmpty) {
						// 何もしない
					} else {

						Element PayloadContentDict3 = document
								.createElement("dict");
						PayloadContentArray.appendChild(PayloadContentDict3);

						// EAP
						if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)
								|| colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_PASS_AUTO)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_PASS_NONE)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_PASS_MANUAL)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_AUTO)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_NONE)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_MANUAL)) {
							vpn.EAP(PayloadContentDict3, document);
						}

						// IPSec
						if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
							vpn.L2TP_IPSecRoot(PayloadContentDict3, document,
									"SharedSecret", vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
							vpn.L2TP_IPSecRoot(PayloadContentDict3, document,
									"SharedSecret", vpnColmuns.get(3));
						} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
							vpn.IPSec_IPSecRoot(PayloadContentDict3, document,
									"SharedSecret", vpnColmuns.get(7), "KeyID",
									vpnColmuns.get(3), vpnColmuns.get(6), "1",
									vpnColmuns.get(4), vpnColmuns.get(5));
						}

						// IPv4
						if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(5));
						} else if (colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_AUTO)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_NONE)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_MANUAL)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_AUTO)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(3));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_NONE)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(3));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_MANUAL)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(3));
						} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(6));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								CISCO_ANYCONNECT)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(5));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								JUNIPER_SSL)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(6));
						} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(5));
						} else if (colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								CHECK_POINT)) {
							vpn.IPv4(PayloadContentDict3, document,
									vpnColmuns.get(4));
						}

						// PPP
						if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
							vpn.L2TP_PPP_PassRoot(PayloadContentDict3,
									document, vpnColmuns.get(2),
									vpnColmuns.get(3), vpnColmuns.get(1));
						} else if (colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
							vpn.L2TP_PPP_NonPassRoot(PayloadContentDict3,
									document, "EAP-RSA", vpnColmuns.get(2),
									"EAP", vpnColmuns.get(1), true);
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_AUTO)) {
							vpn.PPTP_PPP_PassRoot(PayloadContentDict3,
									document, vpnColmuns.get(2),
									vpnColmuns.get(3), "1", "1", "1",
									vpnColmuns.get(1));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_NONE)) {
							vpn.PPTP_PPP_PassRoot(PayloadContentDict3,
									document, vpnColmuns.get(2),
									vpnColmuns.get(3), "0", "0", "0",
									vpnColmuns.get(1));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_MANUAL)) {
							vpn.PPTP_PPP_PassRoot(PayloadContentDict3,
									document, vpnColmuns.get(2),
									vpnColmuns.get(3), "1", "1", "0",
									vpnColmuns.get(1));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_AUTO)) {
							vpn.PPTP_PPP_NonPassRoot(PayloadContentDict3,
									document, "EAP-RSA", vpnColmuns.get(2),
									"EAP", "1", "1", "1", vpnColmuns.get(1),
									true);
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_NONE)) {
							vpn.PPTP_PPP_NonPassRoot(PayloadContentDict3,
									document, "EAP-RSA", vpnColmuns.get(2),
									"EAP", "0", "0", "0", vpnColmuns.get(1),
									true);
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_RSA_MANUAL)) {
							vpn.PPTP_PPP_NonPassRoot(PayloadContentDict3,
									document, "EAP-RSA", vpnColmuns.get(2),
									"EAP", "1", "1", "0", vpnColmuns.get(1),
									true);
						}

						common.PayloadDescription(PayloadContentDict3,
								document, Common.STRING,
								"Configures VPN settings, including authentication.");

						common.PayloadDisplayName(PayloadContentDict3,
								document, Common.STRING,
								"VPN (" + colmuns.get(0) + ")");

						common.PayloadIdentifier(PayloadContentDict3, document,
								Common.STRING,
								String.valueOf(profileID.getText()) + "."
										+ String.valueOf(params));

						common.PayloadOrganization(PayloadContentDict3,
								document, Common.STRING, "");

						common.PayloadType(PayloadContentDict3, document,
								WiFi.STRING, "com.apple.vpn.managed");

						common.PayloadUUID(PayloadContentDict3, document,
								Common.STRING);

						common.PayloadVersion(PayloadContentDict3, document,
								Common.INTEGER, "1");

						// Proxies
						// プロキシ設定の選択に応じて処理（XMLの中身を変える）
						if (colmuns.get(vpnTypeNumTmp + 1).equals(PROXY_NONE)) {
							vpn.ProxiesNone(PayloadContentDict3, document);
						} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
								PROXY_MANUAL)) {
							if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(7),
										vpnColmuns.get(6), vpnColmuns.get(9),
										vpnColmuns.get(8), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									L2TP_RSA)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(6),
										vpnColmuns.get(5), vpnColmuns.get(8),
										vpnColmuns.get(7), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									PPTP_PASS_AUTO)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_PASS_NONE)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_PASS_MANUAL)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(6),
										vpnColmuns.get(5), vpnColmuns.get(8),
										vpnColmuns.get(7), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									PPTP_RSA_AUTO)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_RSA_NONE)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_RSA_MANUAL)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(5),
										vpnColmuns.get(4), vpnColmuns.get(7),
										vpnColmuns.get(6), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(8),
										vpnColmuns.get(7), vpnColmuns.get(10),
										vpnColmuns.get(9), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									CISCO_ANYCONNECT)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(7),
										vpnColmuns.get(6), vpnColmuns.get(9),
										vpnColmuns.get(8), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									JUNIPER_SSL)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(8),
										vpnColmuns.get(7), vpnColmuns.get(10),
										vpnColmuns.get(9), "1");
							} else if (colmuns.get(vpnTypeNumTmp)
									.equals(FS_SSL)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(6),
										vpnColmuns.get(5), vpnColmuns.get(8),
										vpnColmuns.get(7), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									SONICWALL)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(7),
										vpnColmuns.get(6), vpnColmuns.get(9),
										vpnColmuns.get(8), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									ARUBA_VIA)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(6),
										vpnColmuns.get(5), vpnColmuns.get(8),
										vpnColmuns.get(7), "1");
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									CHECK_POINT)) {
								vpn.ProxiesManual(PayloadContentDict3,
										document, "1", vpnColmuns.get(6),
										vpnColmuns.get(5), vpnColmuns.get(8),
										vpnColmuns.get(7), "1");
							}
						} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
								PROXY_AUTO)) {
							if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(6));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									L2TP_RSA)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(5));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									PPTP_PASS_AUTO)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_PASS_NONE)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_PASS_MANUAL)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(5));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									PPTP_RSA_AUTO)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_RSA_NONE)
									|| colmuns.get(vpnTypeNumTmp).equals(
											PPTP_RSA_MANUAL)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(4));
							} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(7));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									CISCO_ANYCONNECT)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(6));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									JUNIPER_SSL)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(7));
							} else if (colmuns.get(vpnTypeNumTmp)
									.equals(FS_SSL)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(5));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									SONICWALL)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(6));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									ARUBA_VIA)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(5));
							} else if (colmuns.get(vpnTypeNumTmp).equals(
									CHECK_POINT)) {
								vpn.ProxiesAuto(PayloadContentDict3, document,
										"1", vpnColmuns.get(5));
							}
						}

						vpn.UserDefinedName(PayloadContentDict3, document,
								vpnColmuns.get(0));

						// VPNType
						if (colmuns.get(vpnTypeNumTmp).equals(L2TP_PASS)
								|| colmuns.get(vpnTypeNumTmp).equals(L2TP_RSA)) {
							vpn.VPNType(PayloadContentDict3, document, "L2TP");
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								PPTP_PASS_AUTO)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_PASS_NONE)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_PASS_MANUAL)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_AUTO)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_NONE)
								|| colmuns.get(vpnTypeNumTmp).equals(
										PPTP_RSA_MANUAL)) {
							vpn.VPNType(PayloadContentDict3, document, "PPTP");
						} else if (colmuns.get(vpnTypeNumTmp).equals(IPSEC)) {
							vpn.VPNType(PayloadContentDict3, document, "IPSec");
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								CISCO_ANYCONNECT)
								|| colmuns.get(vpnTypeNumTmp).equals(
										JUNIPER_SSL)
								|| colmuns.get(vpnTypeNumTmp).equals(FS_SSL)
								|| colmuns.get(vpnTypeNumTmp).equals(SONICWALL)
								|| colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)
								|| colmuns.get(vpnTypeNumTmp).equals(
										CHECK_POINT)) {
							vpn.VPNType(PayloadContentDict3, document, "VPN");
						}

						// VPN
						if (colmuns.get(vpnTypeNumTmp).equals(CISCO_ANYCONNECT)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								JUNIPER_SSL)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						} else if (colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								CHECK_POINT)) {
							if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_NONE)) {
								vpn.VPNRoot(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"Password", vpnColmuns.get(1));
							} else if (colmuns.get(vpnTypeNumTmp + 1).equals(
									PROXY_AUTO)
									|| colmuns.get(vpnTypeNumTmp + 1).equals(
											PROXY_MANUAL)) {
								vpn.VPNRootProxy(PayloadContentDict3, document,
										vpnColmuns.get(2), vpnColmuns.get(3),
										"", "Password", vpnColmuns.get(1));
							}
						}

						// VPNSubType
						if (colmuns.get(vpnTypeNumTmp).equals(CISCO_ANYCONNECT)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"com.cisco.anyconnect.applevpn.plugin");
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								JUNIPER_SSL)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"net.juniper.sslvpn");
						} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"com.apple.vpn.managed");
						} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"com.sonicwall.SonicWALL-SSLVPN.vpnplugin");
						} else if (colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"com.arubanetworks.aruba-via.vpnplugin");
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								CHECK_POINT)) {
							vpn.VPNSubType(PayloadContentDict3, document,
									"com.checkpoint.CheckPoint-VPN.vpnplugin");
						}

						if (colmuns.get(vpnTypeNumTmp).equals(CISCO_ANYCONNECT)) {
							vpn.VendorConfig_AnyConnect(PayloadContentDict3,
									document, vpnColmuns.get(4));
						} else if (colmuns.get(vpnTypeNumTmp).equals(
								JUNIPER_SSL)) {
							vpn.VendorConfig_Juniper(PayloadContentDict3,
									document, vpnColmuns.get(4),
									vpnColmuns.get(5));
						} else if (colmuns.get(vpnTypeNumTmp).equals(FS_SSL)
								|| colmuns.get(vpnTypeNumTmp).equals(ARUBA_VIA)
								|| colmuns.get(vpnTypeNumTmp).equals(
										CHECK_POINT)) {
							vpn.VendorConfig(PayloadContentDict3, document);
						} else if (colmuns.get(vpnTypeNumTmp).equals(SONICWALL)) {
							vpn.VendorConfig_SonicWall(PayloadContentDict3,
									document, vpnColmuns.get(4));
						}

						// TODO テスト用
						System.out.println(String.valueOf("before:"
								+ vpnTypeNumTmp));

						// 現在のパラメータ数を更新する
						vpnTypeNumTmp += VPNPARAMS + 2;

						// TODO テスト用
						System.out.println(String.valueOf("after:"
								+ vpnTypeNumTmp));
					}
				}
			}

			/* ---------- VPN設定パラメータここまで ---------- */

			description = profileDescription.getText();
			common.PayloadDescription(dict, document, Common.STRING,
					description);

			// プロファイル名に電話番号がつく
			displayName = colmuns.get(0);
			// プロファイル名がついていない場合は自動的に名前をつける
			if (displayName.equals("")) {
				displayName = "WebClip";
			}
			common.PayloadDisplayName(dict, document, Common.STRING,
					displayName);

			identifier = profileID.getText();
			common.PayloadIdentifier(dict, document, Common.STRING, identifier);

			common.PayloadOrganization(dict, document, Common.STRING, "");

			common.PayloadRemovalDisallowed(dict, document, deleteProfile);

			common.PayloadType(dict, document, Common.STRING, "Configuration");

			common.PayloadUUID(dict, document, Common.STRING);

			common.PayloadVersion(dict, document, Common.INTEGER, "1");

			/* ------ 以上、構成プロファイルの中身 ------------ */

			DOMSource source = new DOMSource(document);
			File newXML = new File(exportFileName);
			FileOutputStream os = new FileOutputStream(newXML);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);
			os.close();

			// プロファイル数のインクリメント
			params++;

		}
		br.close();
	}

	// ドロップダウンリストから数値への変換メソッド
	public int ParamNumGenerate(JCheckBox paramChk, Choice paramNum) {
		String param = paramNum.getSelectedItem();
		// チェックボックスがついていなければ、そもそも必ず0にすることと、
		// 「★選択してください（デフォルト）」となっている場合は、0とする
		// それ以外の場合には数値をそのまま取り出し、値を返す
		if (!paramChk.isSelected() || param.equals(NONE)) {
			return 0;
		} else {
			return Integer.valueOf(paramNum.getSelectedItem());
		}
	}
}