package com.mxmobiling.kitting;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WebClip {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";

	public WebClip() {
	}

	/*
	 * URL
	 * 
	 * Webクリップのジャンプ先URL
	 */
	public void WebclipURL(Element PayloadContentDict, Document document,
			String valueType, String URL) {
		Element URLKey = document.createElement("key");
		PayloadContentDict.appendChild(URLKey);

		Text URLKeyParam = document.createTextNode("URL");
		URLKey.appendChild(URLKeyParam);

		Element URLString = document.createElement(valueType);
		PayloadContentDict.appendChild(URLString);

		Text URLStringParam = document.createTextNode(URL);
		URLString.appendChild(URLStringParam);
	}

	// アイコン画像をBase64エンコードする
	@SuppressWarnings("rawtypes")
	public String encodeBase64(String fileName) throws IOException,
			InterruptedException {
		URL iconUrl = getClass().getClassLoader().getResource(fileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(fileName).getImage();

		// java.awt.MediaTracker でロードを待機
		MediaTracker tracker = new MediaTracker(new Component() {

			private static final long serialVersionUID = 1L;
		});
		tracker.addImage(icon, 0);
		tracker.waitForAll();

		PixelGrabber pixelGrabber = new PixelGrabber(icon, 0, 0, -1, -1, false);
		pixelGrabber.grabPixels();
		ColorModel cm = pixelGrabber.getColorModel();

		final int w = pixelGrabber.getWidth();
		final int h = pixelGrabber.getHeight();
		WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
		BufferedImage renderedImage = new BufferedImage(cm, raster,
				cm.isAlphaPremultiplied(), new Hashtable());
		renderedImage.getRaster().setDataElements(0, 0, w, h,
				pixelGrabber.getPixels());

		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		BufferedOutputStream os = new BufferedOutputStream(bos);
		renderedImage.flush();
		ImageIO.write(renderedImage, "png", os);
		os.flush();
		os.close();

		byte[] inStrByte = bos.toByteArray();

		// 文字列をBase64にエンコード
		byte[] outStrBtye = Base64.encodeBase64(inStrByte);

		// Base64にエンコードした結果を出力
		String sOutStr = new String(outStrBtye);

		return sOutStr;
	}

	/*
	 * Icon
	 * 
	 * Webクリップのアイコン
	 */
	public void WebclipIcon(Element PayloadContentDict, Document document,
			String valueType, String imgName) throws IOException,
			InterruptedException {
		Element IconKey = document.createElement("key");
		PayloadContentDict.appendChild(IconKey);

		Text IconKeyParam = document.createTextNode("Icon");
		IconKey.appendChild(IconKeyParam);

		Element IconString = document.createElement(valueType);
		PayloadContentDict.appendChild(IconString);

		Text IconStringParam = document.createTextNode(String
				.valueOf(encodeBase64(imgName)));
		IconString.appendChild(IconStringParam);
	}

	/*
	 * Label
	 * 
	 * ホーム画面に表示されるWebクリップの名前
	 */
	public void WebclipLabel(Element PayloadContentDict, Document document,
			String valueType, String label) {
		Element LabelKey = document.createElement("key");
		PayloadContentDict.appendChild(LabelKey);

		Text LabelKeyParam = document.createTextNode("Label");
		LabelKey.appendChild(LabelKeyParam);

		Element LabelString = document.createElement(valueType);
		PayloadContentDict.appendChild(LabelString);

		Text LabelStringParam = document.createTextNode(label);
		LabelString.appendChild(LabelStringParam);
	}

	/*
	 * IsRemovable
	 * 
	 * Webクリップの削除可否
	 */
	public void WebcilpIsRemovable(Element PayloadContentDict,
			Document document, Boolean isRemovable) {
		Element IsRemovableKey = document.createElement("key");
		PayloadContentDict.appendChild(IsRemovableKey);

		Text IsRemovableParam = document.createTextNode("IsRemovable");
		IsRemovableKey.appendChild(IsRemovableParam);

		Element IsRemovableParamString = document.createElement(String
				.valueOf(isRemovable));
		PayloadContentDict.appendChild(IsRemovableParamString);
	}
}
