package com.mxmobiling.kitting;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class WebClipGUIVer3 extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;
	private static final String APPTITLE = "作業用構成プロファイル作成ツール　Ver 3.3.0";

	private String lastDirPath = "lib/lastdir.txt";

	private String displayName = ""; // プロファイル名
	private String description = ""; // プロファイルの説明

	private Boolean deleteProfile = false; // プロファイル削除可否

	private JRadioButton noneNumRb;
	private JRadioButton existNumRb;
	private ButtonGroup numBtnGrp;
	private JCheckBox gatWifiChk;
	private JCheckBox d08WifiChk;
	private JCheckBox mpcWifiChk;
	private JCheckBox stsWifiChk;
	private JCheckBox inputClipChk;
	private JCheckBox webClipChk;
	private JCheckBox smsmClipChk;
	private JCheckBox gmailChk;

	private JTextField profileNameText;
	private JTextField profileDescriptionText;
	private JTextField profileSaveText;

	private JTextField inputClipText;
	private JTextField webClipText;
	private JTextField smsmCompanyCodeText;
	private JTextField smsmAuthCodeText;
	private JTextField gmailAddressText;
	private JTextField gmailPasswordText;
	private JTextField fileNameText;

	public static void main(String args[]) {
		WebClipGUIVer3 frame = new WebClipGUIVer3(APPTITLE);
		frame.setVisible(true);
		frame.setResizable(false);
		frame.setLocationRelativeTo(null);
	}

	WebClipGUIVer3(String title) {
		setTitle(title);
		setSize(700, 550);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// アイコンファイルの読み込み
		String iconFileName = "img/icon.png";
		URL iconUrl = this.getClass().getClassLoader()
				.getResource(iconFileName);

		Image icon = (iconUrl != null) ? new ImageIcon(iconUrl).getImage()
				: new ImageIcon(iconFileName).getImage();
		setIconImage(icon);

		/* ---------- ↓アプリタイトル名ラベル↓ ---------- */
		getContentPane().setLayout(null);

		// タイトルロゴ
		String logoFileName = "logo.png";
		ClassLoader loader = this.getClass().getClassLoader();
		URL resUrl = loader.getResource(logoFileName);
		ImageIcon titleIcon = new ImageIcon(resUrl);
		JLabel lblGazou = new JLabel(titleIcon);
		lblGazou.setBounds(12, 13, 198, 120);
		getContentPane().add(lblGazou);

		JLabel label = new JLabel("※＝必須パラメータ");
		label.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		label.setBounds(552, 143, 120, 13);
		getContentPane().add(label);

		/* ---------- ↑アプリタイトル名ラベル↑ ---------- */

		/* ---------- ↓メニューバー↓ ---------- */

		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		JMenu files = new JMenu("ファイル");
		menuBar.add(files);
		JMenuItem open = new JMenuItem("開く");
		open.setActionCommand("開く");
		files.add(open);
		JMenuItem overwriteSave = new JMenuItem("上書き保存");
		overwriteSave.setActionCommand("上書き保存");
		files.add(overwriteSave);
		JMenuItem saveAs = new JMenuItem("名前をつけて保存");
		saveAs.setActionCommand("名前をつけて保存");
		files.add(saveAs);
		JMenuItem quit = new JMenuItem("終了");
		quit.setActionCommand("終了");
		files.add(quit);

		/* ---------- ↑Wi-Fiプロファイルチェックボックス↑ ---------- */

		/* ---------- ↓作成プロファイルチェックボックス↓ ---------- */

		@SuppressWarnings("unused")
		Container contentPane = getContentPane();

		JPanel createProfileLabel = new JPanel();
		createProfileLabel.setBounds(222, 10, 450, 123);
		createProfileLabel.setBorder(new TitledBorder(new EtchedBorder(),
				"作成プロファイル", TitledBorder.LEFT, TitledBorder.TOP, new Font(
						"ＭＳ Ｐゴシック", Font.PLAIN, 13), Color.BLACK));
		getContentPane().add(createProfileLabel);
		createProfileLabel.setLayout(null);

		noneNumRb = new JRadioButton("数字ラベルなし", true);
		noneNumRb.setBounds(8, 22, 113, 21);
		createProfileLabel.add(noneNumRb);
		noneNumRb.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));

		existNumRb = new JRadioButton("数字ラベルあり");
		existNumRb.setBounds(8, 45, 113, 21);
		createProfileLabel.add(existNumRb);
		existNumRb.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));

		numBtnGrp = new ButtonGroup();
		numBtnGrp.add(noneNumRb);
		numBtnGrp.add(existNumRb);

		gatWifiChk = new JCheckBox("2ndguests(GAT)");
		gatWifiChk.setBounds(150, 22, 138, 21);
		createProfileLabel.add(gatWifiChk);
		gatWifiChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		gatWifiChk.setSelected(true);	// 20141023 初期値ONに変更

		d08WifiChk = new JCheckBox("kddisupport(GAT)");
		d08WifiChk.setBounds(150, 45, 138, 21);
		createProfileLabel.add(d08WifiChk);
		d08WifiChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		d08WifiChk.setSelected(true);	// 20141023 初期値ONに変更

		mpcWifiChk = new JCheckBox("0ST001mpc(平和島)");
		mpcWifiChk.setBounds(150, 68, 138, 21);
		createProfileLabel.add(mpcWifiChk);
		mpcWifiChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		mpcWifiChk.setSelected(true);	// 20141023 初期値ONに変更

		stsWifiChk = new JCheckBox("xxxx,yyyy,zzzz(場外)");
		stsWifiChk.setBounds(150, 91, 138, 21);
		createProfileLabel.add(stsWifiChk);
		stsWifiChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));

		inputClipChk = new JCheckBox("入力支援Webクリップ");
		inputClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		inputClipChk.setBounds(292, 22, 138, 21);
		createProfileLabel.add(inputClipChk);

		webClipChk = new JCheckBox("Webサイトショートカット");
		webClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		webClipChk.setBounds(292, 45, 138, 21);
		createProfileLabel.add(webClipChk);

		smsmClipChk = new JCheckBox("SMSM用JavaScript");
		smsmClipChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		smsmClipChk.setBounds(292, 68, 138, 21);
		createProfileLabel.add(smsmClipChk);

		gmailChk = new JCheckBox("作業用Gmailアドレス");
		gmailChk.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 11));
		gmailChk.setBounds(292, 91, 138, 21);
		createProfileLabel.add(gmailChk);

		/* ---------- ↑作成プロファイルチェックボックス↑ ---------- */

		/* ---------- ↓作成プロファイルタブ↓ ---------- */

		JTabbedPane tabLayout = new JTabbedPane(JTabbedPane.TOP);
		tabLayout.setBounds(12, 143, 660, 123);
		getContentPane().add(tabLayout);

		JPanel inputClipPanel = new JPanel();
		tabLayout.addTab("入力支援", null, inputClipPanel, null);
		tabLayout.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 15));
		inputClipPanel.setBackground(Color.WHITE);
		inputClipPanel.setLayout(null);

		JLabel inputClipLabel = new JLabel("※CSV読み込み先");
		inputClipLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		inputClipLabel.setBounds(12, 10, 110, 30);
		inputClipPanel.add(inputClipLabel);

		inputClipText = new JTextField(50);
		inputClipText.setBounds(134, 11, 430, 30);
		inputClipPanel.add(inputClipText);

		JButton inputClipBtn = new JButton("参照");
		inputClipBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		inputClipBtn.setActionCommand("入力支援CSV");
		inputClipBtn.setBounds(578, 10, 65, 30);
		inputClipPanel.add(inputClipBtn);

		JPanel webClipPanel = new JPanel();
		tabLayout.addTab("Webサイト", null, webClipPanel, null);
		webClipPanel.setBackground(Color.WHITE);
		webClipPanel.setLayout(null);

		JLabel webClipLabel = new JLabel("※CSV読み込み先");
		webClipLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		webClipLabel.setBounds(12, 10, 110, 30);
		webClipPanel.add(webClipLabel);

		webClipText = new JTextField(50);
		webClipText.setBounds(134, 11, 430, 30);
		webClipPanel.add(webClipText);

		JButton webClipBtn = new JButton("参照");
		webClipBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		webClipBtn.setActionCommand("WebクリップCSV");
		webClipBtn.setBounds(578, 10, 65, 30);
		webClipPanel.add(webClipBtn);

		JPanel smsmPanel = new JPanel();
		tabLayout.addTab("SMSM", null, smsmPanel, null);
		smsmPanel.setBackground(Color.WHITE);
		smsmPanel.setLayout(null);

		JLabel smsmCompanyCodeLabel = new JLabel("※企業コード");
		smsmCompanyCodeLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		smsmCompanyCodeLabel.setBounds(12, 10, 100, 30);
		smsmPanel.add(smsmCompanyCodeLabel);

		JLabel smsmAuthCodeLabel = new JLabel("※認証コード");
		smsmAuthCodeLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		smsmAuthCodeLabel.setBounds(12, 50, 100, 30);
		smsmPanel.add(smsmAuthCodeLabel);

		smsmCompanyCodeText = new JTextField(50);
		smsmCompanyCodeText.setBounds(124, 11, 507, 30);
		smsmPanel.add(smsmCompanyCodeText);

		smsmAuthCodeText = new JTextField(50);
		smsmAuthCodeText.setBounds(124, 51, 507, 30);
		smsmPanel.add(smsmAuthCodeText);

		JPanel gmailPanel = new JPanel();
		tabLayout.addTab("作業用Gmail", null, gmailPanel, null);
		gmailPanel.setBackground(Color.WHITE);
		gmailPanel.setLayout(null);

		JLabel gmailAddressLabel = new JLabel("※Gmailアドレス");
		gmailAddressLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		gmailAddressLabel.setBounds(12, 10, 100, 30);
		gmailPanel.add(gmailAddressLabel);

		JLabel gmailPasswordLabel = new JLabel("パスワード");
		gmailPasswordLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		gmailPasswordLabel.setBounds(12, 50, 100, 30);
		gmailPanel.add(gmailPasswordLabel);

		gmailAddressText = new JTextField(50);
		gmailAddressText.setBounds(124, 11, 507, 30);
		gmailPanel.add(gmailAddressText);

		gmailPasswordText = new JTextField(50);
		gmailPasswordText.setBounds(124, 51, 507, 30);
		gmailPanel.add(gmailPasswordText);

		/* ---------- ↑作成プロファイルタブ↑ ---------- */

		/* ---------- ↓プロファイル基本情報↓ ---------- */

		JLabel fileNameLabel = new JLabel("※ファイル名");
		fileNameLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		fileNameLabel.setBounds(11, 276, 140, 30);
		getContentPane().add(fileNameLabel);
		fileNameText = new JTextField(50);
		fileNameText.setBounds(146, 276, 526, 30);
		getContentPane().add(fileNameText);

		JLabel profileNameLabel = new JLabel("プロファイル名");
		profileNameLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileNameLabel.setBounds(11, 315, 140, 30);
		getContentPane().add(profileNameLabel);
		profileNameText = new JTextField(50);
		profileNameText.setBounds(146, 316, 526, 30);
		getContentPane().add(profileNameText);

		JLabel profileDescriptionLabel = new JLabel("プロファイルの説明");
		profileDescriptionLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileDescriptionLabel.setBounds(11, 355, 140, 30);
		getContentPane().add(profileDescriptionLabel);
		profileDescriptionText = new JTextField(50);
		profileDescriptionText.setBounds(146, 356, 526, 30);
		getContentPane().add(profileDescriptionText);

		JLabel profileSaveLabel = new JLabel("※プロファイル保存先");
		profileSaveLabel.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileSaveLabel.setBounds(11, 396, 140, 30);
		getContentPane().add(profileSaveLabel);
		profileSaveText = new JTextField(43);
		profileSaveText.setBounds(146, 397, 450, 30);
		getContentPane().add(profileSaveText);

		JButton profileSaveBtn = new JButton("参照");
		profileSaveBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileSaveBtn.setBounds(606, 396, 65, 30);
		getContentPane().add(profileSaveBtn);
		profileSaveBtn.setActionCommand("プロファイル保存先");

		JButton profileCreateBtn = new JButton("プロファイル作成");
		profileCreateBtn.setFont(new Font("ＭＳ Ｐゴシック", Font.PLAIN, 13));
		profileCreateBtn.setBounds(68, 450, 553, 30);
		getContentPane().add(profileCreateBtn);
		profileCreateBtn.setActionCommand("プロファイル作成");

		/* ---------- ↑プロファイル基本情報↑ ---------- */

		// ボタン押下時のリスナー
		open.addActionListener(this); // メニューの開くボタン
		overwriteSave.addActionListener(this); // メニューの上書き保存ボタン
		saveAs.addActionListener(this); // メニューの名前をつけて保存ボタン
		quit.addActionListener(this); // メニューの終了ボタン
		inputClipBtn.addActionListener(this); // 入力支援クリップCSV参照ボタン
		webClipBtn.addActionListener(this); // WebクリップCSV参照ボタン
		profileSaveBtn.addActionListener(this); // プロファイル作成ボタン
		profileCreateBtn.addActionListener(this); // プロファイル保存先フォルダ参照ボタン
	}

	// 最後に使ったパスを格納
	String lastOpenOrSavePath = "";

	public void actionPerformed(ActionEvent e) {
		String str = e.getActionCommand();

		File file = null;
		JFileChooser filechooser = new JFileChooser();

		// カレントディレクトリを最後に開いたフォルダとし、
		// テキストファイルに記録されているパスを読み込む
		try {
			FileReader in = new FileReader(lastDirPath);
			BufferedReader br = new BufferedReader(in);
			String line;
			while ((line = br.readLine()) != null) {
				File currentDir = new File(line);
				filechooser.setCurrentDirectory(currentDir);
			}
			br.close();
			in.close();
		} catch (IOException err) {
			System.out.println(err);
		}

		// メニュー内のボタンクリック時の動作
		if (str.equals("開く")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"workprofファイル(*.workprof)", "workprof");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 読み込むパラメータの準備
				List<String> workfile = WorkProfOpen(file.getPath());

				// 入力支援CSVのパスをセットする
				inputClipChk.setSelected(Boolean.valueOf(workfile.get(0)));
				webClipChk.setSelected(Boolean.valueOf(workfile.get(1)));
				smsmClipChk.setSelected(Boolean.valueOf(workfile.get(2)));
				gmailChk.setSelected(Boolean.valueOf(workfile.get(3)));
				inputClipText.setText(workfile.get(4));
				webClipText.setText(workfile.get(5));
				smsmCompanyCodeText.setText(workfile.get(6));
				smsmAuthCodeText.setText(workfile.get(7));
				gmailAddressText.setText(workfile.get(8));
				gmailPasswordText.setText(workfile.get(9));
				fileNameText.setText(workfile.get(10));
				profileNameText.setText(workfile.get(11));
				profileDescriptionText.setText(workfile.get(12));
				profileSaveText.setText(workfile.get(13));
				gatWifiChk.setSelected(Boolean.valueOf(workfile.get(14)));
				d08WifiChk.setSelected(Boolean.valueOf(workfile.get(15)));
				mpcWifiChk.setSelected(Boolean.valueOf(workfile.get(16)));
				stsWifiChk.setSelected(Boolean.valueOf(workfile.get(17)));

				// 最後に開いたフォルダを更新
				CurrentDir(file.getParent());

				// 最後に開いたファイルを更新
				lastOpenOrSavePath = file.getPath();
			}
		} else if (str.equals("上書き保存") && !lastOpenOrSavePath.equals("")) {
			// 書き出すパラメータの準備
			ArrayList<String> workfile = new ArrayList<String>();

			workfile.add(String.valueOf(inputClipChk.isSelected()));
			workfile.add(String.valueOf(webClipChk.isSelected()));
			workfile.add(String.valueOf(smsmClipChk.isSelected()));
			workfile.add(String.valueOf(gmailChk.isSelected()));
			workfile.add(inputClipText.getText());
			workfile.add(webClipText.getText());
			workfile.add(smsmCompanyCodeText.getText());
			workfile.add(smsmAuthCodeText.getText());
			workfile.add(gmailAddressText.getText());
			workfile.add(gmailPasswordText.getText());
			workfile.add(fileNameText.getText());
			workfile.add(profileNameText.getText());
			workfile.add(profileDescriptionText.getText());
			workfile.add(profileSaveText.getText());
			workfile.add(String.valueOf(gatWifiChk.isSelected()));
			workfile.add(String.valueOf(d08WifiChk.isSelected()));
			workfile.add(String.valueOf(mpcWifiChk.isSelected()));
			workfile.add(String.valueOf(stsWifiChk.isSelected()));

			// ファイルの保存
			WorkProfSave(lastOpenOrSavePath, workfile);
		} else if (str.equals("名前をつけて保存")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"workprofファイル(*.workprof)", "workprof");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showSaveDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 書き出すパラメータの準備
				ArrayList<String> workfile = new ArrayList<String>();

				workfile.add(String.valueOf(inputClipChk.isSelected()));
				workfile.add(String.valueOf(webClipChk.isSelected()));
				workfile.add(String.valueOf(smsmClipChk.isSelected()));
				workfile.add(String.valueOf(gmailChk.isSelected()));
				workfile.add(inputClipText.getText());
				workfile.add(webClipText.getText());
				workfile.add(smsmCompanyCodeText.getText());
				workfile.add(smsmAuthCodeText.getText());
				workfile.add(gmailAddressText.getText());
				workfile.add(gmailPasswordText.getText());
				workfile.add(fileNameText.getText());
				workfile.add(profileNameText.getText());
				workfile.add(profileDescriptionText.getText());
				workfile.add(profileSaveText.getText());
				workfile.add(String.valueOf(gatWifiChk.isSelected()));
				workfile.add(String.valueOf(d08WifiChk.isSelected()));
				workfile.add(String.valueOf(mpcWifiChk.isSelected()));
				workfile.add(String.valueOf(stsWifiChk.isSelected()));

				// ファイルの保存
				WorkProfSave(file.getPath() + ".workprof", workfile);

				// 最後に開いたフォルダを更新
				CurrentDir(file.getParent());

				// 最後に保存したファイルを更新
				lastOpenOrSavePath = file.getPath() + ".workprof";
			}
		} else if (str.equals("終了")) {
			System.exit(0);
		}

		// メニュー以外のボタンクリック時の動作
		if (str.equals("入力支援CSV")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// 入力支援CSVのパスをセットする
				inputClipText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("WebクリップCSV")) {
			FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"CSVファイル(*.csv)", "csv");
			filechooser.addChoosableFileFilter(filter);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// WebサイトCSVのパスをセットする
				webClipText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("プロファイル保存先")) {
			filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int selected = filechooser.showOpenDialog(this);
			file = filechooser.getSelectedFile();

			if (selected == JFileChooser.APPROVE_OPTION) {
				// プロファイル保存先のパスをセットする
				profileSaveText.setText(file.getPath());

				// 最後に開いたフォルダを更新
				CurrentDir(file.getPath());
			}
		} else if (str.equals("プロファイル作成")) {
			/* ---------- エラー処理（入力漏れ等）ここから ---------- */

			// どのチェックボックスも選択されていない場合
			if (!inputClipChk.isSelected() && !webClipChk.isSelected()
					&& !smsmClipChk.isSelected() && !gmailChk.isSelected()) {
				JLabel error = new JLabel("作成プロファイルが選択されていません");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// 入力支援の必須パラメータ未入力の場合
			if (inputClipChk.isSelected() && inputClipText.getText().equals("")) {
				JLabel error = new JLabel("入力支援の必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// Webサイトの必須パラメータ未入力の場合
			if (webClipChk.isSelected() && webClipText.getText().equals("")) {
				JLabel error = new JLabel("Webサイトの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// SMSMクリップの必須パラメータ未入力の場合
			if (smsmClipChk.isSelected()
					&& (smsmCompanyCodeText.getText().equals("") || smsmAuthCodeText
							.getText().equals(""))) {
				JLabel error = new JLabel("SMSMの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// 作業用Gmailアドレスの必須パラメータ未入力の場合
			if (gmailChk.isSelected()
					&& (gmailAddressText.getText().equals(""))) {
				JLabel error = new JLabel("作業用Gmailの必須パラメータが未入力です");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			// ファイル名、プロファイル保存先が未指定の場合
			if (fileNameText.getText().equals("")
					|| profileSaveText.getText().equals("")) {
				JLabel error = new JLabel("【ファイル名】と【プロファイル保存先】を指定してください");
				JOptionPane.showMessageDialog(this, error);
				return;
			}

			/* ---------- エラー処理（入力漏れ等）ここまで ---------- */

			// プロファイル生成
			try {
				wepclipProfileCreate();
				JLabel label = new JLabel("プロファイル作成完了！！");
				JOptionPane.showMessageDialog(this, label);
				// 20141023 入力項目の初期化
				clearContents();
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			} catch (FileNotFoundException e1) {
				// おかしなパラメータが入力されている場合
				JLabel error = new JLabel("存在しないフォルダが指定されています。");
				JOptionPane.showMessageDialog(this, error);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			} catch (TransformerException e1) {
				e1.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
	}

	// 構成プロファイル生成
	private void wepclipProfileCreate() throws ParserConfigurationException,
			IOException, InterruptedException, TransformerException {

		// インスタンスの生成
		Common common = new Common();
		WiFi wifi = new WiFi();
		WebClip webClip = new WebClip();
		Email email = new Email();

		// 入力支援ブランク用画像の読み込み
		String imgName1 = "img/icon1.png";

		// 入力支援本体用画像の読み込み
		String imgName2 = "img/icon2.png";

		// Webサイト本体用画像の読み込み
		String imgName3 = "img/icon3.png";

		String[] iconImages = { imgName1, imgName2, imgName3 };

		// SMSM用JavaScript画像
		String smsmImg = "img/smsm.png";

		// ファイル名反映
		String fileName = fileNameText.getText();

		// 構成プロファイルの吐き出し先
		String exportFileName = profileSaveText.getText() + "\\" + fileName
				+ ".mobileconfig";

		/* ----- 構成プロファイルを生成する ----- */

		// DOM Documentのインスタンスを生成するBuilderクラスの
		// インスタンスを取得する
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		// ビルダーからDOMを取得する
		Document document = builder.newDocument();

		// root(plist)タグ
		Element plist = document.createElement("plist");
		plist.setAttribute("version", "1.0");
		document.appendChild(plist);

		// dictタグ
		Element dict = document.createElement("dict");
		plist.appendChild(dict);

		// plistタグのパラメータ
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(
				OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");
		transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC,
				"-//Apple//DTD PLIST 1.0//EN");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
				"http://www.apple.com/DTDs/PropertyList-1.0.dtd");

		/* ------ 以下、構成プロファイルの中身 ------------ */

		/*
		 * PayloadContent
		 *
		 * ペイロードされるパラメータ
		 */
		Element PayloadContentKey = document.createElement("key");
		dict.appendChild(PayloadContentKey);

		Text PayloadContentParam = document.createTextNode("PayloadContent");
		PayloadContentKey.appendChild(PayloadContentParam);

		Element PayloadContentArray = document.createElement("array");
		dict.appendChild(PayloadContentArray);

		/* ---------- 作業用Wi-Fiここから ---------- */

		// 2ndguests(GAT)が選択されている場合
		if (gatWifiChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			wifi.WiFiAutoJoin(PayloadContentDict, document, true);

			wifi.WiFiEncryptionType(PayloadContentDict, document, WiFi.STRING,
					"WPA");

			wifi.WiFiHIDDEN_NETWORK(PayloadContentDict, document, false);

			wifi.WiFiPassword(PayloadContentDict, document, WiFi.STRING,
					"Sepkddi0077");

			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, "Configures wireless connectivity settings.");

			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, "WiFi (" + "2ndguests" + ")");

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.wifi.2ndguests");

			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, "");

			common.PayloadType(PayloadContentDict, document, WiFi.STRING,
					"com.apple.wifi.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			wifi.WiFiProxyType(PayloadContentDict, document, WiFi.STRING,
					"None");

			wifi.WiFiSSID_STR(PayloadContentDict, document, WiFi.STRING,
					"2ndguests");
		}

		// kddisupport(GAT)が選択されている場合
		if (d08WifiChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			wifi.WiFiAutoJoin(PayloadContentDict, document, true);

			wifi.WiFiEncryptionType(PayloadContentDict, document, WiFi.STRING,
					"WPA");

			wifi.WiFiHIDDEN_NETWORK(PayloadContentDict, document, false);

			wifi.WiFiPassword(PayloadContentDict, document, WiFi.STRING,
					"12345678");

			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, "Configures wireless connectivity settings.");

			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, "WiFi (" + "kddisupport" + ")");

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.wifi.kddisupport");

			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, "");

			common.PayloadType(PayloadContentDict, document, WiFi.STRING,
					"com.apple.wifi.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			wifi.WiFiProxyType(PayloadContentDict, document, WiFi.STRING,
					"None");

			wifi.WiFiSSID_STR(PayloadContentDict, document, WiFi.STRING,
					"kddisupport");
		}

		// 0ST001mpc(平和島)が選択されている場合
		if (mpcWifiChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			wifi.WiFiAutoJoin(PayloadContentDict, document, true);

			wifi.WiFiEncryptionType(PayloadContentDict, document, WiFi.STRING,
					"WPA");

			wifi.WiFiHIDDEN_NETWORK(PayloadContentDict, document, false);

			wifi.WiFiPassword(PayloadContentDict, document, WiFi.STRING,
					"00770077");

			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, "Configures wireless connectivity settings.");

			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, "WiFi (" + "0ST001mpc" + ")");

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.wifi.0ST001mpc");

			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, "");

			common.PayloadType(PayloadContentDict, document, WiFi.STRING,
					"com.apple.wifi.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			wifi.WiFiProxyType(PayloadContentDict, document, WiFi.STRING,
					"None");

			wifi.WiFiSSID_STR(PayloadContentDict, document, WiFi.STRING,
					"0ST001mpc");
		}

		// xxxx,yyyy,zzzz(場外)が選択されている場合
		if (stsWifiChk.isSelected()) {
			String[] stsSSID = { "xxxx", "yyyy", "zzzz" };
			for (String ssid : stsSSID) {
				Element PayloadContentDict = document.createElement("dict");
				PayloadContentArray.appendChild(PayloadContentDict);

				wifi.WiFiAutoJoin(PayloadContentDict, document, true);

				wifi.WiFiEncryptionType(PayloadContentDict, document,
						WiFi.STRING, "WPA");

				wifi.WiFiHIDDEN_NETWORK(PayloadContentDict, document, false);

				wifi.WiFiPassword(PayloadContentDict, document, WiFi.STRING,
						"asdfghjkl");

				common.PayloadDescription(PayloadContentDict, document,
						Common.STRING,
						"Configures wireless connectivity settings.");

				common.PayloadDisplayName(PayloadContentDict, document,
						Common.STRING, "WiFi (" + ssid + ")");

				common.PayloadIdentifier(PayloadContentDict, document,
						Common.STRING, "jp.kddi.workprof.wifi." + ssid);

				common.PayloadOrganization(PayloadContentDict, document,
						Common.STRING, "");

				common.PayloadType(PayloadContentDict, document, WiFi.STRING,
						"com.apple.wifi.managed");

				common.PayloadUUID(PayloadContentDict, document, Common.STRING);

				common.PayloadVersion(PayloadContentDict, document,
						Common.INTEGER, "1");

				wifi.WiFiProxyType(PayloadContentDict, document, WiFi.STRING,
						"None");

				wifi.WiFiSSID_STR(PayloadContentDict, document, WiFi.STRING,
						ssid);
			}
		}

		/* ---------- 作業用Wi-Fiここまで ---------- */

		/* ---------- 入力支援・Webサイト用ブランクここから ---------- */

		// ブランクの生成
		// 作業用Gmail以外が選択されている場合のみ追加
		if (!gmailChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

			String label = "①ブランク";
			webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
					label);

			webClip.WebclipIcon(PayloadContentDict, document, "data",
					iconImages[0]);

			String webDescription = "ブランククリップ";
			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, webDescription);

			String webDisplayName = "Blank";
			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, webDisplayName);

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.webclip.blank");

			String webCompanyName = "";
			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, webCompanyName);

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.webClip.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// ブランクを生成
			webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
					"about:blank");
		}

		/* ---------- 入力支援・Webサイト用ブランクここまで ---------- */

		/* ---------- 入力支援Webクリップ設定パラメータここから ---------- */

		// 入力支援Webクリップが選択されている場合、実行
		if (inputClipChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

			String label = "②入力支援";
			webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
					label);

			webClip.WebclipIcon(PayloadContentDict, document, "data",
					iconImages[1]);

			String webDescription = "入力支援Webクリップ";
			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, webDescription);

			String webDisplayName = "InputWebClip";
			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, webDisplayName);

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.webclip.input");

			String webCompanyName = "";
			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, webCompanyName);

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.webClip.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// 入力支援JavaScript生成
			String URL = InputJavascriptCreate(inputClipText.getText());

			// JavaScript本体を入れ込む
			webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
					URL);
		}

		/* ---------- 入力支援Webクリップ設定パラメータここまで ---------- */

		/* ---------- Webサイト設定パラメータここから ---------- */

		// Webクリップが選択されている場合、実行
		if (webClipChk.isSelected()) {
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

			String label = "③Webサイト";
			webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
					label);

			webClip.WebclipIcon(PayloadContentDict, document, "data",
					iconImages[2]);

			String webDescription = "Webサイトクリップ";
			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, webDescription);

			String webDisplayName = "WebSiteClip";
			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, webDisplayName);

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.webclip.web");

			String webCompanyName = "";
			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, webCompanyName);

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.webClip.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// WebサイトJavaScript生成
			String URL = WebJavascriptCreate(webClipText.getText());

			// JavaScript本体を入れ込む
			webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
					URL);
		}

		/* ---------- Webサイト設定パラメータここまで ---------- */

		/* ---------- SMSMクリップ設定パラメータここから ---------- */

		// SMSMクリップが選択されている場合、実行
		if (smsmClipChk.isSelected()) {
			// SMSMクリップは必ず１つになるので、ループなし
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			webClip.WebcilpIsRemovable(PayloadContentDict, document, true);

			String label = "④SMSM";
			webClip.WebclipLabel(PayloadContentDict, document, WebClip.STRING,
					label);

			webClip.WebclipIcon(PayloadContentDict, document, "data", smsmImg);

			String webDescription = "SMSMクリップ";
			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, webDescription);

			String webDisplayName = "SMSMWebClip";
			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, webDisplayName);

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.webclip.smsm");

			String webCompanyName = "";
			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, webCompanyName);

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.webClip.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// smsmCompanyCodeText = 企業コード
			// smsmAuthCodeText = 認証コード
			/* 過去コード */
			// String smsmURL =
			// "javascript:document.write('<body><form action=\""
			// + "https://ausl.smartmanager.jp/setup/ios"
			// +
			// "\" method=\"POST\"><input name=\"ios_customer[code]\" value=\""
			// + smsmCompanyCodeText.getText()
			// + "\"><input name=\"ios_customer[certification_code]\" value=\""
			// + smsmAuthCodeText.getText()
			// +
			// "\"></form><script type=\"text/javascript\">document.forms[0].submit();</script></body>');";

			// 「100%25」という記述は「100%」を示す
			// ※「%」＝「%25」であり、念のため最初から変換済みのコードを仕込む
			// 「%E3%82%A2%E3%82%AF%E3%83%86%E3%82%A3%E3%83%99%E3%83%BC%E3%82%B7%E3%83%A7%E3%83%B3」＝アクティベーション
			// 「%E4%BC%81%E6%A5%AD%E3%82%B3%E3%83%BC%E3%83%89」＝企業コード
			// 「%E8%AA%8D%E8%A8%BC%E3%82%B3%E3%83%BC%E3%83%89」＝認証コード
			// 「%E3%82%A4%E3%83%B3%E3%82%B9%E3%83%88%E3%83%BC%E3%83%AB」＝インストール
			String smsmURL = "javascript:document.write('"
					+ "<head>"
					+ "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no\">"
					+ "<title>SMSM</title>"
					+ "</head>"
					+ "<body>"
					+ "<center><h2>SMSM%E3%82%A2%E3%82%AF%E3%83%86%E3%82%A3%E3%83%99%E3%83%BC%E3%82%B7%E3%83%A7%E3%83%B3</h2></center>"
					+ "<hr>"
					+ "<form action=\"https://ausl.smartmanager.jp/setup/ios\" method=\"POST\">"
					+ "<h3>%E4%BC%81%E6%A5%AD%E3%82%B3%E3%83%BC%E3%83%89</h3>"
					+ "<input name=\"ios_customer[code]\" value=\""
					+ smsmCompanyCodeText.getText().trim()
					+ "\" style=\"width:100%25;height:30px\" readonly=\"readonly\">"
					+ "<h3>%E8%AA%8D%E8%A8%BC%E3%82%B3%E3%83%BC%E3%83%89</h3>"
					+ "<input name=\"ios_customer[certification_code]\" value=\""
					+ smsmAuthCodeText.getText().trim()
					+ "\" style=\"width:100%25;height:30px\" readonly=\"readonly\">"
					+ "<br>"
					+ "<br>"
					+ "<br>"
					+ "<center><input type =\"submit\" value=\"%E3%82%A4%E3%83%B3%E3%82%B9%E3%83%88%E3%83%BC%E3%83%AB\" style=\"width:100%25;height:30px\"></center>"
					+ "</form>" + "</body>" + "');";

			// 禁止文字の置き換え
			smsmURL = smsmURL.replace("<", "%3C");
			smsmURL = smsmURL.replace(">", "%3E");
			smsmURL = smsmURL.replace("\"", "%22");
			smsmURL = smsmURL.replace("[", "%5B");
			smsmURL = smsmURL.replace("]", "%5D");
			smsmURL = smsmURL.replace("{", "%7B");
			smsmURL = smsmURL.replace("}", "%7D");
			smsmURL = smsmURL.replace(" ", "%20");
			smsmURL = smsmURL.replace("?", "%3F");

			// 生成したJavaScriptをセット
			webClip.WebclipURL(PayloadContentDict, document, WebClip.STRING,
					smsmURL);

		}

		/* ---------- SMSMクリップ設定パラメータここまで ---------- */

		/* ---------- 作業用Gmailアドレス設定パラメータここから ---------- */

		// 作業用Gmailアドレスが選択されている場合、実行
		if (gmailChk.isSelected()) {
			// 作業用Gmailアドレスは必ず１つになるので、ループなし
			Element PayloadContentDict = document.createElement("dict");
			PayloadContentArray.appendChild(PayloadContentDict);

			email.EmailAccountDescription(PayloadContentDict, document,
					Email.STRING, "作業用Gmailアドレス");

			// 作業用Gmailアドレスセット
			email.EmailAccountName(PayloadContentDict, document, Email.STRING,
					gmailAddressText.getText());

			// とりあえず「IMAP」で固定
			email.EmailAccountType(PayloadContentDict, document, Email.STRING,
					"EmailTypeIMAP");

			// 作業用Gmailアドレスセット
			email.EmailAddress(PayloadContentDict, document, Email.STRING,
					gmailAddressText.getText());

			// とりあえず「EmailAuthPassword」で固定
			email.IncomingMailServerAuthentication(PayloadContentDict,
					document, Email.STRING, "EmailAuthPassword");

			// とりあえず「imap.gmail.com」で固定
			email.IncomingMailServerHostName(PayloadContentDict, document,
					Email.STRING, "imap.gmail.com");

			// とりあえず「/」で固定
			email.IncomingMailServerIMAPPathPrefix(PayloadContentDict,
					document, Email.STRING, "/");

			// とりあえず「993」で固定
			email.IncomingMailServerPortNumber(PayloadContentDict, document,
					Email.INTEGER, "993");

			// とりあえず「true」で固定
			email.IncomingMailServerUseSSL(PayloadContentDict, document, true);

			// 作業用Gmailアドレスセット
			email.IncomingMailServerUsername(PayloadContentDict, document,
					Email.STRING, gmailAddressText.getText());

			// 作業用Gmailアドレスのパスワードセット
			email.IncomingPassword(PayloadContentDict, document, Email.STRING,
					gmailPasswordText.getText());

			// とりあえず「EmailAuthPassword」で固定
			email.OutgoingMailServerAuthentication(PayloadContentDict,
					document, Email.STRING, "EmailAuthPassword");

			// とりあえず「smtp.gmail.com」で固定
			email.OutgoingMailServerHostName(PayloadContentDict, document,
					Email.STRING, "smtp.gmail.com");

			// とりあえず「587」で固定
			email.OutgoingMailServerPortNumber(PayloadContentDict, document,
					Email.STRING, "587");

			// とりあえず「true」で固定
			email.OutgoingMailServerUseSSL(PayloadContentDict, document, true);

			// 作業用Gmailアドレスセット
			email.OutgoingMailServerUsername(PayloadContentDict, document,
					Email.STRING, gmailAddressText.getText());

			// とりあえず「true」で固定
			email.OutgoingPasswordSameAsIncomingPassword(PayloadContentDict,
					document, true);

			common.PayloadDescription(PayloadContentDict, document,
					Common.STRING, "Configures email account.");

			common.PayloadDisplayName(PayloadContentDict, document,
					Common.STRING, "作業用Gmailアドレス");

			common.PayloadIdentifier(PayloadContentDict, document,
					Common.STRING, "jp.kddi.workprof.email");

			common.PayloadOrganization(PayloadContentDict, document,
					Common.STRING, "");

			common.PayloadType(PayloadContentDict, document, Common.STRING,
					"com.apple.mail.managed");

			common.PayloadUUID(PayloadContentDict, document, Common.STRING);

			common.PayloadVersion(PayloadContentDict, document, Common.INTEGER,
					"1");

			// とりあえず、「false」で固定
			email.EmailPreventAppSheet(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.EmailPreventMove(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.EmailSMIMEEnabled(PayloadContentDict, document, false);

			// とりあえず、「false」で固定
			email.disableMailRecentsSyncing(PayloadContentDict, document, false);
		}

		/* ---------- 作業用Gmailアドレス設定パラメータここまで ---------- */

		description = profileDescriptionText.getText();
		common.PayloadDescription(dict, document, Common.STRING, description);

		displayName = profileNameText.getText();
		// プロファイル名がついていない場合は自動的に名前をつける
		if (displayName.equals("")) {
			displayName = "WebClip";
		}
		common.PayloadDisplayName(dict, document, Common.STRING, displayName);

		common.PayloadIdentifier(dict, document, Common.STRING,
				"jp.kddi.workprof");

		common.PayloadOrganization(dict, document, Common.STRING, "");

		common.PayloadRemovalDisallowed(dict, document, deleteProfile);

		common.PayloadType(dict, document, Common.STRING, "Configuration");

		common.PayloadUUID(dict, document, Common.STRING);

		common.PayloadVersion(dict, document, Common.INTEGER, "1");

		/* ------ 以上、構成プロファイルの中身 ------------ */

		DOMSource source = new DOMSource(document);
		File newXML = new File(exportFileName);
		FileOutputStream os = new FileOutputStream(newXML);
		StreamResult result = new StreamResult(os);
		transformer.transform(source, result);
		os.close();
	}

	// CSVを読み込み、入力支援Javascript生成
	public String InputJavascriptCreate(String fileName) throws IOException {
		Pattern pattern = Pattern.compile(",");
		List<String> header = new ArrayList<String>(); // 1行目をラベルに使用するため、配列に格納する準備
		File csv = new File(fileName); // CSVデータファイル
		BufferedReader br = new BufferedReader(new FileReader(csv));

		// CSV行数カウント
		int csvLines = 0;

		// テキスト番号(id)振り
		int count = 1;

		// 1行のデータ数カウント
		int dataCount = 0;

		String top = "";
		String middle = "";
		String bottom = "";
//		String search = "";
//		String label = "";
		StringBuilder search = new StringBuilder("");
		StringBuilder label = new StringBuilder("");
		String html = "";

		top = "javascript:document.open();document.write('<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\"><title>%e5%85%a5%e5%8a%9b%e6%94%af%e6%8f%b4%e3%82%af%e3%83%aa%e3%83%83%e3%83%97</title><script type=\"text/javascript\">function getE(n){return document.getElementById(n);};function search(){var searchKey = document.getElementById(\"searchText\").value;";
		middle = "}</script></head><body><form><label>%E6%A4%9C%E7%B4%A2</label><br><input type =\"text\" value =\"\" id =\"searchText\"><input type =\"button\" value =\"push\" onclick =\"search();\"><HR>";
		bottom = "</body>');document.close();";

		// 最終行まで読み込む
		String line = "";

		// 1行目を読み込む
		line = br.readLine();

		// 文字列の分割(split「-1」を指定で空白も読み込む)
		String[] strs1 = pattern.split(line, -1);

		// リストへの代入
		// 1列目（電話番号列のラベルは必要ない）を読み飛ばす
		// 2列目以降を読み込み
		for (int i = 1; i < strs1.length; i++) {
			// 1つのヘッダを取得
			String ftmp = strs1[i];

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
			ftmp = ftmp.replace(" ", "%20");

			// 日本語対応のため、取り込む文字列をURLエンコード
			ftmp = URLEncoder.encode(ftmp, "UTF-8");

			// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
			ftmp = ftmp.replace("%2520", "%20");

			header.add(ftmp);
		}

		// 2行目以降を最終行まで1行ずつ読んでいく
		while ((line = br.readLine()) != null) {

			// 文字列の分割(split「-1」を指定で空白も読み込む)
			String[] strs2 = pattern.split(line, -1);

			// 1行のパラメータをjavascriptへ直接書き込む
			String tmp1 = strs2[0];

			// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
			tmp1 = tmp1.replace(" ", "%20");

			// 日本語対応のため、取り込む文字列をURLエンコード
			tmp1 = URLEncoder.encode(tmp1, "UTF-8");

			// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
			tmp1 = tmp1.replace("%2520", "%20");

			// はじめに1列目を読み込んでおく（検索キー）
			if (csvLines == 0) {
				search.append("if(searchKey == \"" + tmp1 + "\"){");
			} else {
				search.append("else if(searchKey == \"" + tmp1 + "\"){");
			}

			// 2列目以降を読み込む
			for (int i = 1; i < strs2.length; i++) {
				// 1行のパラメータをjavascriptへ直接書き込む
				String tmp2 = strs2[i];

				// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
				tmp2 = tmp2.replace(" ", "%20");

				// Ver 3.2.1による改修
				// 『'』をエスケープ（特殊文字扱い）する（JavaScriptはエスケープの必要あり）
				tmp2 = tmp2.replace("\'", "\\\'");

				// 日本語対応のため、取り込む文字列をURLエンコード
				tmp2 = URLEncoder.encode(tmp2, "UTF-8");

				// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
				tmp2 = tmp2.replace("%2520", "%20");

				search.append("getE(\"text" + count
						+ "\").value=\"" + tmp2 + "\";");
				count++;
			}
			search.append("}");
			// 1列完了するごとにインクリメント（行数カウント）
			csvLines++;

			// データ数算出
			dataCount = count - 1;

			// 次の行で1からカウントするためクリア
			count = 1;
		}

		// else文で検索キーに含まれないものの場合削除
		search.append("else{");
		for (int i = 0; i < dataCount; i++) {
			search.append("getE(\"text" + (i + 1)
					+ "\").value=\"\";");
		}
		search.append("}");
		br.close();

		// ラベルの作成
//		// ラベルのありとなしを選択
//		if (existNumRb.isSelected()) {
//			for (int i = 0; i < dataCount; i++) {
//				label.append("<label>"
//						+ (i + 1)
//						+ "%ef%bc%9a" // URLエンコードで「：」を変換したもの
//						+ header.get(i)
//						+ "</label><br><input type =\"text\" value =\"\" id =\"text"
//						+ (i + 1) + "\"><br>");
//			}
//		} else if (noneNumRb.isSelected()) {
//			for (int i = 0; i < dataCount; i++) {
//				label.append("<label>"
//						+ header.get(i)
//						+ "</label><br><input type =\"text\" value =\"\" id =\"text"
//						+ (i + 1) + "\"><br>");
//			}
//		}

		// ラベルの作成
		for (int i = 0; i < dataCount; i++) {
			label.append("<label>");
			// ラベルのありとなしを選択
			if (existNumRb.isSelected()) {
				label.append(String.valueOf(i + 1));
				label.append("%ef%bc%9a"); // URLエンコードで「：」を変換したもの
			} else if (noneNumRb.isSelected()) {
			}
			label.append(header.get(i));
			label.append("</label><br><input type =\"text\" value =\"\" id =\"text");
//			label.append("</label><br><input type=\"text\" value=\"\" style=\"width:100%25\" id=\"text");	//TODO 幅100％
			label.append(String.valueOf(i + 1) + "\"><br>");
		}

		// 生成したすべての文字列を1つの文字列とする
		html = top + search.toString() + middle + label.toString() + bottom;

		// 禁止文字の置き換え
		html = html.replace("<", "%3C");
		html = html.replace(">", "%3E");
		html = html.replace("\"", "%22");
		html = html.replace("[", "%5B");
		html = html.replace("]", "%5D");
		html = html.replace("{", "%7B");
		html = html.replace("}", "%7D");
		html = html.replace(" ", "%20");
		html = html.replace("?", "%3F");

		return html;
	}

	// CSVを読み込み、Webサイト一覧生成
	public String WebJavascriptCreate(String fileName) throws IOException {
		Pattern pattern = Pattern.compile(",");
		File csv = new File(fileName); // CSVデータファイル
		BufferedReader br = new BufferedReader(new FileReader(csv));

		String top = "";
//		String middle = "";
		StringBuilder middle = new StringBuilder("");
		String bottom = "";

		String pFontTop = "<p><font size=\"4\"><a href=\"";
		String url = ""; // URLのパラメータを一時格納
		String pFontmiddle = "\" target=\"_blank\">";
		String label = ""; // ラベルのパラメータを一時格納
		String pFontBottom = "</a></font></p>";

		String html = "";

		top = "javascript:document.open();document.write('<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\"><title>Web%e3%82%b5%e3%82%a4%e3%83%88%e3%82%a2%e3%82%af%e3%82%bb%e3%82%b9</title></head><body><font size=\"6\">Web%e3%82%b5%e3%82%a4%e3%83%88%e3%82%a2%e3%82%af%e3%82%bb%e3%82%b9</font><hr>";
		bottom = "</form></body>');document.close();";

		// 最終行まで読み込む
		String line = "";

		// 1行目を読みとばす
		line = br.readLine();

		// 2行目以降を最終行まで1行ずつ読んでいく
		while ((line = br.readLine()) != null) {

			// 文字列の分割(split「-1」を指定で空白も読み込む)
			String[] strs = pattern.split(line, -1);

			// すべての行を読み込む
			for (int i = 0; i < strs.length; i++) {
				// 1行のパラメータをjavascriptへ直接書き込む
				String tmp = strs[i];

				// 1回目のラベルのみURLエンコード
				if (i == 0) {

					// そのままURLエンコードをかけると、半角スペースが「+」になるため、事前に変換
					tmp = tmp.replace(" ", "%20");

					// 日本語対応のため、取り込む文字列をURLエンコード
					tmp = URLEncoder.encode(tmp, "UTF-8");

					// 上記「%20」をURLエンコードするため、「%2520」となるため、「%2520」を「%20」に事後に変換
					tmp = tmp.replace("%2520", "%20");
				}

				// 1行目か2行目かによって、パラメータを代入する先を換える
				if (i == 0) {
					label = tmp;
				} else {
					url = tmp;
				}
			}
			// 1列終了するごとにパラメータを増やしていく
			middle.append(pFontTop + url + pFontmiddle + label + pFontBottom);
		}
		br.close();

		// 生成したすべての文字列を1つの文字列とする
		html = top + middle.toString() + bottom;

		// 禁止文字の置き換え
		html = html.replace("<", "%3C");
		html = html.replace(">", "%3E");
		html = html.replace("\"", "%22");
		html = html.replace("[", "%5B");
		html = html.replace("]", "%5D");
		html = html.replace("{", "%7B");
		html = html.replace("}", "%7D");
		html = html.replace(" ", "%20");
		html = html.replace("?", "%3F");

		System.out.println(html);
		return html;
	}

	// 作業用ファイルを書き出すためのメソッド
	public void WorkProfSave(String workProfPath, ArrayList<String> workfile) {
		try {
			// 出力先を作成する
			FileWriter fw = new FileWriter(workProfPath, false);
			PrintWriter pw = new PrintWriter(new BufferedWriter(fw));

			// CSVファイルに書き出す内容を指定する

			// 1行目・作成プロファイル
			pw.print(workfile.get(0));
			pw.print(",");
			pw.print(workfile.get(1));
			pw.print(",");
			pw.print(workfile.get(2));
			pw.print(",");
			pw.print(workfile.get(3));
			pw.println();

			// 2行目・タブ
			pw.print(workfile.get(4));
			pw.print(",");
			pw.print(workfile.get(5));
			pw.print(",");
			pw.print(workfile.get(6));
			pw.print(",");
			pw.print(workfile.get(7));
			pw.print(",");
			pw.print(workfile.get(8));
			pw.print(",");
			pw.print(workfile.get(9));
			pw.println();

			// 3行目・その他情報
			pw.print(workfile.get(10));
			pw.print(",");
			pw.print(workfile.get(11));
			pw.print(",");
			pw.print(workfile.get(12));
			pw.print(",");
			pw.print(workfile.get(13));
			pw.println();

			pw.print(workfile.get(14));
			pw.print(",");
			pw.print(workfile.get(15));
			pw.print(",");
			pw.print(workfile.get(16));
			pw.print(",");
			pw.print(workfile.get(17));
			pw.println();

			// ファイルに書き出す
			pw.close();

		} catch (IOException ex) {
			// 例外時処理
			ex.printStackTrace();
		}
	}

	// 作業ファイルを読み込むためのメソッド
	public List<String> WorkProfOpen(String workProfPath) {
		Pattern pattern = Pattern.compile(",");
		List<String> workfile = new ArrayList<String>();

		try {
			File csv = new File(workProfPath); // CSVデータファイル
			BufferedReader br = new BufferedReader(new FileReader(csv));

			// 最終行まで読み込む
			String line = "";

			while ((line = br.readLine()) != null) {

				// 文字列の分割(split「-1」を指定で空白も読み込む)
				String[] strs = pattern.split(line, -1);

				// リストへの代入
				for (int i = 0; i < strs.length; i++) {
					// データの格納
					workfile.add(strs[i]);
				}

			}
			br.close();

		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		return workfile;
	}

	// ファイル選択で最後に開いたフォルダを表示するためのメソッド
	public void CurrentDir(String currentDir) {
		try {
			File file = new File(lastDirPath);

			if (checkBeforeWritefile(file)) {
				PrintWriter pw = new PrintWriter(new BufferedWriter(
						new FileWriter(file)));

				pw.println(currentDir);

				pw.close();
			} else {
				System.out.println("ファイルに書き込めません");
			}
		} catch (IOException e) {
			System.out.println(e);
		}
	}

	private static boolean checkBeforeWritefile(File file) {
		if (file.exists()) {
			if (file.isFile() && file.canWrite()) {
				return true;
			}
		}

		return false;
	}

	/**
	 * 画面入力項目の初期化を行う
	 */
	private void clearContents() {

		// 作成プロファイルのチェックボックス
		inputClipChk.setSelected(false);
		webClipChk.setSelected(false);
		smsmClipChk.setSelected(false);
		gmailChk.setSelected(false);

		// 入力支援のCSV
		inputClipText.setText(null);
		// WebClipのCSV
		webClipText.setText(null);
		// SMSM企業コード、認証コード
		smsmCompanyCodeText.setText(null);
		smsmAuthCodeText.setText(null);
		// 作業用Gmail
		gmailAddressText.setText(null);
		gmailPasswordText.setText(null);

		// プロファイルのファイル名等
		fileNameText.setText(null);
		profileNameText.setText(null);
		profileDescriptionText.setText(null);
		profileSaveText.setText(null);
	}
}