package com.mxmobiling.kitting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WiFi {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";

	public WiFi() {
	}

	/*
	 * AutoJoin
	 * 
	 * デフォルト値は「true」であり、指定SSIDへの自動接続を行う
	 */
	public void WiFiAutoJoin(Element PayloadContentDict, Document document,
			Boolean autoJoin) {
		Element AutoJoinKey = document.createElement("key");
		PayloadContentDict.appendChild(AutoJoinKey);

		Text AutoJoinKeyParam = document.createTextNode("AutoJoin");
		AutoJoinKey.appendChild(AutoJoinKeyParam);

		Element AutoJoinString = document.createElement(String
				.valueOf(autoJoin));
		PayloadContentDict.appendChild(AutoJoinString);
	}

	/*
	 * EncryptionType
	 * 
	 * WEP、WPA（ここでは対応しないがAny、None）の入力
	 * 
	 * セキュリティ種別の設定
	 */
	public void WiFiEncryptionType(Element PayloadContentDict,
			Document document, String valueType, String encryptionType) {
		Element WiFiEncryptionTypekey = document.createElement("key");
		PayloadContentDict.appendChild(WiFiEncryptionTypekey);

		Text WiFiEncryptionTypeKeyParam = document
				.createTextNode("EncryptionType");
		WiFiEncryptionTypekey.appendChild(WiFiEncryptionTypeKeyParam);

		Element WiFiEncryptionTypeString = document.createElement(valueType);
		PayloadContentDict.appendChild(WiFiEncryptionTypeString);

		Text WiFiEncryptionTypeStringParam = document
				.createTextNode(encryptionType);
		WiFiEncryptionTypeString.appendChild(WiFiEncryptionTypeStringParam);
	}

	/*
	 * HIDDEN_NETWORK
	 * 
	 * オープンなWi-Fiであれば「false」暗号化等かかっていてクローズなWi-Fiであれば「true」
	 */
	public void WiFiHIDDEN_NETWORK(Element PayloadContentDict,
			Document document, Boolean hidden) {
		Element WiFiHIDDEN_NETWORKKey = document.createElement("key");
		PayloadContentDict.appendChild(WiFiHIDDEN_NETWORKKey);

		Text WiFiHIDDEN_NETWORKKeyParam = document
				.createTextNode("HIDDEN_NETWORK");
		WiFiHIDDEN_NETWORKKey.appendChild(WiFiHIDDEN_NETWORKKeyParam);

		Element WiFiHIDDEN_NETWORKString = document.createElement(String
				.valueOf(hidden));
		PayloadContentDict.appendChild(WiFiHIDDEN_NETWORKString);
	}

	/*
	 * Password
	 * 
	 * Wi-Fiネットワークへ接続するためのパスワード
	 */
	public void WiFiPassword(Element PayloadContentDict, Document document,
			String valueType, String password) {
		Element WiFiPasswordKey = document.createElement("key");
		PayloadContentDict.appendChild(WiFiPasswordKey);

		Text WiFiPasswordKeyParam = document.createTextNode("Password");
		WiFiPasswordKey.appendChild(WiFiPasswordKeyParam);

		Element WiFiPasswordString = document.createElement(valueType);
		PayloadContentDict.appendChild(WiFiPasswordString);

		Text WiFiPasswordStringParam = document.createTextNode(password);
		WiFiPasswordString.appendChild(WiFiPasswordStringParam);
	}

	/*
	 * ProxyType
	 * 
	 * None、Manual、Autoに対応しているが、本ツールではNoneがデフォルト
	 */
	public void WiFiProxyType(Element PayloadContentDict, Document document,
			String valueType, String proxyType) {
		Element WiFiProxyTypeKey = document.createElement("key");
		PayloadContentDict.appendChild(WiFiProxyTypeKey);

		Text WiFiProxyTypeKeyParam = document.createTextNode("ProxyType");
		WiFiProxyTypeKey.appendChild(WiFiProxyTypeKeyParam);

		Element WiFiProxyTypeString = document.createElement(valueType);
		PayloadContentDict.appendChild(WiFiProxyTypeString);

		Text WiFiProxyTypeStringParam = document.createTextNode(proxyType);
		WiFiProxyTypeString.appendChild(WiFiProxyTypeStringParam);
	}

	/*
	 * SSID_STR
	 * 
	 * None、Manual、Autoに対応しているが、本ツールではNoneがデフォルト
	 */
	public void WiFiSSID_STR(Element PayloadContentDict, Document document,
			String valueType, String ssid) {
		Element WiFiSSID_STRKey = document.createElement("key");
		PayloadContentDict.appendChild(WiFiSSID_STRKey);

		Text WiFiSSID_STRKeyParam = document.createTextNode("SSID_STR");
		WiFiSSID_STRKey.appendChild(WiFiSSID_STRKeyParam);

		Element WiFiSSID_STRString = document.createElement(valueType);
		PayloadContentDict.appendChild(WiFiSSID_STRString);

		Text WiFiSSID_STRStringParam = document.createTextNode(ssid);
		WiFiSSID_STRString.appendChild(WiFiSSID_STRStringParam);
	}
}
