from PIL import Image, ImageFont, ImageDraw
import os, sys
import configparser


cfg = configparser.ConfigParser()
cfg.read("config.ini")

# 変換元フォルダ
sources_dir = cfg["files"]["sources_dir"]
# 変換先フォルダ
dest_dir = cfg["files"]["dest_dir"]
# 透かし文字
text = cfg["texts"]["text"]
# 文字色
text_color = cfg["texts"]["text_color"]
# 使用するフォントファイル
fonts = cfg["texts"]["fonts"]
# 文字サイズ
font_size = int(cfg["texts"]["font_size"])
# 透かしの色と明度
img_color = (0, 0, 0, 160)
# 検索する画像の拡張子
ext_lists = ("jpg", "jpeg", "png", "gif")

def text_center(width=0):
    if width:
        return width / 4
    else:
        return 0

if not os.path.exists(sources_dir):
    os.mkdir(sources_dir)
    input(f"{sources_dir}フォルダを作成しました。この中に画像を放り込んでから再度起動して下さい。")
    sys.exit(0)
elif not os.listdir(sources_dir):
    input(f"{sources_dir}フォルダ内にファイルが存在しません。この中に画像を放り込んでから再度起動して下さい。")
    sys.exit(0)

if not os.path.exists(dest_dir):
    os.mkdir(dest_dir)

for file in os.listdir(sources_dir):
    root, ext = os.path.splitext(file)
    ext = ext.lower()
    if ext[1:] in ext_lists:
        img = Image.open(os.path.join(sources_dir, file)).convert("RGBA")
        width, height = img.size
        # 文字の座標("横(px)", "縦(px)")
        text_position = (text_center(width=width), height / 2)
        img_object = Image.new("RGBA", img.size, color=img_color)
        draw = ImageDraw.Draw(img_object)
        arial_font = ImageFont.truetype(fonts, font_size)
        draw.text(xy=text_position, text=text, fill=text_color, font=arial_font)
        output = Image.alpha_composite(img, img_object)
        output.save(os.path.join(dest_dir, root) + ".png")
    else:
        print(f"{file}は画像ではありません。パスします。")
