/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

// main.c
// MachiKania BASIC System Ver Megalopa
// KM-BASIC Js for PIC32MX370F512H by K.Tanaka

// pVXe
// ps2keyboard370f.X.a : PS/2L[{[h̓VXeCu
// lib_videoout_megalopa.X.a : J[rfIMo̓VXeCu
// sdfsio370fLib.a F SDJ[hANZXpCu


/*
	PIC32MX ytFgp
	
	荞
		NTSC,   Timer2, vector  8, priority 5
		NTSC,   OC5,    vector 22, priority 5
		NTSC,   OC2,    vector 10, priority 5
		NTSC,   OC1,    vector  6, priority 5
		PS/2,   CNF,    vector 33, priority 6
		PS/2,   Timer5, vector 20, priority 4
		MUSIC,  CS0,    vector  1, priority 2
		SERIAL, UART,   vector 31, priority 3
	
	^C}[
		Timer1 gp
		Timer2 NTSC
		Timer3 MUSIC/PWM
		Timer4 MUSIC
		Timer5 PS/2
	
	DMA
		DMA0 gp
		DMA1 MUSIC
		DMA2 MUSIC
		DMA3 PS/2
	
	Output compair
		OC1 NTSC
		OC2 NTSC
		OC3 MUSIC/PWM
		OC4 MUSIC/PWM
		OC5 NTSC
	
	UART
		UART1 VAʐM
		UART2 gp
	
	SPI
		SPI1 SPIʐMi\j
		SPI2 }`fBAJ[h
	
	I2C
		I2C1 I2CʐMi\j
		I2C2 gp
	
	|[ggp
		B0  I/O, AN0
		B1  I/O, AN1
		B2  I/O, AN2
		B3  I/O, AN3
		B4  I/O, AN4
		B5  I/O, AN5
		B6  I/O, AN6
		B7  I/O, AN7
		B8  I/O, AN8
		B9  I/O, AN9
		B10 I/O, AN10
		B11 I/O, AN11
		B12 I/O, AN12
		B13 I/O, AN13
		B14 I/O, AN14
		B15 I/O, AN15
		C12 OSC1 (Crystal)
		C13 U1TX (UART)
		C14 U1RX (UART)
		C15 OSC2 (Crystal)
		D0  SW_DOWN
		D1  SW_LEFT
		D2  SW_UP
		D3  SW_RIGHT
		D4  SW_START
		D5  SW_FIRE
		D6  
		D7  
		D8  
		D9  SPI1_CS (SPI)
		D10 PWM1
		D11 PWM2
		E0  NTSC
		E1  NTSC
		E2  NTSC
		E3  NTSC
		E4  NTSC
		E5  I/O, AN22
		E6  I/O, AN23
		E7  I/O, AN27
		F0  PS/2 DAT
		F1  PS/2 CLK
		F2  SDI1 (SPI)
		F3  SPI2_CS (MMC)
		F4  AUDIO_R
		F5  AUDIO_L
		F6  SCK1 (SPI)
		G2  SCL1 (I2C)
		G3  SDA1 (I2C)
		G6  SCK2 (MMC)
		G7  SDI2 (MMC)
		G8  SDO2 (MMC)
		G9  SDO1 (SPI)
*/

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"
#include "keyinput.h"
#include "main.h"

//OtNX^ with PLL (20/3{)
//NX^3.579545~414.31818MHz
#pragma config FSRSSEL = PRIORITY_7
#pragma config PMDL1WAY = OFF
#pragma config IOL1WAY = OFF
//#pragma config FUSBIDIO = OFF
//#pragma config FVBUSONIO = OFF
#pragma config FPLLIDIV = DIV_3
#pragma config FPLLMUL = MUL_20
//#pragma config UPLLIDIV = DIV_1
//#pragma config UPLLEN = OFF
#pragma config FPLLODIV = DIV_1
#pragma config FNOSC = PRIPLL
#pragma config FSOSCEN = OFF
#pragma config IESO = OFF
#pragma config POSCMOD = XT
#pragma config OSCIOFNC = OFF
#pragma config FPBDIV = DIV_1
#pragma config FCKSM = CSDCMD
#pragma config FWDTEN = OFF
#pragma config DEBUG = OFF
#pragma config PWP = OFF
#pragma config BWP = OFF
#pragma config CP = OFF

#define mBMXSetRAMKernProgOffset(offset)	(BMXDKPBA = (offset))
#define mBMXSetRAMUserDataOffset(offset)	(BMXDUDBA = (offset))
#define mBMXSetRAMUserProgOffset(offset)	(BMXDUPBA = (offset))

// INIt@CwL[[hi8ȓj
const char InitKeywords[][9]={
	"106KEY","101KEY","NUMLOCK","CAPSLOCK","SCRLLOCK","WIDTH36","WIDTH48","WIDTH80"
};
unsigned char initialvmode;

void freadline(char *s,FSFILE *fp){
// t@C1sǂݍ݁AzsɕԂ
// ő8܂ŁB9ȏ̏ꍇ
// #܂0x20ȉ̃R[hꍇAȍ~͖
// s:9oCgȏ̔z
// fp:t@C|C^
	int n;
	char c,*p;
	n=0;
	p=s;
	*p=0;
	while(n<=8){
		if(FSfread(p,1,1,fp)==0 || *p=='\n'){
			*p=0;
			return;
		}
		if(*p=='#'){
			*p=0;
			break;
		}
		if(*p<=' '){
			if(n>0){
				*p=0;
				break;
			}
			continue;
		}
		p++;
		n++;
	}
	if(n>8) *s=0; //9ȏ̏̕ꍇ͖
	//ȍ~͖̕
	while(FSfread(&c,1,1,fp) && c!='\n') ;
}
int searchinittext(char *s){
// InitKeywordsz̒當sTAʒuꍇԖڂԂ
// Ȃꍇ-1Ԃ
	int i;
	char *p1;
	const char *p2;
	for(i=0;i<sizeof(InitKeywords)/sizeof(InitKeywords[0]);i++){
		p1=s;
		p2=InitKeywords[i];
		while(*p1==*p2){
			if(*p1==0) return i;
			p1++;
			p2++;
		}
	}
	return -1;
}
void readinifile(void){
	FSFILE *fp;
	char inittext[9];

	fp=FSfopen(INIFILE,"r");
	if(fp==NULL) return;
	printstr("Initialization File Found\n");
	lockkey=0; //INIt@C݂ꍇALock֘AL[INIt@Cɏ]
	while(1){
		if(FSfeof(fp)) break;
		freadline(inittext,fp);
		switch(searchinittext(inittext)){
			case 0:
				keytype=0;//{L[{[h
				break;
			case 1:
				keytype=1;//pL[{[h
				break;
			case 2:
				lockkey|=2;//Num Lock
				break;
			case 3:
				lockkey|=4;//CAPS Lock
				break;
			case 4:
				lockkey|=1;//Scroll Lock
				break;
			case 5:
				initialvmode=VMODE_STDTEXT;
				break;
			case 6:
				initialvmode=VMODE_WIDETEXT;
				break;
			case 7:
				initialvmode=VMODE_MONOTEXT;
				break;
		}
	}
	FSfclose(fp);
}

void printhex8(unsigned char d){
	printchar("0123456789ABCDEF"[d>>4]);
	printchar("0123456789ABCDEF"[d&0x0f]);	
}

void printhex16(unsigned short d){
	printhex8(d>>8);
	printhex8(d&0x00ff);
}

void printhex32(unsigned int d){
	printhex16(d>>16);
	printhex16(d&0x0000ffff);
}

int main(void){
	char *appname,*s;

	/* |[g̏ݒ */
	CNPUB = 0xFFFF; // PORTBSăvAbv(I/O)
	TRISB = 0xFFFF; // PORTBSē
	CNPUC = 0x4000; // PORTC14vAbv(U1RX)
	TRISC = 0x4000; // PORTC14ȊO͏o
	TRISD = KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// {^ڑ|[g͐ݒ
	CNPUE = 0x00E0; // PORTE5-7vAbv(I/O)
	TRISE = 0x00E0; // PORTE0-4o5-7
	CNPUF = 0x0004; // PORTF2vAbv(SDI1)
	TRISF = 0x0004; // PORTF2ȊO͏o
	TRISG = 0x0080; // PORTG7ȊO͏o

	ANSELB = 0x0000; // SăfW^
	ANSELD = 0x0000; // SăfW^
	ANSELE = 0x0000; // SăfW^
	ANSELG = 0x0000; // SăfW^
	CNPUDSET=KEYSTART | KEYFIRE | KEYUP | KEYDOWN | KEYLEFT | KEYRIGHT;// vAbvݒ
	ODCF = 0x0003;	//RF0,RF1̓I[vhC

	// Ӌ@\s蓖
	SDI2R = 1; //RPG7SDI2蓖
	RPG8R = 6; //RPG8SDO2蓖

	// Make RAM executable. See also "char RAM[RAMSIZE]" in globalvars.c
	mBMXSetRAMKernProgOffset(PIC32MX_RAMSIZE-RAMSIZE);
	mBMXSetRAMUserDataOffset(PIC32MX_RAMSIZE);
	mBMXSetRAMUserProgOffset(PIC32MX_RAMSIZE);

	init_composite(); // rfINAA荞ݏAJ[rfIo͊Jn
	setcursor(0,0,COLOR_NORMALTEXT);

	// Show blue screen if exception before soft reset.
	blue_screen();

	printstr("MachiKania BASIC System\n");
	printstr(" Ver "SYSVER1" "SYSVER2" by KENKEN\n");
	printstr("BASIC Compiler "BASVER"\n");
	printstr(" by Katsumi\n\n");
	//SDJ[ht@CVXe
	setcursorcolor(COLOR_NORMALTEXT);
	printstr("Init File System...");
	// Initialize the File System
	if(FSInit()==FALSE){ //t@CVXe
		//G[̏ꍇ~
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("\nFile System Error\n");
		printstr("Insert Correct Card\n");
		printstr("And Reset\n");
		while(1) asm("wait");
	}
	printstr("OK\n");

	// 
	OC4RS=LATFbits.LATF5 ? 0xff:0x00;
	OC3RS=LATFbits.LATF4 ? 0xff:0x00;
	init_music();

	initialvmode=VMODE_STDTEXT; // WeLXg[hi36j
	lockkey=2; // NumLockL[I
	keytype=0; // {L[{[h
	readinifile(); //INIt@Cǂݍ
	printstr("Init PS/2...");
	wait60thsec(30); //0.5b҂
	if(ps2init()){ //PS/2
		//L[{[hȂꍇ
		printstr("Keyboard Not Found\n");
	}
	else printstr("OK\n");

	wait60thsec(60); //1b҂

	set_videomode(initialvmode,0); //rfI[hؑ

	// sHEXt@CHEXFILEƈvꍇ̓GfB^N
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=HEXFILE;
	while(*s++==*appname++) if(*s==0) texteditor(); //eLXgGfB^[Ăяo

	// sHEXt@Ću.HEXvu.BASvɒuBASt@Cs
	appname=(char*)FILENAME_FLASH_ADDRESS;
	s=tempfile;
	while(*appname!='.') *s++=*appname++;
	appname=".BAS";
	while(*appname!=0) *s++=*appname++;
	*s=0;
	// buttonmode(); //{^L
	g_disable_break=1; // BreakL[
	runbasic(tempfile,0);
	while(1) asm(WAIT);
}
