#include "xc.h"
#include "./api.h"
#include "./compiler.h"

#define FILENAME_FLASH_ADDRESS 0x9D005800

const char __attribute__((address(FILENAME_FLASH_ADDRESS))) filename[13]="TEST.HEX";

static const char initext[];
static const char bastext[];

static char* readtext;
static int filepos;

FSFILE fsfile;

size_t FSfread(void *ptr, size_t size, size_t n, FSFILE *stream){
	char b;
	size_t ret=0;
	if (!readtext) return 0;
	while(b=readtext[filepos]){
		filepos++;
		((char*)ptr)[ret]=b;
		ret++;
		if (n<=ret) break;
	}
	return ret;
}
FSFILE* FSfopen(const char * fileName, const char *mode){
	int i;
	for(i=0;i<13;i++){
		if (fileName[i]=='.') break;
	}
	if (i==13) {
		// Unknown file name
		// Force BAS file
		readtext=(char*)&bastext[0];
	} else if (fileName[i+1]=='I' && fileName[i+2]=='N' && fileName[i+3]=='I') {
		// INI file
		readtext=(char*)&initext[0];
	} else if (fileName[i+1]=='B' && fileName[i+2]=='A' && fileName[i+3]=='S') {
		// BAS file
		readtext=(char*)&bastext[0];
	} else {
		readtext=0;
		return 0;
	}
	filepos=0;
	return &fsfile;
}
int FSfeof( FSFILE * stream ){
	return readtext[filepos]?1:0;
}
int FSfclose(FSFILE *fo){
	return 0;
}
int FSInit(void){
	return 1;
}
int FSremove (const char * fileName){
	return 0;
}
size_t FSfwrite(const void *ptr, size_t size, size_t n, FSFILE *stream){
	return 0;
}

int FindFirst (const char * fileName, unsigned int attr, SearchRec * rec){
	return 0;
}
int FindNext (SearchRec * rec){
	return 0;
}

volatile unsigned char ps2keystatus[256]; // zR[hɑL[̏ԁiOn̎1j
volatile unsigned short vkey; //zL[R[h
unsigned char lockkey; // LockL[̏ԎwB3rbg<CAPSLK><NUMLK><SCRLK>
unsigned char keytype; // L[{[h̎ށB0F{109L[A1Fp104L[

int ps2init(){
	PR1=0x0FFF;
	TMR1=0;
	IFS0bits.T1IF=0;
	T1CON=0xA000;
	// Timer1 interrupt: priority 4
	IPC1bits.T1IP=4;
	IPC1bits.T1IS=0;
	IEC0bits.T1IE=1;

	return 0;
} // PS/2Cu֘ABI0AG[-1Ԃ
unsigned char shiftkeys(){return 0;} // SHIFT֘AL[̉ԂԂ
unsigned char ps2readkey(){return 0;}
// ͂ꂽ1̃L[̃L[R[hO[oϐvkeyɊi[iĂȂ0Ԃj
// 8rbgFL[R[h
// 8rbgFVtgԁiF1jAʂ<0><CAPSLK><NUMLK><SCRLK><Win><ALT><CTRL><SHIFT>
// pEL̏ꍇA߂lƂASCIIR[hiȊO0Ԃj

// PIC32MX1xx/2xxł̃L[{[hƃ{^̔rpVXeŎgp֐A}N
void ps2mode(){} // PS/2Lɂ
void buttonmode(){} // {^Lɂ


unsigned char currentfile[13],tempfile[13]; //ҏW̃t@CAꎞt@C

void wait60thsec(unsigned short n){
	// 60nbEFCgirfIʂ̍ŉsMo͏I܂ő҂j
	n+=drawcount;
	while(drawcount!=n) asm("nop");
}

void texteditor(void){
//eLXgGfB^[{
}



#pragma interrupt timer1Int IPL4SOFT vector 4

void timer1Int(){
	IFS0CLR=_IFS0_T1IF_MASK; //IFS0bits.T1IF=0;
	if (drawing) {
		drawing=0;
		drawcount++;
	} else {
		drawing=1;
	}
}

static const char initext[]=
"#PRINT\n"
"#PRINT\n";

static const char bastext[]=
"CLS\n"
"FOR I=0 TO 9:PRINT I;:NEXT\n"
"GOSUB SUB\n"
"PRINT \"DONE\"\n"
"END\n"
"LABEL SUB\n"
"I=0\n"
"DO\n"
" I=I+1\n"
" IF I=5 THEN BREAK\n"
" PRINT I,\n"
"WHILE I<10\n"
"RETURN\n";

int g_v0;
int g_v1;
int test(int v0,int v1){
	v1=v0<<2;
	asm volatile("lw $ra,4($sp)");
	asm volatile("nop");
	asm volatile("jr $ra");
	asm volatile("addu $ra,$ra,8");
	asm volatile("sw $ra,4($sp)");
	asm volatile("label9:");
	asm volatile("la $a0,%0"::"i"(0x12345678));
	return v0*v1;
}
