package jp.co.tryjava.cli;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 * コマンドラインアプリケーションサンプル<br>
 * 使用ライブラリ：Apache Commons CLI 1.2<br>
 */
public class SampleCli {
	public static void main(String[] args) {
		new SampleCli().run(new String[] { "-h" });
		new SampleCli().run(new String[] { "-a", "--bbb", "b_arg", "infile" });
	}

	public void run(String[] args) {
		Options options = new Options();
		options.addOption("h", "help", false, "ヘルプを表示する。");
		options.addOption("a", "aaa", false, "引数なしオプションです。");
		options.addOption("b", "bbb", true, "引数ありオプションです。");
		BasicParser parser = new BasicParser();
		try {
			CommandLine cl = parser.parse(options, args);

			if (cl.hasOption("h")) {
				HelpFormatter formatter = new HelpFormatter();
				formatter.printHelp("command_name [options] <infile>", options);
			} else {
				System.out.println("オプションa : " + cl.hasOption("a"));
				System.out.println("オプションb : " + cl.getOptionValue("b"));
				System.out.println("必須引数 : " + cl.getArgs()[0]);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

}
