package jp.co.tryjunit.s18_3;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(Enclosed.class)
public class CounterTest2 {

	public static class 初期状態の場合 {
		private Counter sut;

		@Before
		public void setUp() {
			sut = new Counter();
		}

		@Test
		public void testIncrement() {
			// 準備
			// 実行
			int actual = sut.increment();
			// 検証
			int expected = 1;
			assertThat(actual, is(expected));
		}
	}

	public static class incrementを1回実行後の場合 {
		private Counter sut;

		@Before
		public void setUp() {
			sut = new Counter();
			sut.increment();
		}

		@Test
		public void testIncrement() {
			// 準備
			// 実行
			int actual = sut.increment();
			// 検証
			int expected = 2;
			assertThat(actual, is(expected));
		}
	}

	public static class incrementを50回実行後の場合 {
		private Counter sut;

		@Before
		public void setUp() {
			sut = new Counter();
			for (int i = 0; i < 50; i++) {
				sut.increment();
			}
		}

		@Test
		public void testIncrement() {
			// 準備
			// 実行
			int actual = sut.increment();
			// 検証
			int expected = 51;
			assertThat(actual, is(expected));
		}
	}

}
