/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.GoogleException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;

public class GoogleRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_EXTERNAL_MESSAGE = "A system error has occurred";
    private String internalMessage;
    private String externalMessage = "A system error has occurred";

    public GoogleRuntimeException() {
    }

    public GoogleRuntimeException(String internalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
    }

    public GoogleRuntimeException(String externalMessage, Throwable t) {
        super(externalMessage, t);
        this.setInternalMessage(GoogleRuntimeException.exceptionToVerboseString(t));
        this.setExternalMessage(externalMessage);
    }

    public GoogleRuntimeException(GoogleException e) {
        super(e);
        this.setInternalMessage(e.getInternalMessage());
        this.setExternalMessage(e.getExternalMessage());
    }

    public int getErrorCode() {
        return -999;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public void setInternalMessage(String s) {
        this.internalMessage = s;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public void setExternalMessage(String s) {
        this.externalMessage = s;
    }

    public String getMessage() {
        return this.getInternalMessage();
    }

    public static String exceptionToVerboseString(Throwable e) {
        Throwable root;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (e instanceof ServletException && (root = ((ServletException)e).getRootCause()) != null) {
            pw.println(GoogleRuntimeException.exceptionToVerboseString(root));
        }
        e.printStackTrace(pw);
        return sw.toString();
    }
}

