/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.ReferenceType;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
class Platform {
    @GwtIncompatible(value="List.subList")
    static <T> List<T> subList(List<T> list, int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

    @GwtIncompatible(value="Class.isInstance")
    static boolean isInstance(Class<?> clazz, Object obj) {
        return clazz.isInstance(obj);
    }

    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    static void unsafeArrayCopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference, java.lang.ref.WeakReference")
    static <E> Set<E> newIdentityHashSet(ReferenceType referenceType) {
        Map map = null;
        switch (referenceType) {
            case STRONG: {
                map = new IdentityHashMap();
                break;
            }
            case SOFT: {
                map = new MapMaker().softKeys().makeMap();
                break;
            }
            case WEAK: {
                map = new MapMaker().weakKeys().makeMap();
                break;
            }
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom references are not supported.");
            }
        }
        return Sets.newSetFromMap(map);
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

