/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slim3.gen.util.ClassUtil;
import org.slim3.gen.util.StringUtil;

public class ModelMetaClassName {
    protected final String modelClassName;
    protected final String modelPackage;
    protected final String metaPackage;
    protected final String sharedPackage;
    protected final String serverPackage;
    protected final String packageName;
    protected final String simpleName;
    protected final String kind;

    public ModelMetaClassName(String modelClassName, String modelPackage, String metaPackage, String sharedPackage, String serverPackage) {
        if (modelClassName == null) {
            throw new NullPointerException("The modelClassName parameter is null.");
        }
        if (modelPackage == null) {
            throw new NullPointerException("The modelPackage parameter is null.");
        }
        if (metaPackage == null) {
            throw new NullPointerException("The metaPackage parameter is null.");
        }
        if (sharedPackage == null) {
            throw new NullPointerException("The sharedPackage parameter is null.");
        }
        if (serverPackage == null) {
            throw new NullPointerException("The serverPackage parameter is null.");
        }
        this.modelClassName = modelClassName;
        this.modelPackage = modelPackage;
        this.metaPackage = metaPackage;
        this.sharedPackage = sharedPackage;
        this.serverPackage = serverPackage;
        String packageName = this.replacePackageName(ClassUtil.getPackageName(modelClassName), modelPackage, metaPackage);
        this.packageName = this.replacePackageName(packageName, sharedPackage, serverPackage);
        this.simpleName = ClassUtil.getSimpleName(modelClassName) + "Meta";
        this.kind = ClassUtil.getSimpleName(modelClassName);
    }

    protected String replacePackageName(String originalPackageName, String from, String to) {
        if (StringUtil.isEmpty(originalPackageName)) {
            return originalPackageName;
        }
        String regex = String.format("(.*)(\\.%s)(\\..*|$)", from);
        String replacement = String.format("$1.%s$3", to);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(originalPackageName);
        if (!matcher.matches()) {
            return originalPackageName;
        }
        StringBuffer buf = new StringBuffer();
        matcher.reset();
        while (matcher.find()) {
            matcher.appendReplacement(buf, replacement);
            if (!matcher.hitEnd()) continue;
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public String getQualifiedName() {
        return ClassUtil.getQualifiedName(this.packageName, this.simpleName);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getKind() {
        return this.kind;
    }
}

