/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.File;
import java.io.IOException;
import org.slim3.gen.desc.ViewDesc;
import org.slim3.gen.desc.ViewDescFactory;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.generator.ViewGenerator;
import org.slim3.gen.task.AbstractGenFileTask;

public class GenViewTask
extends AbstractGenFileTask {
    protected String controllerPath;

    public void setControllerPath(String controllerPath) {
        this.controllerPath = controllerPath;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.controllerPath == null) {
            throw new IllegalStateException("The controllerPath parameter is null.");
        }
        ViewDesc viewDesc = this.createViewDesc();
        this.generateView(viewDesc);
    }

    private ViewDesc createViewDesc() {
        String path = this.controllerPath.startsWith("/") ? this.controllerPath : "/" + this.controllerPath;
        ViewDescFactory viewDescFactory = this.createViewDescFactory();
        ViewDesc viewDesc = viewDescFactory.createViewDesc(path);
        return viewDesc;
    }

    protected ViewDescFactory createViewDescFactory() {
        return new ViewDescFactory();
    }

    protected void generateView(ViewDesc viewDesc) throws IOException {
        File viewDir = new File(this.warDir, viewDesc.getDirName());
        viewDir.mkdirs();
        File viewFile = new File(viewDir, viewDesc.getFileName());
        Generator generator = this.careateViewGenerator(viewDesc);
        this.generateFile(generator, viewFile);
    }

    protected Generator careateViewGenerator(ViewDesc viewDesc) {
        return new ViewGenerator(viewDesc);
    }
}

