package tryslim3.model;

import java.io.Serializable;
import java.util.Date;

import org.slim3.datastore.Attribute;
import org.slim3.datastore.Model;
import org.slim3.util.DateUtil;

import com.google.appengine.api.datastore.Key;

@Model
public class Crud2 implements Serializable {

    private static final long serialVersionUID = 1L;

    @Attribute(primaryKey = true)
    private Key key;

    @Attribute(version = true)
    private Long version = 0L;

    private String title;
    private String content;
    private Date date;
    private Integer number;
    private Boolean flag;

    /**
     * @return the key
     */
    public Key getKey() {
        return key;
    }

    /**
     * @param key
     *            the key to set
     */
    public void setKey(Key key) {
        this.key = key;
    }

    /**
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title
     *            the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * @return the content
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content
     *            the content to set
     */
    public void setContent(String content) {
        this.content = content;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    /**
     * @return date
     */
    public Date getDate() {
        return date;
    }

    public String getDateAsString() {
        return DateUtil.toString(date, "yyyy-MM-dd");
    }

    /**
     * @param date
     *            セットする date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * @return number
     */
    public Integer getNumber() {
        return number;
    }

    /**
     * @param number
     *            セットする number
     */
    public void setNumber(Integer number) {
        this.number = number;
    }

    /**
     * @return flag
     */
    public Boolean getFlag() {
        return flag;
    }

    /**
     * @param flag
     *            セットする flag
     */
    public void setFlag(Boolean flag) {
        this.flag = flag;
    }
}