/**
Base64Encode

Copyright (c) 2014 Akira Sasaki

This software is released under the MIT License.

http://opensource.org/licenses/mit-license.php

*/

#include <stdio.h>

#include "Base64Encode.h"

size_t Base64EncodeSize(size_t InLen)
{
    return (InLen + 2) / 3 * 4;
}

size_t Base64Encode(const char *In, size_t InLen, char *Out, size_t OutLen)
{
    if (Base64EncodeSize(InLen) > OutLen) {
        return (size_t)(-1);
    }

    const char * const Table =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz"
        "0123456789"
        "+/";

    size_t InIdx = 0;
    size_t OutIdx = 0;

    for (InIdx = 0; InIdx < InLen; InIdx += 3) {
        unsigned char In0 = In[InIdx];
        unsigned char In1 = (InIdx + 1 < InLen) ? In[InIdx + 1] : 0;
        unsigned char In2 = (InIdx + 2 < InLen) ? In[InIdx + 2] : 0;
        Out[OutIdx++] = Table[(In0 >> 2) & 0x3f];
        Out[OutIdx++] = Table[((In0 << 4) | (In1 >> 4)) & 0x3f];
        Out[OutIdx++] = (InIdx + 1 < InLen) ?
            Table[((In1 << 2) | (In2 >> 6)) & 0x3f] : '=';
        Out[OutIdx++] = (InIdx + 2 < InLen) ? Table[In2 & 0x3f] : '=';
    }

    return OutIdx;
}
