%
% This is part of LFSbookja package.
%
% This is a CTIE change file for the LFS hint text files.
%
% $Author: matsuand $
% $Rev: 47 $
% $Date:: 2020-03-11 22:13:34 +0900#$
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <!ENTITY gsl-buildsize     "275 MB (with tests, without docs)">
  <!ENTITY gsl-time          "1.7 SBU (with tests, without docs)">
@y
  <!ENTITY gsl-buildsize     "275 MB (テスト込み、ドキュメントなし)">
  <!ENTITY gsl-time          "1.7 SBU (テスト込み、ドキュメントなし)">
@z

@x
    <title>Introduction to Gsl</title>
@y
    <title>&IntroductionTo1;Gsl&IntroductionTo2;</title>
@z

@x
      The GNU Scientific Library (GSL) is a numerical library for C and C++
      programmers. It provides a wide range of mathematical routines such as
      random number generators, special functions and least-squares fitting.
@y
      GNU 科学技術計算ライブラリ (GNU Scientific Library; GSL) は、C や C++ プログラミングにおける数値演算ライブラリです。
      広範囲にわたる数値演算ルーチンを提供するものであり、乱数発生、最小二乗法 (least-squares fitting) などの特殊な処理ルーチンも含まれます。
@z

@x
    <bridgehead renderas="sect3">Package Information</bridgehead>
@y
    <bridgehead renderas="sect3">&PackageInformation;</bridgehead>
@z

@x
          Download (HTTP): <ulink url="&gsl-download-http;"/>
@y
          &Download; (HTTP): <ulink url="&gsl-download-http;"/>
@z

@x
          Download (FTP): <ulink url="&gsl-download-ftp;"/>
@y
          &Download; (FTP): <ulink url="&gsl-download-ftp;"/>
@z

@x
          Download MD5 sum: &gsl-md5sum;
@y
          &Download; MD5 sum: &gsl-md5sum;
@z

@x
          Download size: &gsl-size;
@y
          &DownloadSize;: &gsl-size;
@z

@x
          Estimated disk space required: &gsl-buildsize;
@y
          &Estimateddiskspacerequired;: &gsl-buildsize;
@z

@x
          Estimated build time: &gsl-time;
@y
          &Estimatedbuildtime;: &gsl-time;
@z

@x
    <bridgehead renderas="sect3">Gsl Dependencies</bridgehead>
@y
    <bridgehead renderas="sect3">&Dependencies1;Gsl&Dependencies2;</bridgehead>
@z

@x
    <bridgehead renderas="sect4">Optional</bridgehead>
    <para role="optional">
      <ulink url="http://www.sphinx-doc.org/en/stable/man/sphinx-build.html">Sphinx</ulink>
      with <ulink url="https://pypi.python.org/pypi/sphinx_rtd_theme">sphinx_rtd_theme</ulink>
    </para>
@y
    <bridgehead renderas="sect4">&Optional;</bridgehead>
    <para role="optional">
      <ulink url="http://www.sphinx-doc.org/en/stable/man/sphinx-build.html">Sphinx</ulink>
      ただし <ulink url="https://pypi.python.org/pypi/sphinx_rtd_theme">sphinx_rtd_theme</ulink> を含む
    </para>
@z

@x
      User Notes: <ulink url="&blfs-wiki;/gsl"/>
@y
      &UserNotes;: <ulink url="&blfs-wiki;/gsl"/>
@z

@x
    <title>Installation of Gsl</title>
@y
    <title>&InstallationOf1;Gsl&InstallationOf2;</title>
@z

@x
      Install <application>Gsl</application> by running the following commands:
@y
      以下のコマンドを実行して <application>Gsl</application> をビルドします。
@z

@x
      If you have the optional <application>Sphinx</application> package
      installed, buid the documentation with:
@y
      任意のパッケージ <application>Sphinx</application> をインストールしている場合は、以下によりドキュメントを生成します。
@z

@x
      To test the results, issue: <command>make check</command>.
@y
      ビルド結果をテストする場合は <command>make check</command> を実行します。
@z

@x
      Now, as the <systemitem class="username">root</systemitem> user:
@y
      <systemitem class="username">root</systemitem> ユーザーになって以下を実行します。
@z

@x
      If you built the documentation, install it (as <systemitem
      class="username">root</systemitem>) with:
@y
    ドキュメントを生成していた場合は (<systemitem
      class="username">root</systemitem> になって) インストールします。
@z

@x
    <title>Command Explanations</title>
@y
    <title>&CommandExplanations;</title>
@z

@x
    <title>Contents</title>
@y
    <title>&Contents;</title>
@z

@x
      <segtitle>Installed Programs</segtitle>
      <segtitle>Installed Libraries</segtitle>
      <segtitle>Installed Directory</segtitle>
@y
      <segtitle>&InstalledPrograms;</segtitle>
      <segtitle>&InstalledLibraries;</segtitle>
      <segtitle>&InstalledDirectories;</segtitle>
@z

@x
        <seg>
          gsl-config, gsl-histogram, and gsl-randist
        </seg>
        <seg>
          libgslcblas.so and libgsl.so
        </seg>
        <seg>
          /usr/include/gsl and /usr/share/doc/gsl-&gsl-version;
        </seg>
@y
        <seg>
          gsl-config, gsl-histogram, gsl-randist
        </seg>
        <seg>
          libgslcblas.so, libgsl.so
        </seg>
        <seg>
          /usr/include/gsl, /usr/share/doc/gsl-&gsl-version;
        </seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x gsl-config
            is a shell script to get the version number and compiler flags of
            the installed <application>Gsl</application> library.
@y
            インストールされている <application>Gsl</application> ライブラリのバージョン番号やコンパイラーフラグの情報を取得します。
@z

@x gsl-histogram
            is a demonstration program for the GNU Scientific Library that
            computes a histogram from data taken from stdin.
@y
            標準入力よりデータを得てヒストグラムを計算する GNU 科学技術計算ライブラリ (GNU Scientific Library) のデモプログラムです。
@z

@x gsl-randist
            is a demonstration program for the GNU Scientific Library that
            generates random samples from various distributions.
@y
            さまざまな分布から乱数サンプルを生成する GNU 科学技術計算ライブラリ (GNU Scientific Library) のデモプログラムです。
@z

@x libgslcblas.so
            contains functions that implement a C interface to Basic Linear
            Algebra Subprograms.
@y
            基本線形代数サブプログラム (Basic Linear Algebra Subprograms) への C 言語インターフェースを実装する関数を提供します。
@z

@x libgsl.so.so
            contains functions that provide a collection of numerical routines
            for scientific computing.
@y
            科学技術計算に関するさまざまな数値ルーチンを提供します。
@z
