%
% This is part of BLFSbookja package.
%
% This is a CTIE change file for the original XML source of the BLFSbook.
%
% $Author: matsuand $
% $Rev: 56 $
% $Date:: 2020-08-20 17:37:38 +0900#$
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <!ENTITY libxslt-buildsize     "36 MB (with tests)">
  <!ENTITY libxslt-time          "0.3 SBU (with tests)">
@y
  <!ENTITY libxslt-buildsize     "36 MB (テスト込み)">
  <!ENTITY libxslt-time          "0.3 SBU (テスト込み)">
@z

@x
    <title>Introduction to libxslt</title>
@y
    <title>&IntroductionTo1;libxslt&IntroductionTo2;</title>
@z

@x
      The <application>libxslt</application> package contains
      XSLT libraries used for extending <filename
      class="libraryfile">libxml2</filename> libraries to
      support XSLT files.
@y
      <application>libxslt</application> パッケージは XSLT ライブラリを提供します。
      これは <filename class="libraryfile">libxml2</filename> ライブラリを拡張して XSLT ファイルをサポートするために利用します。
@z

@x
    <bridgehead renderas="sect3">Package Information</bridgehead>
@y
    <bridgehead renderas="sect3">&PackageInformation;</bridgehead>
@z

@x
          Download (HTTP): <ulink url="&libxslt-download-http;"/>
@y
          &Download; (HTTP): <ulink url="&libxslt-download-http;"/>
@z

@x
          Download (FTP): <ulink url="&libxslt-download-ftp;"/>
@y
          &Download; (FTP): <ulink url="&libxslt-download-ftp;"/>
@z

@x
          Download MD5 sum: &libxslt-md5sum;
@y
          &Download; MD5 sum: &libxslt-md5sum;
@z

@x
          Download size: &libxslt-size;
@y
          &DownloadSize;: &libxslt-size;
@z

@x
          Estimated disk space required: &libxslt-buildsize;
@y
          &Estimateddiskspacerequired;: &libxslt-buildsize;
@z

@x
          Estimated build time: &libxslt-time;
@y
          &Estimatedbuildtime;: &libxslt-time;
@z

@x
    <bridgehead renderas="sect3">libxslt Dependencies</bridgehead>
@y
    <bridgehead renderas="sect3">&Dependencies1;libxslt&Dependencies2;</bridgehead>
@z

@x
    <bridgehead renderas="sect4">Required</bridgehead>
    <para role="required">
      <xref linkend="libxml2"/>
    </para>
@y
    <bridgehead renderas="sect4">&Required;</bridgehead>
    <para role="required">
      <xref linkend="libxml2"/>
    </para>
@z

@x
    <bridgehead renderas="sect4">Recommended</bridgehead>
    <para role="recommended">
      <xref linkend="DocBook"/> and
      <xref linkend="docbook-xsl"/>
    </para>
@y
    <bridgehead renderas="sect4">&Recommended;</bridgehead>
    <para role="recommended">
      <xref linkend="DocBook"/>,
      <xref linkend="docbook-xsl"/>
    </para>
@z

@x
        Although it is not a direct dependency, many applications
        using <application>libxslt</application> will expect
        <xref linkend="DocBook"/> and <xref linkend="docbook-xsl"/>
        to be present.
@y
        <application>libxslt</application> を利用しているアプリケーションは、直接の依存関係ではないにせよ、<xref
        linkend="DocBook"/> や <xref linkend="docbook-xsl"/> を必要としているものが多々あります。
@z

@x
    <bridgehead renderas="sect4">Optional</bridgehead>
    <para role="optional">
      <xref linkend="libgcrypt"/> and 
      <xref linkend="libxml2py2"/>
      <!-- Seems to be used for tests -->
      <note><simpara>The <xref role="nodep" linkend="libxml2py2"/> 
      dependency is only appropriate if the <application>Python2</application>
      module for this package is needed. The
      libxslt <application>Python2</application> module is not needed for
      any package in BLFS but various non-BLFS packages may install
      <application>Python2</application> modules which reference it.
      </simpara></note>
    </para>
@y
    <bridgehead renderas="sect4">&Optional;</bridgehead>
    <para role="optional">
      <xref linkend="libgcrypt"/>,
      <xref linkend="libxml2py2"/>
      <!-- Seems to be used for tests -->
      <note><simpara>The <xref role="nodep" linkend="libxml2py2"/> 
      dependency is only appropriate if the <application>Python2</application>
      module for this package is needed. The
      libxslt <application>Python2</application> module is not needed for
      any package in BLFS but various non-BLFS packages may install
      <application>Python2</application> modules which reference it.
      </simpara></note>
    </para>
@z

@x
    <para condition="html" role="usernotes">User Notes:
@y
    <para condition="html" role="usernotes">&UserNotes;:
@z

@x
    <title>Installation of libxslt</title>
@y
    <title>&InstallationOf1;libxslt&InstallationOf2;</title>
@z

@x
      Install <application>libxslt</application> by running the following
      commands:
@y
      以下のコマンドを実行して <application>libxslt</application> をビルドします。
@z

@x
      To test the results, issue: <command>make check</command>.
@y
      ビルド結果をテストする場合は <command>make check</command> を実行します。
@z

@x
      Now, as the <systemitem class="username">root</systemitem> user:
@y
      <systemitem class="username">root</systemitem> ユーザーとなって以下を実行します。
@z

@x
    <title>Command Explanations</title>
@y
    <title>&CommandExplanations;</title>
@z

@x
    <title>Contents</title>
@y
    <title>&Contents;</title>
@z

@x
      <segtitle>Installed Programs</segtitle>
      <segtitle>Installed Libraries</segtitle>
      <segtitle>Installed Directories</segtitle>
@y
      <segtitle>&InstalledPrograms;</segtitle>
      <segtitle>&InstalledLibraries;</segtitle>
      <segtitle>&InstalledDirectories;</segtitle>
@z

@x
        <seg>
          xslt-config and xsltproc
        </seg>
        <seg>
          libexslt.so, libxslt.so and optionally, libxsltmod.so
          <application>Python</application> module
        </seg>
        <seg>
          /usr/include/libexslt,
          /usr/include/libxslt,
          /usr/lib/libxslt-plugins,
          /usr/share/doc/libxslt-&libxslt-version;, and
          /usr/share/doc/libxslt-python-&libxslt-version;</seg>
@y
        <seg>
          xslt-config, xsltproc
        </seg>
        <seg>
          libexslt.so, libxslt.so, さらに任意ビルドとして libxsltmod.so
          <application>Python</application> モジュール
        </seg>
        <seg>
          /usr/include/libexslt,
          /usr/include/libxslt,
          /usr/lib/libxslt-plugins,
          /usr/share/doc/libxslt-&libxslt-version;,
          /usr/share/doc/libxslt-python-&libxslt-version;</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x xslt-config
            is used to find out the pre-processor, linking and
            compiling flags necessary to use the <application>libxslt</application>
            libraries in 3rd-party programs.
@y
            サードパーティー製のプログラムが <application>libxslt</application> ライブラリを利用するにあたって、必要となるプリプロセッサー、コンパイルフラグ、リンクフラグを決定するために利用します。
@z

@x xsltproc
            is used to apply XSLT stylesheets to XML documents.
@y
            XML ドキュメントファイルに対して XSLT スタイルシートを適用します。
@z

@x libexslt.so
            is used to provide extensions to XSLT functions.
@y
            XSLT 関数を取り扱う拡張機能を提供します。
@z

@x libxslt.so
            provides extensions to the
            <filename class="libraryfile">libxml2</filename>
            libraries to parse files that use the XSLT format.
@y
            <filename class="libraryfile">libxml2</filename> ライブラリを拡張して XSLT 形式のファイルを取り扱う機能を提供します。
@z
