﻿using System;

using Vintagestory.API.Common;
using Vintagestory.API.Config;
using Vintagestory.API.MathTools;
using Vintagestory.API.Server;
using Vintagestory.GameContent;

namespace AdjustorMod
{
	public static class Tamperers
	{
		private const string _chuteCode = @"chute";//Just for "normal" Chutes...

		public static bool TryUnborkChute(this ICoreServerAPI ServerAPI, Block thatBlock, BlockPos position)
		{
		if (thatBlock.IsChute( )) {
		var entity = ServerAPI.World.BlockAccessor.GetBlockEntity(position) as BlockEntityItemFlow;
		UnborkChute_ItemFlowStates(entity);
		return true;
		}
		return false;
		}

		private static void UnborkChute_ItemFlowStates( BlockEntityItemFlow itemFlowEntity)
		{
		if (itemFlowEntity == null) return;

		var theChute = itemFlowEntity.Block as BlockChute;

		if (theChute.Attributes != null) 
		{
			if (theChute.Attributes["pullFaces"].Exists) {
			string[ ] faces = theChute.Attributes["pullFaces"].AsArray<string>(null);
			itemFlowEntity.PullFaces = new BlockFacing[faces.Length];
			for (int i = 0; i < faces.Length; i++) itemFlowEntity.PullFaces[i] = BlockFacing.FromCode(faces[i]);
			}

			if (theChute.Attributes["pushFaces"].Exists) {
			string[ ] faces = theChute.Attributes["pushFaces"].AsArray<string>(null);
			itemFlowEntity.PushFaces = new BlockFacing[faces.Length];
			for (int i = 0; i < faces.Length; i++) itemFlowEntity.PushFaces[i] = BlockFacing.FromCode(faces[i]);
			}

			if (theChute.Attributes["acceptFromFaces"].Exists) {
			string[ ] faces = theChute.Attributes["acceptFromFaces"].AsArray<string>(null);
			itemFlowEntity.AcceptFromFaces = new BlockFacing[faces.Length];
			for (int i = 0; i < faces.Length; i++) itemFlowEntity.AcceptFromFaces[i] = BlockFacing.FromCode(faces[i]);
			}
		}

		}

		public static bool IsChute(this Block thatBlock)
		{
		return thatBlock.Code.BeginsWith(GlobalConstants.DefaultDomain, _chuteCode);
		}
	}
}

