﻿using System;
using System.Text;


using Vintagestory.API.Common.Entities;
using Vintagestory.API.Server;
using Vintagestory.API.Common;


namespace AdminToolkit
{
	public class AdminListingCommand : AdminModCommand
	{						
		public AdminListingCommand(ICoreServerAPI _serverAPI ): base(_serverAPI)
		{			
		this.Command = "admins";
		this.Description = "List of Server Administrators";
		this.handler += AdminsitratorListing;
		}


		private void AdminsitratorListing(IServerPlayer player, int groupId, CmdArgs args)
		{
			player.SendMessage(groupId, "Listing Administrators:", EnumChatType.CommandSuccess);

			StringBuilder msgLine = new StringBuilder( );

			foreach (var srvPlayer in ServerAPI.Server.Players) {
				if (AdminToolkit.AdminRoles.Contains(srvPlayer.Role.Code)) {

					msgLine.AppendFormat("<font color='{2}'>[{0}]</font>  -- \"{1}\" ", srvPlayer.Role.Name, srvPlayer.PlayerName, srvPlayer.Role.Color.Name);

					if (srvPlayer.ConnectionState == EnumClientState.Playing) {
						msgLine.AppendFormat("IS: <font color='lime'>*{0}*</font>", srvPlayer.ConnectionState);
					} else {
						msgLine.AppendFormat("IS: <font color='yellow'>{0}</font>", srvPlayer.ConnectionState);
					}

					if (srvPlayer.ServerData.CustomPlayerData.ContainsKey(AdminToolkit._lastLoginKey)) {
						msgLine.AppendFormat(" Last Login: {0}", srvPlayer.ServerData.CustomPlayerData[AdminToolkit._lastLoginKey]);
					}
					msgLine.AppendLine( );
				}
			}

			player.SendMessage(groupId, msgLine.ToString( ), EnumChatType.CommandSuccess);
		}

	}
}

