﻿using System;
using System.Text;
using System.Linq;
using System.Collections.Generic;
using System.IO;

using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.API.Config;
using Vintagestory.API.Datastructures;

namespace AdminToolkit
{
	public partial class AdminToolkit : ModSystem
	{
		private void PopulateAdminRoleTable( )
		{
		AdminRoles = new List<string>( );
		foreach (var role in ServerAPI.Server.Config.Roles) {

		if (role.PrivilegeLevel >= 200 && role.Privileges.Any(adminPriviledges.Contains)) {

		AdminRoles.Add(role.Code);

		#if DEBUG
		Mod.Logger.VerboseDebug("Role {0} =[{1}] considerd Admin-like", role.Name, role.Code);
		#endif
		}
		}
		}

		private void PrepareServersideConfig( )
		{
		AdminModConfig config = ServerAPI.LoadModConfig<AdminModConfig>(_configFilename);

		if (config == null) {
		//Regen default
		Mod.Logger.Warning("Regenerating default config as it was missing / unparsable...");
		ServerAPI.StoreModConfig<AdminModConfig>(new AdminModConfig( ), _configFilename);
		config = ServerAPI.LoadModConfig<AdminModConfig>(_configFilename);
		}

		this.CachedConfiguration = config;

		if (this.CachedConfiguration.RuleRoleChangerEnabled) { Mod.Logger.Notification("Admin toolkit; Role change on Rule accept: * ENABLED *"); }
		}

		/// <summary>
		/// Makes Administrator text messages appear 'different'
		/// </summary>
		/// <returns>The voice of authority.</returns>
		/// <param name="byPlayer">By player.</param>
		/// <param name="channelId">Channel identifier.</param>
		/// <param name="message">Message.</param>
		/// <param name="consumed">Consumed.</param>		                                      
		private void BoomingVoiceOfAuthority(IServerPlayer byPlayer, int channelId, ref string message, ref string data, BoolRef consumed)
		{
		if (AdminRoles.Contains(byPlayer.Role.Code)) {
		//Make text lined
		consumed.value = false;
		StringBuilder adminMessage = new StringBuilder( );
		foreach (char letter in message) {

		adminMessage.Append(letter);
		if (!Char.IsWhiteSpace(letter)) {
		//adminMessage.Append(@"̅̅̅");
		adminMessage.Append(@"̲");
		}
		}

		message = adminMessage.ToString( );
		}
		}

		private void SaveConfigSettings( )
		{
		if (this.CachedConfiguration != null) {
		Mod.Logger.Notification("Persisting configuration.");
		ServerAPI.StoreModConfig<AdminModConfig>(this.CachedConfiguration, _configFilename);
		}
		}

		private void WelcomeMessage(IServerPlayer byPlayer)
		{
		if (AdminToolkit.AdminRoles.Contains(byPlayer.Role.Code)) {
		//Annonce to all players that Admin\Moderator has arrived

		StringBuilder adminMessage = new StringBuilder( );
		
		adminMessage.Append(MultiLang.Get(byPlayer, @"atk:admin_present",byPlayer.Role.Name, byPlayer.Role.Color.Name, byPlayer.PlayerName));

		ServerAPI.SendMessageToGroup(GlobalConstants.AllChatGroups, adminMessage.ToString( ), EnumChatType.AllGroups);

		byPlayer.ServerData.CustomPlayerData[AdminToolkit._lastLoginKey] = DateTimeOffset.UtcNow.ToString("u");
		}

		double elapsedDays = 0D;
		string elapsedDayStr;

		if (byPlayer.ServerData.CustomPlayerData.TryGetValue(AdminToolkit._lastGameDayCountKey, out elapsedDayStr)
			&&
			double.TryParse(elapsedDayStr, out elapsedDays)) {
		elapsedDays = ServerAPI.World.Calendar.TotalDays - elapsedDays;
		var playerPos = byPlayer.Entity.Pos.AsBlockPos.Copy();
		
		//No Localized Season/Hemispehere names?		
		string welcomebackMsg = MultiLang.Get(byPlayer, @"atk:welcomeback-message",
				                          elapsedDays,
				                          ServerAPI.World.AllOnlinePlayers.Length,
				                          ServerAPI.World.Calendar.GetSeason(playerPos),
				                          ServerAPI.World.Calendar.GetHemisphere(playerPos)
										 );

		byPlayer.SendMessage(GlobalConstants.CurrentChatGroup, welcomebackMsg, EnumChatType.OthersMessage);
		}
		else {
		string welcomeMsg = MultiLang.Get(byPlayer, @"atk:welcome-message",
									 ServerAPI.World.Calendar.PrettyDate( )
				                    );
		byPlayer.SendMessage(GlobalConstants.CurrentChatGroup,welcomeMsg, EnumChatType.OthersMessage);
		}

		byPlayer.ServerData.CustomPlayerData[AdminToolkit._lastGameDayCountKey] = ServerAPI.World.Calendar.TotalDays.ToString("R");


		}
	}
}

