﻿
Instructions for using the Administrator's Toolkit (V0.3.6);
============================================================

It provides the (server side only) commands:

*	/rules
*	/admins
*	/backups
*	/pings
*	/spawnpoints

The configuration file: 'admintoolkit.json' ( %home%/.config/VintagestoryData/ModConfig ); 
Note: by default most features are _DISABLED_ . 


RULES
-----


Server administrators should create a unicode *(UTF-8)* text file;

(server config directory root): /Rules/rules_en.txt

Keep it small (1~2K) as it spools _ONE-LINE-AT-A-TIME_ to players that have used the 
'/rules' command. (CR/LF is acceptable - .NET supports either line endings)

Any player can issue the '/rules accept' command to "Accept" whatever the rules mean; (it keeps track - they can only 'accept' once)

This _CAN_ have an effect of changing the players role (IF the 'admintoolkit.json' is setup).

See: '/ModConfig/admintoolkit.json' - 

>  "PlayerRoleRestrain": "suvisitor",   <--  This is the role they are 'demoted' to just-after joining; when the have *NOT* already accepted the rules.
>  "PlayerRoleNormal": "suplayer",      <--  This is the role that a 'normal' player will be 'promoted' to, after using '/rules accept'
>  "RuleRoleChangerEnabled": false,     <--  When 'true' players roles WILL Be CHANGED depending on IF they 'accepted' the rules (/rules just prints out the rules)

All these roles must exist and use the 'code' name, any misconfiguration will prevent the command from working. (with error messages in the log...)

BACKUPS
-------


An automatic call to the '/genbackup' command exists as a Administrator only ('controlserver' permission) function.
By default it isn't automatically activated;


Manual triggering of the backup cycle with:

'/backups enable'


And to stop the automatic backup process;

'/backups disable'

Note; This process ISN'T AWARE OF FREE DISK SPACE!
(the '/genbackup' command itself may fail without free disk/volume space!)

To alter the time delay:

'/backups delay 9'

Sets the delay to 9 hours (and restarts the backup schedule IF its already active).


To inquire about the existing backups and when the last one was issued;

'/backups stats' - will print out various information about when/if/how many, backups were made...if any.


The number of "old" backup files to keep (at least 4):

'/backups count 10'


See: '/ModConfig/admintoolkit.json' - 

>  "BackupDelay": "04:00:00", 	<-- The time-span delay BETWEEN Starting a backup. In "HH:MM:SS" format, so to delay 3 Hours, 15 Minutes, 21 Seconds: "03:15:21" It is limited to a max of 500 HOURS.
>  "BackupCount": 6,			<-- The count of backups; minimum of 4, max is uint. (billions...) to keep around.
>  "Autobackup": false        	<-- set to true if you want the server to automatically run the backup cycle UNATTENDED, without an admin issuing '/backups enable'



Note; The 'admin' role needs to exist for internal use purposes, this mod will NOT function correctly without it.


ADMINS
------

'/admins'

Usable by anyone - it just prints a listing of all higher role(s) 
currently present (or not) on the server - offline admins also.



BOOMING VOICE
-------------

A special feature for admins; their text messages get underlined.

edit file ('/ModConfig/admintoolkit.json' ) :

>	"BoomingVoice": true



VARIABLE SPAWNS
---------------

Lets admins define and have players spawn from a list of pre-defined coordinates. 
(chosen at random, equal weighting)

Config file setting: "VariableSpawnpoints" : set value to 'true' or 'false' (no quotes)

Use command:
/spawnpoints

/spawnpoints add {name} {5123 100 3992} | here

(either 'here' where admin is standing OR manually entered RELATIVE (to-spawn) coordinates)

/spawnpoints remove {name}

(by name of spawnpoint)

/spawnpoints list

/spawnpoints enable

/spawnpoints disable

NOTE: The spawn randomization code relies on a pre-set player group
in the 'admintoolkit.json' configuration file value : [PlayerRoleNormal].

This _MUST_ be correct - if your server uses a different role than "suplayer", set accordingly.
Only 1 role is supported for the Variable Spawns.