﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Drawing;

using Vintagestory.API.Client;
using Vintagestory.API.Common;
using Vintagestory.API.MathTools;

namespace Automap
{
	public delegate void DesignatonAction(ICoreClientAPI clientAPI, PointsOfInterest poi, BlockPos posn, Block block);

	/// <summary>
	/// Point of Interest Rule Designator
	/// </summary>
	public class Designator
	{		
		public Color OverwriteColor;
		public DesignatonAction SpecialAction;
		public AssetLocation Pattern;
		public EnumBlockMaterial? Material;

		private Designator( )
		{
		throw new NotSupportedException( );
		}

		public Designator( AssetLocation pattern , Color overwriteColor, EnumBlockMaterial? material)
		{			
			this.Pattern = pattern;
			this.OverwriteColor = overwriteColor;
			Material = material;
		}

		public Designator(AssetLocation pattern, Color overwriteColor, EnumBlockMaterial? material ,DesignatonAction specialAct )
		{
		this.Pattern = pattern;
		this.OverwriteColor = overwriteColor;
		this.Material = material;
		this.SpecialAction = specialAct;
		}

		public override string ToString( )
		{
			return Pattern.ToShortString() +"|"+ OverwriteColor.Name + "|" + Material ?? "";
		}
	}
}

