﻿using System;

using Vintagestory.API.Util;

using Hjg.Pngcs;
using Hjg.Pngcs.Chunks;

namespace Automap
{
	/// <summary>
	/// Png metadata chunk.
	/// </summary>
	/// <remarks>There can be only one. (per PNG file)</remarks>
	public class PngMetadataChunk : PngChunkSingle
	{
		// ID must follow the PNG conventions: four ascii letters,
		public readonly static string ID = "cHUK";

		public ColumnMeta ChunkMetadata { get; set; }


		public PngMetadataChunk(ImageInfo info) : base(ID, info)
		{
			
		}

		public override ChunkOrderingConstraint GetOrderingConstraint( )
		{
		return ChunkOrderingConstraint.NONE;
		}

		public override ChunkRaw CreateRawChunk( )
		{		 
		var datas = SerializerUtil.Serialize<ColumnMeta>(ChunkMetadata);

		ChunkRaw rawChunk = createEmptyChunk(datas.Length, true);
		rawChunk.Data = datas;

		return rawChunk;
		}

		public override void ParseFromRaw(ChunkRaw rawChunk)
		{
		this.ChunkMetadata = SerializerUtil.Deserialize<ColumnMeta>(rawChunk.Data);		
		}

		public override void CloneDataFromRead(PngChunk other)
		{
		PngMetadataChunk clone = ( PngMetadataChunk )other;
		this.ChunkMetadata = clone.ChunkMetadata; 
		}

	}
}

