/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by  Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 *  CPUˑ^C}W[iIntegratorpj
 *  TIMER1(24MhzŒ)gp
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <integrator.h>

/*
 *  ^C}݂̊ݔԍ
 */
#define    INHNO_TIMER    IRQ_TM1_BIT

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UW    CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *  TIMER_CLOCK ̓^[Qbg{[hɐݒ
 */
#define TO_CLOCK(nume, deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK    ((CLOCK) 0xffffffff)
/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
    CLOCK    cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
        
    /*
     *  ^C}֘A̐ݒ
     */
    /* ^C}~ */
    sil_wrw_mem((VP)TM1_CTRL,TCTRL_STOP);
    /* ^C}l̃`FbN */
    assert(cyc <= MAX_CLOCK);       
    /* ݂̃NA  */
    sil_wrw_mem((VP)TM1_CTRL,TCLR_CLEAR);
    sil_wrw_mem((VP)TM1_LOAD,cyc);
    /* JEglZbg */
    sil_wrw_mem((VP)TM1_VAL,cyc);
    /* JEgX^[g   */
    sil_wrw_mem((VP)TM1_CTRL,TCTRL_START|TCTRL_PERIODIC);
    /* ݋ */        
    sil_wrw_mem((VP)IRQ0_ENABLESET,IRQ_TM1);
}

/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
  sil_wrw_mem((VP)TM1_CLR,0x01);    /* yfBOrbgNA */
}

/*
 *  ^C}̒~
 */
Inline void
hw_timer_terminate()
{
    /* yfBOrbgNA */
    sil_wrw_mem((VP)TM1_CLR,0x01);    
    /* ^C}~ */
    sil_wrw_mem((VP)TM1_CTRL,TCTRL_STOP);
    /* ݕs*/
    sil_wrw_mem((VP)IRQ0_ENABLECLR,
                sil_rew_mem((VP)IRQ0_ENABLECLR)&~IRQ_TM1);
}

/*
 *  ^C}̌ݒl̓ǂ݂
 *
 *  ݋֎~ԒŌĂяoƁD
 */
Inline CLOCK
hw_timer_get_current(void)
{
    return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TM1_VAL));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)IRQ0_STATUS) & IRQ_TM1);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



