/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2008 by TOPPERS/JSP for CORTEX-M3 project
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.19 2008/08/02 07:36:14 suikan Exp $
 */

/*
 *	vZbTˑW[iCORTEX-M3pj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 * CORTEX-M3ڐÁuߑvBRpCG[Ԃ߂
 * ֋XAɂ֐̒CM3NIƏĂBȉ#define`
 * RgAEgƁAڐAĂȂ֐􂢏oB
 * 
 * CORTEX-M3 Not Implemented
 */
#define CM3NI
 
/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */


/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	sp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;



/*
 *  VXeԎQ
 * 
 *  ^XNEReLXgȂTRUEԂBTOPPERS/JSP for CORTEX-M3ł́A
 *  ^XNEReLXgThread[hɊ蓖ĂĂ邽߁Aipsr0Ȃ^XN
 *  ReLXgAȊO͔^XNEReLXgƂB̊֐́Adispatch()
 *  ŌĂԂƐmȏԂȂAdispatch()͂Ă΂Ȃ̂ŖȂB
 * 
 * MRS Rx, IPSR ߂IPSR̒loBIPSR͉9bitɎsx
 * Ă̂ŁA}XNŎoĐ^UɂB
 */

Inline BOOL
sense_context()
{
	unsigned int ipsr_value;
	
	Asm( "mrs %0,ipsr" : "=r"(ipsr_value) );
	return(ipsr_value & 0x1FF);
}

/*
 *  bNԎQ
 * 
 * CPUbNԂȂTRUEԂBTOPPERS/JSP for CORTEX-M3ł́A
 * S荞݋֎~ăbNԂƂB̂߁APRIMASKbit1
 * bNԂ𔽉fB
 * 
 * MRS Rx, PRIMASK ߂PRIMASK̒loBPRIMASKLSB
 * 荞݋֎~ĂA1Ȃ֎~łB}XNŎo
 * ^UɂB
 */

Inline BOOL
sense_lock()
{
	unsigned int primask_value;
	
	Asm( "mrs %0,primask" : "=r"(primask_value) );
	return(primask_value & 0x01);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 * CPUbNƂ̉i^XNReLXgpj
 *
 * CORTEX-M3łł́ACPUbNS荞݋֎~ōsB̂߁A
 * CPSID I߂CPUbNACPSIE I߂ŃAbNłB
 * ߂̓ReLXgɂ炸gB
 */


Inline void
t_lock_cpu()
{
	Asm( "cpsid i" );
}

Inline void
t_unlock_cpu()
{
	Asm( "cpsie i" );
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

#define i_lock_cpu t_lock_cpu
#define i_unlock_cpu t_unlock_cpu

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* Onh̋NԒn */
} EXCVE;

extern EXCVE exception_vector[];

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{

	exception_vector[inhno].exchdr = inthdr;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	exception_vector[excno].exchdr = exchdr;
}

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 */

#define	INTHDR_ENTRY(inthdr)		\
extern void inthdr##_entry(void);	\
asm(".text				\n" \
#inthdr "_entry:			\n" \
"	push {lr} \n"				/* ߂Ԓnۑ */\
"	ldr r0,=" #inthdr "+1 \n"		/* nh̔Ԓn */\
"	blx r0 \n"					/* nhĂяo */\
"	pop {lr} \n"				/* ߂Ԓn𕜋A */\
"	and r0,lr,#0x0F \n"			/* EXC_RETURN̉4bito */\
"	cmp r0,#0x0D \n"			/* LSB 4bit 0b1101Ȃ΁AԊO̊荞 */\
"   beq.w _kernel_ret_int \n"	/* ԊOȂo */\
"	bx lr " );					/* ^[ */

#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPUOnh̏o̐}N
 *
 * CORTEX-M3łł͎Ȃ
 */

#define	EXCHDR_ENTRY(exchdr)
#define	EXC_ENTRY(exchdr)	exchdr##_entry

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 *  CORTEX-M3łł͎ȂBԂ̂͂ł߂̒lłB
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return(0);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 *  CORTEX-M3łł͎ȂBԂ̂͂ł߂̒lłB
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(0);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
