/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[ AZuꕔ
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"

/*
 *  VXeˑ̏[`
 */
	.h8300h
	.text
	.align 2

	.global	_hardware_init_hook
_hardware_init_hook:
	/*
	 *  [Xł́AODRAMLɂB
	 */
#ifdef ROM
	mov.l	#H8P1DDR, er0
	mov.b	#0xff, r1l
	mov.b	r1l, @er0	/* enable A0  - A7  */

	add.b	#(H8P2DDR - H8P1DDR), r0l
	mov.b	r1l, @er0	/* enable A8  - A15 */

	add.b	#(H8P3DDR - H8P2DDR), r0l
	mov.b	r1l, @er0	/* enable D8  - D15 */

	add.b	#(H8P5DDR - H8P3DDR), r0l
	mov.b	r1l, @er0	/* enable A16 - A19 */

#ifdef ENABLE_LOWER_DATA

	mov.l	#H8P4DDR, er0
	mov.b	r1l, @er0	/* enable D0  - D7  */

#endif	/* #if ENABLE_LOWER_DATA */

#ifdef ENABLE_P8_CS

	mov.l	#H8P8DDR, er0
	mov.b	#ENABLE_P8_CS, r1l
	mov.b	r1l, @er0	/* enable CS0 - CS3 */

#endif	/* #ifdef ENABLE_P8_CS */

#ifdef ENABLE_PA_CS

	mov.l	#H8PADDR, er0
	mov.b	#ENABLE_PA_CS, r1l
	mov.b	r1l, @er0	/* enable CS4 - CS6 */

#elif defined(ENABLE_PA_A21_A23)

	mov.l	#H8PADDR, er0
	mov.b	#ENABLE_PA_A21_A23, r1l
	mov.b	r1l, @er0	/* enable A21 - A23 */

#endif	/* #ifdef ENABLE_PA_CS */

#ifdef ENABLE_PB_CS

	mov.l	#H8PBDDR, er0
	mov.b	#ENABLE_PB_CS, r1l
	mov.b	r1l, @er0	/* enable CS7 */

#endif	/* #ifdef ENABLE_PB_CS */

#endif	/*  #ifdef ROM  */

	rts
