/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: h8_sil.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 * VXeC^tF[XCiǉj
 *@@I/O|[g̃f[^EfBNVEWX^DDRւ̃ANZX
 *@@H8DDR͏ݐpłÂ܂܂ł͏]̃rbg
 *@@ύX邱ƂłȂBibset,bclr߂łsj
 *@@̂߁A{ł́AɃe|pӂāADDR
 *@@ݒlێ@̂ĂB
 *@@
 *@@ȂA|[g7͓͐pDDRWX^Ȃ߁AȗĂB
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <h8_sil.h>

#define	DUMMY	0

/*  ̃e|̈  */
static UB ddr_tmp[] = {
	/* 1         2         3         4         5      */
	H8P1DDR0, H8P2DDR0, H8P3DDR0, H8P4DDR0, H8P5DDR0, 
	/* 6         8         9         A         B      */
	H8P6DDR0, H8P8DDR0, H8P9DDR0, H8PADDR0, H8PBDDR0
};

/*  e|[g̃AhX  */
static const VP ddr_adr[] = {
	(VP)H8P1DDR, (VP)H8P2DDR, (VP)H8P3DDR, (VP)H8P4DDR, (VP)H8P5DDR, 
	(VP)H8P6DDR, (VP)H8P8DDR, (VP)H8P9DDR, (VP)H8PADDR, (VP)H8PBDDR
};


/*
 *  ԑ҂
 *  @vg^Cv錾sil.hɂ
 */
void sil_dly_nse(UINT dlytim) {
	/* er0 = dlytim */
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM1) );
	Asm("		ble	sil_dly_nse_2");
				/* dlytim < SIL_DLY_TIM1 Ȃ烋[vI */
	Asm("	sil_dly_nse_1:");
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM2) );
	Asm("		bgt	sil_dly_nse_1");
				/* dlytim > SIL_DLY_TIM2 Ȃ烋[vs */
	Asm("	sil_dly_nse_2:");
}

/*
 *      DDR̓ǂݏo
 */
UB sil_reb_ddr(UINT port)
{
	assert((IO_PORT1 <= port) && (port <= IO_PORTB));
	return ddr_tmp[port];
}

/*
 *      DDȐ
 */
void sil_wrb_ddr(UINT port, UB data)
{
	assert((IO_PORT1 <= port) && (port <= IO_PORTB));
	ddr_tmp[port] = data;
	sil_wrb_mem(ddr_adr[port], (VB)data);
}

/*
 *      DDRANDZ
 */
void sil_anb_ddr(UINT port, UB data)
{
	UB ddr = sil_reb_ddr(port);
	
	ddr &= data;
	sil_wrb_ddr(port, ddr);
}

/*
 *      DDRORZ
 */
void sil_orb_ddr(UINT port, UB data)
{
	UB ddr = sil_reb_ddr(port);

	ddr |= data;
	sil_wrb_ddr(port, ddr);
}

