/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *  vZbTˑW[(H8Sp)
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT֘A̒`
 */
#include <h8s.h>
#include <h8s_sil.h>

/*
 *  ݒ\ȃJ[lǗ̍ō݃rbgp^[
 *  (GNXehWX^֐ݒ;cpu_insn.h ŗp̂ŁAɒ`B)
 */
#ifndef GDB_STUB
#define  MAX_IPM	7	/* = EXR_I2|EXR_I1|EXR_I0 (ōx) */
#else  /* GDB_STUB */
#define  MAX_IPM	6	/* xV̊荞݂́AGDB_STUB p */
#endif /* GDB_STUB */

#define  str_MAX_IPM	TO_STRING(MAX_IPM)
			/* ݓINTHDR_ENTRY}Np (cpu_config.h) */

/*
 *  vZbT̓ꖽ߂̃CC֐`
 *    ŁAMAX_IPM𗘗pĂ̂ŁA`ɓǂݍ
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IPM

/*
 *  ^XNReLXgubN̒`
 */
#ifndef _MACRO_ONLY

typedef struct task_context_block {
	VP	sp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;

#endif /* _MACRO_ONLY */

/*
 *  VXeԎQ
 */
#ifndef _MACRO_ONLY

/*
 *  ݃lXgJE^
 *    lXgJE^̒lŃReLXg̔fŝŁAReLXgQƎ
 *    pB
 */

extern UW	intnest;

/*
 *  ReLXgQ
 *    ݃lXgJE^ǂݏoɊ݂ĂA߂Ƃɂ
 *    ReLXgɖ߂Ă
 */

Inline BOOL
sense_context(void)
{
	return( intnest > 0 );
}

Inline BOOL
sense_lock(void)
{
	return( current_intmask() == MAX_IPM );
}

#endif /* _MACRO_ONLY */

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

#ifndef _MACRO_ONLY

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Achg_ipm T|[g邽߂̕ϐBchg_ipm T|[g
 *  Ȃꍇɂ́At_unlock_cpu  task_intmask  0 ɒuĂ悢B
 */

#ifdef SUPPORT_CHG_IPM
extern IPM	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
	disint();		/* cpu_insn.h */
}

Inline void
t_unlock_cpu(void)
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽߁B
	 *  ̓r task_intmask 邱Ƃ͂ȂB
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern IPM	int_intmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu(void)
{
	IPM	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Acurrent_intmask()Ă񂾒
	 *  ݂ANꂽ݃nh int_intmask ύX
	 *  \邽߂łB
	 */
	intmask = current_intmask();
	disint();		/* cpu_insn.h */
	int_intmask = intmask;
}

Inline void
i_unlock_cpu(void)
{
	set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *    dispatch ́C^XNReLXgĂяoꂽT[rXR[ŁA
 *    CPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *    exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂB
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh̐ݒ
 *    H8Sł́A݃nhe[u̐ݒROMɒڍsߎgpȂB
 */

Inline void define_inh(INHNO inhno, FP inthdr) {
}

/*
 *  CPUOnh̐ݒ
 *    H8Sł́A݃nhe[u̐ݒROMɒڍsߎgpȂB
 */

Inline void define_exc(EXCNO excno, FP exchdr) {
}

#endif /* _MACRO_ONLY */

/*
 *  ݃nh̏o
 */

/*
 *  ݃nh̓
 *    ̏ɗ܂łɁAn[hEFAɂāAY݃x܂ł݂̊
 *    ֎~鏈sĂB
 *    entryF̃x
 *    inthdrFCꃋ[`̐擪AhX
 */
#define	_INTHDR_ENTRY(entry, inthdr)		    \
asm("	.text					\n" \
"	.align 2				\n" \
"	.global _"#entry"			\n" \
"						\n" \
"_"#entry":					\n" \
"	push.l	er0				\n" \
			/* CPUbNɕKvȃWX^^XNX^bNɑҔ */ \
"	stc.b	exr, r0l			\n" \
			/* exr  r0l (er0) ɃRs[ \
"			  (_kernel_ret_main ŁA݋֎~Ɏg) */ \
"						\n" \
"	ldc.b	#"str_MAX_IPM", exr		\n" \
			/* lock_cpu  (݋֎~) */ \
"						\n" \
"	push.l	er1				\n" \
			/* er1 ^XNX^bNɑҔ */ \
"	mov.l	#_"#inthdr", er1		\n" \
			/* er1 = ݃nh̃AhX */ \
"	jmp	_kernel_ret_main		\n" \
			/* ݓփWv */ \
)

/*
 *  ݃nh̏o̐}N
 */
#define INTHDR_ENTRY(inthdr)			\
	extern void inthdr##_entry(void);	\
	_INTHDR_ENTRY(inthdr##_entry, inthdr)	/* ̏͏L}NŒ` */
#define	INT_ENTRY(inthdr)	inthdr##_entry

/* xN^e[u(sys_support.S)Lqpx擾}N */
#define	__INT_ENTRY(inthdr)	_##inthdr##_entry
#define	_INT_ENTRY(inthdr)	__INT_ENTRY(inthdr)

/*
 *  CPUOnh̏o̐}N
 */
#define	EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)
#define	EXC_ENTRY(exchdr)	exchdr##_entry

/* xN^e[u(sys_support.S)Lqpx擾}N */
#define	__EXC_ENTRY(exchdr)	_##exchdr##_entry
#define	_EXC_ENTRY(exchdr)	__EXC_ENTRY(exchdr)

/*
 *  CPUO̔̃VXeԂ̎Q
 */
#ifndef _MACRO_ONLY

/*
 *  CPUO̔̃ReLXg
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return(intnest > 1);
		/* 1Ɣr̂́AݎsCPUO݃̕lXg
		   JE^CNgĂ邽 */
}

/*
 *  CPUO̔CPUbNԂ̎Q
 *    H8Słł́AĂ΂邱Ƃ͖A\[Xrꍇɐݒ肷B
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(TRUE);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY_ */

/*============================================================================*/
/*  ʃhLgɂ͂ȂAƎ̕  */

/*
 *  ݃xݒp}NíACC֐j
 *  Ex : C^vgvCIeBWX^	( IPRA - IPRK )
 *  Ey : IPRݒp}XNiʂʂ̑Ij	( IPR_UPR, IPR_LOW )
 *  Ez : ݃x				( 0 - 7 )
 */
#ifndef _MACRO_ONLY

Inline void icu_set_ilv( VP ipr, BOOL mask, INT level ) {

	if( mask == IPR_UPR ) {
		h8s_wrb_mem( ipr, ( h8s_reb_mem( ipr ) & ~IPR_UPR_MASK ) | TO_HI4((UB) level) );
	} else if( mask == IPR_LOW ) {
		h8s_wrb_mem( ipr, ( h8s_reb_mem( ipr ) & ~IPR_LOW_MASK ) | TO_LO4((UB) level) );
	}
}

#endif /* _MACRO_ONLY_ */

#ifndef _MACRO_ONLY
/*
 *  `ݔ̃G[o (cpu_config.c, cpu_support.S)
 *    \ EXCSTACK ́Ah8s.h Œ`
 */
extern void	cpu_experr(EXCSTACK *sp);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
