/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _H8S_H_
#define _H8S_H_

#include <util.h>

/*
 *  H8S/2600, H8S/2000 CPU p`
 *    сAoXRg[A݃Rg[֘A̒`
 */

/*
 *  RfBVR[hWX^(CCR)
 */
#define CCR_I		BIT7
#define CCR_UI		BIT6
#define CCR_H		BIT5
#define CCR_U		BIT4
#define CCR_N		BIT3
#define CCR_Z		BIT2
#define CCR_V		BIT1
#define CCR_C		BIT0

/*
 *  GNXehWX^(EXR)
 */
#define EXR_T		BIT7		/* g[Xrbg */
#define EXR_I2		BIT2		/* ݃}XNrbg */
#define EXR_I1		BIT1		/* ݃}XNrbg */
#define EXR_I0		BIT0		/* ݃}XNrbg */

/* ݃}XNrbg擾p}XN */
#define EXR_I_MASK	(EXR_I2|EXR_I1|EXR_I0)

/*
 *  MCU샂[h֘ÃWX^
 */

/* WX^̃AhX */
#define MDCR		0xff3b
#define SYSCR		0xff39

/* eWX^̃rbgp^[ */

/* MDCR */
#define MDS2		BIT2
#define MDS1		BIT1
#define MDS0		BIT0

/* SYSCR */
#define INTM1		BIT5
#define INTM0		BIT4
#define NMIEG		BIT3
#define RAME		BIT0

#define RAME_BIT	0x0

/*
 *  ݃Rg[
 */
/* WX^̃AhX */
/* VXeRg[WX^́Aɒ`ς */
#define ISCRH		0xff2c		/* IRQZXRg[WX^H */
#define ISCRL		0xff2d		/* IRQZXRg[WX^L */
#define IER		0xff2e		/* IRQCl[uWX^ */
#define ISR		0xff2f		/* IRQXe[^XWX^ */
#define IPRA		0xfec4		/* C^vgvCIeBWX^A */
#define IPRB 		0xfec5		/* C^vgvCIeBWX^B */
#define IPRC		0xfec6		/* C^vgvCIeBWX^C */
#define IPRD		0xfec7		/* C^vgvCIeBWX^D */
#define IPRE		0xfec8		/* C^vgvCIeBWX^E */
#define IPRF		0xfec9		/* C^vgvCIeBWX^F */
#define IPRG		0xfeca		/* C^vgvCIeBWX^G */
#define IPRH		0xfecb		/* C^vgvCIeBWX^H */
#define IPRI		0xfecc		/* C^vgvCIeBWX^I */
#define IPRJ		0xfecd		/* C^vgvCIeBWX^J */
#define IPRK		0xfece		/* C^vgvCIeBWX^K */

/* eWX^̃rbgp^[ */

/* IPRx (x = A-K) */
#define IPR6		BIT6
#define IPR5		BIT5
#define IPR4		BIT4
#define IPR2		BIT2
#define IPR1		BIT1
#define IPR0		BIT0

/* icu_set_ilvp */
#define IPR_UPR		TRUE
#define IPR_LOW		FALSE
#define IPR_UPR_MASK	(IPR6|IPR5|IPR4)	/* IPRʃrbg}XN */
#define IPR_LOW_MASK	(IPR2|IPR1|IPR0)	/* IPRʃrbg}XN */

/* IER */
#define IRQ7E		BIT7
#define IRQ6E		BIT6
#define IRQ5E		BIT5
#define IRQ4E		BIT4
#define IRQ3E		BIT3
#define IRQ2E		BIT2
#define IRQ1E		BIT1
#define IRQ0E		BIT0

/* ISCRH */
#define IRQ7SCB		BIT7
#define IRQ7SCA		BIT6
#define IRQ6SCB		BIT5
#define IRQ6SCA		BIT4
#define IRQ5SCB		BIT3
#define IRQ5SCA		BIT2
#define IRQ4SCB		BIT1
#define IRQ4SCA		BIT0

/* ISCRL */
#define IRQ3SCB		BIT7
#define IRQ3SCA		BIT6
#define IRQ2SCB		BIT5
#define IRQ2SCA		BIT4
#define IRQ1SCB		BIT3
#define IRQ1SCA		BIT2
#define IRQ0SCB		BIT1
#define IRQ0SCA		BIT0

/* ISR */
#define IRQ7F		BIT7
#define IRQ6F		BIT6
#define IRQ5F		BIT5
#define IRQ4F		BIT4
#define IRQ3F		BIT3
#define IRQ2F		BIT2
#define IRQ1F		BIT1
#define IRQ0F		BIT0

/* ݗOxN^e[ũxN^ԍ */
					/* v */
#define IRQ_POWRESET	0		/* p[IZbg */
#define IRQ_MANRESET	1		/* }jAZbg */
/* 2-4 ́AOxN^e[uɑΉ̂ŁAȗ */
#define IRQ_TRACE	5		/* g[X */
/* 6 ́AOxN^e[uɑΉ̂ŁAȗ */
#define IRQ_NMI		7		/* O[q */
#define IRQ_TRAP0	8		/* gbv */
#define IRQ_TRAP1	9		/* gbv */
#define IRQ_TRAP2	10		/* gbv */
#define IRQ_TRAP3	11		/* gbv */
/* 12-15 ́AOxN^e[uɑΉ̂ŁAȗ */
#define IRQ_IRQ0	16		/* O[q */
#define IRQ_IRQ1	17		/* O[q */
#define IRQ_IRQ2	18		/* O[q */
#define IRQ_IRQ3	19		/* O[q */
#define IRQ_IRQ4	20		/* O[q */
#define IRQ_IRQ5	21		/* O[q */
#define IRQ_IRQ6	22		/* O[q */
#define IRQ_IRQ7	23		/* O[q */
#define IRQ_SWDTEND	24		/* DTC */
#define IRQ_WOVI	25		/* EHb`hbO^C} */
#define IRQ_CMI 	26		/* tbVRg[ */
/* 27 Ԃ́AU[u */
#define IRQ_ADI		28		/* A/D */
/* 29, 30, 31 Ԃ́AU[u */
#define IRQ_TGI0A	32		/* TPU`l0 */
#define IRQ_TGI0B	33		/* TPU`l0 */
#define IRQ_TGI0C	34		/* TPU`l0 */
#define IRQ_TGI0D	35		/* TPU`l0 */
#define IRQ_TCI0V	36		/* TPU`l0 */
/* 37, 38, 39 Ԃ́AU[u */
#define IRQ_TGI1A	40		/* TPU`l1 */
#define IRQ_TGI1B	41		/* TPU`l1 */
#define IRQ_TCI1V	42		/* TPU`l1 */
#define IRQ_TCI1U	43		/* TPU`l1 */
#define IRQ_TGI2A	44		/* TPU`l2 */
#define IRQ_TGI2B	45		/* TPU`l2 */
#define IRQ_TCI2V	46		/* TPU`l2 */
#define IRQ_TCI2U	47		/* TPU`l2 */
#define IRQ_TGI3A	48		/* TPU`l3 */
#define IRQ_TGI3B	49		/* TPU`l3 */
#define IRQ_TGI3C	50		/* TPU`l3 */
#define IRQ_TGI3D	51		/* TPU`l3 */
#define IRQ_TCI3V	52		/* TPU`l3 */
/* 53, 54, 55 Ԃ́AU[u */
#define IRQ_TGI4A	56		/* TPU`l4 */
#define IRQ_TGI4B	57		/* TPU`l4 */
#define IRQ_TCI4V	58		/* TPU`l4 */
#define IRQ_TCI4U	59		/* TPU`l4 */
#define IRQ_TGI5A	60		/* TPU`l5 */
#define IRQ_TGI5B	61		/* TPU`l5 */
#define IRQ_TCI5V	62		/* TPU`l5 */
#define IRQ_TCI5U	63		/* TPU`l5 */
/* 64, 65, 66, 67, 68, 69, 70, 71 Ԃ́AU[u */
#define IRQ_DEND0A	72		/* DMAC */
#define IRQ_DEND0B	73		/* DMAC */
#define IRQ_DEND1A	74		/* DMAC */
#define IRQ_DEND1B	75		/* DMAC */
/* 76, 77, 78, 79 Ԃ́AU[u */
#define IRQ_ERI0	80		/* SCI`l0 */
#define IRQ_RXI0	81		/* SCI`l0 */
#define IRQ_TXI0	82		/* SCI`l0 */
#define IRQ_TEI0	83		/* SCI`l0 */
#define IRQ_ERI1	84		/* SCI`l1 */
#define IRQ_RXI1	85		/* SCI`l1 */
#define IRQ_TXI1	86		/* SCI`l1 */
#define IRQ_TEI1	87		/* SCI`l1 */
/* 88, 89, 90, 91 Ԃ́AU[u */

/*
 *  oXRg[
 */
/* WX^̃AhX */
#define ABWCR		0xfed0		/* oXRg[WX^ */
#define ASTCR		0xfed1		/* ANZXXe[gRg[WX^ */
#define WCRH		0xfed2		/* EFCgRg[WX^H */
#define WCRL      	0xfed3		/* EFCgRg[WX^L */
#define BCRH		0xfed4		/* oXRg[WX^H */
#define BCRL		0xfed5		/* oXRg[WX^L */
#define MCR		0xfed6		/* Rg[WX^ */
#define DRAMCR		0xfed7		/* DRAMRg[WX^ */
#define RTCNT		0xfed8		/* tbV^C}JE^ */
#define RTCOR		0xfed9		/* tbV^C}RX^gWX^ */

/* eWX^̃rbgp^[ */

/* ASTCR */
#define AST7 		BIT7
#define AST6 		BIT6
#define AST5 		BIT5
#define AST4 		BIT4
#define AST3 		BIT3
#define AST2 		BIT2
#define AST1 		BIT1
#define AST0 		BIT0

/* WCRH */
#define W71 		BIT7
#define W70 		BIT6
#define W61 		BIT5
#define W60 		BIT4
#define W51 		BIT3
#define W50 		BIT2
#define W41 		BIT1
#define W40 		BIT0

/* WCRL */
#define W31 		BIT7
#define W30 		BIT6
#define W21 		BIT5
#define W20 		BIT4
#define W11 		BIT3
#define W10 		BIT2
#define W01 		BIT1
#define W00 		BIT0

/* BCRH */
#define ICIS1 		BIT7
#define ICIS0 		BIT6
#define BRSTRM		BIT5
#define BRSTS1 		BIT4
#define BRSTS0		BIT3
#define RMTS2		BIT2
#define RMTS1		BIT1
#define RMTS0 		BIT0

/*
 *  ݎ̃X^bNɂEXRWX^̃ItZbg
 */
#define EXR_offset	28

/*
 *  `ݔ̃G[õ͎X^bN\̒`
 */
#ifndef _MACRO_ONLY

typedef struct exc_stack {
	UW	er6;
	UW	er5;
	UW	er4;
	UW	er3;
	UW	er2;
	UW	er1;
	UW	er0;
	UB	exr;
	UB	tmp;
	UH	ccr;	/* 1 byte : 1 byte = CCR : PC(ʂPoCg) */
	UH	pc;	/* 1 byte : 1 byte = PC(ʂQoCg) */
} EXCSTACK;

#endif /* _MACRO_ONLY */

#endif /* _H8S_H_ */
