/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY
#include <jsp_kernel.h>

/*
 *  ^[Qbgn[hEFAˑ鏉
 */
	.h8300s
	.text
	.align 2

	.global	_hardware_init_hook

_hardware_init_hook:

#ifndef GDB_STUB	/* ROM ̏Ȃǂ́AGDB X^uōŝŕsv */
	/*
	 *  SYSCR ̐ݒ
	 *  Eݐ䃂[hݐ䃂[h2ɐݒ
	 *  ERAM
	 */
	mov.l	#(H8S_BASE_ADDR+SYSCR), er0
	mov.b	@er0, r1l		/* r1l = SYSCR */

	or.b	#INTM1, r1l		/* INTM1 = 1(ݐ䃂[h2ɐݒ) */
	bset	#RAME_BIT, r1l		/* RAME  = 1(RAML) */
	mov.b	r1l, @er0		/* SYSCR = r1l */

	/*
	 *  MCU 샂[h̐ݒ
	 *  E{[h̃fBbvXCb`Ń[h5ɐݒ
	 *    ([h5FAhoXgEROMg[hGAhXԂ16MB)
	 *  EMCU 샂[h̐ݒɂAI/O|[g͈ȉ̂悤ɐݒ肳B
         *      |[gA, B, CFAhXo
         *      |[gD      Ff[^o
         *      |[gF      FPF6`PF3 -> oXo
	 */

	/*
	 * I/O |[g̏ (DRAMC^tF[X֌W)
	 */
	mov.l	#(H8S_BASE_ADDR+PGDDR), er0	/* |[gf ̐ݒ */
	mov.b	#(PG4DDR|PG3DDR), r1l		/* [hTł̗pȂ̂ŁA
						   CS0,CS1 Cl[u */
	mov.b	r1l, @er0

        /*
         *  oXRg[̐ݒ
         *  EOROM (0x000000-0x01ffff;128kB)FGA0
         *  EORAM (0x200000-0x21ffff:128kB)FGA1
         *  ERAM (0xfff400-0xfffbff:  2kB)F
	 *  EI/O (0xfffe3f-0xffffff:     )FGA7
         *
	 *  ݒl
	 *  EGA0 FE16rbgANZX		( ABW0=1 ; ABWCR )
	 *		E3Xe[gANZX		( AST0=1 ; ASTCR )
	 *		EvOEGCg3Xe[g}
	 *						( W01=1, W00=1 ; WCRL )
	 *  EGA1 FE16rbgANZX		( ABW1=1 ; ABWCR )
	 *		E3Xe[gANZX		( AST1=1 ; ASTCR )
	 *		EvOEGCg3Xe[g}
	 *						( W11=1, W10=1 ; WCRL )
	 *  EAChTCN̑}
	 *	      FEقȂGÅO[hTCNAƂ,
	 *		  AChTCN}	( ICIS1=1 ; BCRH )
	 *	      FEO[hTCNƊOCgTCNAƂ,
	 *		  AChTCN}	( ICIS0=1 ; BCRH )
	 *	      FEo[XgTCN͂QXe[g	( BRSTS1=1; BCRH )
         *  ( ӁFRAMyѓI/OWX^ɑ΂ANZXXe[g
         *          ASTCR̐ݒlɊւ炸ŒB)
	 */

	/* ABWCR, ASTCR ̐ݒ͏l̂܂܂Ȃ̂ŁAȗ */

	/* EGCgRg[WX^L (WCRL) ̐ݒ */
	mov.l	#(H8S_BASE_ADDR+WCRL), er0
	mov.b	#(W11|W10|W01|W00), r1l
	mov.b	r1l, @er0

	/* oXRg[WX^H (BCRH) ̐ݒ */
	mov.l	#(H8S_BASE_ADDR+BCRH), er0
 	mov.b	#(ICIS1|ICIS0|BRSTS1), r1l	/* WX^lƓl */
	mov.b 	r1l, @er0

#endif /* GDB_STUB */

	/*
	 * I/O |[g̏ (̑)
	 */

	/* |[gP̐ݒ */
	/* ̃|[gɂ́A^[Qbg{[hł̓fBbvXCb`ڑĂB
	   P1DDR ͏lŁúvȂ̂ŁAݒsv */

	/* |[gQ̐ݒ */
	/* ̃|[gɂ́A^[Qbg{[hł LED ڑĂB
	   }ŃA^[Qbg{[hɊւt@Cɒ`ĂB */
	PORT2_INIT

	/* |[gR̐ݒ */
	/* ̃|[gɂ́ASCI ڑĂB
	   SCI  SCRASMR̕ƂȂݒŝŁAݒsv */

	mov.l	@bss_clear_k, er0
	jmp	@er0

bss_clear_k:
	.long  bss_clear
