/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	^[Qbgˑ^C}W[iLinuxpj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#ifndef _MACRO_ONLY
#include <sys/time.h>
#endif /* _MACRO_ONLY */
/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	SIGALRM

/*
 *
 *
 */
#define TIMER_CLOCK             1
#define TO_CLOCK(nume, deno)    (TIMER_CLOCK * (nume) / (deno))



#ifndef _MACRO_ONLY
/*
 *  ^C}l̓\̌^
 */
typedef UW	CLOCK;

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
    struct itimerval val;

    val.it_interval.tv_sec = TO_CLOCK(TIC_NUME, TIC_DENO) / 1000;
    
    val.it_interval.tv_usec = (TO_CLOCK(TIC_NUME, TIC_DENO) % 1000) * 1000;
    val.it_value = val.it_interval;
    setitimer(ITIMER_REAL, &val, 0);
}


/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate()
{
    struct itimerval val;

    val.it_interval.tv_sec = 0;
    val.it_interval.tv_usec = 0;
    val.it_value = val.it_interval;
    setitimer(ITIMER_REAL, &val, 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */


