/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef _SYS_CONF_
/*
 *  OS ̎ނ̒`
 */

/*
 *  NbZ[W̃^[Qbg
 */
#define	TARGET_NAME	"Linux"

/*
 *  CPU  _setjmp/_longjmp Cu̎Ɉˑ萔̐ݒ
 *
 *  JMPBUF_PC: jmp_buf \̒ŁCPC ̒lꏊ̃ItZbg
 *  JMPBUF_SP: jmp_buf \̒ŁCSP ̒lꏊ̃ItZbg
 *
 *  STACK_MERGIN: X^bN|C^̏lCX^bN̈̏ (m
 *  ̈̎̔Ԓn)  ꂾDX^bN|C^w
 *  ngn߂vZbT ̏ꍇɂ́CgăX^bN|C
 *  ^̏l牺D܂Clongjmp ɁCX^bN|C
 *  ^̔Ԓn ANZX\ꍇɂ́Cg
 *  }[ẄmۂD
 *
 *  SIGSTACK_MERGIN: VOiX^bNvZXX^bNɎ鎞̃}[
 *  WDX^[gAbv[`g߂̃X^bN̈D
 */

#if defined(i386) | defined(_i386_) | defined(__i386__)

#define JMPBUF_PC		JB_PC
#define JMPBUF_SP		JB_SP
#define STACK_MERGIN		4
#define SIGSTACK_MERGIN		8192

#else /* i386 */

#error not supported.

#endif /* i386 */

/*
 *  VOiX^bN̕ύX sigaltstack g
 */
#define USE_SIGALTSTACK

/*
 *  X^bNGA̎擾/ԋp֐ mprotect ĝɍ
 */
#define	USE_MPROTECT_STACK



#ifdef _BSD_SERIAL_
#undef RAW			/* Փ˂V{̒`𖕏 */
#undef ECHO
#endif /* _BSD_SERIAL_ */


/*
 *  VXe^XNɊւ`
 */
#define	CONSOLE_PORTID	1	/* R\[pɗpVA|[gԍ */
#define	LOGTASK_PORTID	1	/* VXeOo͂VA|[gԍ */
#define LOGTASK_STACK_SIZE 8192 /* O^XÑX^bNTCY */

#ifndef _MACRO_ONLY
/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^ďoŎ邱Ƃz肵
 *  ĂD
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^ďoŎ邱
 *  Ƃz肵ĂD
 */
extern void	sys_putc(char c);

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONF_ */



