/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *  vZbTˑW[iM16Cpj
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/* 
 *  /CPUOlXgJE^
 */
char	intnest;

/*
 *  vZbTˑ̏
 */
void
cpu_initialize(void)
{
	/* ݃lXgJEg(^XNReLXg) */
	intnest = 0;
}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate(void)
{
}

/*
 * software_init_hook̉`
 */
#ifndef EXTERNAL_SOFT_HOOK
const VP_INT software_init_hook = 0;
#endif  /* EXTERNAL_SOFT_HOOK */


/*
 * 荞ݐ䃌WX^荞ݗDxύX
 *
 * 荞ݐ䃌WX^́C̃WX^ɑΉ銄ݗvȂӏ
 * ύXKvD̂߁C݂֎~CύXKvD
 * ݂֎~Ċݐ䃌WX^ύXꍇ́Cgp閽߂ɒӂ
 * KvD
 * IRrbgȊOύXꍇɂ́CAND,OR,BCLR,BSET߂gp邱ƁD
 * IRrbgMOV߂gp邱ƁD
 * ܂CItOpĊ݂֎~ꍇ́COɐ߂ƁD
 * ڍׂ́CM16Cn[hEFA}jA
 *       "gp̒->荞->ݐ䃌WX^̕ύX"
 * QƂ̂ƁD 
 */
void
set_ic_ilvl(VP addr, UB val){
    BOOL    locked;
    
    locked = sense_lock();
    if (!(locked)) {
        sense_context() ? i_lock_cpu() : t_lock_cpu();
    }
    
    _asm("PUSH.W A0");
    _asm("PUSH.B R0L");
    _asm("MOV.W $$[FB], A0", addr);
    _asm("MOV.B $$[FB], R0L", val);
    _asm("AND.B #08H, [A0]");
    _asm("OR.B  R0L, [A0]");
    _asm("NOP");
    _asm("NOP");    
    _asm("POP.B R0L");
    _asm("POP.W A0");

    if (!(locked)) {
        sense_context() ? i_unlock_cpu() : t_unlock_cpu();
    }
    
}

