/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *	^C}hCoiM3029pj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <sil.h>
#include <m3029.h>


/*
 *  ^C}[̊荞݃x
 */
#define INT_LEVEL_TIMER	0x05

/*
 * ^C}݃nh̃xN^ԍ
 */
#ifdef USE_TA0
#define	INHNO_TIMER	       INT_TA0
#elif defined(USE_TA1)
#define	INHNO_TIMER	       INT_TA1
#endif


/*
 * ^C}[hWX^
 */
#ifdef USE_TA0
#define TADR_SFR_TAMR TADR_SFR_TA0MR
#elif  defined(USE_TA1)
#define TADR_SFR_TAMR TADR_SFR_TA1MR
#endif

/*
 * Abv_EtO
 */
#ifdef USE_TA0
#define TBIT_UDF_TAUD TBIT_UDF_TA0UD
#elif  defined(USE_TA1)
#define TBIT_UDF_TAUD TBIT_UDF_TA1UD  
#endif

/*
 * ^C}WX^
 */
#ifdef USE_TA0
#define TADR_SFR_TA TADR_SFR_TA0
#elif  defined(USE_TA1)
#define TADR_SFR_TA TADR_SFR_TA1
#endif

/*
 * JEgJnrbg
 */
#ifdef USE_TA0
#define TBIT_TABSR_TS  TBIT_TABSR_TA0S
#elif  defined(USE_TA1)
#define TBIT_TABSR_TS  TBIT_TABSR_TA1S
#endif

/*
 * ݐ䃌WX^̃ItZbg
 */
#ifdef USE_TA0
#define TADR_SFR_TAIC_OFFSET  TADR_SFR_TA0IC_OFFSET
#elif  defined(USE_TA1)
#define TADR_SFR_TAIC_OFFSET  TADR_SFR_TA1IC_OFFSET
#endif


#ifndef _MACRO_ONLY


/*
 *  ^C}l̓\̌^
 */
typedef UH	CLOCK;


/*
 *  ^C}l̓\ƃ~bPʂƂ̕ϊ
 *
 *  1ms̃^C}[荞݂gp̂ł̃NbN`D
 */
#define TIMER_CLOCK		20000
#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((unsigned long)(clock) * 1000 / TIMER_CLOCK)


/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)


/*
 *  \]pVXeoۂ̏Ԃ̌ςliPʂ͓\j
 */
#define	GET_TOLERANCE	100	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
    /*
     * ^C}
     */
    /* ^C}JEg~ */
	sil_wrb_mem((VP)TADR_SFR_TABSR,
                sil_reb_mem((VP)TADR_SFR_TABSR) & ~TBIT_TABSR_TS);
    /* _EJEgݒ */
	sil_wrb_mem((VP)TADR_SFR_UDF,
                sil_reb_mem((VP)TADR_SFR_UDF)   & ~TBIT_UDF_TAUD);
    /*  JEg\[Xf1, ^C}[h  */
	sil_wrb_mem((VP)TADR_SFR_TAMR, 0x00);		
    
	/*
     *  ^C}l̏
	 *  ^C} 1ms TIMER_CLOCK JEg,
	 *  WX^ݒl̓}CiX1.
	 */
	sil_wrh_mem((VP)TADR_SFR_TA, (TIMER_CLOCK - 1));
    
    /* 荞݃x̐ݒ */
    set_ic_ilvl((VP)(TADR_SFR_INT_BASE + TADR_SFR_TAIC_OFFSET), INT_LEVEL_TIMER);
    
    /* JEgJn	*/
	sil_wrb_mem((VP)TADR_SFR_TABSR,
                sil_reb_mem((VP)TADR_SFR_TABSR) | TBIT_TABSR_TS);
}


/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
	/*
	 *  ̊֐̓^C}荞݃nh
	 *  isig_tim ĂяoOɎs.
	 *  ݂󂯕tĂ
	 *  ݃nhɏڂ_
	 *  ݗvrbg̓NA邽
	 *  KvȂ. 
	 */
}


/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
hw_timer_terminate()
{
    /* JEg~	*/
	sil_wrb_mem((VP)TADR_SFR_TABSR,
                sil_reb_mem((VP)TADR_SFR_TABSR) & ~TBIT_TABSR_TS);    
}


/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return ((TIMER_CLOCK-1) - sil_reh_mem((VP)TADR_SFR_TA));
}


/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)(TADR_SFR_INT_BASE + TADR_SFR_TAIC_OFFSET)) & TBIT_IC_IR) != 0;
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
