/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 

 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */

#define _MACRO_ONLY

#include <m32rasm.inc>
#include <s_services.h>
		
/*
 *  X^[gAbv[` 
 */
	.text
	.align 4
	.globl start

start:
	.extern		kernel_start
	.extern		hardware_init_hook
	.extern		software_init_hook
	.extern 	reset

	/* psw̏ */
	ldi		r0, 0	
	mvtc	r0, psw

	/* ݃X^bN|C^̏ */
	lea		r15, __stack
	
	/* EITx[XWX^̐ݒ */
	lea		r0, reset
	mvtc	r0, cr5

	/* n[hEFA[`̋N */
	lea		r0, hardware_init_hook
	beqz	r0, L1
	jl		r0

L1:
	/* .bssZNṼNA */
	xor		r0, r0
	lea		r1, __sbss
	lea		r2, __ebss
	beq		r1, r2, L3
L2:
	st		r0, @-r2
	bne		r1, r2, L2

L3:
	/* .dataZNV̏ */
	lea		r1, __sidata
	lea		r2, __eidata
	lea		r3, __sdata

	addi	r3, -4
	beq		r1, r2, L5
L4:	ld		r0, @r1+
	st		r0, @+r3
	bne		r1, r2, L4

L5:
	/* \tgEFA[`̋N */
	lea		r0, software_init_hook
	beqz	r0, L6
	jl		r0

L6:
	/* ݃}XN̐ݒ */
	ld24 	r0, ICUIMASK + 1
	ldi 	r1, 7				/* ׂĂ̊ݗvt */
	stb 	r1, @r0 			

	/* J[lN */
	bl		kernel_start

L7:	bra		L7
