/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: dve68k_dga.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 *	DGÃANZX[eBeB
 */

#ifndef _DVE68K_DGA_H_
#define _DVE68K_DGA_H_

/*
 *  DGÅݐrbg̒`
 */
#define TBIT_ABT	0x40000000u	/* A{[g݃rbg */
#define TBIT_SQR	0x04000000u	/* SQR ݃rbg */
#define	TBIT_TT0	0x00100000u	/* ^C}0 ݃rbg */
#define	TBIT_GP0	0x00010000u	/* VAI/O ݃rbg */

/*
 *  DGÅ݃xݒ̂߂̒`
 */
#define	TIRQ_NMI	0x7u		/* m}XJu */
#define	TIRQ_LEVEL6	0x6u		/* ݃x6 */
#define	TIRQ_LEVEL5	0x5u		/* ݃x5 */
#define	TIRQ_LEVEL4	0x4u		/* ݃x4 */
#define	TIRQ_LEVEL3	0x3u		/* ݃x3 */
#define	TIRQ_LEVEL2	0x2u		/* ݃x2 */
#define	TIRQ_LEVEL1	0x1u		/* ݃x1 */

#define TBIT_ABTIL	24		/* A{[g */
#define TBIT_SQRIL	8		/* SRQ  */

#define TBIT_TT0IL	16		/* ^C}0  */
#define TBIT_GP0IL	0		/* VAI/O  */

#ifndef _MACRO_ONLY

/*
 *  DGÃWX^ւ̃ANZX֐
 */

Inline UW
dga_read(VP addr)
{
	return((UW) dga_rew_reg(addr));
}

Inline void
dga_write(VP addr, UW val)
{
	dga_wrw_reg(addr, (VW) val);
}

Inline void
dga_bit_or(VP addr, UW bitpat)
{
	dga_write(addr, dga_read(addr) | bitpat);
}

Inline void
dga_bit_and(VP addr, UW bitpat)
{
	dga_write(addr, dga_read(addr) & bitpat);
}

Inline void
dga_set_ilv(VP addr, UINT shift, UINT level)
{
	dga_write(addr, (dga_read(addr) & ~(0x07 << shift))
						| (level << shift));
} 

#endif /* _MACRO_ONLY */
#endif /* _DVE68K_DGA_H_ */
