/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


/*
 *  vZbTˑW[iMicroBlazepj
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>


/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */


/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */


/*
 *  LbV̏
 */
#if defined(D_CACHE_ENABLE) && defined(I_CACHE_ENABLE)
#define MSR_CACHE_SETTING  MSR_DCE|MSR_ICE
#elif defined(D_CACHE_ENABLE)
#define MSR_CACHE_SETTING  MSR_DCE
#elif defined(I_CACHE_ENABLE)
#define MSR_CACHE_SETTING  MSR_ICE
#else
#define MSR_CACHE_SETTING  0x00
#endif        


#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
        VP	sp;             /* X^bN|C^ */
        FP  pc;             /* vOJE^ */
} CTXB;


/*
 * 荞݂̃lXg񐔂̃JEg
 */
extern UW interrupt_count;

/*
 *  VXeԎQ
 */

Inline BOOL
sense_context()
{
  return(interrupt_count > 0);    
}

Inline BOOL
sense_lock()
{
  return((current_msr() & MSR_IE) == 0);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock



/*
 *  CPUbNƂ̉
 *
 */
#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu

Inline void
lock_cpu()
{
	disint();
}

Inline void
unlock_cpu()
{
	enaint();
}


/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);


/*
 *  ݃nh^CPUOnh̐ݒ
 *  MicroBlaze͗OxN^݂͑邪CO𔭐鎖ۂ͂Ȃ
 *  O֘A͋̊֐pӂĂ
 */


/*
 *  荞݃nh/rbg}XÑe[u
 *  int_handler_table[] ͊݃nho^e[u
 *  int_bit_table[]@݂̗͊D揇ʂɉrbg̃e[ułC
 *  MicroBlazẽVtg߂́C1߂1rbgVtgłȂ߁C
 *  ݂Ă炱̃rbgp^[𐶐ƎԂ邽
 *  
 */
extern FP	int_handler_table[32];
extern UW   int_bit_table[32];

/*
 *  CPUOnh̋^e[u
 */
/*
extern FP	exc_table[];
*/

extern FP exception_entry();
extern FP interrupt_entry();


/*
 *
 *  ݃nh̐ݒ
 *
 *  ݗDx inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 *  ^e[uɓo^
 *  
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
  int_handler_table[inhno-1] = inthdr;
}

/*
 *   CPUOnh̐ݒ
 *   [xN^[e[uɓo^
 *   Not Support! 
 */   
Inline void
define_exc(EXCNO excno, FP exchdr)
{

}


/*
 *  ݃nh^CPUOnh̏o
 *  
 */


/*
 *  ݃nh̏o̐}N
 */

#define	INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPUOnh̏o̐}N
 *
 */
#define	EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

#define	EXC_ENTRY(exchdr)     exchdr

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg
 *  Not Support! 
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
  	return(interrupt_count > 1); 
}

/*
 *  CPUO̔CPUbNԂ̎Q
 *  Not Support!
 *  Not Yet!   
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(FALSE);
}


/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);


/*
 * o^̊/ÕOo
 */
extern void     no_reg_interrupt(void);
/* extern void     cpu_expevt(VW,VW,VW,VW); */
extern void     cpu_interrupt(void);

#endif /* _MACRO_ONLY_ */

/*
 *  vxget_tim T|[g邩ǂ̒`
 */
#define	SUPPORT_VXGET_TIM

/*                                                                             
 *  VA|[gԍɊւ`      
 */
#define TNUM_PORT   1   /* T|[gVA|[g̐ */
#define TNUM_SIOP   1   /* T|[gVAI/O|[g̐ */

/*
 *  VXe^XNɊւ`
 */
#define	LOGTASK_PORTID	1	/* VXeOo͂VA|[gԍ */


#endif /* _CPU_CONFIG_H_ */
