/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */
 
#include <vr4131_dsiu.h>

/*
 *	VR4131DSIUp ȈSIOhCo
 */

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UB	lcr_def;	/* LCRݒl b0-b6;
				   (MrbgAXgbvrbgCpeB) */
	UB	boud_hi_def;	/* DLMݒli{[[gʂ̐ݒlj */
	UB	boud_lo_def;	/* DLLݒli{[[gʂ̐ݒlj */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
	BOOL		getready;	/* M */
	BOOL		putready;	/* 𑗐Mł */
};

/*
 *  VAI/O|[gubN
 *  i|[g͂PȂÃ\[XR[hƂ̐eazŒ`j
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ (UB)	WORD_LENGTH_8 | STOP_BITS_1 | PARITY_NON,
	  (UB)	HI8(DIVISOR),
	  (UB)	LO8(DIVISOR) }
};

/*
 *  VAI/O|[gubN̎o
 */
#define INDEX_SIOPINIB(siopid)	((UINT)((siopid) - 1))
#define get_siopinib(siopid)	(&(siopinib_table[INDEX_SIOPINIB(siopid)]))

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  Ԃ̓ǏoiIID̓Ǐoj
 */
static void
vr4131_dsiu_get_stat(SIOPCB *siopcb)
{
	UB	iid;

	iid = vr4131_reb_mem( (VP) DSIUIID ) & INT_MASK;

	switch( iid ) {
		case INT_TRANS_EMPTY :
			siopcb->putready = TRUE;
			break;
		case INT_RECEIVE_DATA :
		case INT_CHAR_TIME_OUT :
			siopcb->getready = TRUE;
			break;
		default :
			break;
	}


}

/*
 *  Mł邩H
 */
Inline BOOL
vr4131_dsiu_getready(SIOPCB *siopcb)
{
	return(siopcb->getready);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
vr4131_dsiu_putready(SIOPCB *siopcb)
{
	return(siopcb->putready);
}

/*
 *  M̎o
 */
Inline char
vr4131_dsiu_getchar(SIOPCB *siopcb)
{
	siopcb->getready = FALSE;
	return((char) vr4131_reb_mem( (VP) DSIURB ));
}

/*
 *  M镶̏
 */
Inline void
vr4131_dsiu_putchar(SIOPCB *siopcb, char c)
{
	siopcb->putready = FALSE;

#ifndef GDB_STUB
	vr4131_wrb_mem( (VP) DSIUTH, c );
#else /* GDB_STUB */
	stub_putc( c );
#endif /* GDB_STUB */
}

/*
 *  SIOhCȍ[`
 */
void
vr4131_dsiu_initialize()
{
	SIOPCB	*siopcb = siopcb_table;
	UINT	i = 0;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	siopcb->siopinib = &(siopinib_table[i]);
	siopcb->openflag = FALSE;
}

/*
 *  SIOWX^[`
 */
void
vr4131_dsiu_init_siopinib( const SIOPINIB  *siopinib )
{
	/*
	 * DSIUWX^̏
	 */
	/*  */
	vr4131_wrb_mem( (VP) DSIUIE,  DIS_INT );

	/* {[[g̐ݒ */
	vr4131_wrb_mem( (VP) DSIULC,  siopinib->lcr_def | DIVISOR_LATCH_ACC );

	vr4131_wrb_mem( (VP) DSIUDLL, siopinib->boud_lo_def );
	vr4131_wrb_mem( (VP) DSIUDLM, siopinib->boud_hi_def );

	/* [h̐ݒ */
	vr4131_wrb_mem( (VP) DSIULC,  siopinib->lcr_def );

	/* FIFO̐ݒ */
	vr4131_wrb_mem( (VP) DSIUFC,  FIFO_ENABLE );
	vr4131_wrb_mem( (VP) DSIUFC,  FIFO_ENABLE | RECEIVE_FIFO_RESET | TRANS_FIFO_RESET | RECEIVE_TRIG_1_BYTE );
	vr4131_wrb_mem( (VP) DSIUFC,  FIFO_ENABLE | RECEIVE_TRIG_1_BYTE );

	/* I */
	vr4131_wrb_mem( (VP) DSIUMC,  RTS );

	vr4131_wrb_mem( (VP) DSIUIE,  RECEIVE_DATA_AVAILABLE);
}

/*
 *  J[lÑo[i[o͗p̏
 */
void
vr4131_dsiu_init(void)
{
	vr4131_dsiu_init_siopinib( get_siopinib(1) );
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
vr4131_dsiu_openflag(void)
{
	return( siopcb_table[0].openflag );
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
vr4131_dsiu_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb = get_siopcb(siopid);
	const SIOPINIB	*siopinib = siopcb->siopinib;

#ifndef GDB_STUB
	/* DSIUWX^̏ */
	vr4131_dsiu_init_siopinib( siopinib );
#endif	/*  GDB_STUB  */

	/* ݃xݒAݗvNÁAsio_opn_por(hw_serial.h)ōsB */

	siopcb->exinf = exinf;
	siopcb->getready = siopcb->putready = FALSE;
	siopcb->openflag = TRUE;

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
vr4131_dsiu_cls_por(SIOPCB *siopcb)
{
	vr4131_wrb_mem( (VP) DSIUIE, DIS_INT );

	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
vr4131_dsiu_snd_chr(SIOPCB *siopcb, char c)
{
	if (vr4131_dsiu_putready(siopcb)) {
		vr4131_dsiu_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
vr4131_dsiu_rcv_chr(SIOPCB *siopcb)
{
	if (vr4131_dsiu_getready(siopcb)) {
		return((INT)(UB) vr4131_dsiu_getchar(siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
vr4131_dsiu_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ie_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		ie_bit = TRANS_REG_EMPTY;
		break;
	case SIO_ERDY_RCV:
		ie_bit = RECEIVE_DATA_AVAILABLE | RECEIVE_LINE_STATUS;
		break;
	}

	vr4131_orb( (VP) DSIUIE, ie_bit );
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
vr4131_dsiu_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ie_bit = 0;

	switch (cbrtn) {
	case SIO_ERDY_SND:
		ie_bit = TRANS_REG_EMPTY;
		break;
	case SIO_ERDY_RCV:
		ie_bit = RECEIVE_DATA_AVAILABLE | RECEIVE_LINE_STATUS;
		break;
	}

	vr4131_andb( (VP) DSIUIE, ~ie_bit );
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
vr4131_dsiu_isr_siop(SIOPCB *siopcb)
{
	vr4131_dsiu_get_stat(siopcb);

	if ( vr4131_dsiu_getready(siopcb) ) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		vr4131_dsiu_ierdy_rcv(siopcb->exinf);
	}
	if ( vr4131_dsiu_putready(siopcb) ) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		vr4131_dsiu_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
vr4131_dsiu_isr()
{
	if (siopcb_table[0].openflag) {
		vr4131_dsiu_isr_siop(&(siopcb_table[0]));
	}
}

/*
 *  VR4131  DSIU p|[Oo (sys_putcŗp)
 */
void
vr4131_dsiu_putchar_pol( char val ) {

	/* MGveBɂȂ܂ő҂B */
	while( (vr4131_reb_mem( (VP)DSIULS ) & (TEMT) ) == 0 );

	vr4131_wrb_mem( (VP)DSIUTH, (VB) val );
}
