/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _VR4131_DSIU_H_
#define _VR4131_DSIU_H_

#include <s_services.h>		/* foCXhCopWCN[ht@C */

/*
 *  VR4131fobOVAC^tF[Xjbg(DSIU)֘A̒`
 *  (ȈNS16550)
 */

/* DSIUWX^̃AhX */
#define DSIURB		0x0f000820	/* Mobt@WX^([h) */
#define DSIUTH		0x0f000820	/* MێWX^(Cg) */
#define DSIUDLL		0x0f000820	/* 䉺ʃWX^ */
#define DSIUIE		0x0f000821	/* ݋WX^ */
#define DSIUDLM		0x0f000821	/* ʃWX^ */
#define DSIUIID		0x0f000822	/* ݕ\WX^([h) */
#define DSIUFC		0x0f000822	/* FIFO 䃌WX^(Cg) */
#define DSIULC		0x0f000823	/* C䃌WX^ */
#define DSIUMC		0x0f000824	/* f䃌WX^ */
#define DSIULS		0x0f000825	/* CԃWX^ */
#define DSIUMS		0x0f000826	/* fԃWX^ */
#define DSIUSC		0x0f000827	/* XNb`WX^ */

/* for DSIULC */
#define	WORD_LENGTH_8		(BIT1 | BIT0)
#define	STOP_BITS_1		0u		/* BIT2 */
#define	PARITY_NON		0u		/* BIT3, 4 */
/* BIT5,6 ȗ */
#define	DIVISOR_LATCH_ACC	BIT7

/* for DSIUIE */
#define	DIS_INT			0u
#define	RECEIVE_DATA_AVAILABLE	BIT0
#define	TRANS_REG_EMPTY		BIT1
#define RECEIVE_LINE_STATUS	BIT2
#define MODEM_STATUS		BIT3

/* for DSIUMC */
#define	DTR			BIT0
#define	RTS			BIT1

/* for DSIUFC */
#define	FIFO_ENABLE		BIT0
#define	RECEIVE_FIFO_RESET	BIT1
#define	TRANS_FIFO_RESET	BIT2
#define RECEIVE_TRIG_1_BYTE	0u	/* BIT6, 7 */
#define RECEIVE_TRIG_4_BYTE	BIT6
#define	RECEIVE_TRIG_8_BYTE	BIT7
#define	RECEIVE_TRIG_14_BYTE	(BIT6 | BIT7)

/* for DSIUIID */
#define	INT_MASK		0x0eu
#define	INT_RECEIVE_DATA	BIT2
#define INT_CHAR_TIME_OUT	(BIT3 | BIT2)
#define	INT_TRANS_EMPTY		BIT1

/* for DSIULS */
#define	THRE			BIT5
#define TEMT			BIT6

/* {[[g`֌W */
#define	DIVISOR			XIN_CLOCK / (16u * DEVIDE_RATIO)

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_control_block	SIOPCB;

#endif /* _MACRO_ONLY */

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND	1u		/* M\R[obN */
#define SIO_ERDY_RCV	2u		/* MʒmR[obN */

#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
extern void	vr4131_dsiu_initialize(void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL	vr4131_dsiu_openflag(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB	*vr4131_dsiu_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	vr4131_dsiu_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	vr4131_dsiu_snd_chr(SIOPCB *siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT	vr4131_dsiu_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void	vr4131_dsiu_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void	vr4131_dsiu_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void	vr4131_dsiu_dsiu_isr(void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void	vr4131_dsiu_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void	vr4131_dsiu_ierdy_rcv(VP_INT exinf);

/*
 *  J[lNp̏ (sys_putcŗp)
 */
extern void	vr4131_dsiu_init(void);

/*
 *  VAI/O|[gւ̕Mi|[Oj
 */
extern void	vr4131_dsiu_putchar_pol(char c);

#endif /* _MACRO_ONLY */

#endif /* _VR4131_DSIU_H_ */
